/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgConfigureEntity.cpp: implementation of the DlgConfigureEntity class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgMessage.h"
#include "DlgConfigureEntity.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


DlgConfigureEntity::DlgConfigureEntity(wxWindow * wParent, const PKI_CERT & entity_cert, PkiClient * ClientPki):wxDialog(wParent, (wxWindowID)-1, _("Configure Entity"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION),	m_entity_cert(entity_cert)
{
	m_IsOK = false;
	m_ClientPki = ClientPki;
}

DlgConfigureEntity::~DlgConfigureEntity()
{
	m_ClientPki->ResourceUnlock(m_entity_cert.GetStringName());
	m_ClientPki->ResourceUnlock(PKI_ENTITIES_GROUPS_RESOURCE);
}

void DlgConfigureEntity::OnOk(wxCommandEvent& event)
{
	if(!SetConf())
	{
		return;
	}

	if(DisplayMessage(this, _("Are you sure to want to modify the configuration ?"), wxYES_NO) == wxNO) return;

	DlgMessage Dlg(this);

	Dlg.wShow(_("Modifying Entity's Configuration..."));

	if(!m_ClientPki->SetEntityConf(m_entity_cert, m_EntityConf))
	{
		Dlg.wHide();
		HandleError(m_ClientPki->GetError(), this);
		return;
	}
	Dlg.wHide();
	
	m_IsOK = true;
	Close(TRUE);
}

void DlgConfigureEntity::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}

bool DlgConfigureEntity::Init(int entity_type)
{
	DlgMessage Dlg(this);

	Dlg.wShow(_("Loading Entity's Configuration..."));

	if(!m_ClientPki->ResourceLock(m_entity_cert.GetStringName()))
	{
		Dlg.wHide();
		HandleError(m_ClientPki->GetError(), this);
		return false;
	}
	if(!m_ClientPki->ResourceLock(PKI_ENTITIES_GROUPS_RESOURCE))
	{
		Dlg.wHide();
		HandleError(m_ClientPki->GetError(), this);
		return false;
	}
	
	if(!m_ClientPki->GetEntityConf(m_entity_cert, m_EntityConf))
	{
		Dlg.wHide();
		HandleError(m_ClientPki->GetError(), this);
		return false;
	}
	if(!m_ClientPki->GetGroups(m_Groups))
	{
		Dlg.wHide();
		HandleError(m_ClientPki->GetError(), this);
		return false;
	}
	Dlg.wHide();

	if(m_EntityConf.get_type() != entity_type)
	{
		NEWPKIerr(CLIENT_ERROR_TXT, ERROR_BAD_DATAS_FORMAT);
		HandleErrorResult(NULL, this, 0);
		return false;
	}

	if(!DisplayConf())
	{
		return false;
	}
	return true;
}

