/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgExtWizard.cpp: implementation of the DlgExtWizard class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgExtWizard.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgExtWizard, wxDialog)
    EVT_BUTTON(IDC_OK, DlgExtWizard::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgExtWizard::OnCancel)
    EVT_BUTTON(IDC_NSCERT_TYPE_ADD, DlgExtWizard::OnAddNsCertTypeUsageValue)
    EVT_BUTTON(IDC_NSCERT_TYPE_DEL, DlgExtWizard::OnDelNsCertTypeValue)
    EVT_BUTTON(IDC_EXTKEY_USAGE_ADD, DlgExtWizard::OnAddExtKeyUsageValue)
    EVT_BUTTON(IDC_EXTKEY_USAGE_DEL, DlgExtWizard::OnDelExtKeyUsageValue)
    EVT_BUTTON(IDC_KEY_USAGE_ADD, DlgExtWizard::OnAddKeyUsageValue)
    EVT_BUTTON(IDC_KEY_USAGE_DEL, DlgExtWizard::OnDelKeyUsageValue)
    EVT_BUTTON(IDC_AUTH_INFO_ADD, DlgExtWizard::OnAddAuthInfoValue)
    EVT_BUTTON(IDC_AUTH_INFO_DEL, DlgExtWizard::OnDelAuthInfoValue)
    EVT_BUTTON(IDC_SUBJ_ALT_ADD, DlgExtWizard::OnAddSubjAltValue)
    EVT_BUTTON(IDC_SUBJ_ALT_DEL, DlgExtWizard::OnDelSubjAltValue)
    EVT_BUTTON(IDC_ISSU_ALT_ADD, DlgExtWizard::OnAddIssuAltValue)
    EVT_BUTTON(IDC_ISSU_ALT_DEL, DlgExtWizard::OnDelIssuAltValue)
    EVT_BUTTON(IDC_CRLDP_ADD, DlgExtWizard::OnAddCrldpValue)
    EVT_BUTTON(IDC_CRLDP_DEL, DlgExtWizard::OnDelCrldpValue)
	EVT_NOTEBOOK_PAGE_CHANGING(ID_NOTEBOOK, DlgExtWizard::OnPageChanging)
	EVT_NOTEBOOK_PAGE_CHANGED(ID_NOTEBOOK, DlgExtWizard::OnPageChanged)
END_EVENT_TABLE()


DlgExtWizard::DlgExtWizard(wxWindow * wParent, HashTable_String * Exts):wxDialog(wParent, (wxWindowID)-1, _("Extension wizard"), wxDefaultPosition)
{
	m_Exts = Exts;
	m_SavedExts=*Exts;
	m_IsOK = false;
	loading=true;

	DlgExtWizard_SetWindow(this);
	loading=false;

	Frame = (wxNotebook*)FindWindow(ID_NOTEBOOK);

	ParsePhase1();

	CenterOnScreen();
	ShowModal();
}



DlgExtWizard::~DlgExtWizard()
{
}


void DlgExtWizard::OnOk(wxCommandEvent& event)
{
	wxNotebookEvent pgevent;
	pgevent.SetSelection(((wxNotebook *)Frame->FindWindow(ID_NOTEBOOK))->GetSelection());
	OnPageChanging(pgevent);

	m_IsOK = true;
	Close(TRUE);
}
void DlgExtWizard::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	*m_Exts = m_SavedExts;
	Close(TRUE);
}

bool DlgExtWizard::IsOK()
{
	return m_IsOK;
}

void DlgExtWizard::ParsePhase1()
{
	char TmpValue[100];
	const char * Value;
	bool critical;
	wxString AddValue;
	

	((wxComboBox *)Frame->FindWindow(IDC_BASIC))->Clear();
	((wxComboBox *)Frame->FindWindow(IDC_BASIC))->Append("FALSE", (void*)"CA:FALSE");
	((wxComboBox *)Frame->FindWindow(IDC_BASIC))->Append("TRUE", (void*)"CA:TRUE");
	((wxComboBox *)Frame->FindWindow(IDC_BASIC))->SetSelection(0);

	//On parse basicConstraints
	Value = m_Exts->Get("basicConstraints");
	if(Value)
	{
		BASIC_CONSTRAINTS * basicConst;
		basicConst = (BASIC_CONSTRAINTS *)GetExtensionInternal("basicConstraints", Value, critical);
		if(basicConst)
		{
			if(basicConst->ca)
			{
				((wxComboBox *)Frame->FindWindow(IDC_BASIC))->SetSelection(1);
			}
			else
			{
				((wxComboBox *)Frame->FindWindow(IDC_BASIC))->SetSelection(0);
			}

			if(basicConst->pathlen)
			{
				sprintf(TmpValue, "%d", *basicConst->pathlen->data);
				((wxTextCtrl *)Frame->FindWindow(IDC_PATHLEN))->SetValue(TmpValue);
			}

			((wxCheckBox *)Frame->FindWindow(IDC_BASIC_CRITIC))->SetValue(critical);

			BASIC_CONSTRAINTS_free(basicConst);
		}
	}


	((wxComboBox *)Frame->FindWindow(IDC_SUBJ_ALT_TYPE))->Clear();
	((wxComboBox *)Frame->FindWindow(IDC_SUBJ_ALT_TYPE))->Append("Email address", (void*)"email");
	((wxComboBox *)Frame->FindWindow(IDC_SUBJ_ALT_TYPE))->Append("Subject's email", (void*)"email:copy");
	((wxComboBox *)Frame->FindWindow(IDC_SUBJ_ALT_TYPE))->Append("URL", (void*)"URI");
	((wxComboBox *)Frame->FindWindow(IDC_SUBJ_ALT_TYPE))->Append("DNS name", (void*)"DNS");
	((wxComboBox *)Frame->FindWindow(IDC_SUBJ_ALT_TYPE))->Append("OID", (void*)"RID");
	((wxComboBox *)Frame->FindWindow(IDC_SUBJ_ALT_TYPE))->Append("IP address", (void*)"IP");
	((wxComboBox *)Frame->FindWindow(IDC_SUBJ_ALT_TYPE))->SetSelection(0);

	
	WriteListExtension("subjectAltName", IDC_SUBJ_ALT_CRITIC, IDC_SUBJ_ALT_LIST);

	
	((wxCheckBox *)Frame->FindWindow(IDC_SUBJ_KEYID))->SetValue( (m_Exts->Get("subjectKeyIdentifier") != NULL) );
	((wxCheckBox *)Frame->FindWindow(IDC_AUTH_KEYID))->SetValue( (m_Exts->Get("authorityKeyIdentifier") != NULL) );
}


void * DlgExtWizard::GetExtensionInternal(const char *Name, const char *Value, bool & critical)
{
	X509V3_CTX ctx;
	X509V3_set_ctx_test(&ctx);
	STACK_OF(CONF_VALUE) *nval;
	X509V3_EXT_METHOD *method;
	int ext_nid;
	void * ext_struc;
	
	critical = v3_check_critical((char**)&Value);

	ext_nid = OBJ_sn2nid(Name);
	if (ext_nid == NID_undef)
	{
		return NULL;
	}
	if (!(method = X509V3_EXT_get_nid(ext_nid)))
	{
		return NULL;
	}

	if (method->v2i)
	{
		nval = X509V3_parse_list(Value);
		if(!nval)
		{
			return NULL;
		}
		ext_struc = method->v2i(method, &ctx, nval);
		sk_CONF_VALUE_pop_free(nval, X509V3_conf_free);
	}
	else if(method->s2i)
	{
		if(!(ext_struc = method->s2i(method, &ctx, (char*)Value))) return NULL;
	}
	else if(method->r2i)
	{
		if(!ctx.db)
		{
			return NULL;
		}
		if(!(ext_struc = method->r2i(method, &ctx, (char*)Value))) return NULL;
	}
	else
	{
		return NULL;
	}
	return ext_struc;
}

bool DlgExtWizard::v3_check_critical(char **value)
{
	char *p = *value;
	if ((strlen(p) < 9) || strncmp(p, "critical,", 9)) return false;
	p+=9;
	while(isspace((unsigned char)*p)) p++;
	*value = p;
	return true;
}


void DlgExtWizard::OnAddSubjAltValue(wxCommandEvent &event)
{
	wxString f_value;
	wxString value;
	char * Object = (char*)((wxComboBox *)Frame->FindWindow(IDC_SUBJ_ALT_TYPE))->GetClientData(((wxComboBox *)Frame->FindWindow(IDC_SUBJ_ALT_TYPE))->GetSelection());
	if(!Object) return;

	f_value = Object;

	if(!strstr(Object, ":"))
	{
		value = ((wxTextCtrl *)Frame->FindWindow(IDC_SUBJ_ALT_VALUE))->GetValue();
		if(!value.Len()) return;
		f_value += ":";
		f_value += value;
	}

	((wxListBox *)Frame->FindWindow(IDC_SUBJ_ALT_LIST))->Append(f_value);
}

void DlgExtWizard::OnDelSubjAltValue(wxCommandEvent &event)
{
	int nItem;
	
	nItem = ((wxListBox *)Frame->FindWindow(IDC_SUBJ_ALT_LIST))->GetSelection();
	if(nItem == -1) return;

	((wxListBox *)Frame->FindWindow(IDC_SUBJ_ALT_LIST))->Delete(nItem);
}

void DlgExtWizard::OnAddKeyUsageValue(wxCommandEvent &event)
{
	char * Object = (char*)((wxComboBox *)Frame->FindWindow(IDC_KEY_USAGE_TYPE))->GetClientData(((wxComboBox *)Frame->FindWindow(IDC_KEY_USAGE_TYPE))->GetSelection());
	if(!Object) return;

	((wxListBox *)Frame->FindWindow(IDC_KEY_USAGE_LIST))->Append(Object);
}

void DlgExtWizard::OnDelKeyUsageValue(wxCommandEvent &event)
{
	int nItem;
	
	nItem = ((wxListBox *)Frame->FindWindow(IDC_KEY_USAGE_LIST))->GetSelection();
	if(nItem == -1) return;

	((wxListBox *)Frame->FindWindow(IDC_KEY_USAGE_LIST))->Delete(nItem);
}

void DlgExtWizard::OnAddExtKeyUsageValue(wxCommandEvent &event)
{
	char * Object = (char*)((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->GetClientData(((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->GetSelection());
	if(!Object) return;

	((wxListBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_LIST))->Append(Object);
}

void DlgExtWizard::OnDelExtKeyUsageValue(wxCommandEvent &event)
{
	int nItem;
	
	nItem = ((wxListBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_LIST))->GetSelection();
	if(nItem == -1) return;

	((wxListBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_LIST))->Delete(nItem);
}

void DlgExtWizard::OnAddNsCertTypeUsageValue(wxCommandEvent &event)
{
	char * Object = (char*)((wxComboBox *)Frame->FindWindow(IDC_NSCERT_TYPE_TYPE))->GetClientData(((wxComboBox *)Frame->FindWindow(IDC_NSCERT_TYPE_TYPE))->GetSelection());
	if(!Object) return;

	((wxListBox *)Frame->FindWindow(IDC_NSCERT_TYPE_LIST))->Append(Object);
}

void DlgExtWizard::OnDelNsCertTypeValue(wxCommandEvent &event)
{
	int nItem;
	
	nItem = ((wxListBox *)Frame->FindWindow(IDC_NSCERT_TYPE_LIST))->GetSelection();
	if(nItem == -1) return;

	((wxListBox *)Frame->FindWindow(IDC_NSCERT_TYPE_LIST))->Delete(nItem);
}

void DlgExtWizard::OnAddIssuAltValue(wxCommandEvent &event)
{
	wxString f_value;
	wxString value;
	char * Object = (char*)((wxComboBox *)Frame->FindWindow(IDC_ISSU_ALT_TYPE))->GetClientData(((wxComboBox *)Frame->FindWindow(IDC_ISSU_ALT_TYPE))->GetSelection());
	if(!Object) return;

	f_value = Object;

	if(!strstr(Object, ":"))
	{
		value = ((wxTextCtrl *)Frame->FindWindow(IDC_ISSU_ALT_VALUE))->GetValue();
		if(!value.Len()) return;
		f_value += ":";
		f_value += value;
	}

	((wxListBox *)Frame->FindWindow(IDC_ISSU_ALT_LIST))->Append(f_value);
}

void DlgExtWizard::OnDelIssuAltValue(wxCommandEvent &event)
{
	int nItem;
	
	nItem = ((wxListBox *)Frame->FindWindow(IDC_ISSU_ALT_LIST))->GetSelection();
	if(nItem == -1) return;

	((wxListBox *)Frame->FindWindow(IDC_ISSU_ALT_LIST))->Delete(nItem);
}


void DlgExtWizard::OnAddAuthInfoValue(wxCommandEvent &event)
{
	wxString f_value;
	wxString value;
	char * Object = (char*)((wxComboBox *)Frame->FindWindow(IDC_AUTH_INFO_TYPE))->GetClientData(((wxComboBox *)Frame->FindWindow(IDC_AUTH_INFO_TYPE))->GetSelection());
	if(!Object) return;

	f_value = Object;
	value = ((wxTextCtrl *)Frame->FindWindow(IDC_AUTH_INFO_VALUE))->GetValue();
	if(!value.Len()) return;
	f_value += ":";
	f_value += value;


	((wxListBox *)Frame->FindWindow(IDC_AUTH_INFO_LIST))->Append(f_value);
}

void DlgExtWizard::OnDelAuthInfoValue(wxCommandEvent &event)
{
	int nItem;
	
	nItem = ((wxListBox *)Frame->FindWindow(IDC_AUTH_INFO_LIST))->GetSelection();
	if(nItem == -1) return;

	((wxListBox *)Frame->FindWindow(IDC_AUTH_INFO_LIST))->Delete(nItem);
}


void DlgExtWizard::ParsePhase2()
{
	wxString AddValue;
	
	((wxComboBox *)Frame->FindWindow(IDC_ISSU_ALT_TYPE))->Clear();
	((wxComboBox *)Frame->FindWindow(IDC_ISSU_ALT_TYPE))->Append("Email address", (void*)"email");
	((wxComboBox *)Frame->FindWindow(IDC_ISSU_ALT_TYPE))->Append("Issuer's DN", (void*)"issuer:copy");
	((wxComboBox *)Frame->FindWindow(IDC_ISSU_ALT_TYPE))->Append("URL", (void*)"URI");
	((wxComboBox *)Frame->FindWindow(IDC_ISSU_ALT_TYPE))->Append("DNS name", (void*)"DNS");
	((wxComboBox *)Frame->FindWindow(IDC_ISSU_ALT_TYPE))->Append("OID", (void*)"RID");
	((wxComboBox *)Frame->FindWindow(IDC_ISSU_ALT_TYPE))->Append("IP address", (void*)"IP");
	((wxComboBox *)Frame->FindWindow(IDC_ISSU_ALT_TYPE))->SetSelection(0);
	
	WriteListExtension("issuerAltName", IDC_ISSU_ALT_CRITIC, IDC_ISSU_ALT_LIST);
	WriteListExtension("crlDistributionPoints", IDC_CRLDP_CRITIC, IDC_CRLDP_LIST);
}

void DlgExtWizard::ParsePhase3()
{
	wxString AddValue;
	


	((wxComboBox *)Frame->FindWindow(IDC_AUTH_INFO_TYPE))->Clear();
	((wxComboBox *)Frame->FindWindow(IDC_AUTH_INFO_TYPE))->Append("CA's certificate URL", (void*)"caIssuers;URI");
	((wxComboBox *)Frame->FindWindow(IDC_AUTH_INFO_TYPE))->Append("OCSP server URL", (void*)"OCSP;URI");
	((wxComboBox *)Frame->FindWindow(IDC_AUTH_INFO_TYPE))->SetSelection(0);
	
	WriteListExtension("authorityInfoAccess", IDC_AUTH_INFO_CRITIC, IDC_AUTH_INFO_LIST);

	
	((wxComboBox *)Frame->FindWindow(IDC_KEY_USAGE_TYPE))->Clear();
	((wxComboBox *)Frame->FindWindow(IDC_KEY_USAGE_TYPE))->Append("Digital Signature", (void*)"digitalSignature");
	((wxComboBox *)Frame->FindWindow(IDC_KEY_USAGE_TYPE))->Append("Non Repudiation", (void*)"nonRepudiation");
	((wxComboBox *)Frame->FindWindow(IDC_KEY_USAGE_TYPE))->Append("Key Encipherment", (void*)"keyEncipherment");
	((wxComboBox *)Frame->FindWindow(IDC_KEY_USAGE_TYPE))->Append("Data Encipherment", (void*)"dataEncipherment");
	((wxComboBox *)Frame->FindWindow(IDC_KEY_USAGE_TYPE))->Append("Key Agreement", (void*)"keyAgreement");
	((wxComboBox *)Frame->FindWindow(IDC_KEY_USAGE_TYPE))->Append("Certificate Signature", (void*)"keyCertSign");
	((wxComboBox *)Frame->FindWindow(IDC_KEY_USAGE_TYPE))->Append("CRL Signature", (void*)"cRLSign");
	((wxComboBox *)Frame->FindWindow(IDC_KEY_USAGE_TYPE))->Append("Encipher Only", (void*)"encipherOnly");
	((wxComboBox *)Frame->FindWindow(IDC_KEY_USAGE_TYPE))->Append("Decipher Only", (void*)"decipherOnly");
	((wxComboBox *)Frame->FindWindow(IDC_KEY_USAGE_TYPE))->SetSelection(0);
	
	WriteListExtension("keyUsage", IDC_KEY_USAGE_CRITIC, IDC_KEY_USAGE_LIST);
}

void DlgExtWizard::ParsePhase4()
{
	((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->Clear();
	((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->Append("SSL/TLS Web Server Authentication", (void*)"serverAuth");
	((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->Append("SSL/TLS Web Client Authentication", (void*)"clientAuth");
	((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->Append("Code signing", (void*)"codeSigning");
	((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->Append("E-mail Protection (S/MIME)", (void*)"emailProtection");
	((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->Append("Trusted Timestamping", (void*)"timeStamping");
	((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->Append("Microsoft Individual Code Signing (authenticode)", (void*)"msCodeInd");
	((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->Append("Microsoft Commercial Code Signing (authenticode)", (void*)"msCodeCom");
	((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->Append("Microsoft Trust List Signing", (void*)"msCTLSign");
	((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->Append("Microsoft Server Gated Crypto", (void*)"msSGC");
	((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->Append("Microsoft Encrypted File System", (void*)"msEFS");
	((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->Append("Netscape Server Gated Crypto", (void*)"nsSGC");
	((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->Append("OCSP Response Signature", (void*)"OCSPSigning");
	((wxComboBox *)Frame->FindWindow(IDC_EXTKEY_USAGE_TYPE))->SetSelection(0);
	
	WriteListExtension("extendedKeyUsage", IDC_EXTKEY_USAGE_CRITIC, IDC_EXTKEY_USAGE_LIST);


	
	((wxComboBox *)Frame->FindWindow(IDC_NSCERT_TYPE_TYPE))->Clear();
	((wxComboBox *)Frame->FindWindow(IDC_NSCERT_TYPE_TYPE))->Append("SSL/TLS Web Server Authentication", (void*)"server");
	((wxComboBox *)Frame->FindWindow(IDC_NSCERT_TYPE_TYPE))->Append("SSL/TLS Web Client Authentication", (void*)"client");
	((wxComboBox *)Frame->FindWindow(IDC_NSCERT_TYPE_TYPE))->Append("E-mail Protection (S/MIME)", (void*)"email");
	((wxComboBox *)Frame->FindWindow(IDC_NSCERT_TYPE_TYPE))->Append("Object Signing", (void*)"objsign");
	((wxComboBox *)Frame->FindWindow(IDC_NSCERT_TYPE_TYPE))->Append("SSL CA", (void*)"sslCA");
	((wxComboBox *)Frame->FindWindow(IDC_NSCERT_TYPE_TYPE))->Append("S/MIME CA", (void*)"emailCA");
	((wxComboBox *)Frame->FindWindow(IDC_NSCERT_TYPE_TYPE))->Append("Object CA", (void*)"objCA");
	((wxComboBox *)Frame->FindWindow(IDC_NSCERT_TYPE_TYPE))->SetSelection(0);
	
	WriteListExtension("nsCertType", IDC_NSCERT_TYPE_CRITIC, IDC_NSCERT_TYPE_LIST);
}

void DlgExtWizard::ModifyPhase1()
{
	wxString CurrentValue;
	wxString TmpValue;

	CurrentValue = "";
	m_Exts->Delete("basicConstraints");
	if(((wxCheckBox *)Frame->FindWindow(IDC_BASIC_CRITIC))->GetValue())
	{
		CurrentValue = "critical, ";
	}
	if(! ((wxComboBox *)Frame->FindWindow(IDC_BASIC))->GetSelection())
	{
		CurrentValue += "CA:FALSE";
	}
	else
	{
		CurrentValue += "CA:TRUE";
	}
	TmpValue = ((wxTextCtrl *)Frame->FindWindow(IDC_PATHLEN))->GetValue();
	if(TmpValue.Len())
	{
		CurrentValue += ", pathlen:";
		CurrentValue += TmpValue;
	}
	m_Exts->Add("basicConstraints", (char*)CurrentValue.GetData());


	CurrentValue = "";
	m_Exts->Delete("subjectKeyIdentifier");
	if(((wxCheckBox *)Frame->FindWindow(IDC_SUBJ_KEYID))->GetValue())
	{
		m_Exts->Add("subjectKeyIdentifier", "hash");
	}


	
	CurrentValue = "";
	m_Exts->Delete("authorityKeyIdentifier");
	if(((wxCheckBox *)Frame->FindWindow(IDC_AUTH_KEYID))->GetValue())
	{
		m_Exts->Add("authorityKeyIdentifier", "keyid:always");
	}
	
	
	ListExtension("subjectAltName", IDC_SUBJ_ALT_CRITIC, IDC_SUBJ_ALT_LIST);
}

void DlgExtWizard::ModifyPhase2()
{
	ListExtension("issuerAltName", IDC_ISSU_ALT_CRITIC, IDC_ISSU_ALT_LIST);
	ListExtension("crlDistributionPoints", IDC_CRLDP_CRITIC, IDC_CRLDP_LIST);
}


void DlgExtWizard::ModifyPhase3()
{
	ListExtension("authorityInfoAccess", IDC_AUTH_INFO_CRITIC, IDC_AUTH_INFO_LIST);
	ListExtension("keyUsage", IDC_KEY_USAGE_CRITIC, IDC_KEY_USAGE_LIST);
}

void DlgExtWizard::ModifyPhase4()
{
	ListExtension("extendedKeyUsage", IDC_EXTKEY_USAGE_CRITIC, IDC_EXTKEY_USAGE_LIST);
	ListExtension("nsCertType", IDC_NSCERT_TYPE_CRITIC, IDC_NSCERT_TYPE_LIST);
}

void DlgExtWizard::OnPageChanging(wxNotebookEvent &event)
{
	if(loading) return;
	
	switch(event.GetSelection())
	{
		case 0:
			ModifyPhase1();
			break;

		case 1:
			ModifyPhase2();
			break;

		case 2:
			ModifyPhase3();
			break;

		case 3:
			ModifyPhase4();
			break;
	}
}

void DlgExtWizard::OnPageChanged(wxNotebookEvent &event)
{
	if(loading) return;
	switch(event.GetSelection())
	{
		case 0:
			ParsePhase1();
			break;

		case 1:
			ParsePhase2();
			break;

		case 2:
			ParsePhase3();
			break;

		case 3:
			ParsePhase4();
			break;
	}
}


void DlgExtWizard::OnDelCrldpValue(wxCommandEvent& event)
{
	int nItem;
	
	nItem = ((wxListBox *)Frame->FindWindow(IDC_CRLDP_LIST))->GetSelection();
	if(nItem == -1) return;

	((wxListBox *)Frame->FindWindow(IDC_CRLDP_LIST))->Delete(nItem);
}

void DlgExtWizard::OnAddCrldpValue(wxCommandEvent& event)
{
	wxString f_value;
	wxString value;

	value = ((wxTextCtrl *)Frame->FindWindow(IDC_CRLDP_VALUE))->GetValue();
	if(!value.Len()) return;
	f_value += "URI:";
	f_value += value;

	((wxListBox *)Frame->FindWindow(IDC_CRLDP_LIST))->Append(f_value);
}



void DlgExtWizard::ListExtension(char * ExtensioName, int crit_uid, int list_uid)
{
	wxString CurrentValue;
	wxString TmpValue;
	int i;

	CurrentValue = "";		
	m_Exts->Delete(ExtensioName);
	if(((wxListBox *)Frame->FindWindow(list_uid))->GetCount())
	{
		if(crit_uid && ((wxCheckBox *)Frame->FindWindow(crit_uid))->GetValue())
		{
			CurrentValue = "critical, ";
		}
		for(i=0; i<((wxListBox *)Frame->FindWindow(list_uid))->GetCount(); i++)
		{
			TmpValue = ((wxListBox *)Frame->FindWindow(list_uid))->GetString(i);
			if(!TmpValue.Len()) continue;

			CurrentValue += TmpValue;

			if(i != ((wxListBox *)Frame->FindWindow(list_uid))->GetCount() -1)
			{
				CurrentValue += ", ";
			}
		}
		if(CurrentValue.Len())
		{
			m_Exts->Add(ExtensioName, (char*)CurrentValue.GetData());
		}
	}
}

void DlgExtWizard::WriteListExtension(char *ExtensioName, int crit_uid, int list_uid)
{
	const char * Value;
	CONF_VALUE *cnf;
	wxString AddValue;
	STACK_OF(CONF_VALUE) *nval;
	int i;

	((wxListBox *)Frame->FindWindow(list_uid))->Clear();
	
	Value = m_Exts->Get(ExtensioName);
	if(Value)
	{
		if(crit_uid)
		{
			((wxCheckBox *)Frame->FindWindow(crit_uid))->SetValue(v3_check_critical((char**)&Value));
		}

		nval = X509V3_parse_list(Value);
		if(nval)
		{
			for(i = 0; i < sk_CONF_VALUE_num(nval); i++)
			{
				cnf = sk_CONF_VALUE_value(nval, i);
				if(cnf && cnf->name)
				{
					AddValue = cnf->name;
					if(cnf->value)
					{
						AddValue += ":";
						AddValue += cnf->value;
					}
					((wxListBox *)Frame->FindWindow(list_uid))->Append(AddValue);
				}
			}
			sk_CONF_VALUE_pop_free(nval, X509V3_conf_free);
		}
	}
}

