/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgGUI.h: interface for the DlgGUI class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGGUI_H
#define DLGGUI_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "DlgMessage.h"
#include <PkiClient.h>
#include "Error.h"


class DlgGUI: public wxFrame
{
public:
	void OnAbout(wxCommandEvent& event);
	DlgGUI(wxWindow * wParent, PkiClient * ClientPki, const char * EntityName, const char * UserName, const char * Password);
	virtual ~DlgGUI();
	void ShowEntity_Certificate(wxCommandEvent& event);
	void ShowSSL_Certificate(wxCommandEvent& event);
	void OnReconnect(wxCommandEvent &event);
	void OnShowLogs(wxCommandEvent& event);
	void OnQuit(wxCommandEvent &event);
protected:
	PkiClient * m_ClientPki;
	mString m_EntityName;
	mString m_UserName;
	mString m_Password;
	PKI_CERT m_EntityCert;
	DlgMessage * m_DlgMsg;
	const char * GetProfileStatusString(unsigned long status);
	const char * GetCertificateStatusString(unsigned long status);
	const char * GetCertificateTypeString(unsigned long type);
	void SavePKCS12(const PKI_PKCS12 & p12);
private:
	virtual bool ReloadConf() =0;
};

#endif
