/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgImportP12.cpp: implementation of the DlgImportP12 class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgMessage.h"
#include "DlgImportP12.h"
#include "dlgs_wdr.h"
#include "clintl.h"
#include "PkiEnroll.h"
#include "PkiUserCreation.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgImportP12, wxDialog)
    EVT_BUTTON(IDC_OK, DlgImportP12::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgImportP12::OnCancel)
END_EVENT_TABLE()


DlgImportP12::DlgImportP12(wxWindow * wParent, const PKI_PKCS12 & p12):
		wxDialog(wParent, (wxWindowID)-1, _("Import PKCS#12 to CSP"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION)
{
	if(!(m_p12 = p12))
	{
		Close(TRUE);
		return;
	}
	DlgImportP12_SetWindow(this);
	CenterOnScreen();


	PkiUserCreation::LoadProviders((wxComboBox *)FindWindow(IDC_CSP));
	
	ShowModal();
}

DlgImportP12::~DlgImportP12()
{
}

void DlgImportP12::OnCancel(wxCommandEvent& event)
{
	Close(TRUE);
}



void DlgImportP12::OnOk(wxCommandEvent& event)
{	
#ifdef _WIN32
	PkiEnroll enroll;
	wxString m_P12Pwd;
	wxString ProviderName;
	DlgMessage Msg(this);


	m_P12Pwd = ((wxTextCtrl *)FindWindow(IDC_PWD))->GetValue();
	if(!m_P12Pwd.Len())
	{
		return;
	}
	ProviderName = ((wxComboBox *)FindWindow(IDC_CSP))->GetValue();
	if(!ProviderName.Len())
	{
		return;
	}
	if(!m_p12.Reload(m_P12Pwd.GetData()))
	{
		HandleErrorResult(NULL, this, 0);
		return;
	}
	Msg.wShow(_("Importing Certificate..."));
	if(!enroll.import_PKCS12toCSP(ProviderName.GetData(), m_p12))
	{
		Msg.wHide();
		HandleErrorResult(NULL, this, enroll.GetEnrollLastError());
		return;
	}
	Msg.wHide();
	DisplayMessage(this, _("Importation was successful"), wxOK);
#endif
	Close(TRUE);
}

