/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgManageExt.cpp: implementation of the DlgManageExt class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgManageExt.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgManageExt, wxDialog)
    EVT_BUTTON(IDC_OK, DlgManageExt::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgManageExt::OnCancel)
    EVT_BUTTON(IDC_EXT_WIZARD, DlgManageExt::OnExtWizard)
    EVT_BUTTON(IDC_TEMPLATE, DlgManageExt::OnAddTemplate)
    EVT_BUTTON(IDC_ADD_VALUE, DlgManageExt::OnAddValue)
    EVT_BUTTON(IDC_MODIFY_VALUE, DlgManageExt::OnModifyValue)
    EVT_BUTTON(IDC_DELETE_VALUE, DlgManageExt::OnDelValue)
END_EVENT_TABLE()

DlgManageExt::DlgManageExt(wxWindow * wParent, HashTable_String * Ext):wxDialog(wParent, (wxWindowID)-1, _("Manage extensions"), wxDefaultPosition)
{
	m_Ext = Ext;
	// On sauvegarde la liste en cas d'annulation
	SavedListe.AllowDuplicateNames();
	SavedListe = *Ext;

	m_IsOk = false;

	DlgManageExt_SetWindow(this);

	m_listCtrl = ((wxListCtrl *)FindWindow(IDC_LIST_FIELDS));

	wxIcon ico;
	m_imageListSmall = new wxImageList(16, 16, TRUE);	
	ico.CopyFromBitmap(DlgCertProperties_GetBitmap(0));
	m_imageListSmall->Add(ico);

	m_listCtrl->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listCtrl->InsertColumn(0, _("Name"), wxLIST_FORMAT_LEFT, 135);
	m_listCtrl->InsertColumn(1, _("Value"), wxLIST_FORMAT_LEFT, 198);

	ReloadList();


	CenterOnScreen();
	ShowModal();
}

DlgManageExt::~DlgManageExt()
{
	if(m_imageListSmall) delete m_imageListSmall;
}


void DlgManageExt::ReloadList()
{
	const char * Value;
	const char * Name;

	m_listCtrl->DeleteAllItems();

	for(int i=0; i<m_Ext->EntriesCount(); i++)
	{
		Name = m_Ext->GetName(i);
		Value = m_Ext->Get(i);
		
		if(!Name || !Value) continue;
		m_listCtrl->InsertItem(i, Name, 0);
		m_listCtrl->SetItem(i, 1, Value);
		m_listCtrl->SetItemData(i, i);
	}
}




void DlgManageExt::OnAddValue(wxCommandEvent& event)
{
	wxString Ext;

	DlgAddValueExt Dlg(this, "", "");

	if(!Dlg.IsOK()) return;

	const mString & mName = Dlg.GetName();
	const mString & mValue = Dlg.GetValue();

	if(!PKI_EXT::VerifyExtensionValue(mName.c_str(), mValue.c_str()))
	{
		HandleError(NEWPKIerrGetStr(ERROR_BAD_DATAS), NULL);
		return;
	}
	m_Ext->Add(mName.c_str(), mValue.c_str());

	ReloadList();
}

void DlgManageExt::OnModifyValue(wxCommandEvent& event)
{
	const char * mName;
	const char * mValue;

	long SelectedItem;
	wxListItem ItemInfo;



	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	SelectedItem = m_listCtrl->GetItemData(SelectedItem);

	mName = m_Ext->GetName(SelectedItem);
	mValue = m_Ext->Get(SelectedItem);
	if(!mName || !mValue) return;


	DlgAddValueExt Dlg(this, mName, mValue);

	if(!Dlg.IsOK()) return;

	const mString & Name = Dlg.GetName();
	const mString & Value = Dlg.GetValue();

	if(!PKI_EXT::VerifyExtensionValue(Name.c_str(), Value.c_str()))
	{
		HandleError(NEWPKIerrGetStr(ERROR_BAD_DATAS), NULL);
		return;
	}
	
	m_Ext->Delete(SelectedItem);
	m_Ext->Add(Name.c_str(), Value.c_str());
	
	ReloadList();
}

void DlgManageExt::OnDelValue(wxCommandEvent& event)
{
	long SelectedItem;


	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	SelectedItem = m_listCtrl->GetItemData(SelectedItem);
	
	m_Ext->Delete(SelectedItem);
	ReloadList();
}

bool DlgManageExt::IsOK()
{
	return m_IsOk;
}


void DlgManageExt::OnOk(wxCommandEvent& event)
{
	if(DisplayMessage(this, _("Are you sure to want to modify the extensions ?"), wxYES_NO) == wxNO) return;
	m_IsOk = true;
	Close(TRUE);
}


void DlgManageExt::OnExtWizard(wxCommandEvent& event)
{
	DlgExtWizard Dlg(this, m_Ext);

	if(Dlg.IsOK()) ReloadList();
}

void DlgManageExt::OnAddTemplate(wxCommandEvent& event)
{
	wxString name;
	wxArrayString Choices;
	Choices.Add("S/MIME");
	Choices.Add("Cypher");
	Choices.Add("SSL Client");
	Choices.Add("SSL Server");
	Choices.Add("CA Certificate");
	Choices.Add("Object/Code Sign");


	name = wxGetSingleChoice(_("Please select the template"), _("Extension Template"), Choices, this, -1, -1, TRUE);
	if(!name.Len())
		return;


	m_Ext->Clear();

	if(name == "S/MIME")
	{
		m_Ext->Add("basicConstraints", "CA:FALSE");
		m_Ext->Add("nsComment", "NewPKI SMIME User Certificate");
		m_Ext->Add("subjectKeyIdentifier", "hash");
		m_Ext->Add("authorityKeyIdentifier", "keyid:always");
		m_Ext->Add("nsCertType", "email");
		m_Ext->Add("keyUsage", "digitalSignature");
		m_Ext->Add("extendedKeyUsage", "emailProtection");
	}
	else if(name == "Cypher")
	{
		m_Ext->Add("basicConstraints", "CA:FALSE");
		m_Ext->Add("nsComment", "NewPKI Cypher User Certificate");
		m_Ext->Add("subjectKeyIdentifier", "hash");
		m_Ext->Add("authorityKeyIdentifier", "keyid:always");
		m_Ext->Add("keyUsage", "keyEncipherment, dataEncipherment");
		m_Ext->Add("nsCertType", "email");
		m_Ext->Add("extendedKeyUsage", "emailProtection");
	}
	else if(name == "SSL Client")
	{
		m_Ext->Add("basicConstraints", "CA:FALSE");
		m_Ext->Add("nsComment", "NewPKI SSL Client Certificate");
		m_Ext->Add("subjectKeyIdentifier", "hash");
		m_Ext->Add("authorityKeyIdentifier", "keyid:always");
		m_Ext->Add("nsCertType", "client");
		m_Ext->Add("keyUsage", "digitalSignature, nonRepudiation");
		m_Ext->Add("extendedKeyUsage", "clientAuth");
	}
	else if(name == "SSL Server")
	{
		m_Ext->Add("basicConstraints", "CA:FALSE");
		m_Ext->Add("nsComment", "NewPKI SSL Server Certificate");
		m_Ext->Add("subjectKeyIdentifier", "hash");
		m_Ext->Add("authorityKeyIdentifier", "keyid:always");
		m_Ext->Add("nsCertType", "server");
		m_Ext->Add("keyUsage", "digitalSignature, nonRepudiation, keyEncipherment");
		m_Ext->Add("extendedKeyUsage", "serverAuth");
	}
	else if(name == "CA Certificate")
	{
		m_Ext->Add("basicConstraints", "critical, CA:TRUE");
		m_Ext->Add("nsComment", "NewPKI Generated CA Certificate");
		m_Ext->Add("subjectKeyIdentifier", "hash");
		m_Ext->Add("authorityKeyIdentifier", "keyid:always");
		m_Ext->Add("nsCertType", "sslCA, emailCA, objCA");
		m_Ext->Add("keyUsage", "keyCertSign, cRLSign, digitalSignature, nonRepudiation, keyEncipherment");
	}
	else if(name == "Object/Code Sign")
	{
		m_Ext->Add("basicConstraints", "CA:FALSE");
		m_Ext->Add("nsComment", "NewPKI Object/Code Sign Certificate");
		m_Ext->Add("subjectKeyIdentifier", "hash");
		m_Ext->Add("authorityKeyIdentifier", "keyid:always");
		m_Ext->Add("nsCertType", "objsign");
		m_Ext->Add("keyUsage", "digitalSignature");
		m_Ext->Add("extendedKeyUsage", "codeSigning");
	}
	else
	{
		return;
	}

	ReloadList();
}

void DlgManageExt::OnCancel(wxCommandEvent& event)
{
	*m_Ext = SavedListe;
	m_IsOk = false;
	Close(TRUE);
}


