/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgP7bProperties.cpp: implementation of the DlgP7bProperties class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgP7bProperties.h"
#include "dlgs_wdr.h"
#include "clintl.h"
#include "DlgCertProperties.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


BEGIN_EVENT_TABLE(DlgP7bPropertiesListCtrl, wxListCtrl)
    EVT_LIST_ITEM_ACTIVATED(IDC_LIST_CERTS, DlgP7bPropertiesListCtrl::OnItemClick)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(DlgP7bProperties, wxDialog)
    EVT_BUTTON(IDC_OK, DlgP7bProperties::OnOk)
    EVT_BUTTON(IDC_SAVE_P7B, DlgP7bProperties::OnSaveP7b)
END_EVENT_TABLE()

void DlgP7bPropertiesListCtrl::OnItemClick(wxListEvent& event)
{
	DlgP7bProperties * wParent = (DlgP7bProperties *)GetParent();
	wParent->OnItemDblClick(event);
}


DlgP7bProperties::DlgP7bProperties(wxWindow * wParent, const PKI_P7B & p7b):wxDialog(wParent, (wxWindowID)-1, _("PKCS#7 properties"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION), m_p7b(p7b)
{
	m_imageListSmall = NULL;
	InitDatas();
}
DlgP7bProperties::~DlgP7bProperties()
{
	if(m_imageListSmall)
		delete m_imageListSmall;
}

void DlgP7bProperties::OnItemDblClick(wxListEvent& event)
{
	X509 * cert;
	int SelectedItem;
	int index;
	PKI_CERT pCert;

	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	index = (size_t)m_listCtrl->GetItemData(SelectedItem);

	cert = m_p7b.GetCert(index);
	if(!cert)
		return;

	if(!pCert.load_Datas(cert))
		return;

	DlgCertProperties Dlg(this, pCert);
}

void DlgP7bProperties::InitDatas()
{
	DlgP7bProperties_SetWindow(this);

	int i;
	wxIcon ico;
	long pos;
	const char * cn;
	const char * issuer;
	PKI_CERT pCert;
	X509 * cert;


	m_listCtrl = ((DlgP7bPropertiesListCtrl *)FindWindow(IDC_LIST_CERTS));
	m_imageListSmall = new wxImageList(16, 16, TRUE);

	ico.CopyFromBitmap(DlgP7bProperties_GetBitmap(IDB_CERT));
	m_imageListSmall->Add( ico );

	m_listCtrl->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listCtrl->InsertColumn(0, _("Issued To"), wxLIST_FORMAT_LEFT, 100);
	m_listCtrl->InsertColumn(1, _("Issued By"), wxLIST_FORMAT_LEFT, 100);
	m_listCtrl->InsertColumn(2, _("Expiration Date"), wxLIST_FORMAT_LEFT, 100);

	for(i=0; i < m_p7b.GetNumCert(); i++)
	{
		cert = m_p7b.GetCert(i);
		if(!cert)
			continue;
		if(!pCert.load_Datas(cert))
			continue;

		// Subject
		pos = pCert.GetCertDN().SeekEntryName("commonName", HASHTABLE_NOT_FOUND);
		if(pos == HASHTABLE_NOT_FOUND)
			continue;
		cn = pCert.GetCertDN().Get(pos);
		if(!cn)
			continue;

		// Issuer
		pos = pCert.GetIssuerDN().SeekEntryName("commonName", HASHTABLE_NOT_FOUND);
		if(pos != HASHTABLE_NOT_FOUND)
			issuer = pCert.GetIssuerDN().Get(pos);
		else
			issuer = NULL;

		m_listCtrl->InsertItem(i, cn, 0);
		if(issuer)
			m_listCtrl->SetItem(i, 1, issuer);
		m_listCtrl->SetItem(i, 2, FormatTime(pCert.GetEndDate()));
		m_listCtrl->SetItemData(i, (long)i);

	}
	CenterOnScreen();
	ShowModal();
}

void DlgP7bProperties::OnSaveP7b(wxCommandEvent& event)
{
	long pos;
	int i, j;
	const char * cn;
	X509 * cert1;
	X509 * cert2;
	int endcert = 0;
	HashTable_Dn dn;

	for(i=0; i < m_p7b.GetNumCert(); i++)
	{
		cert1 = m_p7b.GetCert(i);
		if(!cert1)
			continue;

		// Am I the issuer of another certificate
		for(j=0; j < m_p7b.GetNumCert(); j++)
		{
			cert2 = m_p7b.GetCert(j);
			if(!cert2)
				continue;

			if(X509_NAME_cmp(cert1->cert_info->subject, 
				cert2->cert_info->issuer) == 0)
				break;
		}
		// No
		if(j == m_p7b.GetNumCert())
		{
			endcert = i;
			break;
		}
	}
	cert1 = m_p7b.GetCert(endcert);
	if(!cert1)
	{
		return;
	}
	if(!dn.From_X509_NAME(cert1->cert_info->subject))
	{
		return;
	}



	pos = dn.SeekEntryName("commonName", HASHTABLE_NOT_FOUND);
	if(pos != HASHTABLE_NOT_FOUND)
	{
		cn = dn.Get(pos);
		if(!cn)
			cn = _("certificate");
	}
	else
		cn = _("certificate");

	wxFileDialog dialog(this, _("Save PKCS#7"), "", cn, _("PKCS#7 File (*.p7b)|*.p7b"), wxSAVE|wxOVERWRITE_PROMPT);

	if (dialog.ShowModal() != wxID_OK)
	{
		return;
	}

	FILE * fd;
	fd = fopen(dialog.GetPath() , "wb");
	if(!fd)
	{
		HandleErrorResult(NULL, this, 0);
		return;
	}
	if(i2d_PKCS7_fp(fd, m_p7b.GetPKCS7()) <= 0)
	{
		HandleError(NULL , this);
	}
	fclose(fd);
}

void DlgP7bProperties::OnOk(wxCommandEvent& event)
{
	Close(TRUE);
}
