/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgRequestCert.cpp: implementation of the DlgRequestCert class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgRequestCert.h"
#include "DlgMessage.h"
#include "Error.h"
#include <sys/stat.h>
#include "DlgCsrProperties.h"
#include "dlgs_wdr.h"
#include "clintl.h"
#include "PkiUserCreation.h"



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgRequestCert, wxDialog)
    EVT_BUTTON(IDC_BROWSE_PKCS10, DlgRequestCert::OnBrowseP10)
    EVT_BUTTON(IDC_P10_PROPERTIES, DlgRequestCert::OnP10Properties)
    EVT_BUTTON(IDC_OK, DlgRequestCert::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgRequestCert::OnCancel)
    EVT_RADIOBUTTON(IDC_GENERATE_PKCS12, DlgRequestCert::OnPkcs12)
    EVT_RADIOBUTTON(IDC_GENERATE_SC, DlgRequestCert::OnLocalKey)
    EVT_RADIOBUTTON(IDC_IMPORT_PKCS10, DlgRequestCert::OnPkcs10)
    EVT_CHECKBOX(IDC_RA_GEN_PWD, DlgRequestCert::OnRaGenPwd)
END_EVENT_TABLE()


DlgRequestCert::DlgRequestCert(wxWindow * wParent, const X509_NAME * profile_dn, const EntityConf & conf, XmlRequest * xmlrequest):wxDialog(wParent, (wxWindowID)-1, xmlrequest?_("Modify a certificate request"):_("Request a certificate"), wxDefaultPosition),
	m_conf(conf)
{
	m_IsOk=false;
	m_IsSc = false;


	m_xmlrequest = xmlrequest;

	if(!m_xmlrequest)
	{
		// We load the DN
		if(!DN.From_X509_NAME(profile_dn))
		{
			HandleErrorResult(NULL, this, 0);
			Close(TRUE);
			return;
		}
	}



	DlgRequestCert_SetWindow(this);


	// The key len
	size_t i;
	wxString label;
	int keylen;
	int lst_len[]={8192, 4096, 2048, 1024, 512, 0};
	int index;

	if(m_xmlrequest)
		keylen = m_xmlrequest->get_KeyLen();
	else
	{
		keylen = (int)m_conf.get_body().get_raConf().RA_CONF_PTR.get_minkeylen();
	}

	index = 0;
	for(i=0; lst_len[i]; i++)
	{
		if(lst_len[i] >= (int)m_conf.get_body().get_raConf().RA_CONF_PTR.get_minkeylen())
		{
			if(lst_len[i] == keylen)
				index = i;

			label.sprintf("%d bits", lst_len[i]);
			((wxComboBox *)FindWindow(IDC_LIST_LEN))->Append(label, (void*)lst_len[i]);
		}
	}
	((wxComboBox *)FindWindow(IDC_LIST_LEN))->SetSelection(index);


	index = 0;
	// The CAs list
	for(i=0; i<m_conf.get_cas().get_list().size(); i++)
	{
		if(m_xmlrequest && m_xmlrequest->get_CaName() == m_conf.get_cas().get_list()[i].get_name())
			index = i;

		((wxComboBox *)FindWindow(IDC_LIST_CA))->Append(m_conf.get_cas().get_list()[i].get_name().c_str());
	}
	((wxComboBox *)FindWindow(IDC_LIST_CA))->SetSelection(index);


	// The validity len
	if(m_xmlrequest)
	{
		label.sprintf("%ld", m_xmlrequest->get_Request().get_validity());
	}
	else
	{
		label.sprintf("%ld", m_conf.get_body().get_raConf().RA_CONF_PTR.get_defaultValidity());
	}
	((wxTextCtrl *)FindWindow(IDC_VALIDITY))->SetValue(label);

	PkiUserCreation::LoadProviders((wxComboBox *)FindWindow(IDC_KEY_CONTAINER), m_xmlrequest?m_xmlrequest->get_CSP().c_str():"");

#ifndef _WIN32
	((wxRadioButton *)FindWindow(IDC_GENERATE_SC))->Enable(FALSE);
#endif

	wxCommandEvent event2;
	if(m_xmlrequest)
	{
		if(ASN1_BIT_STRING_get_bit((ASN1_BIT_STRING*)m_xmlrequest->get_Request().get_flags(), REQUEST_CERT_FLAG_SEND_CERT_TO_USER))
			((wxCheckBox *)FindWindow(IDC_SEND_TO_USER))->SetValue(TRUE);
		
		((wxComboBox *)FindWindow(IDC_LIST_CA))->Enable(FALSE);
		((wxTextCtrl *)FindWindow(IDC_VALIDITY))->Enable(FALSE);
		((wxComboBox *)FindWindow(IDC_LIST_LEN))->Enable(FALSE);

		((wxCheckBox *)FindWindow(IDC_ADMIN_NOTIFY))->Enable(FALSE);
		((wxCheckBox *)FindWindow(IDC_SEND_TO_USER))->Enable(FALSE);

		((wxRadioButton *)FindWindow(IDC_IMPORT_PKCS10))->Enable(FALSE);
		((wxRadioButton *)FindWindow(IDC_GENERATE_PKCS12))->Enable(FALSE);
		((wxRadioButton *)FindWindow(IDC_GENERATE_SC))->Enable(FALSE);

		((wxStaticText *)FindWindow(IDC_LBL_KEY_LEN))->Enable(FALSE);
		((wxComboBox *)FindWindow(IDC_LIST_LEN))->Enable(FALSE);

		((wxButton *)FindWindow(IDC_BROWSE_PKCS10))->Enable(FALSE);
		((wxButton *)FindWindow(IDC_P10_PROPERTIES))->Enable(TRUE);

		((wxComboBox *)FindWindow(IDC_KEY_CONTAINER))->Enable(FALSE);
		((wxRadioButton *)FindWindow(IDC_GENERATE_SC))->Enable(FALSE);

		((wxTextCtrl *)FindWindow(IDC_PWD1))->Enable(FALSE);
		((wxTextCtrl *)FindWindow(IDC_PWD2))->Enable(FALSE);
		((wxStaticText *)FindWindow(IDC_STATIC_PWD1))->Enable(FALSE);
		((wxStaticText *)FindWindow(IDC_STATIC_PWD2))->Enable(FALSE);
		((wxCheckBox *)FindWindow(IDC_RA_GEN_PWD))->Enable(FALSE);
		((wxCheckBox *)FindWindow(IDC_SEND_PASSWORD))->Enable(FALSE);

		((wxCheckBox *)FindWindow(IDC_SEND_TO_USER))->Enable(FALSE);

		switch(m_xmlrequest->get_Request().get_type())
		{
			case NEWPKI_PROFILE_CERT_TYPE_PKCS10:
				if(! (csr = m_xmlrequest->get_Request().get_request().get_pkcs10()) )
				{
					HandleErrorResult(NULL, this, 0);
				}
				((wxRadioButton *)FindWindow(IDC_IMPORT_PKCS10))->SetValue(true);
				((wxButton *)FindWindow(IDC_P10_PROPERTIES))->Enable(TRUE);
				break;
			case NEWPKI_PROFILE_CERT_TYPE_PKCS12:
				((wxTextCtrl *)FindWindow(IDC_PWD1))->SetValue(m_xmlrequest->get_Request().get_request().get_p12Privdatas().get_passwd().c_str());
				((wxTextCtrl *)FindWindow(IDC_PWD2))->SetValue(m_xmlrequest->get_Request().get_request().get_p12Privdatas().get_passwd().c_str());

				if(ASN1_BIT_STRING_get_bit((ASN1_BIT_STRING*)m_xmlrequest->get_Request().get_flags(), REQUEST_CERT_FLAG_SEND_P12_PASSWD_TO_USER))
					((wxCheckBox *)FindWindow(IDC_SEND_PASSWORD))->SetValue(TRUE);

				if(ASN1_BIT_STRING_get_bit((ASN1_BIT_STRING*)m_xmlrequest->get_Request().get_flags(), REQUEST_CERT_FLAG_RA_GENERATE_P12_PASSWD))
					((wxCheckBox *)FindWindow(IDC_RA_GEN_PWD))->SetValue(TRUE);

				((wxRadioButton *)FindWindow(IDC_GENERATE_PKCS12))->SetValue(true);
				((wxRadioButton *)FindWindow(IDC_GENERATE_PKCS12))->Enable(TRUE);
				break;
			case NEWPKI_PROFILE_CERT_TYPE_SC:
#				ifdef _WIN32
				((wxRadioButton *)FindWindow(IDC_GENERATE_SC))->SetValue(true);
				((wxRadioButton *)FindWindow(IDC_GENERATE_SC))->Enable(TRUE);
#				endif
				break;
		}
		((wxButton *)FindWindow(IDC_CANCEL))->Hide();
	}
	else
	{
		((wxRadioButton *)FindWindow(IDC_GENERATE_PKCS12))->SetValue(true);
		OnPkcs12(event2);
	}


	CenterOnScreen();
	ShowModal();
}

DlgRequestCert::~DlgRequestCert()
{
}

void DlgRequestCert::OnOk(wxCommandEvent &event)
{
#ifdef _WIN32
	wxString ProviderName;
#endif

	if(m_xmlrequest)
	{
		m_IsOk= true;
		Close(TRUE);
		return;
	}

	if(DisplayMessage(this, _("Are you sure, you want to sign this request ?"), wxYES_NO) == wxNO) return;

	int RsaLen;
	int nItem;
	wxString Passwd1;
	wxString Passwd2;
	wxString CaName;
	long validity;
	DlgMessage Msg(this);

	// Get Key len
	nItem = ((wxComboBox *)FindWindow(IDC_LIST_LEN))->GetSelection();
	if(nItem == -1)
		return;
	RsaLen = (long)((wxComboBox *)FindWindow(IDC_LIST_LEN))->GetClientData(nItem);

	// Get the CA name
	CaName = ((wxComboBox *)FindWindow(IDC_LIST_CA))->GetValue();
	if(!CaName.Len())
		return;

	// Get Validity
	Passwd1 = ((wxTextCtrl *)FindWindow(IDC_VALIDITY))->GetValue();
	if(!Passwd1.Len())
		return;
	if(!Passwd1.ToLong(&validity))
		return;

	m_cert_request.Clear();

	if(m_xmlrequest)
		m_xmlrequest->set_CaName(CaName.c_str());

	m_cert_request.set_caName(CaName.c_str());
	m_cert_request.set_validity(validity);
	
	if(((wxCheckBox *)FindWindow(IDC_SEND_TO_USER))->GetValue())
		ASN1_BIT_STRING_set_bit(m_cert_request.get_flags(), REQUEST_CERT_FLAG_SEND_CERT_TO_USER, 1);
	else
		ASN1_BIT_STRING_set_bit(m_cert_request.get_flags(), REQUEST_CERT_FLAG_SEND_CERT_TO_USER, 0);

	if(((wxCheckBox *)FindWindow(IDC_ADMIN_NOTIFY))->GetValue())
		ASN1_BIT_STRING_set_bit(m_cert_request.get_flags(), REQUEST_CERT_FLAG_SEND_ADMIN_NOTIFICATION, 1);
	else
		ASN1_BIT_STRING_set_bit(m_cert_request.get_flags(), REQUEST_CERT_FLAG_SEND_ADMIN_NOTIFICATION, 0);

	if(((wxCheckBox *)FindWindow(IDC_SEND_PASSWORD))->GetValue())
		ASN1_BIT_STRING_set_bit(m_cert_request.get_flags(), REQUEST_CERT_FLAG_SEND_P12_PASSWD_TO_USER, 1);
	else
		ASN1_BIT_STRING_set_bit(m_cert_request.get_flags(), REQUEST_CERT_FLAG_SEND_P12_PASSWD_TO_USER, 0);

	if(((wxCheckBox *)FindWindow(IDC_RA_GEN_PWD))->GetValue())
		ASN1_BIT_STRING_set_bit(m_cert_request.get_flags(), REQUEST_CERT_FLAG_RA_GENERATE_P12_PASSWD, 1);
	else
		ASN1_BIT_STRING_set_bit(m_cert_request.get_flags(), REQUEST_CERT_FLAG_RA_GENERATE_P12_PASSWD, 0);


	// Shall we generate a key in a SmartCard ?
	if( ((wxRadioButton *)FindWindow(IDC_GENERATE_SC))->GetValue() )
	{
#ifdef _WIN32
		m_cert_request.get_request().set_type(REQUEST_CERT_BODY_PKCS10);
		m_IsSc = true;

		// We get the provider name
		ProviderName = ((wxComboBox *)FindWindow(IDC_KEY_CONTAINER))->GetValue();
		if(!ProviderName.Len())
		{
			m_cert_request.Clear();
			return;
		}

		if(!m_xmlrequest)
		{
			char * strCsr;

			Msg.wShow(_("Generating Certificate Request..."));
			strCsr = Enroll.CreatePkcs10(&DN, (char *)ProviderName.GetData(), RsaLen);
			Msg.wHide();

			if(!strCsr)
			{
				HandleErrorResult(NULL, this, Enroll.GetEnrollLastError());
				m_cert_request.Clear();
				return;
			}
			if(!csr.SetCSR(strCsr))
			{
				HandleErrorResult(NULL, this, 0);
				Enroll.DestroyContainer();
				m_cert_request.Clear();
				return;
			}
		}
		else
		{
			m_xmlrequest->set_CSP(ProviderName.GetData());
			m_xmlrequest->set_KeyLen(RsaLen);
		}
		m_cert_request.set_type(NEWPKI_PROFILE_CERT_TYPE_SC);
#endif
	}
	else if( ((wxRadioButton *)FindWindow(IDC_GENERATE_PKCS12))->GetValue() )
	{
		m_cert_request.get_request().set_type(REQUEST_CERT_BODY_PKCS12);

		wxString Passwd2;

		if(!((wxCheckBox *)FindWindow(IDC_RA_GEN_PWD))->GetValue())
		{
			Passwd1 = ((wxTextCtrl *)FindWindow(IDC_PWD1))->GetValue();
			Passwd2 = ((wxTextCtrl *)FindWindow(IDC_PWD2))->GetValue();

			if(!Passwd1.Len() || !Passwd2.Len())
			{
				m_cert_request.Clear();
				return;
			}

			if(wxStrcmp(Passwd1, Passwd2) != 0)
			{
				HandleError(_("The two passwords don't match."), this);
				m_cert_request.Clear();
				return;
			}
			if(Passwd1.Len() < (unsigned int)m_conf.get_body().get_raConf().RA_CONF_PTR.get_minpwdlen())
			{
				Passwd1.sprintf("%s (%ld)", _("The password doesn't respect the minimum length."), m_conf.get_body().get_raConf().RA_CONF_PTR.get_minpwdlen());
				HandleError(Passwd1.c_str(), this);
				m_cert_request.Clear();
				return;
			}
		}

		m_cert_request.set_type(NEWPKI_PROFILE_CERT_TYPE_PKCS12);
		if(m_xmlrequest)
			m_xmlrequest->set_KeyLen(RsaLen);
	}
	else if( ((wxRadioButton *)FindWindow(IDC_IMPORT_PKCS10))->GetValue() )
	{
		m_cert_request.get_request().set_type(REQUEST_CERT_BODY_PKCS10);

		if(!csr.GetX509_REQ())
		{
			m_cert_request.Clear();
			return;
		}
		if(m_xmlrequest)
			m_xmlrequest->set_KeyLen((EVP_PKEY_size((EVP_PKEY*)csr.GetPublicKey())*8));

		m_cert_request.set_type(NEWPKI_PROFILE_CERT_TYPE_PKCS10);
	}

	switch(m_cert_request.get_request().get_type())
	{
		case REQUEST_CERT_BODY_PKCS10:
			if(!m_xmlrequest || !m_IsSc)
			{
				if(! (m_cert_request.get_request().get_pkcs10() = csr) )
				{
					HandleError(NEWPKIerrGetStr(ERROR_MALLOC), this);
#ifdef _WIN32
					if(m_IsSc) Enroll.DestroyContainer();
#endif
					m_cert_request.Clear();
					return;
				}
			}
			else
			{
				m_cert_request.get_request().get_pkcs10().Clear();
			}
			break;
		case REQUEST_CERT_BODY_PKCS12:
			m_cert_request.get_request().get_p12Privdatas().set_keylen(RsaLen);

			if(!((wxCheckBox *)FindWindow(IDC_RA_GEN_PWD))->GetValue())
			{
				m_cert_request.get_request().get_p12Privdatas().set_passwd(Passwd1.c_str());
			}
			break;
	}
	m_IsOk= true;
	Close(TRUE);
}

bool DlgRequestCert::IsOk()
{
	return m_IsOk;
}

void DlgRequestCert::OnBrowseP10(wxCommandEvent& event)
{
	char * strCsr;
	wxFileDialog dialog(this, _("Open CSR"), "", "", _("CSR File (*.csr)|*.csr"), wxOPEN);
	if (dialog.ShowModal() != wxID_OK)
	{
		return;
	}
	struct stat st;
	FILE * fd;
	if(stat(dialog.GetPath(), &st) == -1)
	{
		HandleErrorResult(NULL, this, 0);
		return;
	}
	fd = fopen(dialog.GetPath(), "rb");
	if(!fd)
	{
		HandleErrorResult(NULL, this, 0);
		return;
	}
	strCsr = (char*)malloc(st.st_size);
	if(!strCsr)
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_MALLOC);
		HandleErrorResult(NULL, this, 0);
		fclose(fd);
		return;
	}
	fread(strCsr, st.st_size, 1, fd);
	fclose(fd);

	if(!csr.SetCSR(strCsr))
	{
		free(strCsr);
		HandleErrorResult(NULL, this, 0);
		return;
	}
	free(strCsr);
	((wxButton *)FindWindow(IDC_P10_PROPERTIES))->Enable(TRUE);
}

void DlgRequestCert::OnP10Properties(wxCommandEvent& event)
{
	DlgCsrProperties Dlg(this, csr);
}


void DlgRequestCert::OnPkcs12(wxCommandEvent &event)
{
	if(m_xmlrequest)
		return;

	((wxStaticText *)FindWindow(IDC_LBL_KEY_LEN))->Enable(TRUE);
	((wxComboBox *)FindWindow(IDC_LIST_LEN))->Enable(TRUE);

	((wxComboBox *)FindWindow(IDC_KEY_CONTAINER))->Enable(FALSE);

	((wxButton *)FindWindow(IDC_BROWSE_PKCS10))->Enable(FALSE);
	((wxButton *)FindWindow(IDC_P10_PROPERTIES))->Enable(FALSE);

	((wxCheckBox *)FindWindow(IDC_SEND_TO_USER))->Enable(TRUE);

	((wxCheckBox *)FindWindow(IDC_RA_GEN_PWD))->Enable(TRUE);
	OnRaGenPwd(event);
}

void DlgRequestCert::OnLocalKey(wxCommandEvent &event)
{
	if(m_xmlrequest)
		return;

	((wxStaticText *)FindWindow(IDC_LBL_KEY_LEN))->Enable(TRUE);
	((wxComboBox *)FindWindow(IDC_LIST_LEN))->Enable(TRUE);

	((wxComboBox *)FindWindow(IDC_KEY_CONTAINER))->Enable(TRUE);

	((wxButton *)FindWindow(IDC_BROWSE_PKCS10))->Enable(FALSE);
	((wxButton *)FindWindow(IDC_P10_PROPERTIES))->Enable(FALSE);

	((wxTextCtrl *)FindWindow(IDC_PWD1))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_PWD2))->Enable(FALSE);
	((wxStaticText *)FindWindow(IDC_STATIC_PWD1))->Enable(FALSE);
	((wxStaticText *)FindWindow(IDC_STATIC_PWD2))->Enable(FALSE);
	((wxCheckBox *)FindWindow(IDC_RA_GEN_PWD))->Enable(FALSE);
	((wxCheckBox *)FindWindow(IDC_SEND_PASSWORD))->Enable(FALSE);

	((wxCheckBox *)FindWindow(IDC_SEND_TO_USER))->SetValue(FALSE);
	((wxCheckBox *)FindWindow(IDC_SEND_TO_USER))->Enable(FALSE);
}

void DlgRequestCert::OnPkcs10(wxCommandEvent &event)
{
	if(m_xmlrequest)
		return;

	((wxStaticText *)FindWindow(IDC_LBL_KEY_LEN))->Enable(FALSE);
	((wxComboBox *)FindWindow(IDC_LIST_LEN))->Enable(FALSE);

	((wxButton *)FindWindow(IDC_BROWSE_PKCS10))->Enable(TRUE);
	((wxButton *)FindWindow(IDC_P10_PROPERTIES))->Enable(FALSE);

	((wxComboBox *)FindWindow(IDC_KEY_CONTAINER))->Enable(FALSE);

	((wxTextCtrl *)FindWindow(IDC_PWD1))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_PWD2))->Enable(FALSE);
	((wxStaticText *)FindWindow(IDC_STATIC_PWD1))->Enable(FALSE);
	((wxStaticText *)FindWindow(IDC_STATIC_PWD2))->Enable(FALSE);
	((wxCheckBox *)FindWindow(IDC_RA_GEN_PWD))->Enable(FALSE);
	((wxCheckBox *)FindWindow(IDC_SEND_PASSWORD))->Enable(FALSE);

	((wxCheckBox *)FindWindow(IDC_SEND_TO_USER))->Enable(TRUE);
}

void DlgRequestCert::OnCancel(wxCommandEvent &event)
{
	m_IsOk=false;
	Close(TRUE);
}

void DlgRequestCert::OnRaGenPwd(wxCommandEvent &event)
{
	bool value = ((wxCheckBox *)FindWindow(IDC_RA_GEN_PWD))->GetValue();

	((wxTextCtrl *)FindWindow(IDC_PWD1))->Enable(!value);
	((wxTextCtrl *)FindWindow(IDC_PWD2))->Enable(!value);
	((wxStaticText *)FindWindow(IDC_STATIC_PWD1))->Enable(!value);
	((wxStaticText *)FindWindow(IDC_STATIC_PWD2))->Enable(!value);
	((wxCheckBox *)FindWindow(IDC_SEND_PASSWORD))->Enable(!value);

	if(value)
		((wxCheckBox *)FindWindow(IDC_SEND_PASSWORD))->SetValue(value);
}

void DlgRequestCert::Cancel()
{
#ifdef _WIN32
	if(m_IsSc)
		Enroll.DestroyContainer();
#endif
}

const NewpkiRequestCert & DlgRequestCert::get_Request()
{
	return m_cert_request;
}
