/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/



#include "Functions.h"

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif


char * FormatTime(time_t timeValue)
{
	static char ret[50];
	char * res = ret;
	struct tm * tmval;

	if(!timeValue)
	{
		strcpy(ret, "undefined");
	}
	else
	{
		tmval = localtime(&timeValue);
		sprintf(ret, "%.2d/%.2d/%.2d %.2d:%.2d:%.2d GMT", tmval->tm_mday, tmval->tm_mon + 1, tmval->tm_year+1900, tmval->tm_hour, tmval->tm_min, tmval->tm_sec);
	}

	return res;
}


mString FormatDN(const HashTable_Dn & DN, bool tabSeparated)
{
	int j;
	const char * dnCurrName;
	const char * dnCurrValue;
	int nid;
	mString retDn;

	for(j=0; j<DN.EntriesCount(); j++)
	{
		dnCurrName=DN.GetName(j);
		if(!dnCurrName) continue;

		dnCurrValue=DN.Get(j);

		if(!dnCurrValue) continue;

		IsValidObject(dnCurrName);

		nid = OBJ_ln2nid(dnCurrName);
		
		retDn += OBJ_nid2sn(nid);
		retDn += "=";
		retDn += dnCurrValue;

		if(j < (DN.EntriesCount()-1))
		{
			if(tabSeparated)
				retDn += " ,  ";
			else
				retDn += "\n";

		}
	}

	return retDn;
}


char * Unix2Win(char * Buffer, char * Header, char * Footer)
{
	size_t DatasLen;
	char * Datas;
	char * LastOccur;
	char * CurrOccur;


	DatasLen = strlen(Buffer) + 150;
	if(Header) DatasLen = DatasLen + strlen(Header);
	if(Footer) DatasLen = DatasLen + strlen(Footer);


	Datas = (char *)malloc(DatasLen);
	if(!Datas)
	{
		return NULL;
	}
	*Datas = 0;

	if(Header) strcpy(Datas , Header);

	if(!strstr(Buffer, "\n"))
	{
		strcat(Datas, Buffer);
	}
	else
	{
		LastOccur = Buffer;
		while( (CurrOccur = strstr(LastOccur, "\n")) )
		{
			strncat(Datas, LastOccur, CurrOccur - LastOccur);
			strcat(Datas, "\n");
			LastOccur = CurrOccur + 1; 
		}
		if(*LastOccur)
		{
			strcat(Datas, LastOccur);
		}
	}

	if(Footer)
	{
		if(Datas[strlen(Datas)-1] != '\n') strcat(Datas , "\n");
		strcat(Datas , Footer);
	}

	return Datas;
}

int DisplayMessage(wxWindow * wParent, const char * Message, unsigned int Type)
{
	return wxMessageBox(Message, "NewPKI", Type, wParent);
}
