/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "Asn1Cert.h"
#include <PKI_ERR.h>
#include <openssl/asn1t.h>

ASN1_SEQUENCE(NEWPKI_REQUEST_CERT_BODY_P12) = {
	ASN1_SIMPLE(NEWPKI_REQUEST_CERT_BODY_P12, keylen, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_REQUEST_CERT_BODY_P12, passwd, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(NEWPKI_REQUEST_CERT_BODY_P12)
ASN1_CHOICE(NEWPKI_REQUEST_CERT_BODY) = {
	ASN1_EXP(NEWPKI_REQUEST_CERT_BODY, d.pkcs10, X509_REQ, REQUEST_CERT_BODY_PKCS10),
	ASN1_EXP(NEWPKI_REQUEST_CERT_BODY, d.p12_privdatas, NEWPKI_REQUEST_CERT_BODY_P12, REQUEST_CERT_BODY_PKCS12),
} ASN1_CHOICE_END(NEWPKI_REQUEST_CERT_BODY)
ASN1_SEQUENCE(NEWPKI_REQUEST_CERT) = {
	ASN1_SIMPLE(NEWPKI_REQUEST_CERT, profile_id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_REQUEST_CERT, ca_name, ASN1_UTF8STRING),
	ASN1_SIMPLE(NEWPKI_REQUEST_CERT, request, NEWPKI_REQUEST_CERT_BODY),
	ASN1_SIMPLE(NEWPKI_REQUEST_CERT, validity, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_REQUEST_CERT, type, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_REQUEST_CERT, flags, ASN1_BIT_STRING),
}ASN1_SEQUENCE_END(NEWPKI_REQUEST_CERT)
ASN1_SEQUENCE(NEWPKI_EE_REQUEST_CERT) = {
	ASN1_SIMPLE(NEWPKI_EE_REQUEST_CERT, profile_id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_REQUEST_CERT, ca_name, ASN1_UTF8STRING),
	ASN1_SIMPLE(NEWPKI_EE_REQUEST_CERT, request, NEWPKI_REQUEST_CERT_BODY),
	ASN1_SIMPLE(NEWPKI_EE_REQUEST_CERT, type, ASN1_INTEGER),
}ASN1_SEQUENCE_END(NEWPKI_EE_REQUEST_CERT)
ASN1_SEQUENCE(NEWPKI_EE_REQUEST_REV) = {
	ASN1_SIMPLE(NEWPKI_EE_REQUEST_REV, cert_id, ASN1_INTEGER),
}ASN1_SEQUENCE_END(NEWPKI_EE_REQUEST_REV)
ASN1_SEQUENCE(NEWPKI_CERT_REQUEST) = {
	ASN1_SIMPLE(NEWPKI_CERT_REQUEST, id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_CERT_REQUEST, request, X509_REQ),
	ASN1_SIMPLE(NEWPKI_CERT_REQUEST, validity, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_CERT_REQUEST, ldap_uid, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(NEWPKI_CERT_REQUEST)
ASN1_SEQUENCE(NEWPKI_REV_REQUEST) = {
	ASN1_SIMPLE(NEWPKI_REV_REQUEST, id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_REV_REQUEST, serial, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_REV_REQUEST, reason, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_REV_REQUEST, ldap_uid, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(NEWPKI_REV_REQUEST)
ASN1_SEQUENCE(NEWPKI_SUSP_REQUEST) = {
	ASN1_SIMPLE(NEWPKI_SUSP_REQUEST, id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_SUSP_REQUEST, serial, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_SUSP_REQUEST, ldap_uid, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(NEWPKI_SUSP_REQUEST)
ASN1_SEQUENCE(NEWPKI_UNSUSP_REQUEST) = {
	ASN1_SIMPLE(NEWPKI_UNSUSP_REQUEST, id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_UNSUSP_REQUEST, serial, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_UNSUSP_REQUEST, ldap_uid, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(NEWPKI_UNSUSP_REQUEST)
ASN1_SEQUENCE(NEWPKI_PUB_REQUEST_BODY_REV) = {
	ASN1_SIMPLE(NEWPKI_PUB_REQUEST_BODY_REV, cert, X509),
	ASN1_SIMPLE(NEWPKI_PUB_REQUEST_BODY_REV, revdate, ASN1_UTCTIME),
}ASN1_SEQUENCE_END(NEWPKI_PUB_REQUEST_BODY_REV)
ASN1_CHOICE(NEWPKI_PUB_REQUEST_BODY) = {
	ASN1_EXP(NEWPKI_PUB_REQUEST_BODY, d.cert, X509, NEWPKI_PUB_REQUEST_CERT),
	ASN1_EXP(NEWPKI_PUB_REQUEST_BODY, d.rev, NEWPKI_PUB_REQUEST_BODY_REV, NEWPKI_PUB_REQUEST_REV),
	ASN1_EXP(NEWPKI_PUB_REQUEST_BODY, d.crl, X509_CRL, NEWPKI_PUB_REQUEST_CRL),
} ASN1_CHOICE_END(NEWPKI_PUB_REQUEST_BODY)
ASN1_SEQUENCE(NEWPKI_PUB_REQUEST) = {
	ASN1_SIMPLE(NEWPKI_PUB_REQUEST, ldap_uid, ASN1_UTF8STRING),
	ASN1_SEQUENCE_OF(NEWPKI_PUB_REQUEST, ParentCerts, X509),
	ASN1_SIMPLE(NEWPKI_PUB_REQUEST, object, ASN1_UTF8STRING),
	ASN1_SIMPLE(NEWPKI_PUB_REQUEST, body, NEWPKI_PUB_REQUEST_BODY),
}ASN1_SEQUENCE_END(NEWPKI_PUB_REQUEST)
ASN1_SEQUENCE(NEWPKI_BACKUP_REQUEST) = {
	ASN1_SIMPLE(NEWPKI_BACKUP_REQUEST, sym_algo, ASN1_OBJECT),
	ASN1_SIMPLE(NEWPKI_BACKUP_REQUEST, backup, ASN1_OCTET_STRING),
}ASN1_SEQUENCE_END(NEWPKI_BACKUP_REQUEST)
ASN1_SEQUENCE(NEWPKI_EE_VAL_REQUEST) = {
	ASN1_SIMPLE(NEWPKI_EE_VAL_REQUEST, ra_id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_VAL_REQUEST, dn, X509_NAME),
}ASN1_SEQUENCE_END(NEWPKI_EE_VAL_REQUEST)
ASN1_SEQUENCE(NEWPKI_EE_DN_PUBLISH) = {
	ASN1_SIMPLE(NEWPKI_EE_DN_PUBLISH, ee_id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_DN_PUBLISH, dn, X509_NAME),
}ASN1_SEQUENCE_END(NEWPKI_EE_DN_PUBLISH)
ASN1_SEQUENCE(NEWPKI_EE_DN_REMOVE) = {
	ASN1_SIMPLE(NEWPKI_EE_DN_REMOVE, ee_id, ASN1_INTEGER),
}ASN1_SEQUENCE_END(NEWPKI_EE_DN_REMOVE)
ASN1_SEQUENCE(NEWPKI_EE_UPDATE_CERT_STATUS) = {
	ASN1_SIMPLE(NEWPKI_EE_UPDATE_CERT_STATUS, ra_id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_UPDATE_CERT_STATUS, status, ASN1_INTEGER),
	ASN1_EXP_OPT(NEWPKI_EE_UPDATE_CERT_STATUS, last_crl, X509_CRL, 0),
}ASN1_SEQUENCE_END(NEWPKI_EE_UPDATE_CERT_STATUS)
ASN1_SEQUENCE(NEWPKI_EE_CERT_PUBLISH) = {
	ASN1_SIMPLE(NEWPKI_EE_CERT_PUBLISH, profile_id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_CERT_PUBLISH, ra_id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_CERT_PUBLISH, type, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_CERT_PUBLISH, ca_name, ASN1_UTF8STRING),
	ASN1_SIMPLE(NEWPKI_EE_CERT_PUBLISH, certificate, X509),
	ASN1_EXP_OPT(NEWPKI_EE_CERT_PUBLISH, p7b, PKCS7, 0),
	ASN1_EXP_OPT(NEWPKI_EE_CERT_PUBLISH, p12, PKCS12, 1),
	ASN1_EXP_OPT(NEWPKI_EE_CERT_PUBLISH, last_crl, X509_CRL, 2),
}ASN1_SEQUENCE_END(NEWPKI_EE_CERT_PUBLISH)
ASN1_CHOICE(NEWPKI_REQUEST) = {
	ASN1_EXP(NEWPKI_REQUEST, d.cert_request, NEWPKI_CERT_REQUEST, NEWPKI_REQUEST_TYPE_CERT),
	ASN1_EXP(NEWPKI_REQUEST, d.rev_request, NEWPKI_REV_REQUEST, NEWPKI_REQUEST_TYPE_REV),
	ASN1_EXP(NEWPKI_REQUEST, d.pub_request, NEWPKI_PUB_REQUEST, NEWPKI_REQUEST_TYPE_PUB),
	ASN1_EXP(NEWPKI_REQUEST, d.backup_request, NEWPKI_BACKUP_REQUEST, NEWPKI_REQUEST_TYPE_BACKUP),
	ASN1_EXP(NEWPKI_REQUEST, d.ee_val_request, NEWPKI_EE_VAL_REQUEST, NEWPKI_REQUEST_TYPE_EE_VAL),
	ASN1_EXP(NEWPKI_REQUEST, d.ee_dn_publish, NEWPKI_EE_DN_PUBLISH, NEWPKI_REQUEST_TYPE_EE_DN_PUBLISH),
	ASN1_EXP(NEWPKI_REQUEST, d.ee_dn_remove, NEWPKI_EE_DN_REMOVE, NEWPKI_REQUEST_TYPE_EE_DN_REMOVE),
	ASN1_EXP(NEWPKI_REQUEST, d.ee_cert_request, NEWPKI_EE_REQUEST_CERT, NEWPKI_REQUEST_TYPE_EE_CERT),
	ASN1_EXP(NEWPKI_REQUEST, d.susp_request, NEWPKI_SUSP_REQUEST, NEWPKI_REQUEST_TYPE_SUSP),
	ASN1_EXP(NEWPKI_REQUEST, d.unsusp_request, NEWPKI_UNSUSP_REQUEST, NEWPKI_REQUEST_TYPE_UNSUSP),
	ASN1_EXP(NEWPKI_REQUEST, d.ee_cert_revoke, NEWPKI_EE_REQUEST_REV, NEWPKI_REQUEST_TYPE_EE_REV),
	ASN1_EXP(NEWPKI_REQUEST, d.ee_upd_cert_status, NEWPKI_EE_UPDATE_CERT_STATUS, NEWPKI_REQUEST_TYPE_EE_UPDATE_CERT_STATUS),
	ASN1_EXP(NEWPKI_REQUEST, d.ee_cert_publish, NEWPKI_EE_CERT_PUBLISH, NEWPKI_REQUEST_TYPE_EE_CERT_PUBLISH),
} ASN1_CHOICE_END(NEWPKI_REQUEST)
ASN1_SEQUENCE(CRYPTED_NEWPKI_REQUEST) = {
	ASN1_SIMPLE(CRYPTED_NEWPKI_REQUEST, sender, X509_PUBKEY),
	ASN1_SIMPLE(CRYPTED_NEWPKI_REQUEST, recipient, X509_PUBKEY),
	ASN1_SIMPLE(CRYPTED_NEWPKI_REQUEST, c_request, ASN1_ENCRYPT_SIGN),
	ASN1_SIMPLE(CRYPTED_NEWPKI_REQUEST, transactionID, ASN1_OCTET_STRING),
}ASN1_SEQUENCE_END(CRYPTED_NEWPKI_REQUEST)
ASN1_SEQUENCE(CRYPTED_NEWPKI_REQUESTS) = {
	ASN1_SEQUENCE_OF(CRYPTED_NEWPKI_REQUESTS, requests, CRYPTED_NEWPKI_REQUEST),
}ASN1_SEQUENCE_END(CRYPTED_NEWPKI_REQUESTS)
ASN1_SEQUENCE(NEWPKI_CERT_RESPONSE) = {
	ASN1_SIMPLE(NEWPKI_CERT_RESPONSE, id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_CERT_RESPONSE, status, ASN1_INTEGER),
	ASN1_EXP_OPT(NEWPKI_CERT_RESPONSE, certificate, X509, 0),
	ASN1_EXP_SEQUENCE_OF_OPT(NEWPKI_CERT_RESPONSE, ParentCerts, X509, 1),
	ASN1_EXP_SEQUENCE_OF_OPT(NEWPKI_CERT_RESPONSE, errors, ERROR_ENTRY, 2),
	ASN1_EXP_OPT(NEWPKI_CERT_RESPONSE, last_crl, X509_CRL, 3),
}ASN1_SEQUENCE_END(NEWPKI_CERT_RESPONSE)
ASN1_SEQUENCE(NEWPKI_EE_CERT_RESPONSE) = {
	ASN1_SIMPLE(NEWPKI_EE_CERT_RESPONSE, status, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_CERT_RESPONSE, ra_id, ASN1_INTEGER),
	ASN1_EXP_OPT(NEWPKI_EE_CERT_RESPONSE, certificate, X509, 0),
	ASN1_EXP_OPT(NEWPKI_EE_CERT_RESPONSE, p7b, PKCS7, 1),
	ASN1_EXP_OPT(NEWPKI_EE_CERT_RESPONSE, p12, PKCS12, 2),
	ASN1_EXP_SEQUENCE_OF_OPT(NEWPKI_EE_CERT_RESPONSE, errors, ERROR_ENTRY, 3),
	ASN1_EXP_OPT(NEWPKI_EE_CERT_RESPONSE, last_crl, X509_CRL, 4),
}ASN1_SEQUENCE_END(NEWPKI_EE_CERT_RESPONSE)
ASN1_SEQUENCE(NEWPKI_REV_RESPONSE) = {
	ASN1_SIMPLE(NEWPKI_REV_RESPONSE, id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_REV_RESPONSE, status, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_REV_RESPONSE, cert_status, ASN1_INTEGER),
	ASN1_EXP_SEQUENCE_OF_OPT(NEWPKI_REV_RESPONSE, errors, ERROR_ENTRY, 0),
	ASN1_EXP_OPT(NEWPKI_REV_RESPONSE, last_crl, X509_CRL, 1),
}ASN1_SEQUENCE_END(NEWPKI_REV_RESPONSE)
ASN1_SEQUENCE(NEWPKI_EE_REV_RESPONSE) = {
	ASN1_SIMPLE(NEWPKI_EE_REV_RESPONSE, ra_id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_REV_RESPONSE, status, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_REV_RESPONSE, cert_status, ASN1_INTEGER),
	ASN1_EXP_SEQUENCE_OF_OPT(NEWPKI_EE_REV_RESPONSE, errors, ERROR_ENTRY, 0),
	ASN1_EXP_OPT(NEWPKI_EE_REV_RESPONSE, last_crl, X509_CRL, 1),
}ASN1_SEQUENCE_END(NEWPKI_EE_REV_RESPONSE)
ASN1_SEQUENCE(NEWPKI_SUSP_RESPONSE) = {
	ASN1_SIMPLE(NEWPKI_SUSP_RESPONSE, id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_SUSP_RESPONSE, status, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_SUSP_RESPONSE, cert_status, ASN1_INTEGER),
	ASN1_EXP_SEQUENCE_OF_OPT(NEWPKI_SUSP_RESPONSE, errors, ERROR_ENTRY, 0),
	ASN1_EXP_OPT(NEWPKI_SUSP_RESPONSE, last_crl, X509_CRL, 1),
}ASN1_SEQUENCE_END(NEWPKI_SUSP_RESPONSE)
ASN1_SEQUENCE(NEWPKI_UNSUSP_RESPONSE) = {
	ASN1_SIMPLE(NEWPKI_UNSUSP_RESPONSE, id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_UNSUSP_RESPONSE, status, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_UNSUSP_RESPONSE, cert_status, ASN1_INTEGER),
	ASN1_EXP_SEQUENCE_OF_OPT(NEWPKI_UNSUSP_RESPONSE, errors, ERROR_ENTRY, 0),
	ASN1_EXP_OPT(NEWPKI_UNSUSP_RESPONSE, last_crl, X509_CRL, 1),
}ASN1_SEQUENCE_END(NEWPKI_UNSUSP_RESPONSE)
ASN1_SEQUENCE(NEWPKI_PUB_RESPONSE) = {
	ASN1_SIMPLE(NEWPKI_PUB_RESPONSE, status, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_PUB_RESPONSE, type, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_PUB_RESPONSE, object, ASN1_UTF8STRING),
	ASN1_EXP_SEQUENCE_OF_OPT(NEWPKI_PUB_RESPONSE, errors, ERROR_ENTRY, 0),
}ASN1_SEQUENCE_END(NEWPKI_PUB_RESPONSE)
ASN1_SEQUENCE(NEWPKI_EE_VAL_RESPONSE) = {
	ASN1_SIMPLE(NEWPKI_EE_VAL_RESPONSE, ra_id, ASN1_INTEGER),
	ASN1_SIMPLE(NEWPKI_EE_VAL_RESPONSE, dn, X509_NAME),
}ASN1_SEQUENCE_END(NEWPKI_EE_VAL_RESPONSE)
ASN1_SEQUENCE(NEWPKI_EE_DN_PUBLISH_RESPONSE) = {
	ASN1_EXP_SEQUENCE_OF_OPT(NEWPKI_EE_DN_PUBLISH_RESPONSE, errors, ERROR_ENTRY, 0),
}ASN1_SEQUENCE_END(NEWPKI_EE_DN_PUBLISH_RESPONSE)
ASN1_SEQUENCE(NEWPKI_EE_DN_REMOVE_RESPONSE) = {
	ASN1_EXP_SEQUENCE_OF_OPT(NEWPKI_EE_DN_REMOVE_RESPONSE, errors, ERROR_ENTRY, 0),
}ASN1_SEQUENCE_END(NEWPKI_EE_DN_REMOVE_RESPONSE)
ASN1_SEQUENCE(NEWPKI_EE_UPDATE_CERT_STATUS_RESPONSE) = {
	ASN1_EXP_SEQUENCE_OF_OPT(NEWPKI_EE_UPDATE_CERT_STATUS_RESPONSE, errors, ERROR_ENTRY, 0),
}ASN1_SEQUENCE_END(NEWPKI_EE_UPDATE_CERT_STATUS_RESPONSE)
ASN1_SEQUENCE(NEWPKI_EE_CERT_PUBLISH_RESPONSE) = {
	ASN1_EXP_SEQUENCE_OF_OPT(NEWPKI_EE_CERT_PUBLISH_RESPONSE, errors, ERROR_ENTRY, 0),
}ASN1_SEQUENCE_END(NEWPKI_EE_CERT_PUBLISH_RESPONSE)
ASN1_CHOICE(NEWPKI_RESPONSE) = {
	ASN1_EXP(NEWPKI_RESPONSE, d.cert_response, NEWPKI_CERT_RESPONSE, NEWPKI_RESPONSE_TYPE_CERT),
	ASN1_EXP(NEWPKI_RESPONSE, d.rev_response, NEWPKI_REV_RESPONSE, NEWPKI_RESPONSE_TYPE_REV),
	ASN1_EXP_SEQUENCE_OF(NEWPKI_RESPONSE, d.errors, ERROR_ENTRY, NEWPKI_RESPONSE_TYPE_ERR),
	ASN1_EXP(NEWPKI_RESPONSE, d.pub_response, NEWPKI_PUB_RESPONSE, NEWPKI_RESPONSE_TYPE_PUB),
	ASN1_EXP(NEWPKI_RESPONSE, d.ee_val_response, NEWPKI_EE_VAL_RESPONSE, NEWPKI_RESPONSE_TYPE_EE_VAL),
	ASN1_EXP(NEWPKI_RESPONSE, d.ee_dn_publish_response, NEWPKI_EE_DN_PUBLISH_RESPONSE, NEWPKI_RESPONSE_TYPE_EE_DN_PUBLISH),
	ASN1_EXP(NEWPKI_RESPONSE, d.ee_dn_remove_response, NEWPKI_EE_DN_REMOVE_RESPONSE, NEWPKI_RESPONSE_TYPE_EE_DN_REMOVE),
	ASN1_EXP(NEWPKI_RESPONSE, d.ee_cert_response, NEWPKI_EE_CERT_RESPONSE, NEWPKI_RESPONSE_TYPE_EE_CERT),
	ASN1_EXP(NEWPKI_RESPONSE, d.susp_response, NEWPKI_SUSP_RESPONSE, NEWPKI_RESPONSE_TYPE_SUSP),
	ASN1_EXP(NEWPKI_RESPONSE, d.unsusp_response, NEWPKI_UNSUSP_RESPONSE, NEWPKI_RESPONSE_TYPE_UNSUSP),
	ASN1_EXP(NEWPKI_RESPONSE, d.ee_rev_response, NEWPKI_EE_REV_RESPONSE, NEWPKI_RESPONSE_TYPE_EE_REV),
	ASN1_EXP(NEWPKI_RESPONSE, d.ee_upd_cert_status_response, NEWPKI_EE_UPDATE_CERT_STATUS_RESPONSE, NEWPKI_RESPONSE_TYPE_EE_UPDATE_CERT_STATUS),
	ASN1_EXP(NEWPKI_RESPONSE, d.ee_cert_publish_response, NEWPKI_EE_CERT_PUBLISH_RESPONSE, NEWPKI_RESPONSE_TYPE_EE_CERT_PUBLISH),
} ASN1_CHOICE_END(NEWPKI_RESPONSE)
ASN1_SEQUENCE(CRYPTED_NEWPKI_RESPONSE) = {
	ASN1_SIMPLE(CRYPTED_NEWPKI_RESPONSE, sender, X509_PUBKEY),
	ASN1_SIMPLE(CRYPTED_NEWPKI_RESPONSE, recipient, X509_PUBKEY),
	ASN1_SIMPLE(CRYPTED_NEWPKI_RESPONSE, c_response, ASN1_ENCRYPT_SIGN),
	ASN1_SIMPLE(CRYPTED_NEWPKI_RESPONSE, transactionID, ASN1_OCTET_STRING),
}ASN1_SEQUENCE_END(CRYPTED_NEWPKI_RESPONSE)
ASN1_SEQUENCE(CRYPTED_NEWPKI_RESPONSES) = {
	ASN1_SEQUENCE_OF(CRYPTED_NEWPKI_RESPONSES, responses, CRYPTED_NEWPKI_RESPONSE),
}ASN1_SEQUENCE_END(CRYPTED_NEWPKI_RESPONSES)
ASN1_CHOICE(WAITING_NEWPKI_OBJECT_BODY) = {
	ASN1_EXP(WAITING_NEWPKI_OBJECT_BODY, d.request, CRYPTED_NEWPKI_REQUEST, NEWPKI_OBJECT_TYPE_REQ),
	ASN1_EXP(WAITING_NEWPKI_OBJECT_BODY, d.response, CRYPTED_NEWPKI_RESPONSE, NEWPKI_OBJECT_TYPE_RESP),
	ASN1_EXP(WAITING_NEWPKI_OBJECT_BODY, d.transactionID, ASN1_OCTET_STRING, NEWPKI_OBJECT_TYPE_DEL),
} ASN1_CHOICE_END(WAITING_NEWPKI_OBJECT_BODY)
ASN1_SEQUENCE(TRANSACTION_IDS) = {
	ASN1_SEQUENCE_OF(TRANSACTION_IDS, transactionIds, ASN1_OCTET_STRING),
}ASN1_SEQUENCE_END(TRANSACTION_IDS)
ASN1_SEQUENCE(WAITING_NEWPKI_OBJECT) = {
	ASN1_SIMPLE(WAITING_NEWPKI_OBJECT, object, WAITING_NEWPKI_OBJECT_BODY),
	ASN1_SEQUENCE_OF(WAITING_NEWPKI_OBJECT, rep_path, X509_PUBKEY),
}ASN1_SEQUENCE_END(WAITING_NEWPKI_OBJECT)
ASN1_SEQUENCE(OBJECTS_LIST_SYNCHRO) = {
	ASN1_SIMPLE(OBJECTS_LIST_SYNCHRO, known_requests, TRANSACTION_IDS),
	ASN1_SIMPLE(OBJECTS_LIST_SYNCHRO, known_responses, TRANSACTION_IDS),
	ASN1_SIMPLE(OBJECTS_LIST_SYNCHRO, want_requests, TRANSACTION_IDS),
	ASN1_SIMPLE(OBJECTS_LIST_SYNCHRO, want_responses, TRANSACTION_IDS),
	ASN1_SIMPLE(OBJECTS_LIST_SYNCHRO, delete_responses, TRANSACTION_IDS),
	ASN1_SEQUENCE_OF(OBJECTS_LIST_SYNCHRO, objects, WAITING_NEWPKI_OBJECT),
}ASN1_SEQUENCE_END(OBJECTS_LIST_SYNCHRO)
ASN1_CHOICE(INTERNAL_CA_KEY) = {
	ASN1_EXP(INTERNAL_CA_KEY, d.privkey, RSAPrivateKey, INTERNAL_CA_KEY_TYPE_KEY),
	ASN1_EXP(INTERNAL_CA_KEY, d.keyid, ASN1_UTF8STRING, INTERNAL_CA_KEY_TYPE_ENGINE),
} ASN1_CHOICE_END(INTERNAL_CA_KEY)
ASN1_SEQUENCE(INTERNAL_CA) = {
	ASN1_SIMPLE(INTERNAL_CA, ca_cert, X509),
	ASN1_SIMPLE(INTERNAL_CA, ca_key, INTERNAL_CA_KEY),
	ASN1_SIMPLE(INTERNAL_CA, crypted_body, ASN1_ENCRYPT_SIGN),
}ASN1_SEQUENCE_END(INTERNAL_CA)
NewpkiRequestCertBodyP12 NewpkiRequestCertBodyP12::EmptyInstance;
bool NewpkiRequestCertBodyP12::set_keylen(unsigned long c_keylen)
{
	m_keylen = c_keylen;
	return true;
}

unsigned long NewpkiRequestCertBodyP12::get_keylen() const
{
	return m_keylen;
}

bool NewpkiRequestCertBodyP12::set_passwd(const mString & c_passwd)
{
	m_passwd = c_passwd;
	return true;
}

const mString & NewpkiRequestCertBodyP12::get_passwd() const
{
	return m_passwd;
}

mString & NewpkiRequestCertBodyP12::get_passwd()
{
	return m_passwd;
}

NewpkiRequestCertBodyP12::NewpkiRequestCertBodyP12():NewPKIObject()
{
	resetAll();
}

NewpkiRequestCertBodyP12::NewpkiRequestCertBodyP12(const NewpkiRequestCertBodyP12 & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiRequestCertBodyP12::~NewpkiRequestCertBodyP12()
{
	Clear();
}

void NewpkiRequestCertBodyP12::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiRequestCertBodyP12::freeAll()
{
}

void NewpkiRequestCertBodyP12::resetAll()
{
	m_keylen = 0;
	m_passwd = "";
}

bool NewpkiRequestCertBodyP12::load_Datas(const NEWPKI_REQUEST_CERT_BODY_P12 * Datas)
{
	Clear();
	if(Datas->keylen)
	{
		m_keylen = ASN1_INTEGER_GET(Datas->keylen);
	}
	if(Datas->passwd)
	{
		m_passwd = Datas->passwd;
	}
	m_isOk=true;
	return true;
}

bool NewpkiRequestCertBodyP12::give_Datas(NEWPKI_REQUEST_CERT_BODY_P12 ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_REQUEST_CERT_BODY_P12*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->keylen && !((*Datas)->keylen = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->keylen, m_keylen) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->keylen);
		(*Datas)->keylen = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->passwd && !((*Datas)->passwd = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_passwd.c_ASN1_UTF8STRING(&(*Datas)->passwd))
	{
		ASN1_UTF8STRING_free((*Datas)->passwd);
		(*Datas)->passwd = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool NewpkiRequestCertBodyP12::operator=(const NewpkiRequestCertBodyP12 & other)
{
	Clear();
	m_keylen = other.m_keylen;
	m_passwd = other.m_passwd;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiRequestCertBodyP12::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_REQUEST_CERT_BODY_P12);
}
NewpkiRequestCertBody NewpkiRequestCertBody::EmptyInstance;
bool NewpkiRequestCertBody::set_type(int c_type)
{
	Clear();
	m_type = c_type;
	if(!malloc_byType(m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

int NewpkiRequestCertBody::get_type() const
{
	 return m_type;
}

bool NewpkiRequestCertBody::set_p12Privdatas(const NewpkiRequestCertBodyP12 & c_p12Privdatas)
{
	if(m_type != 1)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_p12Privdatas) = c_p12Privdatas;
	m_isOk=true;
	return true;
}

const NewpkiRequestCertBodyP12 & NewpkiRequestCertBody::get_p12Privdatas() const
{
	if((m_type != 1) || !m_p12Privdatas)
	{
		return NewpkiRequestCertBodyP12::EmptyInstance;
	}
	return (*m_p12Privdatas);
}

NewpkiRequestCertBodyP12 & NewpkiRequestCertBody::get_p12Privdatas()
{
	if((m_type != 1) || !m_p12Privdatas)
	{
		return NewpkiRequestCertBodyP12::EmptyInstance;
	}
	return (*m_p12Privdatas);
}

bool NewpkiRequestCertBody::set_pkcs10(const PKI_CSR & c_pkcs10)
{
	if(m_type != 0)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_pkcs10) = c_pkcs10;
	m_isOk=true;
	return true;
}

const PKI_CSR & NewpkiRequestCertBody::get_pkcs10() const
{
	if((m_type != 0) || !m_pkcs10)
	{
		return PKI_CSR::EmptyInstance;
	}
	return (*m_pkcs10);
}

PKI_CSR & NewpkiRequestCertBody::get_pkcs10()
{
	if((m_type != 0) || !m_pkcs10)
	{
		return PKI_CSR::EmptyInstance;
	}
	return (*m_pkcs10);
}

bool NewpkiRequestCertBody::malloc_byType (int c_type)
{
	switch(m_type)
	{
		case 1:
			m_p12Privdatas = new NewpkiRequestCertBodyP12();
			if(!m_p12Privdatas)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 0:
			m_pkcs10 = new PKI_CSR();
			if(!m_pkcs10)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
	}

	return true;
}

NewpkiRequestCertBody::NewpkiRequestCertBody():NewPKIObject()
{
	resetAll();
}

NewpkiRequestCertBody::NewpkiRequestCertBody(const NewpkiRequestCertBody & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiRequestCertBody::~NewpkiRequestCertBody()
{
	Clear();
}

void NewpkiRequestCertBody::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiRequestCertBody::freeAll()
{
	if(m_p12Privdatas)
	{
		delete m_p12Privdatas;
	}
	if(m_pkcs10)
	{
		delete m_pkcs10;
	}
}

void NewpkiRequestCertBody::resetAll()
{
	m_type = -1;
	m_p12Privdatas = NULL;
	m_pkcs10 = NULL;
}

bool NewpkiRequestCertBody::load_Datas(const NEWPKI_REQUEST_CERT_BODY * Datas)
{
	Clear();
	if(!set_type(Datas->type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(Datas->type)
	{
		case 1:
			if(Datas->d.p12_privdatas)
			{
				if(!(*m_p12Privdatas).load_Datas(Datas->d.p12_privdatas))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 0:
			if(Datas->d.pkcs10)
			{
				if(!(*m_pkcs10).load_Datas(Datas->d.pkcs10))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}

bool NewpkiRequestCertBody::give_Datas(NEWPKI_REQUEST_CERT_BODY ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_REQUEST_CERT_BODY*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	(*Datas)->type = m_type;
	switch(m_type)
	{
		case 1:
			if(!((*Datas)->d.p12_privdatas = (NEWPKI_REQUEST_CERT_BODY_P12*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_REQUEST_CERT_BODY_P12))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_p12Privdatas).give_Datas(&(*Datas)->d.p12_privdatas))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.p12_privdatas, ASN1_ITEM_rptr(NEWPKI_REQUEST_CERT_BODY_P12));
				(*Datas)->d.p12_privdatas = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 0:
			if(!((*Datas)->d.pkcs10 = (X509_REQ*)ASN1_item_new(ASN1_ITEM_rptr(X509_REQ))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_pkcs10).give_Datas(&(*Datas)->d.pkcs10))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.pkcs10, ASN1_ITEM_rptr(X509_REQ));
				(*Datas)->d.pkcs10 = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
	}
	return true;
}

bool NewpkiRequestCertBody::operator=(const NewpkiRequestCertBody & other)
{
	Clear();
	if(!set_type(other.m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(other.m_type)
	{
		case 1:
			if(!other.m_p12Privdatas)
				break;
			(*m_p12Privdatas) = *(other.m_p12Privdatas);
			break;
		case 0:
			if(!other.m_pkcs10)
				break;
			(*m_pkcs10) = *(other.m_pkcs10);
			break;
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiRequestCertBody::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_REQUEST_CERT_BODY);
}
NewpkiRequestCert NewpkiRequestCert::EmptyInstance;
bool NewpkiRequestCert::set_caName(const mString & c_caName)
{
	m_caName = c_caName;
	return true;
}

const mString & NewpkiRequestCert::get_caName() const
{
	return m_caName;
}

mString & NewpkiRequestCert::get_caName()
{
	return m_caName;
}

bool NewpkiRequestCert::set_flags(const ASN1_BIT_STRING * c_flags)
{
	if(m_flags)
		ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)c_flags);
	if(!m_flags)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const ASN1_BIT_STRING * NewpkiRequestCert::get_flags() const
{
	if(!m_flags)
		((NewpkiRequestCert*)this)->m_flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_flags;
}

ASN1_BIT_STRING * NewpkiRequestCert::get_flags()
{
	if(!m_flags)
		m_flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_flags;
}

bool NewpkiRequestCert::set_profileId(unsigned long c_profileId)
{
	m_profileId = c_profileId;
	return true;
}

unsigned long NewpkiRequestCert::get_profileId() const
{
	return m_profileId;
}

bool NewpkiRequestCert::set_request(const NewpkiRequestCertBody & c_request)
{
	m_request = c_request;
	return true;
}

const NewpkiRequestCertBody & NewpkiRequestCert::get_request() const
{
	return m_request;
}

NewpkiRequestCertBody & NewpkiRequestCert::get_request()
{
	return m_request;
}

bool NewpkiRequestCert::set_type(unsigned long c_type)
{
	m_type = c_type;
	return true;
}

unsigned long NewpkiRequestCert::get_type() const
{
	return m_type;
}

bool NewpkiRequestCert::set_validity(unsigned long c_validity)
{
	m_validity = c_validity;
	return true;
}

unsigned long NewpkiRequestCert::get_validity() const
{
	return m_validity;
}

NewpkiRequestCert::NewpkiRequestCert():NewPKIObject()
{
	resetAll();
}

NewpkiRequestCert::NewpkiRequestCert(const NewpkiRequestCert & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiRequestCert::~NewpkiRequestCert()
{
	Clear();
}

void NewpkiRequestCert::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiRequestCert::freeAll()
{
	if(m_flags)
	{
		ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	}
}

void NewpkiRequestCert::resetAll()
{
	m_caName = "";
	m_flags = NULL;
	m_profileId = 0;
	m_request.Clear();
	m_type = 0;
	m_validity = 0;
}

bool NewpkiRequestCert::load_Datas(const NEWPKI_REQUEST_CERT * Datas)
{
	Clear();
	if(Datas->ca_name)
	{
		m_caName = Datas->ca_name;
	}
	if(Datas->flags)
	{
		if(m_flags)
			ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), Datas->flags);
		if(!m_flags)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->profile_id)
	{
		m_profileId = ASN1_INTEGER_GET(Datas->profile_id);
	}
	if(Datas->request)
	{
		if(!m_request.load_Datas(Datas->request))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->type)
	{
		m_type = ASN1_INTEGER_GET(Datas->type);
	}
	if(Datas->validity)
	{
		m_validity = ASN1_INTEGER_GET(Datas->validity);
	}
	m_isOk=true;
	return true;
}

bool NewpkiRequestCert::give_Datas(NEWPKI_REQUEST_CERT ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_REQUEST_CERT*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->ca_name && !((*Datas)->ca_name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_caName.c_ASN1_UTF8STRING(&(*Datas)->ca_name))
	{
		ASN1_UTF8STRING_free((*Datas)->ca_name);
		(*Datas)->ca_name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(m_flags)
	{
		if((*Datas)->flags)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		if(!((*Datas)->flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (ASN1_VALUE*)m_flags)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->flags)
		{
			(*Datas)->flags = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
			if(!(*Datas)->flags)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->profile_id && !((*Datas)->profile_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->profile_id, m_profileId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->profile_id);
		(*Datas)->profile_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->request && !((*Datas)->request = (NEWPKI_REQUEST_CERT_BODY*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_REQUEST_CERT_BODY))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_request.give_Datas(&(*Datas)->request))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->request, ASN1_ITEM_rptr(NEWPKI_REQUEST_CERT_BODY));
		(*Datas)->request = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->type && !((*Datas)->type = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->type, m_type) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->type);
		(*Datas)->type = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->validity && !((*Datas)->validity = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->validity, m_validity) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->validity);
		(*Datas)->validity = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiRequestCert::operator=(const NewpkiRequestCert & other)
{
	Clear();
	m_caName = other.m_caName;
	if(other.m_flags)
	{
		if(m_flags)
			ASN1_item_free((ASN1_VALUE*)m_flags, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_flags = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)other.m_flags);
		if(!m_flags)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_profileId = other.m_profileId;
	m_request = other.m_request;
	m_type = other.m_type;
	m_validity = other.m_validity;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiRequestCert::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_REQUEST_CERT);
}
NewpkiEeRequestCert NewpkiEeRequestCert::EmptyInstance;
bool NewpkiEeRequestCert::set_caName(const mString & c_caName)
{
	m_caName = c_caName;
	return true;
}

const mString & NewpkiEeRequestCert::get_caName() const
{
	return m_caName;
}

mString & NewpkiEeRequestCert::get_caName()
{
	return m_caName;
}

bool NewpkiEeRequestCert::set_profileId(unsigned long c_profileId)
{
	m_profileId = c_profileId;
	return true;
}

unsigned long NewpkiEeRequestCert::get_profileId() const
{
	return m_profileId;
}

bool NewpkiEeRequestCert::set_request(const NewpkiRequestCertBody & c_request)
{
	m_request = c_request;
	return true;
}

const NewpkiRequestCertBody & NewpkiEeRequestCert::get_request() const
{
	return m_request;
}

NewpkiRequestCertBody & NewpkiEeRequestCert::get_request()
{
	return m_request;
}

bool NewpkiEeRequestCert::set_type(unsigned long c_type)
{
	m_type = c_type;
	return true;
}

unsigned long NewpkiEeRequestCert::get_type() const
{
	return m_type;
}

NewpkiEeRequestCert::NewpkiEeRequestCert():NewPKIObject()
{
	resetAll();
}

NewpkiEeRequestCert::NewpkiEeRequestCert(const NewpkiEeRequestCert & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeRequestCert::~NewpkiEeRequestCert()
{
	Clear();
}

void NewpkiEeRequestCert::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeRequestCert::freeAll()
{
}

void NewpkiEeRequestCert::resetAll()
{
	m_caName = "";
	m_profileId = 0;
	m_request.Clear();
	m_type = 0;
}

bool NewpkiEeRequestCert::load_Datas(const NEWPKI_EE_REQUEST_CERT * Datas)
{
	Clear();
	if(Datas->ca_name)
	{
		m_caName = Datas->ca_name;
	}
	if(Datas->profile_id)
	{
		m_profileId = ASN1_INTEGER_GET(Datas->profile_id);
	}
	if(Datas->request)
	{
		if(!m_request.load_Datas(Datas->request))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->type)
	{
		m_type = ASN1_INTEGER_GET(Datas->type);
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeRequestCert::give_Datas(NEWPKI_EE_REQUEST_CERT ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_REQUEST_CERT*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->ca_name && !((*Datas)->ca_name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_caName.c_ASN1_UTF8STRING(&(*Datas)->ca_name))
	{
		ASN1_UTF8STRING_free((*Datas)->ca_name);
		(*Datas)->ca_name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->profile_id && !((*Datas)->profile_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->profile_id, m_profileId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->profile_id);
		(*Datas)->profile_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->request && !((*Datas)->request = (NEWPKI_REQUEST_CERT_BODY*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_REQUEST_CERT_BODY))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_request.give_Datas(&(*Datas)->request))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->request, ASN1_ITEM_rptr(NEWPKI_REQUEST_CERT_BODY));
		(*Datas)->request = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->type && !((*Datas)->type = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->type, m_type) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->type);
		(*Datas)->type = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiEeRequestCert::operator=(const NewpkiEeRequestCert & other)
{
	Clear();
	m_caName = other.m_caName;
	m_profileId = other.m_profileId;
	m_request = other.m_request;
	m_type = other.m_type;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeRequestCert::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_REQUEST_CERT);
}
NewpkiEeRequestRev NewpkiEeRequestRev::EmptyInstance;
bool NewpkiEeRequestRev::set_certId(unsigned long c_certId)
{
	m_certId = c_certId;
	return true;
}

unsigned long NewpkiEeRequestRev::get_certId() const
{
	return m_certId;
}

NewpkiEeRequestRev::NewpkiEeRequestRev():NewPKIObject()
{
	resetAll();
}

NewpkiEeRequestRev::NewpkiEeRequestRev(const NewpkiEeRequestRev & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeRequestRev::~NewpkiEeRequestRev()
{
	Clear();
}

void NewpkiEeRequestRev::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeRequestRev::freeAll()
{
}

void NewpkiEeRequestRev::resetAll()
{
	m_certId = 0;
}

bool NewpkiEeRequestRev::load_Datas(const NEWPKI_EE_REQUEST_REV * Datas)
{
	Clear();
	if(Datas->cert_id)
	{
		m_certId = ASN1_INTEGER_GET(Datas->cert_id);
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeRequestRev::give_Datas(NEWPKI_EE_REQUEST_REV ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_REQUEST_REV*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->cert_id && !((*Datas)->cert_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->cert_id, m_certId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->cert_id);
		(*Datas)->cert_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiEeRequestRev::operator=(const NewpkiEeRequestRev & other)
{
	Clear();
	m_certId = other.m_certId;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeRequestRev::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_REQUEST_REV);
}
NewpkiCertRequest NewpkiCertRequest::EmptyInstance;
bool NewpkiCertRequest::set_id(unsigned long c_id)
{
	m_id = c_id;
	return true;
}

unsigned long NewpkiCertRequest::get_id() const
{
	return m_id;
}

bool NewpkiCertRequest::set_ldapUid(const mString & c_ldapUid)
{
	m_ldapUid = c_ldapUid;
	return true;
}

const mString & NewpkiCertRequest::get_ldapUid() const
{
	return m_ldapUid;
}

mString & NewpkiCertRequest::get_ldapUid()
{
	return m_ldapUid;
}

bool NewpkiCertRequest::set_request(const PKI_CSR & c_request)
{
	m_request = c_request;
	return true;
}

const PKI_CSR & NewpkiCertRequest::get_request() const
{
	return m_request;
}

PKI_CSR & NewpkiCertRequest::get_request()
{
	return m_request;
}

bool NewpkiCertRequest::set_validity(unsigned long c_validity)
{
	m_validity = c_validity;
	return true;
}

unsigned long NewpkiCertRequest::get_validity() const
{
	return m_validity;
}

NewpkiCertRequest::NewpkiCertRequest():NewPKIObject()
{
	resetAll();
}

NewpkiCertRequest::NewpkiCertRequest(const NewpkiCertRequest & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiCertRequest::~NewpkiCertRequest()
{
	Clear();
}

void NewpkiCertRequest::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiCertRequest::freeAll()
{
}

void NewpkiCertRequest::resetAll()
{
	m_id = 0;
	m_ldapUid = "";
	m_request.Clear();
	m_validity = 0;
}

bool NewpkiCertRequest::load_Datas(const NEWPKI_CERT_REQUEST * Datas)
{
	Clear();
	if(Datas->id)
	{
		m_id = ASN1_INTEGER_GET(Datas->id);
	}
	if(Datas->ldap_uid)
	{
		m_ldapUid = Datas->ldap_uid;
	}
	if(Datas->request)
	{
		if(!m_request.load_Datas(Datas->request))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->validity)
	{
		m_validity = ASN1_INTEGER_GET(Datas->validity);
	}
	m_isOk=true;
	return true;
}

bool NewpkiCertRequest::give_Datas(NEWPKI_CERT_REQUEST ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_CERT_REQUEST*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->id && !((*Datas)->id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->id, m_id) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->id);
		(*Datas)->id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ldap_uid && !((*Datas)->ldap_uid = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapUid.c_ASN1_UTF8STRING(&(*Datas)->ldap_uid))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_uid);
		(*Datas)->ldap_uid = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->request && !((*Datas)->request = (X509_REQ*)ASN1_item_new(ASN1_ITEM_rptr(X509_REQ))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_request.give_Datas(&(*Datas)->request))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->request, ASN1_ITEM_rptr(X509_REQ));
		(*Datas)->request = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->validity && !((*Datas)->validity = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->validity, m_validity) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->validity);
		(*Datas)->validity = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiCertRequest::operator=(const NewpkiCertRequest & other)
{
	Clear();
	m_id = other.m_id;
	m_ldapUid = other.m_ldapUid;
	m_request = other.m_request;
	m_validity = other.m_validity;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiCertRequest::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_CERT_REQUEST);
}
NewpkiRevRequest NewpkiRevRequest::EmptyInstance;
bool NewpkiRevRequest::set_id(unsigned long c_id)
{
	m_id = c_id;
	return true;
}

unsigned long NewpkiRevRequest::get_id() const
{
	return m_id;
}

bool NewpkiRevRequest::set_ldapUid(const mString & c_ldapUid)
{
	m_ldapUid = c_ldapUid;
	return true;
}

const mString & NewpkiRevRequest::get_ldapUid() const
{
	return m_ldapUid;
}

mString & NewpkiRevRequest::get_ldapUid()
{
	return m_ldapUid;
}

bool NewpkiRevRequest::set_reason(unsigned long c_reason)
{
	m_reason = c_reason;
	return true;
}

unsigned long NewpkiRevRequest::get_reason() const
{
	return m_reason;
}

bool NewpkiRevRequest::set_serial(unsigned long c_serial)
{
	m_serial = c_serial;
	return true;
}

unsigned long NewpkiRevRequest::get_serial() const
{
	return m_serial;
}

NewpkiRevRequest::NewpkiRevRequest():NewPKIObject()
{
	resetAll();
}

NewpkiRevRequest::NewpkiRevRequest(const NewpkiRevRequest & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiRevRequest::~NewpkiRevRequest()
{
	Clear();
}

void NewpkiRevRequest::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiRevRequest::freeAll()
{
}

void NewpkiRevRequest::resetAll()
{
	m_id = 0;
	m_ldapUid = "";
	m_reason = 0;
	m_serial = 0;
}

bool NewpkiRevRequest::load_Datas(const NEWPKI_REV_REQUEST * Datas)
{
	Clear();
	if(Datas->id)
	{
		m_id = ASN1_INTEGER_GET(Datas->id);
	}
	if(Datas->ldap_uid)
	{
		m_ldapUid = Datas->ldap_uid;
	}
	if(Datas->reason)
	{
		m_reason = ASN1_INTEGER_GET(Datas->reason);
	}
	if(Datas->serial)
	{
		m_serial = ASN1_INTEGER_GET(Datas->serial);
	}
	m_isOk=true;
	return true;
}

bool NewpkiRevRequest::give_Datas(NEWPKI_REV_REQUEST ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_REV_REQUEST*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->id && !((*Datas)->id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->id, m_id) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->id);
		(*Datas)->id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ldap_uid && !((*Datas)->ldap_uid = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapUid.c_ASN1_UTF8STRING(&(*Datas)->ldap_uid))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_uid);
		(*Datas)->ldap_uid = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->reason && !((*Datas)->reason = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->reason, m_reason) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->reason);
		(*Datas)->reason = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->serial && !((*Datas)->serial = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->serial, m_serial) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->serial);
		(*Datas)->serial = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiRevRequest::operator=(const NewpkiRevRequest & other)
{
	Clear();
	m_id = other.m_id;
	m_ldapUid = other.m_ldapUid;
	m_reason = other.m_reason;
	m_serial = other.m_serial;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiRevRequest::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_REV_REQUEST);
}
NewpkiSuspRequest NewpkiSuspRequest::EmptyInstance;
bool NewpkiSuspRequest::set_id(unsigned long c_id)
{
	m_id = c_id;
	return true;
}

unsigned long NewpkiSuspRequest::get_id() const
{
	return m_id;
}

bool NewpkiSuspRequest::set_ldapUid(const mString & c_ldapUid)
{
	m_ldapUid = c_ldapUid;
	return true;
}

const mString & NewpkiSuspRequest::get_ldapUid() const
{
	return m_ldapUid;
}

mString & NewpkiSuspRequest::get_ldapUid()
{
	return m_ldapUid;
}

bool NewpkiSuspRequest::set_serial(unsigned long c_serial)
{
	m_serial = c_serial;
	return true;
}

unsigned long NewpkiSuspRequest::get_serial() const
{
	return m_serial;
}

NewpkiSuspRequest::NewpkiSuspRequest():NewPKIObject()
{
	resetAll();
}

NewpkiSuspRequest::NewpkiSuspRequest(const NewpkiSuspRequest & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiSuspRequest::~NewpkiSuspRequest()
{
	Clear();
}

void NewpkiSuspRequest::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiSuspRequest::freeAll()
{
}

void NewpkiSuspRequest::resetAll()
{
	m_id = 0;
	m_ldapUid = "";
	m_serial = 0;
}

bool NewpkiSuspRequest::load_Datas(const NEWPKI_SUSP_REQUEST * Datas)
{
	Clear();
	if(Datas->id)
	{
		m_id = ASN1_INTEGER_GET(Datas->id);
	}
	if(Datas->ldap_uid)
	{
		m_ldapUid = Datas->ldap_uid;
	}
	if(Datas->serial)
	{
		m_serial = ASN1_INTEGER_GET(Datas->serial);
	}
	m_isOk=true;
	return true;
}

bool NewpkiSuspRequest::give_Datas(NEWPKI_SUSP_REQUEST ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_SUSP_REQUEST*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->id && !((*Datas)->id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->id, m_id) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->id);
		(*Datas)->id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ldap_uid && !((*Datas)->ldap_uid = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapUid.c_ASN1_UTF8STRING(&(*Datas)->ldap_uid))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_uid);
		(*Datas)->ldap_uid = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->serial && !((*Datas)->serial = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->serial, m_serial) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->serial);
		(*Datas)->serial = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiSuspRequest::operator=(const NewpkiSuspRequest & other)
{
	Clear();
	m_id = other.m_id;
	m_ldapUid = other.m_ldapUid;
	m_serial = other.m_serial;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiSuspRequest::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_SUSP_REQUEST);
}
NewpkiUnsuspRequest NewpkiUnsuspRequest::EmptyInstance;
bool NewpkiUnsuspRequest::set_id(unsigned long c_id)
{
	m_id = c_id;
	return true;
}

unsigned long NewpkiUnsuspRequest::get_id() const
{
	return m_id;
}

bool NewpkiUnsuspRequest::set_ldapUid(const mString & c_ldapUid)
{
	m_ldapUid = c_ldapUid;
	return true;
}

const mString & NewpkiUnsuspRequest::get_ldapUid() const
{
	return m_ldapUid;
}

mString & NewpkiUnsuspRequest::get_ldapUid()
{
	return m_ldapUid;
}

bool NewpkiUnsuspRequest::set_serial(unsigned long c_serial)
{
	m_serial = c_serial;
	return true;
}

unsigned long NewpkiUnsuspRequest::get_serial() const
{
	return m_serial;
}

NewpkiUnsuspRequest::NewpkiUnsuspRequest():NewPKIObject()
{
	resetAll();
}

NewpkiUnsuspRequest::NewpkiUnsuspRequest(const NewpkiUnsuspRequest & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiUnsuspRequest::~NewpkiUnsuspRequest()
{
	Clear();
}

void NewpkiUnsuspRequest::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiUnsuspRequest::freeAll()
{
}

void NewpkiUnsuspRequest::resetAll()
{
	m_id = 0;
	m_ldapUid = "";
	m_serial = 0;
}

bool NewpkiUnsuspRequest::load_Datas(const NEWPKI_UNSUSP_REQUEST * Datas)
{
	Clear();
	if(Datas->id)
	{
		m_id = ASN1_INTEGER_GET(Datas->id);
	}
	if(Datas->ldap_uid)
	{
		m_ldapUid = Datas->ldap_uid;
	}
	if(Datas->serial)
	{
		m_serial = ASN1_INTEGER_GET(Datas->serial);
	}
	m_isOk=true;
	return true;
}

bool NewpkiUnsuspRequest::give_Datas(NEWPKI_UNSUSP_REQUEST ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_UNSUSP_REQUEST*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->id && !((*Datas)->id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->id, m_id) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->id);
		(*Datas)->id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ldap_uid && !((*Datas)->ldap_uid = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapUid.c_ASN1_UTF8STRING(&(*Datas)->ldap_uid))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_uid);
		(*Datas)->ldap_uid = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->serial && !((*Datas)->serial = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->serial, m_serial) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->serial);
		(*Datas)->serial = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiUnsuspRequest::operator=(const NewpkiUnsuspRequest & other)
{
	Clear();
	m_id = other.m_id;
	m_ldapUid = other.m_ldapUid;
	m_serial = other.m_serial;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiUnsuspRequest::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_UNSUSP_REQUEST);
}
NewpkiPubRequestBodyRev NewpkiPubRequestBodyRev::EmptyInstance;
bool NewpkiPubRequestBodyRev::set_cert(const PKI_CERT & c_cert)
{
	m_cert = c_cert;
	return true;
}

const PKI_CERT & NewpkiPubRequestBodyRev::get_cert() const
{
	return m_cert;
}

PKI_CERT & NewpkiPubRequestBodyRev::get_cert()
{
	return m_cert;
}

bool NewpkiPubRequestBodyRev::set_revdate(const ASN1_UTCTIME * c_revdate)
{
	if(m_revdate)
		ASN1_item_free((ASN1_VALUE*)m_revdate, ASN1_ITEM_rptr(ASN1_UTCTIME));
	m_revdate = (ASN1_UTCTIME*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_UTCTIME), (void*)c_revdate);
	if(!m_revdate)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const ASN1_UTCTIME * NewpkiPubRequestBodyRev::get_revdate() const
{
	if(!m_revdate)
		((NewpkiPubRequestBodyRev*)this)->m_revdate = (ASN1_UTCTIME*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTCTIME));
	return m_revdate;
}

ASN1_UTCTIME * NewpkiPubRequestBodyRev::get_revdate()
{
	if(!m_revdate)
		m_revdate = (ASN1_UTCTIME*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTCTIME));
	return m_revdate;
}

NewpkiPubRequestBodyRev::NewpkiPubRequestBodyRev():NewPKIObject()
{
	resetAll();
}

NewpkiPubRequestBodyRev::NewpkiPubRequestBodyRev(const NewpkiPubRequestBodyRev & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiPubRequestBodyRev::~NewpkiPubRequestBodyRev()
{
	Clear();
}

void NewpkiPubRequestBodyRev::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiPubRequestBodyRev::freeAll()
{
	if(m_revdate)
	{
		ASN1_item_free((ASN1_VALUE*)m_revdate, ASN1_ITEM_rptr(ASN1_UTCTIME));
	}
}

void NewpkiPubRequestBodyRev::resetAll()
{
	m_cert.Clear();
	m_revdate = NULL;
}

bool NewpkiPubRequestBodyRev::load_Datas(const NEWPKI_PUB_REQUEST_BODY_REV * Datas)
{
	Clear();
	if(Datas->cert)
	{
		if(!m_cert.load_Datas(Datas->cert))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->revdate)
	{
		if(m_revdate)
			ASN1_item_free((ASN1_VALUE*)m_revdate, ASN1_ITEM_rptr(ASN1_UTCTIME));
		m_revdate = (ASN1_UTCTIME*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_UTCTIME), Datas->revdate);
		if(!m_revdate)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool NewpkiPubRequestBodyRev::give_Datas(NEWPKI_PUB_REQUEST_BODY_REV ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_PUB_REQUEST_BODY_REV*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->cert && !((*Datas)->cert = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_cert.give_Datas(&(*Datas)->cert))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->cert, ASN1_ITEM_rptr(X509));
		(*Datas)->cert = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(m_revdate)
	{
		if((*Datas)->revdate)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->revdate, ASN1_ITEM_rptr(ASN1_UTCTIME));
		if(!((*Datas)->revdate = (ASN1_UTCTIME*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_UTCTIME), (ASN1_VALUE*)m_revdate)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->revdate)
		{
			(*Datas)->revdate = (ASN1_UTCTIME*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTCTIME));
			if(!(*Datas)->revdate)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	return true;
}

bool NewpkiPubRequestBodyRev::operator=(const NewpkiPubRequestBodyRev & other)
{
	Clear();
	m_cert = other.m_cert;
	if(other.m_revdate)
	{
		if(m_revdate)
			ASN1_item_free((ASN1_VALUE*)m_revdate, ASN1_ITEM_rptr(ASN1_UTCTIME));
		m_revdate = (ASN1_UTCTIME*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_UTCTIME), (void*)other.m_revdate);
		if(!m_revdate)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiPubRequestBodyRev::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_PUB_REQUEST_BODY_REV);
}
NewpkiPubRequestBody NewpkiPubRequestBody::EmptyInstance;
bool NewpkiPubRequestBody::set_type(int c_type)
{
	Clear();
	m_type = c_type;
	if(!malloc_byType(m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

int NewpkiPubRequestBody::get_type() const
{
	 return m_type;
}

bool NewpkiPubRequestBody::set_cert(const PKI_CERT & c_cert)
{
	if(m_type != 0)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_cert) = c_cert;
	m_isOk=true;
	return true;
}

const PKI_CERT & NewpkiPubRequestBody::get_cert() const
{
	if((m_type != 0) || !m_cert)
	{
		return PKI_CERT::EmptyInstance;
	}
	return (*m_cert);
}

PKI_CERT & NewpkiPubRequestBody::get_cert()
{
	if((m_type != 0) || !m_cert)
	{
		return PKI_CERT::EmptyInstance;
	}
	return (*m_cert);
}

bool NewpkiPubRequestBody::set_crl(const PKI_CRL & c_crl)
{
	if(m_type != 2)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_crl) = c_crl;
	m_isOk=true;
	return true;
}

const PKI_CRL & NewpkiPubRequestBody::get_crl() const
{
	if((m_type != 2) || !m_crl)
	{
		return PKI_CRL::EmptyInstance;
	}
	return (*m_crl);
}

PKI_CRL & NewpkiPubRequestBody::get_crl()
{
	if((m_type != 2) || !m_crl)
	{
		return PKI_CRL::EmptyInstance;
	}
	return (*m_crl);
}

bool NewpkiPubRequestBody::set_rev(const NewpkiPubRequestBodyRev & c_rev)
{
	if(m_type != 1)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_rev) = c_rev;
	m_isOk=true;
	return true;
}

const NewpkiPubRequestBodyRev & NewpkiPubRequestBody::get_rev() const
{
	if((m_type != 1) || !m_rev)
	{
		return NewpkiPubRequestBodyRev::EmptyInstance;
	}
	return (*m_rev);
}

NewpkiPubRequestBodyRev & NewpkiPubRequestBody::get_rev()
{
	if((m_type != 1) || !m_rev)
	{
		return NewpkiPubRequestBodyRev::EmptyInstance;
	}
	return (*m_rev);
}

bool NewpkiPubRequestBody::malloc_byType (int c_type)
{
	switch(m_type)
	{
		case 0:
			m_cert = new PKI_CERT();
			if(!m_cert)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 2:
			m_crl = new PKI_CRL();
			if(!m_crl)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 1:
			m_rev = new NewpkiPubRequestBodyRev();
			if(!m_rev)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
	}

	return true;
}

NewpkiPubRequestBody::NewpkiPubRequestBody():NewPKIObject()
{
	resetAll();
}

NewpkiPubRequestBody::NewpkiPubRequestBody(const NewpkiPubRequestBody & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiPubRequestBody::~NewpkiPubRequestBody()
{
	Clear();
}

void NewpkiPubRequestBody::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiPubRequestBody::freeAll()
{
	if(m_cert)
	{
		delete m_cert;
	}
	if(m_crl)
	{
		delete m_crl;
	}
	if(m_rev)
	{
		delete m_rev;
	}
}

void NewpkiPubRequestBody::resetAll()
{
	m_type = -1;
	m_cert = NULL;
	m_crl = NULL;
	m_rev = NULL;
}

bool NewpkiPubRequestBody::load_Datas(const NEWPKI_PUB_REQUEST_BODY * Datas)
{
	Clear();
	if(!set_type(Datas->type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(Datas->type)
	{
		case 0:
			if(Datas->d.cert)
			{
				if(!(*m_cert).load_Datas(Datas->d.cert))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 2:
			if(Datas->d.crl)
			{
				if(!(*m_crl).load_Datas(Datas->d.crl))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 1:
			if(Datas->d.rev)
			{
				if(!(*m_rev).load_Datas(Datas->d.rev))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}

bool NewpkiPubRequestBody::give_Datas(NEWPKI_PUB_REQUEST_BODY ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_PUB_REQUEST_BODY*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	(*Datas)->type = m_type;
	switch(m_type)
	{
		case 0:
			if(!((*Datas)->d.cert = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_cert).give_Datas(&(*Datas)->d.cert))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.cert, ASN1_ITEM_rptr(X509));
				(*Datas)->d.cert = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 2:
			if(!((*Datas)->d.crl = (X509_CRL*)ASN1_item_new(ASN1_ITEM_rptr(X509_CRL))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_crl).give_Datas(&(*Datas)->d.crl))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.crl, ASN1_ITEM_rptr(X509_CRL));
				(*Datas)->d.crl = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 1:
			if(!((*Datas)->d.rev = (NEWPKI_PUB_REQUEST_BODY_REV*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_PUB_REQUEST_BODY_REV))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_rev).give_Datas(&(*Datas)->d.rev))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.rev, ASN1_ITEM_rptr(NEWPKI_PUB_REQUEST_BODY_REV));
				(*Datas)->d.rev = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
	}
	return true;
}

bool NewpkiPubRequestBody::operator=(const NewpkiPubRequestBody & other)
{
	Clear();
	if(!set_type(other.m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(other.m_type)
	{
		case 0:
			if(!other.m_cert)
				break;
			(*m_cert) = *(other.m_cert);
			break;
		case 2:
			if(!other.m_crl)
				break;
			(*m_crl) = *(other.m_crl);
			break;
		case 1:
			if(!other.m_rev)
				break;
			(*m_rev) = *(other.m_rev);
			break;
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiPubRequestBody::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_PUB_REQUEST_BODY);
}
NewpkiPubRequest NewpkiPubRequest::EmptyInstance;
bool NewpkiPubRequest::set_parentcerts(const mVector< PKI_CERT > & c_parentcerts)
{
	m_parentcerts = c_parentcerts;
	return true;
}

const mVector< PKI_CERT > & NewpkiPubRequest::get_parentcerts() const
{
	return m_parentcerts;
}

mVector< PKI_CERT > & NewpkiPubRequest::get_parentcerts()
{
	return m_parentcerts;
}

bool NewpkiPubRequest::set_body(const NewpkiPubRequestBody & c_body)
{
	m_body = c_body;
	return true;
}

const NewpkiPubRequestBody & NewpkiPubRequest::get_body() const
{
	return m_body;
}

NewpkiPubRequestBody & NewpkiPubRequest::get_body()
{
	return m_body;
}

bool NewpkiPubRequest::set_ldapUid(const mString & c_ldapUid)
{
	m_ldapUid = c_ldapUid;
	return true;
}

const mString & NewpkiPubRequest::get_ldapUid() const
{
	return m_ldapUid;
}

mString & NewpkiPubRequest::get_ldapUid()
{
	return m_ldapUid;
}

bool NewpkiPubRequest::set_object(const mString & c_object)
{
	m_object = c_object;
	return true;
}

const mString & NewpkiPubRequest::get_object() const
{
	return m_object;
}

mString & NewpkiPubRequest::get_object()
{
	return m_object;
}

NewpkiPubRequest::NewpkiPubRequest():NewPKIObject()
{
	resetAll();
}

NewpkiPubRequest::NewpkiPubRequest(const NewpkiPubRequest & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiPubRequest::~NewpkiPubRequest()
{
	Clear();
}

void NewpkiPubRequest::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiPubRequest::freeAll()
{
}

void NewpkiPubRequest::resetAll()
{
	m_parentcerts.clear();
	m_body.Clear();
	m_ldapUid = "";
	m_object = "";
}

bool NewpkiPubRequest::load_Datas(const NEWPKI_PUB_REQUEST * Datas)
{
	Clear();
	int i;
	X509 * currparentcerts;
	if(Datas->ParentCerts)
	{
		for(i=0; i<SKM_sk_num(X509, Datas->ParentCerts); i++)
		{
			currparentcerts = SKM_sk_value(X509, Datas->ParentCerts, i);
			if(!currparentcerts)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_parentcerts.insert(m_parentcerts.begin() + i);
			if(!m_parentcerts[i].load_Datas(currparentcerts))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->body)
	{
		if(!m_body.load_Datas(Datas->body))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->ldap_uid)
	{
		m_ldapUid = Datas->ldap_uid;
	}
	if(Datas->object)
	{
		m_object = Datas->object;
	}
	m_isOk=true;
	return true;
}

bool NewpkiPubRequest::give_Datas(NEWPKI_PUB_REQUEST ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_PUB_REQUEST*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	X509 * currparentcerts;
	size_t i;
	if(!(*Datas)->ParentCerts && !((*Datas)->ParentCerts = SKM_sk_new_null(X509)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_parentcerts.size() ; i++)
	{
		currparentcerts = NULL;
		if(!m_parentcerts[i].give_Datas(&currparentcerts))
		{
			ASN1_item_free((ASN1_VALUE*)currparentcerts, ASN1_ITEM_rptr(X509));
			currparentcerts = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(X509, (*Datas)->ParentCerts, currparentcerts) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currparentcerts, ASN1_ITEM_rptr(X509));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->body && !((*Datas)->body = (NEWPKI_PUB_REQUEST_BODY*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_PUB_REQUEST_BODY))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_body.give_Datas(&(*Datas)->body))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->body, ASN1_ITEM_rptr(NEWPKI_PUB_REQUEST_BODY));
		(*Datas)->body = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ldap_uid && !((*Datas)->ldap_uid = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapUid.c_ASN1_UTF8STRING(&(*Datas)->ldap_uid))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_uid);
		(*Datas)->ldap_uid = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->object && !((*Datas)->object = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_object.c_ASN1_UTF8STRING(&(*Datas)->object))
	{
		ASN1_UTF8STRING_free((*Datas)->object);
		(*Datas)->object = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool NewpkiPubRequest::operator=(const NewpkiPubRequest & other)
{
	Clear();
	m_parentcerts = other.m_parentcerts;
	m_body = other.m_body;
	m_ldapUid = other.m_ldapUid;
	m_object = other.m_object;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiPubRequest::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_PUB_REQUEST);
}
NewpkiBackupRequest NewpkiBackupRequest::EmptyInstance;
bool NewpkiBackupRequest::set_backup(const Asn1OctetString & c_backup)
{
	m_backup = c_backup;
	return true;
}

const Asn1OctetString & NewpkiBackupRequest::get_backup() const
{
	return m_backup;
}

Asn1OctetString & NewpkiBackupRequest::get_backup()
{
	return m_backup;
}

bool NewpkiBackupRequest::set_symAlgo(const ASN1_OBJECT * c_symAlgo)
{
	if(m_symAlgo)
		ASN1_item_free((ASN1_VALUE*)m_symAlgo, ASN1_ITEM_rptr(ASN1_OBJECT));
	m_symAlgo = (ASN1_OBJECT*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_OBJECT), (void*)c_symAlgo);
	if(!m_symAlgo)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const ASN1_OBJECT * NewpkiBackupRequest::get_symAlgo() const
{
	if(!m_symAlgo)
		((NewpkiBackupRequest*)this)->m_symAlgo = (ASN1_OBJECT*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_OBJECT));
	return m_symAlgo;
}

ASN1_OBJECT * NewpkiBackupRequest::get_symAlgo()
{
	if(!m_symAlgo)
		m_symAlgo = (ASN1_OBJECT*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_OBJECT));
	return m_symAlgo;
}

NewpkiBackupRequest::NewpkiBackupRequest():NewPKIObject()
{
	resetAll();
}

NewpkiBackupRequest::NewpkiBackupRequest(const NewpkiBackupRequest & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiBackupRequest::~NewpkiBackupRequest()
{
	Clear();
}

void NewpkiBackupRequest::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiBackupRequest::freeAll()
{
	if(m_symAlgo)
	{
		ASN1_item_free((ASN1_VALUE*)m_symAlgo, ASN1_ITEM_rptr(ASN1_OBJECT));
	}
}

void NewpkiBackupRequest::resetAll()
{
	m_backup.Clear();
	m_symAlgo = NULL;
}

bool NewpkiBackupRequest::load_Datas(const NEWPKI_BACKUP_REQUEST * Datas)
{
	Clear();
	if(Datas->backup)
	{
		if(!m_backup.load_Datas(Datas->backup))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->sym_algo)
	{
		if(m_symAlgo)
			ASN1_item_free((ASN1_VALUE*)m_symAlgo, ASN1_ITEM_rptr(ASN1_OBJECT));
		m_symAlgo = (ASN1_OBJECT*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_OBJECT), Datas->sym_algo);
		if(!m_symAlgo)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool NewpkiBackupRequest::give_Datas(NEWPKI_BACKUP_REQUEST ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_BACKUP_REQUEST*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->backup && !((*Datas)->backup = (ASN1_OCTET_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_OCTET_STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_backup.give_Datas(&(*Datas)->backup))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->backup, ASN1_ITEM_rptr(ASN1_OCTET_STRING));
		(*Datas)->backup = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(m_symAlgo)
	{
		if((*Datas)->sym_algo)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->sym_algo, ASN1_ITEM_rptr(ASN1_OBJECT));
		if(!((*Datas)->sym_algo = (ASN1_OBJECT*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_OBJECT), (ASN1_VALUE*)m_symAlgo)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->sym_algo)
		{
			(*Datas)->sym_algo = (ASN1_OBJECT*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_OBJECT));
			if(!(*Datas)->sym_algo)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	return true;
}

bool NewpkiBackupRequest::operator=(const NewpkiBackupRequest & other)
{
	Clear();
	m_backup = other.m_backup;
	if(other.m_symAlgo)
	{
		if(m_symAlgo)
			ASN1_item_free((ASN1_VALUE*)m_symAlgo, ASN1_ITEM_rptr(ASN1_OBJECT));
		m_symAlgo = (ASN1_OBJECT*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_OBJECT), (void*)other.m_symAlgo);
		if(!m_symAlgo)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiBackupRequest::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_BACKUP_REQUEST);
}
NewpkiEeValRequest NewpkiEeValRequest::EmptyInstance;
bool NewpkiEeValRequest::set_dn(const X509_NAME * c_dn)
{
	if(m_dn)
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)c_dn);
	if(!m_dn)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_NAME * NewpkiEeValRequest::get_dn() const
{
	if(!m_dn)
		((NewpkiEeValRequest*)this)->m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

X509_NAME * NewpkiEeValRequest::get_dn()
{
	if(!m_dn)
		m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

bool NewpkiEeValRequest::set_raId(unsigned long c_raId)
{
	m_raId = c_raId;
	return true;
}

unsigned long NewpkiEeValRequest::get_raId() const
{
	return m_raId;
}

NewpkiEeValRequest::NewpkiEeValRequest():NewPKIObject()
{
	resetAll();
}

NewpkiEeValRequest::NewpkiEeValRequest(const NewpkiEeValRequest & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeValRequest::~NewpkiEeValRequest()
{
	Clear();
}

void NewpkiEeValRequest::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeValRequest::freeAll()
{
	if(m_dn)
	{
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	}
}

void NewpkiEeValRequest::resetAll()
{
	m_dn = NULL;
	m_raId = 0;
}

bool NewpkiEeValRequest::load_Datas(const NEWPKI_EE_VAL_REQUEST * Datas)
{
	Clear();
	if(Datas->dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), Datas->dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->ra_id)
	{
		m_raId = ASN1_INTEGER_GET(Datas->ra_id);
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeValRequest::give_Datas(NEWPKI_EE_VAL_REQUEST ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_VAL_REQUEST*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(m_dn)
	{
		if((*Datas)->dn)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->dn, ASN1_ITEM_rptr(X509_NAME));
		if(!((*Datas)->dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (ASN1_VALUE*)m_dn)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->dn)
		{
			(*Datas)->dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
			if(!(*Datas)->dn)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->ra_id && !((*Datas)->ra_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ra_id, m_raId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ra_id);
		(*Datas)->ra_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiEeValRequest::operator=(const NewpkiEeValRequest & other)
{
	Clear();
	if(other.m_dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)other.m_dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_raId = other.m_raId;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeValRequest::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_VAL_REQUEST);
}
NewpkiEeDnPublish NewpkiEeDnPublish::EmptyInstance;
bool NewpkiEeDnPublish::set_dn(const X509_NAME * c_dn)
{
	if(m_dn)
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)c_dn);
	if(!m_dn)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_NAME * NewpkiEeDnPublish::get_dn() const
{
	if(!m_dn)
		((NewpkiEeDnPublish*)this)->m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

X509_NAME * NewpkiEeDnPublish::get_dn()
{
	if(!m_dn)
		m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

bool NewpkiEeDnPublish::set_eeId(unsigned long c_eeId)
{
	m_eeId = c_eeId;
	return true;
}

unsigned long NewpkiEeDnPublish::get_eeId() const
{
	return m_eeId;
}

NewpkiEeDnPublish::NewpkiEeDnPublish():NewPKIObject()
{
	resetAll();
}

NewpkiEeDnPublish::NewpkiEeDnPublish(const NewpkiEeDnPublish & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeDnPublish::~NewpkiEeDnPublish()
{
	Clear();
}

void NewpkiEeDnPublish::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeDnPublish::freeAll()
{
	if(m_dn)
	{
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	}
}

void NewpkiEeDnPublish::resetAll()
{
	m_dn = NULL;
	m_eeId = 0;
}

bool NewpkiEeDnPublish::load_Datas(const NEWPKI_EE_DN_PUBLISH * Datas)
{
	Clear();
	if(Datas->dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), Datas->dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->ee_id)
	{
		m_eeId = ASN1_INTEGER_GET(Datas->ee_id);
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeDnPublish::give_Datas(NEWPKI_EE_DN_PUBLISH ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_DN_PUBLISH*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(m_dn)
	{
		if((*Datas)->dn)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->dn, ASN1_ITEM_rptr(X509_NAME));
		if(!((*Datas)->dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (ASN1_VALUE*)m_dn)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->dn)
		{
			(*Datas)->dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
			if(!(*Datas)->dn)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->ee_id && !((*Datas)->ee_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ee_id, m_eeId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ee_id);
		(*Datas)->ee_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiEeDnPublish::operator=(const NewpkiEeDnPublish & other)
{
	Clear();
	if(other.m_dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)other.m_dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_eeId = other.m_eeId;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeDnPublish::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_DN_PUBLISH);
}
NewpkiEeDnRemove NewpkiEeDnRemove::EmptyInstance;
bool NewpkiEeDnRemove::set_eeId(unsigned long c_eeId)
{
	m_eeId = c_eeId;
	return true;
}

unsigned long NewpkiEeDnRemove::get_eeId() const
{
	return m_eeId;
}

NewpkiEeDnRemove::NewpkiEeDnRemove():NewPKIObject()
{
	resetAll();
}

NewpkiEeDnRemove::NewpkiEeDnRemove(const NewpkiEeDnRemove & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeDnRemove::~NewpkiEeDnRemove()
{
	Clear();
}

void NewpkiEeDnRemove::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeDnRemove::freeAll()
{
}

void NewpkiEeDnRemove::resetAll()
{
	m_eeId = 0;
}

bool NewpkiEeDnRemove::load_Datas(const NEWPKI_EE_DN_REMOVE * Datas)
{
	Clear();
	if(Datas->ee_id)
	{
		m_eeId = ASN1_INTEGER_GET(Datas->ee_id);
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeDnRemove::give_Datas(NEWPKI_EE_DN_REMOVE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_DN_REMOVE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->ee_id && !((*Datas)->ee_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ee_id, m_eeId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ee_id);
		(*Datas)->ee_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiEeDnRemove::operator=(const NewpkiEeDnRemove & other)
{
	Clear();
	m_eeId = other.m_eeId;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeDnRemove::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_DN_REMOVE);
}
NewpkiEeUpdateCertStatus NewpkiEeUpdateCertStatus::EmptyInstance;
bool NewpkiEeUpdateCertStatus::set_lastCrl(const PKI_CRL & c_lastCrl)
{
	m_lastCrl = c_lastCrl;
	return true;
}

const PKI_CRL & NewpkiEeUpdateCertStatus::get_lastCrl() const
{
	return m_lastCrl;
}

PKI_CRL & NewpkiEeUpdateCertStatus::get_lastCrl()
{
	return m_lastCrl;
}

bool NewpkiEeUpdateCertStatus::set_raId(unsigned long c_raId)
{
	m_raId = c_raId;
	return true;
}

unsigned long NewpkiEeUpdateCertStatus::get_raId() const
{
	return m_raId;
}

bool NewpkiEeUpdateCertStatus::set_status(unsigned long c_status)
{
	m_status = c_status;
	return true;
}

unsigned long NewpkiEeUpdateCertStatus::get_status() const
{
	return m_status;
}

NewpkiEeUpdateCertStatus::NewpkiEeUpdateCertStatus():NewPKIObject()
{
	resetAll();
}

NewpkiEeUpdateCertStatus::NewpkiEeUpdateCertStatus(const NewpkiEeUpdateCertStatus & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeUpdateCertStatus::~NewpkiEeUpdateCertStatus()
{
	Clear();
}

void NewpkiEeUpdateCertStatus::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeUpdateCertStatus::freeAll()
{
}

void NewpkiEeUpdateCertStatus::resetAll()
{
	m_lastCrl.Clear();
	m_raId = 0;
	m_status = 0;
}

bool NewpkiEeUpdateCertStatus::load_Datas(const NEWPKI_EE_UPDATE_CERT_STATUS * Datas)
{
	Clear();
	if(Datas->last_crl)
	{
		if(!m_lastCrl.load_Datas(Datas->last_crl))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->ra_id)
	{
		m_raId = ASN1_INTEGER_GET(Datas->ra_id);
	}
	if(Datas->status)
	{
		m_status = ASN1_INTEGER_GET(Datas->status);
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeUpdateCertStatus::give_Datas(NEWPKI_EE_UPDATE_CERT_STATUS ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_UPDATE_CERT_STATUS*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(m_lastCrl)
	{
		if(!(*Datas)->last_crl && !((*Datas)->last_crl = (X509_CRL*)ASN1_item_new(ASN1_ITEM_rptr(X509_CRL))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_lastCrl.give_Datas(&(*Datas)->last_crl))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->last_crl)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
		}
	}
	if(!(*Datas)->ra_id && !((*Datas)->ra_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ra_id, m_raId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ra_id);
		(*Datas)->ra_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->status && !((*Datas)->status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->status, m_status) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->status);
		(*Datas)->status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiEeUpdateCertStatus::operator=(const NewpkiEeUpdateCertStatus & other)
{
	Clear();
	m_lastCrl = other.m_lastCrl;
	m_raId = other.m_raId;
	m_status = other.m_status;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeUpdateCertStatus::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_UPDATE_CERT_STATUS);
}
NewpkiEeCertPublish NewpkiEeCertPublish::EmptyInstance;
bool NewpkiEeCertPublish::set_caName(const mString & c_caName)
{
	m_caName = c_caName;
	return true;
}

const mString & NewpkiEeCertPublish::get_caName() const
{
	return m_caName;
}

mString & NewpkiEeCertPublish::get_caName()
{
	return m_caName;
}

bool NewpkiEeCertPublish::set_certificate(const PKI_CERT & c_certificate)
{
	m_certificate = c_certificate;
	return true;
}

const PKI_CERT & NewpkiEeCertPublish::get_certificate() const
{
	return m_certificate;
}

PKI_CERT & NewpkiEeCertPublish::get_certificate()
{
	return m_certificate;
}

bool NewpkiEeCertPublish::set_lastCrl(const PKI_CRL & c_lastCrl)
{
	m_lastCrl = c_lastCrl;
	return true;
}

const PKI_CRL & NewpkiEeCertPublish::get_lastCrl() const
{
	return m_lastCrl;
}

PKI_CRL & NewpkiEeCertPublish::get_lastCrl()
{
	return m_lastCrl;
}

bool NewpkiEeCertPublish::set_p12(const PKI_PKCS12 & c_p12)
{
	m_p12 = c_p12;
	return true;
}

const PKI_PKCS12 & NewpkiEeCertPublish::get_p12() const
{
	return m_p12;
}

PKI_PKCS12 & NewpkiEeCertPublish::get_p12()
{
	return m_p12;
}

bool NewpkiEeCertPublish::set_p7b(const PKI_P7B & c_p7b)
{
	m_p7b = c_p7b;
	return true;
}

const PKI_P7B & NewpkiEeCertPublish::get_p7b() const
{
	return m_p7b;
}

PKI_P7B & NewpkiEeCertPublish::get_p7b()
{
	return m_p7b;
}

bool NewpkiEeCertPublish::set_profileId(unsigned long c_profileId)
{
	m_profileId = c_profileId;
	return true;
}

unsigned long NewpkiEeCertPublish::get_profileId() const
{
	return m_profileId;
}

bool NewpkiEeCertPublish::set_raId(unsigned long c_raId)
{
	m_raId = c_raId;
	return true;
}

unsigned long NewpkiEeCertPublish::get_raId() const
{
	return m_raId;
}

bool NewpkiEeCertPublish::set_type(unsigned long c_type)
{
	m_type = c_type;
	return true;
}

unsigned long NewpkiEeCertPublish::get_type() const
{
	return m_type;
}

NewpkiEeCertPublish::NewpkiEeCertPublish():NewPKIObject()
{
	resetAll();
}

NewpkiEeCertPublish::NewpkiEeCertPublish(const NewpkiEeCertPublish & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeCertPublish::~NewpkiEeCertPublish()
{
	Clear();
}

void NewpkiEeCertPublish::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeCertPublish::freeAll()
{
}

void NewpkiEeCertPublish::resetAll()
{
	m_caName = "";
	m_certificate.Clear();
	m_lastCrl.Clear();
	m_p12.Clear();
	m_p7b.Clear();
	m_profileId = 0;
	m_raId = 0;
	m_type = 0;
}

bool NewpkiEeCertPublish::load_Datas(const NEWPKI_EE_CERT_PUBLISH * Datas)
{
	Clear();
	if(Datas->ca_name)
	{
		m_caName = Datas->ca_name;
	}
	if(Datas->certificate)
	{
		if(!m_certificate.load_Datas(Datas->certificate))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->last_crl)
	{
		if(!m_lastCrl.load_Datas(Datas->last_crl))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->p12)
	{
		if(!m_p12.load_Datas(Datas->p12))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->p7b)
	{
		if(!m_p7b.load_Datas(Datas->p7b))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->profile_id)
	{
		m_profileId = ASN1_INTEGER_GET(Datas->profile_id);
	}
	if(Datas->ra_id)
	{
		m_raId = ASN1_INTEGER_GET(Datas->ra_id);
	}
	if(Datas->type)
	{
		m_type = ASN1_INTEGER_GET(Datas->type);
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeCertPublish::give_Datas(NEWPKI_EE_CERT_PUBLISH ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_CERT_PUBLISH*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->ca_name && !((*Datas)->ca_name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_caName.c_ASN1_UTF8STRING(&(*Datas)->ca_name))
	{
		ASN1_UTF8STRING_free((*Datas)->ca_name);
		(*Datas)->ca_name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->certificate && !((*Datas)->certificate = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_certificate.give_Datas(&(*Datas)->certificate))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->certificate, ASN1_ITEM_rptr(X509));
		(*Datas)->certificate = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(m_lastCrl)
	{
		if(!(*Datas)->last_crl && !((*Datas)->last_crl = (X509_CRL*)ASN1_item_new(ASN1_ITEM_rptr(X509_CRL))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_lastCrl.give_Datas(&(*Datas)->last_crl))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->last_crl)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
		}
	}
	if(m_p12)
	{
		if(!(*Datas)->p12 && !((*Datas)->p12 = (PKCS12*)ASN1_item_new(ASN1_ITEM_rptr(PKCS12))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_p12.give_Datas(&(*Datas)->p12))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->p12, ASN1_ITEM_rptr(PKCS12));
			(*Datas)->p12 = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->p12)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->p12, ASN1_ITEM_rptr(PKCS12));
			(*Datas)->p12 = NULL;
		}
	}
	if(m_p7b)
	{
		if(!(*Datas)->p7b && !((*Datas)->p7b = (PKCS7*)ASN1_item_new(ASN1_ITEM_rptr(PKCS7))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_p7b.give_Datas(&(*Datas)->p7b))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->p7b, ASN1_ITEM_rptr(PKCS7));
			(*Datas)->p7b = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->p7b)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->p7b, ASN1_ITEM_rptr(PKCS7));
			(*Datas)->p7b = NULL;
		}
	}
	if(!(*Datas)->profile_id && !((*Datas)->profile_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->profile_id, m_profileId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->profile_id);
		(*Datas)->profile_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ra_id && !((*Datas)->ra_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ra_id, m_raId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ra_id);
		(*Datas)->ra_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->type && !((*Datas)->type = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->type, m_type) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->type);
		(*Datas)->type = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiEeCertPublish::operator=(const NewpkiEeCertPublish & other)
{
	Clear();
	m_caName = other.m_caName;
	m_certificate = other.m_certificate;
	m_lastCrl = other.m_lastCrl;
	m_p12 = other.m_p12;
	m_p7b = other.m_p7b;
	m_profileId = other.m_profileId;
	m_raId = other.m_raId;
	m_type = other.m_type;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeCertPublish::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_CERT_PUBLISH);
}
NewpkiRequest NewpkiRequest::EmptyInstance;
bool NewpkiRequest::set_type(int c_type)
{
	Clear();
	m_type = c_type;
	if(!malloc_byType(m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

int NewpkiRequest::get_type() const
{
	 return m_type;
}

bool NewpkiRequest::set_backupRequest(const NewpkiBackupRequest & c_backupRequest)
{
	if(m_type != 3)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_backupRequest) = c_backupRequest;
	m_isOk=true;
	return true;
}

const NewpkiBackupRequest & NewpkiRequest::get_backupRequest() const
{
	if((m_type != 3) || !m_backupRequest)
	{
		return NewpkiBackupRequest::EmptyInstance;
	}
	return (*m_backupRequest);
}

NewpkiBackupRequest & NewpkiRequest::get_backupRequest()
{
	if((m_type != 3) || !m_backupRequest)
	{
		return NewpkiBackupRequest::EmptyInstance;
	}
	return (*m_backupRequest);
}

bool NewpkiRequest::set_certRequest(const NewpkiCertRequest & c_certRequest)
{
	if(m_type != 0)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_certRequest) = c_certRequest;
	m_isOk=true;
	return true;
}

const NewpkiCertRequest & NewpkiRequest::get_certRequest() const
{
	if((m_type != 0) || !m_certRequest)
	{
		return NewpkiCertRequest::EmptyInstance;
	}
	return (*m_certRequest);
}

NewpkiCertRequest & NewpkiRequest::get_certRequest()
{
	if((m_type != 0) || !m_certRequest)
	{
		return NewpkiCertRequest::EmptyInstance;
	}
	return (*m_certRequest);
}

bool NewpkiRequest::set_eeCertPublish(const NewpkiEeCertPublish & c_eeCertPublish)
{
	if(m_type != 12)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeCertPublish) = c_eeCertPublish;
	m_isOk=true;
	return true;
}

const NewpkiEeCertPublish & NewpkiRequest::get_eeCertPublish() const
{
	if((m_type != 12) || !m_eeCertPublish)
	{
		return NewpkiEeCertPublish::EmptyInstance;
	}
	return (*m_eeCertPublish);
}

NewpkiEeCertPublish & NewpkiRequest::get_eeCertPublish()
{
	if((m_type != 12) || !m_eeCertPublish)
	{
		return NewpkiEeCertPublish::EmptyInstance;
	}
	return (*m_eeCertPublish);
}

bool NewpkiRequest::set_eeCertRequest(const NewpkiEeRequestCert & c_eeCertRequest)
{
	if(m_type != 7)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeCertRequest) = c_eeCertRequest;
	m_isOk=true;
	return true;
}

const NewpkiEeRequestCert & NewpkiRequest::get_eeCertRequest() const
{
	if((m_type != 7) || !m_eeCertRequest)
	{
		return NewpkiEeRequestCert::EmptyInstance;
	}
	return (*m_eeCertRequest);
}

NewpkiEeRequestCert & NewpkiRequest::get_eeCertRequest()
{
	if((m_type != 7) || !m_eeCertRequest)
	{
		return NewpkiEeRequestCert::EmptyInstance;
	}
	return (*m_eeCertRequest);
}

bool NewpkiRequest::set_eeCertRevoke(const NewpkiEeRequestRev & c_eeCertRevoke)
{
	if(m_type != 10)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeCertRevoke) = c_eeCertRevoke;
	m_isOk=true;
	return true;
}

const NewpkiEeRequestRev & NewpkiRequest::get_eeCertRevoke() const
{
	if((m_type != 10) || !m_eeCertRevoke)
	{
		return NewpkiEeRequestRev::EmptyInstance;
	}
	return (*m_eeCertRevoke);
}

NewpkiEeRequestRev & NewpkiRequest::get_eeCertRevoke()
{
	if((m_type != 10) || !m_eeCertRevoke)
	{
		return NewpkiEeRequestRev::EmptyInstance;
	}
	return (*m_eeCertRevoke);
}

bool NewpkiRequest::set_eeDnPublish(const NewpkiEeDnPublish & c_eeDnPublish)
{
	if(m_type != 5)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeDnPublish) = c_eeDnPublish;
	m_isOk=true;
	return true;
}

const NewpkiEeDnPublish & NewpkiRequest::get_eeDnPublish() const
{
	if((m_type != 5) || !m_eeDnPublish)
	{
		return NewpkiEeDnPublish::EmptyInstance;
	}
	return (*m_eeDnPublish);
}

NewpkiEeDnPublish & NewpkiRequest::get_eeDnPublish()
{
	if((m_type != 5) || !m_eeDnPublish)
	{
		return NewpkiEeDnPublish::EmptyInstance;
	}
	return (*m_eeDnPublish);
}

bool NewpkiRequest::set_eeDnRemove(const NewpkiEeDnRemove & c_eeDnRemove)
{
	if(m_type != 6)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeDnRemove) = c_eeDnRemove;
	m_isOk=true;
	return true;
}

const NewpkiEeDnRemove & NewpkiRequest::get_eeDnRemove() const
{
	if((m_type != 6) || !m_eeDnRemove)
	{
		return NewpkiEeDnRemove::EmptyInstance;
	}
	return (*m_eeDnRemove);
}

NewpkiEeDnRemove & NewpkiRequest::get_eeDnRemove()
{
	if((m_type != 6) || !m_eeDnRemove)
	{
		return NewpkiEeDnRemove::EmptyInstance;
	}
	return (*m_eeDnRemove);
}

bool NewpkiRequest::set_eeUpdCertStatus(const NewpkiEeUpdateCertStatus & c_eeUpdCertStatus)
{
	if(m_type != 11)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeUpdCertStatus) = c_eeUpdCertStatus;
	m_isOk=true;
	return true;
}

const NewpkiEeUpdateCertStatus & NewpkiRequest::get_eeUpdCertStatus() const
{
	if((m_type != 11) || !m_eeUpdCertStatus)
	{
		return NewpkiEeUpdateCertStatus::EmptyInstance;
	}
	return (*m_eeUpdCertStatus);
}

NewpkiEeUpdateCertStatus & NewpkiRequest::get_eeUpdCertStatus()
{
	if((m_type != 11) || !m_eeUpdCertStatus)
	{
		return NewpkiEeUpdateCertStatus::EmptyInstance;
	}
	return (*m_eeUpdCertStatus);
}

bool NewpkiRequest::set_eeValRequest(const NewpkiEeValRequest & c_eeValRequest)
{
	if(m_type != 4)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeValRequest) = c_eeValRequest;
	m_isOk=true;
	return true;
}

const NewpkiEeValRequest & NewpkiRequest::get_eeValRequest() const
{
	if((m_type != 4) || !m_eeValRequest)
	{
		return NewpkiEeValRequest::EmptyInstance;
	}
	return (*m_eeValRequest);
}

NewpkiEeValRequest & NewpkiRequest::get_eeValRequest()
{
	if((m_type != 4) || !m_eeValRequest)
	{
		return NewpkiEeValRequest::EmptyInstance;
	}
	return (*m_eeValRequest);
}

bool NewpkiRequest::set_pubRequest(const NewpkiPubRequest & c_pubRequest)
{
	if(m_type != 2)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_pubRequest) = c_pubRequest;
	m_isOk=true;
	return true;
}

const NewpkiPubRequest & NewpkiRequest::get_pubRequest() const
{
	if((m_type != 2) || !m_pubRequest)
	{
		return NewpkiPubRequest::EmptyInstance;
	}
	return (*m_pubRequest);
}

NewpkiPubRequest & NewpkiRequest::get_pubRequest()
{
	if((m_type != 2) || !m_pubRequest)
	{
		return NewpkiPubRequest::EmptyInstance;
	}
	return (*m_pubRequest);
}

bool NewpkiRequest::set_revRequest(const NewpkiRevRequest & c_revRequest)
{
	if(m_type != 1)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_revRequest) = c_revRequest;
	m_isOk=true;
	return true;
}

const NewpkiRevRequest & NewpkiRequest::get_revRequest() const
{
	if((m_type != 1) || !m_revRequest)
	{
		return NewpkiRevRequest::EmptyInstance;
	}
	return (*m_revRequest);
}

NewpkiRevRequest & NewpkiRequest::get_revRequest()
{
	if((m_type != 1) || !m_revRequest)
	{
		return NewpkiRevRequest::EmptyInstance;
	}
	return (*m_revRequest);
}

bool NewpkiRequest::set_suspRequest(const NewpkiSuspRequest & c_suspRequest)
{
	if(m_type != 8)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_suspRequest) = c_suspRequest;
	m_isOk=true;
	return true;
}

const NewpkiSuspRequest & NewpkiRequest::get_suspRequest() const
{
	if((m_type != 8) || !m_suspRequest)
	{
		return NewpkiSuspRequest::EmptyInstance;
	}
	return (*m_suspRequest);
}

NewpkiSuspRequest & NewpkiRequest::get_suspRequest()
{
	if((m_type != 8) || !m_suspRequest)
	{
		return NewpkiSuspRequest::EmptyInstance;
	}
	return (*m_suspRequest);
}

bool NewpkiRequest::set_unsuspRequest(const NewpkiUnsuspRequest & c_unsuspRequest)
{
	if(m_type != 9)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_unsuspRequest) = c_unsuspRequest;
	m_isOk=true;
	return true;
}

const NewpkiUnsuspRequest & NewpkiRequest::get_unsuspRequest() const
{
	if((m_type != 9) || !m_unsuspRequest)
	{
		return NewpkiUnsuspRequest::EmptyInstance;
	}
	return (*m_unsuspRequest);
}

NewpkiUnsuspRequest & NewpkiRequest::get_unsuspRequest()
{
	if((m_type != 9) || !m_unsuspRequest)
	{
		return NewpkiUnsuspRequest::EmptyInstance;
	}
	return (*m_unsuspRequest);
}

bool NewpkiRequest::malloc_byType (int c_type)
{
	switch(m_type)
	{
		case 3:
			m_backupRequest = new NewpkiBackupRequest();
			if(!m_backupRequest)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 0:
			m_certRequest = new NewpkiCertRequest();
			if(!m_certRequest)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 12:
			m_eeCertPublish = new NewpkiEeCertPublish();
			if(!m_eeCertPublish)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 7:
			m_eeCertRequest = new NewpkiEeRequestCert();
			if(!m_eeCertRequest)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 10:
			m_eeCertRevoke = new NewpkiEeRequestRev();
			if(!m_eeCertRevoke)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 5:
			m_eeDnPublish = new NewpkiEeDnPublish();
			if(!m_eeDnPublish)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 6:
			m_eeDnRemove = new NewpkiEeDnRemove();
			if(!m_eeDnRemove)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 11:
			m_eeUpdCertStatus = new NewpkiEeUpdateCertStatus();
			if(!m_eeUpdCertStatus)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 4:
			m_eeValRequest = new NewpkiEeValRequest();
			if(!m_eeValRequest)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 2:
			m_pubRequest = new NewpkiPubRequest();
			if(!m_pubRequest)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 1:
			m_revRequest = new NewpkiRevRequest();
			if(!m_revRequest)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 8:
			m_suspRequest = new NewpkiSuspRequest();
			if(!m_suspRequest)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 9:
			m_unsuspRequest = new NewpkiUnsuspRequest();
			if(!m_unsuspRequest)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
	}

	return true;
}

bool NewpkiRequest::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	NEWPKI_REQUEST * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool NewpkiRequest::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	NEWPKI_REQUEST * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

NewpkiRequest::NewpkiRequest():NewPKIObject(), NewPKISignCryptObject()
{
	resetAll();
}

NewpkiRequest::NewpkiRequest(const NewpkiRequest & other):NewPKIObject(), NewPKISignCryptObject()
{
	resetAll();
	*this = other;
}

NewpkiRequest::~NewpkiRequest()
{
	Clear();
}

void NewpkiRequest::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiRequest::freeAll()
{
	if(m_backupRequest)
	{
		delete m_backupRequest;
	}
	if(m_certRequest)
	{
		delete m_certRequest;
	}
	if(m_eeCertPublish)
	{
		delete m_eeCertPublish;
	}
	if(m_eeCertRequest)
	{
		delete m_eeCertRequest;
	}
	if(m_eeCertRevoke)
	{
		delete m_eeCertRevoke;
	}
	if(m_eeDnPublish)
	{
		delete m_eeDnPublish;
	}
	if(m_eeDnRemove)
	{
		delete m_eeDnRemove;
	}
	if(m_eeUpdCertStatus)
	{
		delete m_eeUpdCertStatus;
	}
	if(m_eeValRequest)
	{
		delete m_eeValRequest;
	}
	if(m_pubRequest)
	{
		delete m_pubRequest;
	}
	if(m_revRequest)
	{
		delete m_revRequest;
	}
	if(m_suspRequest)
	{
		delete m_suspRequest;
	}
	if(m_unsuspRequest)
	{
		delete m_unsuspRequest;
	}
}

void NewpkiRequest::resetAll()
{
	m_type = -1;
	m_backupRequest = NULL;
	m_certRequest = NULL;
	m_eeCertPublish = NULL;
	m_eeCertRequest = NULL;
	m_eeCertRevoke = NULL;
	m_eeDnPublish = NULL;
	m_eeDnRemove = NULL;
	m_eeUpdCertStatus = NULL;
	m_eeValRequest = NULL;
	m_pubRequest = NULL;
	m_revRequest = NULL;
	m_suspRequest = NULL;
	m_unsuspRequest = NULL;
}

bool NewpkiRequest::load_Datas(const NEWPKI_REQUEST * Datas)
{
	Clear();
	if(!set_type(Datas->type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(Datas->type)
	{
		case 3:
			if(Datas->d.backup_request)
			{
				if(!(*m_backupRequest).load_Datas(Datas->d.backup_request))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 0:
			if(Datas->d.cert_request)
			{
				if(!(*m_certRequest).load_Datas(Datas->d.cert_request))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 12:
			if(Datas->d.ee_cert_publish)
			{
				if(!(*m_eeCertPublish).load_Datas(Datas->d.ee_cert_publish))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 7:
			if(Datas->d.ee_cert_request)
			{
				if(!(*m_eeCertRequest).load_Datas(Datas->d.ee_cert_request))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 10:
			if(Datas->d.ee_cert_revoke)
			{
				if(!(*m_eeCertRevoke).load_Datas(Datas->d.ee_cert_revoke))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 5:
			if(Datas->d.ee_dn_publish)
			{
				if(!(*m_eeDnPublish).load_Datas(Datas->d.ee_dn_publish))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 6:
			if(Datas->d.ee_dn_remove)
			{
				if(!(*m_eeDnRemove).load_Datas(Datas->d.ee_dn_remove))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 11:
			if(Datas->d.ee_upd_cert_status)
			{
				if(!(*m_eeUpdCertStatus).load_Datas(Datas->d.ee_upd_cert_status))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 4:
			if(Datas->d.ee_val_request)
			{
				if(!(*m_eeValRequest).load_Datas(Datas->d.ee_val_request))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 2:
			if(Datas->d.pub_request)
			{
				if(!(*m_pubRequest).load_Datas(Datas->d.pub_request))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 1:
			if(Datas->d.rev_request)
			{
				if(!(*m_revRequest).load_Datas(Datas->d.rev_request))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 8:
			if(Datas->d.susp_request)
			{
				if(!(*m_suspRequest).load_Datas(Datas->d.susp_request))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 9:
			if(Datas->d.unsusp_request)
			{
				if(!(*m_unsuspRequest).load_Datas(Datas->d.unsusp_request))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}

bool NewpkiRequest::give_Datas(NEWPKI_REQUEST ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_REQUEST*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	(*Datas)->type = m_type;
	switch(m_type)
	{
		case 3:
			if(!((*Datas)->d.backup_request = (NEWPKI_BACKUP_REQUEST*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_BACKUP_REQUEST))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_backupRequest).give_Datas(&(*Datas)->d.backup_request))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.backup_request, ASN1_ITEM_rptr(NEWPKI_BACKUP_REQUEST));
				(*Datas)->d.backup_request = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 0:
			if(!((*Datas)->d.cert_request = (NEWPKI_CERT_REQUEST*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_CERT_REQUEST))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_certRequest).give_Datas(&(*Datas)->d.cert_request))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.cert_request, ASN1_ITEM_rptr(NEWPKI_CERT_REQUEST));
				(*Datas)->d.cert_request = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 12:
			if(!((*Datas)->d.ee_cert_publish = (NEWPKI_EE_CERT_PUBLISH*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_CERT_PUBLISH))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeCertPublish).give_Datas(&(*Datas)->d.ee_cert_publish))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_cert_publish, ASN1_ITEM_rptr(NEWPKI_EE_CERT_PUBLISH));
				(*Datas)->d.ee_cert_publish = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 7:
			if(!((*Datas)->d.ee_cert_request = (NEWPKI_EE_REQUEST_CERT*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_REQUEST_CERT))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeCertRequest).give_Datas(&(*Datas)->d.ee_cert_request))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_cert_request, ASN1_ITEM_rptr(NEWPKI_EE_REQUEST_CERT));
				(*Datas)->d.ee_cert_request = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 10:
			if(!((*Datas)->d.ee_cert_revoke = (NEWPKI_EE_REQUEST_REV*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_REQUEST_REV))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeCertRevoke).give_Datas(&(*Datas)->d.ee_cert_revoke))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_cert_revoke, ASN1_ITEM_rptr(NEWPKI_EE_REQUEST_REV));
				(*Datas)->d.ee_cert_revoke = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 5:
			if(!((*Datas)->d.ee_dn_publish = (NEWPKI_EE_DN_PUBLISH*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_DN_PUBLISH))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeDnPublish).give_Datas(&(*Datas)->d.ee_dn_publish))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_dn_publish, ASN1_ITEM_rptr(NEWPKI_EE_DN_PUBLISH));
				(*Datas)->d.ee_dn_publish = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 6:
			if(!((*Datas)->d.ee_dn_remove = (NEWPKI_EE_DN_REMOVE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_DN_REMOVE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeDnRemove).give_Datas(&(*Datas)->d.ee_dn_remove))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_dn_remove, ASN1_ITEM_rptr(NEWPKI_EE_DN_REMOVE));
				(*Datas)->d.ee_dn_remove = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 11:
			if(!((*Datas)->d.ee_upd_cert_status = (NEWPKI_EE_UPDATE_CERT_STATUS*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_UPDATE_CERT_STATUS))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeUpdCertStatus).give_Datas(&(*Datas)->d.ee_upd_cert_status))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_upd_cert_status, ASN1_ITEM_rptr(NEWPKI_EE_UPDATE_CERT_STATUS));
				(*Datas)->d.ee_upd_cert_status = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 4:
			if(!((*Datas)->d.ee_val_request = (NEWPKI_EE_VAL_REQUEST*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_VAL_REQUEST))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeValRequest).give_Datas(&(*Datas)->d.ee_val_request))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_val_request, ASN1_ITEM_rptr(NEWPKI_EE_VAL_REQUEST));
				(*Datas)->d.ee_val_request = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 2:
			if(!((*Datas)->d.pub_request = (NEWPKI_PUB_REQUEST*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_PUB_REQUEST))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_pubRequest).give_Datas(&(*Datas)->d.pub_request))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.pub_request, ASN1_ITEM_rptr(NEWPKI_PUB_REQUEST));
				(*Datas)->d.pub_request = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 1:
			if(!((*Datas)->d.rev_request = (NEWPKI_REV_REQUEST*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_REV_REQUEST))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_revRequest).give_Datas(&(*Datas)->d.rev_request))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.rev_request, ASN1_ITEM_rptr(NEWPKI_REV_REQUEST));
				(*Datas)->d.rev_request = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 8:
			if(!((*Datas)->d.susp_request = (NEWPKI_SUSP_REQUEST*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_SUSP_REQUEST))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_suspRequest).give_Datas(&(*Datas)->d.susp_request))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.susp_request, ASN1_ITEM_rptr(NEWPKI_SUSP_REQUEST));
				(*Datas)->d.susp_request = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 9:
			if(!((*Datas)->d.unsusp_request = (NEWPKI_UNSUSP_REQUEST*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_UNSUSP_REQUEST))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_unsuspRequest).give_Datas(&(*Datas)->d.unsusp_request))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.unsusp_request, ASN1_ITEM_rptr(NEWPKI_UNSUSP_REQUEST));
				(*Datas)->d.unsusp_request = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
	}
	return true;
}

bool NewpkiRequest::operator=(const NewpkiRequest & other)
{
	Clear();
	if(!set_type(other.m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(other.m_type)
	{
		case 3:
			if(!other.m_backupRequest)
				break;
			(*m_backupRequest) = *(other.m_backupRequest);
			break;
		case 0:
			if(!other.m_certRequest)
				break;
			(*m_certRequest) = *(other.m_certRequest);
			break;
		case 12:
			if(!other.m_eeCertPublish)
				break;
			(*m_eeCertPublish) = *(other.m_eeCertPublish);
			break;
		case 7:
			if(!other.m_eeCertRequest)
				break;
			(*m_eeCertRequest) = *(other.m_eeCertRequest);
			break;
		case 10:
			if(!other.m_eeCertRevoke)
				break;
			(*m_eeCertRevoke) = *(other.m_eeCertRevoke);
			break;
		case 5:
			if(!other.m_eeDnPublish)
				break;
			(*m_eeDnPublish) = *(other.m_eeDnPublish);
			break;
		case 6:
			if(!other.m_eeDnRemove)
				break;
			(*m_eeDnRemove) = *(other.m_eeDnRemove);
			break;
		case 11:
			if(!other.m_eeUpdCertStatus)
				break;
			(*m_eeUpdCertStatus) = *(other.m_eeUpdCertStatus);
			break;
		case 4:
			if(!other.m_eeValRequest)
				break;
			(*m_eeValRequest) = *(other.m_eeValRequest);
			break;
		case 2:
			if(!other.m_pubRequest)
				break;
			(*m_pubRequest) = *(other.m_pubRequest);
			break;
		case 1:
			if(!other.m_revRequest)
				break;
			(*m_revRequest) = *(other.m_revRequest);
			break;
		case 8:
			if(!other.m_suspRequest)
				break;
			(*m_suspRequest) = *(other.m_suspRequest);
			break;
		case 9:
			if(!other.m_unsuspRequest)
				break;
			(*m_unsuspRequest) = *(other.m_unsuspRequest);
			break;
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiRequest::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_REQUEST);
}
CryptedNewpkiRequest CryptedNewpkiRequest::EmptyInstance;
bool CryptedNewpkiRequest::set_request(const Asn1EncryptSign & c_request)
{
	m_request = c_request;
	return true;
}

const Asn1EncryptSign & CryptedNewpkiRequest::get_request() const
{
	return m_request;
}

Asn1EncryptSign & CryptedNewpkiRequest::get_request()
{
	return m_request;
}

bool CryptedNewpkiRequest::set_recipient(const X509_PUBKEY * c_recipient)
{
	if(m_recipient)
		ASN1_item_free((ASN1_VALUE*)m_recipient, ASN1_ITEM_rptr(X509_PUBKEY));
	m_recipient = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (void*)c_recipient);
	if(!m_recipient)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_PUBKEY * CryptedNewpkiRequest::get_recipient() const
{
	if(!m_recipient)
		((CryptedNewpkiRequest*)this)->m_recipient = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
	return m_recipient;
}

X509_PUBKEY * CryptedNewpkiRequest::get_recipient()
{
	if(!m_recipient)
		m_recipient = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
	return m_recipient;
}

bool CryptedNewpkiRequest::set_sender(const X509_PUBKEY * c_sender)
{
	if(m_sender)
		ASN1_item_free((ASN1_VALUE*)m_sender, ASN1_ITEM_rptr(X509_PUBKEY));
	m_sender = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (void*)c_sender);
	if(!m_sender)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_PUBKEY * CryptedNewpkiRequest::get_sender() const
{
	if(!m_sender)
		((CryptedNewpkiRequest*)this)->m_sender = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
	return m_sender;
}

X509_PUBKEY * CryptedNewpkiRequest::get_sender()
{
	if(!m_sender)
		m_sender = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
	return m_sender;
}

bool CryptedNewpkiRequest::set_transactionid(const Asn1OctetString & c_transactionid)
{
	m_transactionid = c_transactionid;
	return true;
}

const Asn1OctetString & CryptedNewpkiRequest::get_transactionid() const
{
	return m_transactionid;
}

Asn1OctetString & CryptedNewpkiRequest::get_transactionid()
{
	return m_transactionid;
}

bool CryptedNewpkiRequest::to_PEM(mString & PemDatas) const
{
	CRYPTED_NEWPKI_REQUEST * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toPEM("CRYPTED NEWPKI REQUEST", get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool CryptedNewpkiRequest::from_PEM(const mString & PemDatas)
{
	CRYPTED_NEWPKI_REQUEST * c_localvar = NULL;
	if(!Private_fromPEM("CRYPTED NEWPKI REQUEST", get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

CryptedNewpkiRequest::CryptedNewpkiRequest():NewPKIObject()
{
	resetAll();
}

CryptedNewpkiRequest::CryptedNewpkiRequest(const CryptedNewpkiRequest & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

CryptedNewpkiRequest::~CryptedNewpkiRequest()
{
	Clear();
}

void CryptedNewpkiRequest::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void CryptedNewpkiRequest::freeAll()
{
	if(m_recipient)
	{
		ASN1_item_free((ASN1_VALUE*)m_recipient, ASN1_ITEM_rptr(X509_PUBKEY));
	}
	if(m_sender)
	{
		ASN1_item_free((ASN1_VALUE*)m_sender, ASN1_ITEM_rptr(X509_PUBKEY));
	}
}

void CryptedNewpkiRequest::resetAll()
{
	m_request.Clear();
	m_recipient = NULL;
	m_sender = NULL;
	m_transactionid.Clear();
}

bool CryptedNewpkiRequest::load_Datas(const CRYPTED_NEWPKI_REQUEST * Datas)
{
	Clear();
	if(Datas->c_request)
	{
		if(!m_request.load_Datas(Datas->c_request))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->recipient)
	{
		if(m_recipient)
			ASN1_item_free((ASN1_VALUE*)m_recipient, ASN1_ITEM_rptr(X509_PUBKEY));
		m_recipient = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), Datas->recipient);
		if(!m_recipient)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->sender)
	{
		if(m_sender)
			ASN1_item_free((ASN1_VALUE*)m_sender, ASN1_ITEM_rptr(X509_PUBKEY));
		m_sender = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), Datas->sender);
		if(!m_sender)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->transactionID)
	{
		if(!m_transactionid.load_Datas(Datas->transactionID))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool CryptedNewpkiRequest::give_Datas(CRYPTED_NEWPKI_REQUEST ** Datas) const
{
	if(!(*Datas) && !(*Datas = (CRYPTED_NEWPKI_REQUEST*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->c_request && !((*Datas)->c_request = (ASN1_ENCRYPT_SIGN*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_ENCRYPT_SIGN))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_request.give_Datas(&(*Datas)->c_request))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->c_request, ASN1_ITEM_rptr(ASN1_ENCRYPT_SIGN));
		(*Datas)->c_request = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(m_recipient)
	{
		if((*Datas)->recipient)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->recipient, ASN1_ITEM_rptr(X509_PUBKEY));
		if(!((*Datas)->recipient = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (ASN1_VALUE*)m_recipient)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->recipient)
		{
			(*Datas)->recipient = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
			if(!(*Datas)->recipient)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(m_sender)
	{
		if((*Datas)->sender)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->sender, ASN1_ITEM_rptr(X509_PUBKEY));
		if(!((*Datas)->sender = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (ASN1_VALUE*)m_sender)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->sender)
		{
			(*Datas)->sender = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
			if(!(*Datas)->sender)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->transactionID && !((*Datas)->transactionID = (ASN1_OCTET_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_OCTET_STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_transactionid.give_Datas(&(*Datas)->transactionID))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->transactionID, ASN1_ITEM_rptr(ASN1_OCTET_STRING));
		(*Datas)->transactionID = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool CryptedNewpkiRequest::operator=(const CryptedNewpkiRequest & other)
{
	Clear();
	m_request = other.m_request;
	if(other.m_recipient)
	{
		if(m_recipient)
			ASN1_item_free((ASN1_VALUE*)m_recipient, ASN1_ITEM_rptr(X509_PUBKEY));
		m_recipient = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (void*)other.m_recipient);
		if(!m_recipient)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(other.m_sender)
	{
		if(m_sender)
			ASN1_item_free((ASN1_VALUE*)m_sender, ASN1_ITEM_rptr(X509_PUBKEY));
		m_sender = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (void*)other.m_sender);
		if(!m_sender)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_transactionid = other.m_transactionid;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * CryptedNewpkiRequest::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(CRYPTED_NEWPKI_REQUEST);
}
CryptedNewpkiRequests CryptedNewpkiRequests::EmptyInstance;
bool CryptedNewpkiRequests::set_requests(const mVector< CryptedNewpkiRequest > & c_requests)
{
	m_requests = c_requests;
	return true;
}

const mVector< CryptedNewpkiRequest > & CryptedNewpkiRequests::get_requests() const
{
	return m_requests;
}

mVector< CryptedNewpkiRequest > & CryptedNewpkiRequests::get_requests()
{
	return m_requests;
}

CryptedNewpkiRequests::CryptedNewpkiRequests():NewPKIObject()
{
	resetAll();
}

CryptedNewpkiRequests::CryptedNewpkiRequests(const CryptedNewpkiRequests & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

CryptedNewpkiRequests::~CryptedNewpkiRequests()
{
	Clear();
}

void CryptedNewpkiRequests::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void CryptedNewpkiRequests::freeAll()
{
}

void CryptedNewpkiRequests::resetAll()
{
	m_requests.clear();
}

bool CryptedNewpkiRequests::load_Datas(const CRYPTED_NEWPKI_REQUESTS * Datas)
{
	Clear();
	int i;
	CRYPTED_NEWPKI_REQUEST * currrequests;
	if(Datas->requests)
	{
		for(i=0; i<SKM_sk_num(CRYPTED_NEWPKI_REQUEST, Datas->requests); i++)
		{
			currrequests = SKM_sk_value(CRYPTED_NEWPKI_REQUEST, Datas->requests, i);
			if(!currrequests)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_requests.insert(m_requests.begin() + i);
			if(!m_requests[i].load_Datas(currrequests))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool CryptedNewpkiRequests::give_Datas(CRYPTED_NEWPKI_REQUESTS ** Datas) const
{
	if(!(*Datas) && !(*Datas = (CRYPTED_NEWPKI_REQUESTS*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	CRYPTED_NEWPKI_REQUEST * currrequests;
	size_t i;
	if(!(*Datas)->requests && !((*Datas)->requests = SKM_sk_new_null(CRYPTED_NEWPKI_REQUEST)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_requests.size() ; i++)
	{
		currrequests = NULL;
		if(!m_requests[i].give_Datas(&currrequests))
		{
			ASN1_item_free((ASN1_VALUE*)currrequests, ASN1_ITEM_rptr(CRYPTED_NEWPKI_REQUEST));
			currrequests = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(CRYPTED_NEWPKI_REQUEST, (*Datas)->requests, currrequests) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currrequests, ASN1_ITEM_rptr(CRYPTED_NEWPKI_REQUEST));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool CryptedNewpkiRequests::operator=(const CryptedNewpkiRequests & other)
{
	Clear();
	m_requests = other.m_requests;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * CryptedNewpkiRequests::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(CRYPTED_NEWPKI_REQUESTS);
}
NewpkiCertResponse NewpkiCertResponse::EmptyInstance;
bool NewpkiCertResponse::set_parentcerts(const mVector< PKI_CERT > & c_parentcerts)
{
	m_parentcerts = c_parentcerts;
	return true;
}

const mVector< PKI_CERT > & NewpkiCertResponse::get_parentcerts() const
{
	return m_parentcerts;
}

mVector< PKI_CERT > & NewpkiCertResponse::get_parentcerts()
{
	return m_parentcerts;
}

bool NewpkiCertResponse::set_certificate(const PKI_CERT & c_certificate)
{
	m_certificate = c_certificate;
	return true;
}

const PKI_CERT & NewpkiCertResponse::get_certificate() const
{
	return m_certificate;
}

PKI_CERT & NewpkiCertResponse::get_certificate()
{
	return m_certificate;
}

bool NewpkiCertResponse::set_errors(const mVector< ErrorEntry > & c_errors)
{
	m_errors = c_errors;
	return true;
}

const mVector< ErrorEntry > & NewpkiCertResponse::get_errors() const
{
	return m_errors;
}

mVector< ErrorEntry > & NewpkiCertResponse::get_errors()
{
	return m_errors;
}

bool NewpkiCertResponse::set_id(unsigned long c_id)
{
	m_id = c_id;
	return true;
}

unsigned long NewpkiCertResponse::get_id() const
{
	return m_id;
}

bool NewpkiCertResponse::set_lastCrl(const PKI_CRL & c_lastCrl)
{
	m_lastCrl = c_lastCrl;
	return true;
}

const PKI_CRL & NewpkiCertResponse::get_lastCrl() const
{
	return m_lastCrl;
}

PKI_CRL & NewpkiCertResponse::get_lastCrl()
{
	return m_lastCrl;
}

bool NewpkiCertResponse::set_status(unsigned long c_status)
{
	m_status = c_status;
	return true;
}

unsigned long NewpkiCertResponse::get_status() const
{
	return m_status;
}

NewpkiCertResponse::NewpkiCertResponse():NewPKIObject()
{
	resetAll();
}

NewpkiCertResponse::NewpkiCertResponse(const NewpkiCertResponse & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiCertResponse::~NewpkiCertResponse()
{
	Clear();
}

void NewpkiCertResponse::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiCertResponse::freeAll()
{
}

void NewpkiCertResponse::resetAll()
{
	m_parentcerts.clear();
	m_certificate.Clear();
	m_errors.clear();
	m_id = 0;
	m_lastCrl.Clear();
	m_status = 0;
}

bool NewpkiCertResponse::load_Datas(const NEWPKI_CERT_RESPONSE * Datas)
{
	Clear();
	ERROR_ENTRY * currerrors;
	int i;
	X509 * currparentcerts;
	if(Datas->ParentCerts)
	{
		for(i=0; i<SKM_sk_num(X509, Datas->ParentCerts); i++)
		{
			currparentcerts = SKM_sk_value(X509, Datas->ParentCerts, i);
			if(!currparentcerts)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_parentcerts.insert(m_parentcerts.begin() + i);
			if(!m_parentcerts[i].load_Datas(currparentcerts))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->certificate)
	{
		if(!m_certificate.load_Datas(Datas->certificate))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->errors)
	{
		for(i=0; i<SKM_sk_num(ERROR_ENTRY, Datas->errors); i++)
		{
			currerrors = SKM_sk_value(ERROR_ENTRY, Datas->errors, i);
			if(!currerrors)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_errors.insert(m_errors.begin() + i);
			if(!m_errors[i].load_Datas(currerrors))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->id)
	{
		m_id = ASN1_INTEGER_GET(Datas->id);
	}
	if(Datas->last_crl)
	{
		if(!m_lastCrl.load_Datas(Datas->last_crl))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->status)
	{
		m_status = ASN1_INTEGER_GET(Datas->status);
	}
	m_isOk=true;
	return true;
}

bool NewpkiCertResponse::give_Datas(NEWPKI_CERT_RESPONSE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_CERT_RESPONSE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ERROR_ENTRY * currerrors;
	X509 * currparentcerts;
	size_t i;
	if(!(*Datas)->ParentCerts && !((*Datas)->ParentCerts = SKM_sk_new_null(X509)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_parentcerts.size() ; i++)
	{
		currparentcerts = NULL;
		if(!m_parentcerts[i].give_Datas(&currparentcerts))
		{
			ASN1_item_free((ASN1_VALUE*)currparentcerts, ASN1_ITEM_rptr(X509));
			currparentcerts = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(X509, (*Datas)->ParentCerts, currparentcerts) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currparentcerts, ASN1_ITEM_rptr(X509));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(m_certificate)
	{
		if(!(*Datas)->certificate && !((*Datas)->certificate = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_certificate.give_Datas(&(*Datas)->certificate))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->certificate, ASN1_ITEM_rptr(X509));
			(*Datas)->certificate = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->certificate)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->certificate, ASN1_ITEM_rptr(X509));
			(*Datas)->certificate = NULL;
		}
	}
	if(!(*Datas)->errors && !((*Datas)->errors = SKM_sk_new_null(ERROR_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_errors.size() ; i++)
	{
		currerrors = NULL;
		if(!m_errors[i].give_Datas(&currerrors))
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			currerrors = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ERROR_ENTRY, (*Datas)->errors, currerrors) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->id && !((*Datas)->id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->id, m_id) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->id);
		(*Datas)->id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(m_lastCrl)
	{
		if(!(*Datas)->last_crl && !((*Datas)->last_crl = (X509_CRL*)ASN1_item_new(ASN1_ITEM_rptr(X509_CRL))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_lastCrl.give_Datas(&(*Datas)->last_crl))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->last_crl)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
		}
	}
	if(!(*Datas)->status && !((*Datas)->status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->status, m_status) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->status);
		(*Datas)->status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiCertResponse::operator=(const NewpkiCertResponse & other)
{
	Clear();
	m_parentcerts = other.m_parentcerts;
	m_certificate = other.m_certificate;
	m_errors = other.m_errors;
	m_id = other.m_id;
	m_lastCrl = other.m_lastCrl;
	m_status = other.m_status;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiCertResponse::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_CERT_RESPONSE);
}
NewpkiEeCertResponse NewpkiEeCertResponse::EmptyInstance;
bool NewpkiEeCertResponse::set_certificate(const PKI_CERT & c_certificate)
{
	m_certificate = c_certificate;
	return true;
}

const PKI_CERT & NewpkiEeCertResponse::get_certificate() const
{
	return m_certificate;
}

PKI_CERT & NewpkiEeCertResponse::get_certificate()
{
	return m_certificate;
}

bool NewpkiEeCertResponse::set_errors(const mVector< ErrorEntry > & c_errors)
{
	m_errors = c_errors;
	return true;
}

const mVector< ErrorEntry > & NewpkiEeCertResponse::get_errors() const
{
	return m_errors;
}

mVector< ErrorEntry > & NewpkiEeCertResponse::get_errors()
{
	return m_errors;
}

bool NewpkiEeCertResponse::set_lastCrl(const PKI_CRL & c_lastCrl)
{
	m_lastCrl = c_lastCrl;
	return true;
}

const PKI_CRL & NewpkiEeCertResponse::get_lastCrl() const
{
	return m_lastCrl;
}

PKI_CRL & NewpkiEeCertResponse::get_lastCrl()
{
	return m_lastCrl;
}

bool NewpkiEeCertResponse::set_p12(const PKI_PKCS12 & c_p12)
{
	m_p12 = c_p12;
	return true;
}

const PKI_PKCS12 & NewpkiEeCertResponse::get_p12() const
{
	return m_p12;
}

PKI_PKCS12 & NewpkiEeCertResponse::get_p12()
{
	return m_p12;
}

bool NewpkiEeCertResponse::set_p7b(const PKI_P7B & c_p7b)
{
	m_p7b = c_p7b;
	return true;
}

const PKI_P7B & NewpkiEeCertResponse::get_p7b() const
{
	return m_p7b;
}

PKI_P7B & NewpkiEeCertResponse::get_p7b()
{
	return m_p7b;
}

bool NewpkiEeCertResponse::set_raId(unsigned long c_raId)
{
	m_raId = c_raId;
	return true;
}

unsigned long NewpkiEeCertResponse::get_raId() const
{
	return m_raId;
}

bool NewpkiEeCertResponse::set_status(unsigned long c_status)
{
	m_status = c_status;
	return true;
}

unsigned long NewpkiEeCertResponse::get_status() const
{
	return m_status;
}

NewpkiEeCertResponse::NewpkiEeCertResponse():NewPKIObject()
{
	resetAll();
}

NewpkiEeCertResponse::NewpkiEeCertResponse(const NewpkiEeCertResponse & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeCertResponse::~NewpkiEeCertResponse()
{
	Clear();
}

void NewpkiEeCertResponse::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeCertResponse::freeAll()
{
}

void NewpkiEeCertResponse::resetAll()
{
	m_certificate.Clear();
	m_errors.clear();
	m_lastCrl.Clear();
	m_p12.Clear();
	m_p7b.Clear();
	m_raId = 0;
	m_status = 0;
}

bool NewpkiEeCertResponse::load_Datas(const NEWPKI_EE_CERT_RESPONSE * Datas)
{
	Clear();
	int i;
	ERROR_ENTRY * currerrors;
	if(Datas->certificate)
	{
		if(!m_certificate.load_Datas(Datas->certificate))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->errors)
	{
		for(i=0; i<SKM_sk_num(ERROR_ENTRY, Datas->errors); i++)
		{
			currerrors = SKM_sk_value(ERROR_ENTRY, Datas->errors, i);
			if(!currerrors)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_errors.insert(m_errors.begin() + i);
			if(!m_errors[i].load_Datas(currerrors))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->last_crl)
	{
		if(!m_lastCrl.load_Datas(Datas->last_crl))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->p12)
	{
		if(!m_p12.load_Datas(Datas->p12))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->p7b)
	{
		if(!m_p7b.load_Datas(Datas->p7b))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->ra_id)
	{
		m_raId = ASN1_INTEGER_GET(Datas->ra_id);
	}
	if(Datas->status)
	{
		m_status = ASN1_INTEGER_GET(Datas->status);
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeCertResponse::give_Datas(NEWPKI_EE_CERT_RESPONSE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_CERT_RESPONSE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ERROR_ENTRY * currerrors;
	size_t i;
	if(m_certificate)
	{
		if(!(*Datas)->certificate && !((*Datas)->certificate = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_certificate.give_Datas(&(*Datas)->certificate))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->certificate, ASN1_ITEM_rptr(X509));
			(*Datas)->certificate = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->certificate)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->certificate, ASN1_ITEM_rptr(X509));
			(*Datas)->certificate = NULL;
		}
	}
	if(!(*Datas)->errors && !((*Datas)->errors = SKM_sk_new_null(ERROR_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_errors.size() ; i++)
	{
		currerrors = NULL;
		if(!m_errors[i].give_Datas(&currerrors))
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			currerrors = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ERROR_ENTRY, (*Datas)->errors, currerrors) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(m_lastCrl)
	{
		if(!(*Datas)->last_crl && !((*Datas)->last_crl = (X509_CRL*)ASN1_item_new(ASN1_ITEM_rptr(X509_CRL))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_lastCrl.give_Datas(&(*Datas)->last_crl))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->last_crl)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
		}
	}
	if(m_p12)
	{
		if(!(*Datas)->p12 && !((*Datas)->p12 = (PKCS12*)ASN1_item_new(ASN1_ITEM_rptr(PKCS12))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_p12.give_Datas(&(*Datas)->p12))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->p12, ASN1_ITEM_rptr(PKCS12));
			(*Datas)->p12 = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->p12)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->p12, ASN1_ITEM_rptr(PKCS12));
			(*Datas)->p12 = NULL;
		}
	}
	if(m_p7b)
	{
		if(!(*Datas)->p7b && !((*Datas)->p7b = (PKCS7*)ASN1_item_new(ASN1_ITEM_rptr(PKCS7))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_p7b.give_Datas(&(*Datas)->p7b))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->p7b, ASN1_ITEM_rptr(PKCS7));
			(*Datas)->p7b = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->p7b)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->p7b, ASN1_ITEM_rptr(PKCS7));
			(*Datas)->p7b = NULL;
		}
	}
	if(!(*Datas)->ra_id && !((*Datas)->ra_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ra_id, m_raId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ra_id);
		(*Datas)->ra_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->status && !((*Datas)->status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->status, m_status) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->status);
		(*Datas)->status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiEeCertResponse::operator=(const NewpkiEeCertResponse & other)
{
	Clear();
	m_certificate = other.m_certificate;
	m_errors = other.m_errors;
	m_lastCrl = other.m_lastCrl;
	m_p12 = other.m_p12;
	m_p7b = other.m_p7b;
	m_raId = other.m_raId;
	m_status = other.m_status;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeCertResponse::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_CERT_RESPONSE);
}
NewpkiRevResponse NewpkiRevResponse::EmptyInstance;
bool NewpkiRevResponse::set_certStatus(unsigned long c_certStatus)
{
	m_certStatus = c_certStatus;
	return true;
}

unsigned long NewpkiRevResponse::get_certStatus() const
{
	return m_certStatus;
}

bool NewpkiRevResponse::set_errors(const mVector< ErrorEntry > & c_errors)
{
	m_errors = c_errors;
	return true;
}

const mVector< ErrorEntry > & NewpkiRevResponse::get_errors() const
{
	return m_errors;
}

mVector< ErrorEntry > & NewpkiRevResponse::get_errors()
{
	return m_errors;
}

bool NewpkiRevResponse::set_id(unsigned long c_id)
{
	m_id = c_id;
	return true;
}

unsigned long NewpkiRevResponse::get_id() const
{
	return m_id;
}

bool NewpkiRevResponse::set_lastCrl(const PKI_CRL & c_lastCrl)
{
	m_lastCrl = c_lastCrl;
	return true;
}

const PKI_CRL & NewpkiRevResponse::get_lastCrl() const
{
	return m_lastCrl;
}

PKI_CRL & NewpkiRevResponse::get_lastCrl()
{
	return m_lastCrl;
}

bool NewpkiRevResponse::set_status(unsigned long c_status)
{
	m_status = c_status;
	return true;
}

unsigned long NewpkiRevResponse::get_status() const
{
	return m_status;
}

NewpkiRevResponse::NewpkiRevResponse():NewPKIObject()
{
	resetAll();
}

NewpkiRevResponse::NewpkiRevResponse(const NewpkiRevResponse & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiRevResponse::~NewpkiRevResponse()
{
	Clear();
}

void NewpkiRevResponse::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiRevResponse::freeAll()
{
}

void NewpkiRevResponse::resetAll()
{
	m_certStatus = 0;
	m_errors.clear();
	m_id = 0;
	m_lastCrl.Clear();
	m_status = 0;
}

bool NewpkiRevResponse::load_Datas(const NEWPKI_REV_RESPONSE * Datas)
{
	Clear();
	int i;
	ERROR_ENTRY * currerrors;
	if(Datas->cert_status)
	{
		m_certStatus = ASN1_INTEGER_GET(Datas->cert_status);
	}
	if(Datas->errors)
	{
		for(i=0; i<SKM_sk_num(ERROR_ENTRY, Datas->errors); i++)
		{
			currerrors = SKM_sk_value(ERROR_ENTRY, Datas->errors, i);
			if(!currerrors)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_errors.insert(m_errors.begin() + i);
			if(!m_errors[i].load_Datas(currerrors))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->id)
	{
		m_id = ASN1_INTEGER_GET(Datas->id);
	}
	if(Datas->last_crl)
	{
		if(!m_lastCrl.load_Datas(Datas->last_crl))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->status)
	{
		m_status = ASN1_INTEGER_GET(Datas->status);
	}
	m_isOk=true;
	return true;
}

bool NewpkiRevResponse::give_Datas(NEWPKI_REV_RESPONSE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_REV_RESPONSE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ERROR_ENTRY * currerrors;
	size_t i;
	if(!(*Datas)->cert_status && !((*Datas)->cert_status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->cert_status, m_certStatus) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->cert_status);
		(*Datas)->cert_status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->errors && !((*Datas)->errors = SKM_sk_new_null(ERROR_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_errors.size() ; i++)
	{
		currerrors = NULL;
		if(!m_errors[i].give_Datas(&currerrors))
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			currerrors = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ERROR_ENTRY, (*Datas)->errors, currerrors) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->id && !((*Datas)->id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->id, m_id) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->id);
		(*Datas)->id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(m_lastCrl)
	{
		if(!(*Datas)->last_crl && !((*Datas)->last_crl = (X509_CRL*)ASN1_item_new(ASN1_ITEM_rptr(X509_CRL))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_lastCrl.give_Datas(&(*Datas)->last_crl))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->last_crl)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
		}
	}
	if(!(*Datas)->status && !((*Datas)->status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->status, m_status) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->status);
		(*Datas)->status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiRevResponse::operator=(const NewpkiRevResponse & other)
{
	Clear();
	m_certStatus = other.m_certStatus;
	m_errors = other.m_errors;
	m_id = other.m_id;
	m_lastCrl = other.m_lastCrl;
	m_status = other.m_status;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiRevResponse::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_REV_RESPONSE);
}
NewpkiEeRevResponse NewpkiEeRevResponse::EmptyInstance;
bool NewpkiEeRevResponse::set_certStatus(unsigned long c_certStatus)
{
	m_certStatus = c_certStatus;
	return true;
}

unsigned long NewpkiEeRevResponse::get_certStatus() const
{
	return m_certStatus;
}

bool NewpkiEeRevResponse::set_errors(const mVector< ErrorEntry > & c_errors)
{
	m_errors = c_errors;
	return true;
}

const mVector< ErrorEntry > & NewpkiEeRevResponse::get_errors() const
{
	return m_errors;
}

mVector< ErrorEntry > & NewpkiEeRevResponse::get_errors()
{
	return m_errors;
}

bool NewpkiEeRevResponse::set_lastCrl(const PKI_CRL & c_lastCrl)
{
	m_lastCrl = c_lastCrl;
	return true;
}

const PKI_CRL & NewpkiEeRevResponse::get_lastCrl() const
{
	return m_lastCrl;
}

PKI_CRL & NewpkiEeRevResponse::get_lastCrl()
{
	return m_lastCrl;
}

bool NewpkiEeRevResponse::set_raId(unsigned long c_raId)
{
	m_raId = c_raId;
	return true;
}

unsigned long NewpkiEeRevResponse::get_raId() const
{
	return m_raId;
}

bool NewpkiEeRevResponse::set_status(unsigned long c_status)
{
	m_status = c_status;
	return true;
}

unsigned long NewpkiEeRevResponse::get_status() const
{
	return m_status;
}

NewpkiEeRevResponse::NewpkiEeRevResponse():NewPKIObject()
{
	resetAll();
}

NewpkiEeRevResponse::NewpkiEeRevResponse(const NewpkiEeRevResponse & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeRevResponse::~NewpkiEeRevResponse()
{
	Clear();
}

void NewpkiEeRevResponse::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeRevResponse::freeAll()
{
}

void NewpkiEeRevResponse::resetAll()
{
	m_certStatus = 0;
	m_errors.clear();
	m_lastCrl.Clear();
	m_raId = 0;
	m_status = 0;
}

bool NewpkiEeRevResponse::load_Datas(const NEWPKI_EE_REV_RESPONSE * Datas)
{
	Clear();
	int i;
	ERROR_ENTRY * currerrors;
	if(Datas->cert_status)
	{
		m_certStatus = ASN1_INTEGER_GET(Datas->cert_status);
	}
	if(Datas->errors)
	{
		for(i=0; i<SKM_sk_num(ERROR_ENTRY, Datas->errors); i++)
		{
			currerrors = SKM_sk_value(ERROR_ENTRY, Datas->errors, i);
			if(!currerrors)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_errors.insert(m_errors.begin() + i);
			if(!m_errors[i].load_Datas(currerrors))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->last_crl)
	{
		if(!m_lastCrl.load_Datas(Datas->last_crl))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->ra_id)
	{
		m_raId = ASN1_INTEGER_GET(Datas->ra_id);
	}
	if(Datas->status)
	{
		m_status = ASN1_INTEGER_GET(Datas->status);
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeRevResponse::give_Datas(NEWPKI_EE_REV_RESPONSE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_REV_RESPONSE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ERROR_ENTRY * currerrors;
	size_t i;
	if(!(*Datas)->cert_status && !((*Datas)->cert_status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->cert_status, m_certStatus) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->cert_status);
		(*Datas)->cert_status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->errors && !((*Datas)->errors = SKM_sk_new_null(ERROR_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_errors.size() ; i++)
	{
		currerrors = NULL;
		if(!m_errors[i].give_Datas(&currerrors))
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			currerrors = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ERROR_ENTRY, (*Datas)->errors, currerrors) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(m_lastCrl)
	{
		if(!(*Datas)->last_crl && !((*Datas)->last_crl = (X509_CRL*)ASN1_item_new(ASN1_ITEM_rptr(X509_CRL))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_lastCrl.give_Datas(&(*Datas)->last_crl))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->last_crl)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
		}
	}
	if(!(*Datas)->ra_id && !((*Datas)->ra_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ra_id, m_raId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ra_id);
		(*Datas)->ra_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->status && !((*Datas)->status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->status, m_status) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->status);
		(*Datas)->status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiEeRevResponse::operator=(const NewpkiEeRevResponse & other)
{
	Clear();
	m_certStatus = other.m_certStatus;
	m_errors = other.m_errors;
	m_lastCrl = other.m_lastCrl;
	m_raId = other.m_raId;
	m_status = other.m_status;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeRevResponse::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_REV_RESPONSE);
}
NewpkiSuspResponse NewpkiSuspResponse::EmptyInstance;
bool NewpkiSuspResponse::set_certStatus(unsigned long c_certStatus)
{
	m_certStatus = c_certStatus;
	return true;
}

unsigned long NewpkiSuspResponse::get_certStatus() const
{
	return m_certStatus;
}

bool NewpkiSuspResponse::set_errors(const mVector< ErrorEntry > & c_errors)
{
	m_errors = c_errors;
	return true;
}

const mVector< ErrorEntry > & NewpkiSuspResponse::get_errors() const
{
	return m_errors;
}

mVector< ErrorEntry > & NewpkiSuspResponse::get_errors()
{
	return m_errors;
}

bool NewpkiSuspResponse::set_id(unsigned long c_id)
{
	m_id = c_id;
	return true;
}

unsigned long NewpkiSuspResponse::get_id() const
{
	return m_id;
}

bool NewpkiSuspResponse::set_lastCrl(const PKI_CRL & c_lastCrl)
{
	m_lastCrl = c_lastCrl;
	return true;
}

const PKI_CRL & NewpkiSuspResponse::get_lastCrl() const
{
	return m_lastCrl;
}

PKI_CRL & NewpkiSuspResponse::get_lastCrl()
{
	return m_lastCrl;
}

bool NewpkiSuspResponse::set_status(unsigned long c_status)
{
	m_status = c_status;
	return true;
}

unsigned long NewpkiSuspResponse::get_status() const
{
	return m_status;
}

NewpkiSuspResponse::NewpkiSuspResponse():NewPKIObject()
{
	resetAll();
}

NewpkiSuspResponse::NewpkiSuspResponse(const NewpkiSuspResponse & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiSuspResponse::~NewpkiSuspResponse()
{
	Clear();
}

void NewpkiSuspResponse::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiSuspResponse::freeAll()
{
}

void NewpkiSuspResponse::resetAll()
{
	m_certStatus = 0;
	m_errors.clear();
	m_id = 0;
	m_lastCrl.Clear();
	m_status = 0;
}

bool NewpkiSuspResponse::load_Datas(const NEWPKI_SUSP_RESPONSE * Datas)
{
	Clear();
	int i;
	ERROR_ENTRY * currerrors;
	if(Datas->cert_status)
	{
		m_certStatus = ASN1_INTEGER_GET(Datas->cert_status);
	}
	if(Datas->errors)
	{
		for(i=0; i<SKM_sk_num(ERROR_ENTRY, Datas->errors); i++)
		{
			currerrors = SKM_sk_value(ERROR_ENTRY, Datas->errors, i);
			if(!currerrors)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_errors.insert(m_errors.begin() + i);
			if(!m_errors[i].load_Datas(currerrors))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->id)
	{
		m_id = ASN1_INTEGER_GET(Datas->id);
	}
	if(Datas->last_crl)
	{
		if(!m_lastCrl.load_Datas(Datas->last_crl))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->status)
	{
		m_status = ASN1_INTEGER_GET(Datas->status);
	}
	m_isOk=true;
	return true;
}

bool NewpkiSuspResponse::give_Datas(NEWPKI_SUSP_RESPONSE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_SUSP_RESPONSE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ERROR_ENTRY * currerrors;
	size_t i;
	if(!(*Datas)->cert_status && !((*Datas)->cert_status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->cert_status, m_certStatus) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->cert_status);
		(*Datas)->cert_status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->errors && !((*Datas)->errors = SKM_sk_new_null(ERROR_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_errors.size() ; i++)
	{
		currerrors = NULL;
		if(!m_errors[i].give_Datas(&currerrors))
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			currerrors = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ERROR_ENTRY, (*Datas)->errors, currerrors) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->id && !((*Datas)->id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->id, m_id) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->id);
		(*Datas)->id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(m_lastCrl)
	{
		if(!(*Datas)->last_crl && !((*Datas)->last_crl = (X509_CRL*)ASN1_item_new(ASN1_ITEM_rptr(X509_CRL))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_lastCrl.give_Datas(&(*Datas)->last_crl))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->last_crl)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
		}
	}
	if(!(*Datas)->status && !((*Datas)->status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->status, m_status) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->status);
		(*Datas)->status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiSuspResponse::operator=(const NewpkiSuspResponse & other)
{
	Clear();
	m_certStatus = other.m_certStatus;
	m_errors = other.m_errors;
	m_id = other.m_id;
	m_lastCrl = other.m_lastCrl;
	m_status = other.m_status;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiSuspResponse::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_SUSP_RESPONSE);
}
NewpkiUnsuspResponse NewpkiUnsuspResponse::EmptyInstance;
bool NewpkiUnsuspResponse::set_certStatus(unsigned long c_certStatus)
{
	m_certStatus = c_certStatus;
	return true;
}

unsigned long NewpkiUnsuspResponse::get_certStatus() const
{
	return m_certStatus;
}

bool NewpkiUnsuspResponse::set_errors(const mVector< ErrorEntry > & c_errors)
{
	m_errors = c_errors;
	return true;
}

const mVector< ErrorEntry > & NewpkiUnsuspResponse::get_errors() const
{
	return m_errors;
}

mVector< ErrorEntry > & NewpkiUnsuspResponse::get_errors()
{
	return m_errors;
}

bool NewpkiUnsuspResponse::set_id(unsigned long c_id)
{
	m_id = c_id;
	return true;
}

unsigned long NewpkiUnsuspResponse::get_id() const
{
	return m_id;
}

bool NewpkiUnsuspResponse::set_lastCrl(const PKI_CRL & c_lastCrl)
{
	m_lastCrl = c_lastCrl;
	return true;
}

const PKI_CRL & NewpkiUnsuspResponse::get_lastCrl() const
{
	return m_lastCrl;
}

PKI_CRL & NewpkiUnsuspResponse::get_lastCrl()
{
	return m_lastCrl;
}

bool NewpkiUnsuspResponse::set_status(unsigned long c_status)
{
	m_status = c_status;
	return true;
}

unsigned long NewpkiUnsuspResponse::get_status() const
{
	return m_status;
}

NewpkiUnsuspResponse::NewpkiUnsuspResponse():NewPKIObject()
{
	resetAll();
}

NewpkiUnsuspResponse::NewpkiUnsuspResponse(const NewpkiUnsuspResponse & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiUnsuspResponse::~NewpkiUnsuspResponse()
{
	Clear();
}

void NewpkiUnsuspResponse::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiUnsuspResponse::freeAll()
{
}

void NewpkiUnsuspResponse::resetAll()
{
	m_certStatus = 0;
	m_errors.clear();
	m_id = 0;
	m_lastCrl.Clear();
	m_status = 0;
}

bool NewpkiUnsuspResponse::load_Datas(const NEWPKI_UNSUSP_RESPONSE * Datas)
{
	Clear();
	int i;
	ERROR_ENTRY * currerrors;
	if(Datas->cert_status)
	{
		m_certStatus = ASN1_INTEGER_GET(Datas->cert_status);
	}
	if(Datas->errors)
	{
		for(i=0; i<SKM_sk_num(ERROR_ENTRY, Datas->errors); i++)
		{
			currerrors = SKM_sk_value(ERROR_ENTRY, Datas->errors, i);
			if(!currerrors)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_errors.insert(m_errors.begin() + i);
			if(!m_errors[i].load_Datas(currerrors))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->id)
	{
		m_id = ASN1_INTEGER_GET(Datas->id);
	}
	if(Datas->last_crl)
	{
		if(!m_lastCrl.load_Datas(Datas->last_crl))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->status)
	{
		m_status = ASN1_INTEGER_GET(Datas->status);
	}
	m_isOk=true;
	return true;
}

bool NewpkiUnsuspResponse::give_Datas(NEWPKI_UNSUSP_RESPONSE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_UNSUSP_RESPONSE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ERROR_ENTRY * currerrors;
	size_t i;
	if(!(*Datas)->cert_status && !((*Datas)->cert_status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->cert_status, m_certStatus) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->cert_status);
		(*Datas)->cert_status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->errors && !((*Datas)->errors = SKM_sk_new_null(ERROR_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_errors.size() ; i++)
	{
		currerrors = NULL;
		if(!m_errors[i].give_Datas(&currerrors))
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			currerrors = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ERROR_ENTRY, (*Datas)->errors, currerrors) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->id && !((*Datas)->id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->id, m_id) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->id);
		(*Datas)->id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(m_lastCrl)
	{
		if(!(*Datas)->last_crl && !((*Datas)->last_crl = (X509_CRL*)ASN1_item_new(ASN1_ITEM_rptr(X509_CRL))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_lastCrl.give_Datas(&(*Datas)->last_crl))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->last_crl)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->last_crl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->last_crl = NULL;
		}
	}
	if(!(*Datas)->status && !((*Datas)->status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->status, m_status) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->status);
		(*Datas)->status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiUnsuspResponse::operator=(const NewpkiUnsuspResponse & other)
{
	Clear();
	m_certStatus = other.m_certStatus;
	m_errors = other.m_errors;
	m_id = other.m_id;
	m_lastCrl = other.m_lastCrl;
	m_status = other.m_status;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiUnsuspResponse::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_UNSUSP_RESPONSE);
}
NewpkiPubResponse NewpkiPubResponse::EmptyInstance;
bool NewpkiPubResponse::set_errors(const mVector< ErrorEntry > & c_errors)
{
	m_errors = c_errors;
	return true;
}

const mVector< ErrorEntry > & NewpkiPubResponse::get_errors() const
{
	return m_errors;
}

mVector< ErrorEntry > & NewpkiPubResponse::get_errors()
{
	return m_errors;
}

bool NewpkiPubResponse::set_object(const mString & c_object)
{
	m_object = c_object;
	return true;
}

const mString & NewpkiPubResponse::get_object() const
{
	return m_object;
}

mString & NewpkiPubResponse::get_object()
{
	return m_object;
}

bool NewpkiPubResponse::set_status(unsigned long c_status)
{
	m_status = c_status;
	return true;
}

unsigned long NewpkiPubResponse::get_status() const
{
	return m_status;
}

bool NewpkiPubResponse::set_type(unsigned long c_type)
{
	m_type = c_type;
	return true;
}

unsigned long NewpkiPubResponse::get_type() const
{
	return m_type;
}

NewpkiPubResponse::NewpkiPubResponse():NewPKIObject()
{
	resetAll();
}

NewpkiPubResponse::NewpkiPubResponse(const NewpkiPubResponse & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiPubResponse::~NewpkiPubResponse()
{
	Clear();
}

void NewpkiPubResponse::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiPubResponse::freeAll()
{
}

void NewpkiPubResponse::resetAll()
{
	m_errors.clear();
	m_object = "";
	m_status = 0;
	m_type = 0;
}

bool NewpkiPubResponse::load_Datas(const NEWPKI_PUB_RESPONSE * Datas)
{
	Clear();
	int i;
	ERROR_ENTRY * currerrors;
	if(Datas->errors)
	{
		for(i=0; i<SKM_sk_num(ERROR_ENTRY, Datas->errors); i++)
		{
			currerrors = SKM_sk_value(ERROR_ENTRY, Datas->errors, i);
			if(!currerrors)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_errors.insert(m_errors.begin() + i);
			if(!m_errors[i].load_Datas(currerrors))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->object)
	{
		m_object = Datas->object;
	}
	if(Datas->status)
	{
		m_status = ASN1_INTEGER_GET(Datas->status);
	}
	if(Datas->type)
	{
		m_type = ASN1_INTEGER_GET(Datas->type);
	}
	m_isOk=true;
	return true;
}

bool NewpkiPubResponse::give_Datas(NEWPKI_PUB_RESPONSE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_PUB_RESPONSE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ERROR_ENTRY * currerrors;
	size_t i;
	if(!(*Datas)->errors && !((*Datas)->errors = SKM_sk_new_null(ERROR_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_errors.size() ; i++)
	{
		currerrors = NULL;
		if(!m_errors[i].give_Datas(&currerrors))
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			currerrors = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ERROR_ENTRY, (*Datas)->errors, currerrors) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->object && !((*Datas)->object = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_object.c_ASN1_UTF8STRING(&(*Datas)->object))
	{
		ASN1_UTF8STRING_free((*Datas)->object);
		(*Datas)->object = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->status && !((*Datas)->status = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->status, m_status) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->status);
		(*Datas)->status = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->type && !((*Datas)->type = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->type, m_type) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->type);
		(*Datas)->type = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiPubResponse::operator=(const NewpkiPubResponse & other)
{
	Clear();
	m_errors = other.m_errors;
	m_object = other.m_object;
	m_status = other.m_status;
	m_type = other.m_type;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiPubResponse::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_PUB_RESPONSE);
}
NewpkiEeValResponse NewpkiEeValResponse::EmptyInstance;
bool NewpkiEeValResponse::set_dn(const X509_NAME * c_dn)
{
	if(m_dn)
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)c_dn);
	if(!m_dn)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_NAME * NewpkiEeValResponse::get_dn() const
{
	if(!m_dn)
		((NewpkiEeValResponse*)this)->m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

X509_NAME * NewpkiEeValResponse::get_dn()
{
	if(!m_dn)
		m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

bool NewpkiEeValResponse::set_raId(unsigned long c_raId)
{
	m_raId = c_raId;
	return true;
}

unsigned long NewpkiEeValResponse::get_raId() const
{
	return m_raId;
}

NewpkiEeValResponse::NewpkiEeValResponse():NewPKIObject()
{
	resetAll();
}

NewpkiEeValResponse::NewpkiEeValResponse(const NewpkiEeValResponse & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeValResponse::~NewpkiEeValResponse()
{
	Clear();
}

void NewpkiEeValResponse::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeValResponse::freeAll()
{
	if(m_dn)
	{
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	}
}

void NewpkiEeValResponse::resetAll()
{
	m_dn = NULL;
	m_raId = 0;
}

bool NewpkiEeValResponse::load_Datas(const NEWPKI_EE_VAL_RESPONSE * Datas)
{
	Clear();
	if(Datas->dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), Datas->dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->ra_id)
	{
		m_raId = ASN1_INTEGER_GET(Datas->ra_id);
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeValResponse::give_Datas(NEWPKI_EE_VAL_RESPONSE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_VAL_RESPONSE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(m_dn)
	{
		if((*Datas)->dn)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->dn, ASN1_ITEM_rptr(X509_NAME));
		if(!((*Datas)->dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (ASN1_VALUE*)m_dn)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->dn)
		{
			(*Datas)->dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
			if(!(*Datas)->dn)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->ra_id && !((*Datas)->ra_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ra_id, m_raId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ra_id);
		(*Datas)->ra_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool NewpkiEeValResponse::operator=(const NewpkiEeValResponse & other)
{
	Clear();
	if(other.m_dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)other.m_dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_raId = other.m_raId;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeValResponse::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_VAL_RESPONSE);
}
NewpkiEeDnPublishResponse NewpkiEeDnPublishResponse::EmptyInstance;
bool NewpkiEeDnPublishResponse::set_errors(const mVector< ErrorEntry > & c_errors)
{
	m_errors = c_errors;
	return true;
}

const mVector< ErrorEntry > & NewpkiEeDnPublishResponse::get_errors() const
{
	return m_errors;
}

mVector< ErrorEntry > & NewpkiEeDnPublishResponse::get_errors()
{
	return m_errors;
}

NewpkiEeDnPublishResponse::NewpkiEeDnPublishResponse():NewPKIObject()
{
	resetAll();
}

NewpkiEeDnPublishResponse::NewpkiEeDnPublishResponse(const NewpkiEeDnPublishResponse & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeDnPublishResponse::~NewpkiEeDnPublishResponse()
{
	Clear();
}

void NewpkiEeDnPublishResponse::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeDnPublishResponse::freeAll()
{
}

void NewpkiEeDnPublishResponse::resetAll()
{
	m_errors.clear();
}

bool NewpkiEeDnPublishResponse::load_Datas(const NEWPKI_EE_DN_PUBLISH_RESPONSE * Datas)
{
	Clear();
	int i;
	ERROR_ENTRY * currerrors;
	if(Datas->errors)
	{
		for(i=0; i<SKM_sk_num(ERROR_ENTRY, Datas->errors); i++)
		{
			currerrors = SKM_sk_value(ERROR_ENTRY, Datas->errors, i);
			if(!currerrors)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_errors.insert(m_errors.begin() + i);
			if(!m_errors[i].load_Datas(currerrors))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeDnPublishResponse::give_Datas(NEWPKI_EE_DN_PUBLISH_RESPONSE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_DN_PUBLISH_RESPONSE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ERROR_ENTRY * currerrors;
	size_t i;
	if(!(*Datas)->errors && !((*Datas)->errors = SKM_sk_new_null(ERROR_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_errors.size() ; i++)
	{
		currerrors = NULL;
		if(!m_errors[i].give_Datas(&currerrors))
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			currerrors = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ERROR_ENTRY, (*Datas)->errors, currerrors) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool NewpkiEeDnPublishResponse::operator=(const NewpkiEeDnPublishResponse & other)
{
	Clear();
	m_errors = other.m_errors;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeDnPublishResponse::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_DN_PUBLISH_RESPONSE);
}
NewpkiEeDnRemoveResponse NewpkiEeDnRemoveResponse::EmptyInstance;
bool NewpkiEeDnRemoveResponse::set_errors(const mVector< ErrorEntry > & c_errors)
{
	m_errors = c_errors;
	return true;
}

const mVector< ErrorEntry > & NewpkiEeDnRemoveResponse::get_errors() const
{
	return m_errors;
}

mVector< ErrorEntry > & NewpkiEeDnRemoveResponse::get_errors()
{
	return m_errors;
}

NewpkiEeDnRemoveResponse::NewpkiEeDnRemoveResponse():NewPKIObject()
{
	resetAll();
}

NewpkiEeDnRemoveResponse::NewpkiEeDnRemoveResponse(const NewpkiEeDnRemoveResponse & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeDnRemoveResponse::~NewpkiEeDnRemoveResponse()
{
	Clear();
}

void NewpkiEeDnRemoveResponse::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeDnRemoveResponse::freeAll()
{
}

void NewpkiEeDnRemoveResponse::resetAll()
{
	m_errors.clear();
}

bool NewpkiEeDnRemoveResponse::load_Datas(const NEWPKI_EE_DN_REMOVE_RESPONSE * Datas)
{
	Clear();
	int i;
	ERROR_ENTRY * currerrors;
	if(Datas->errors)
	{
		for(i=0; i<SKM_sk_num(ERROR_ENTRY, Datas->errors); i++)
		{
			currerrors = SKM_sk_value(ERROR_ENTRY, Datas->errors, i);
			if(!currerrors)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_errors.insert(m_errors.begin() + i);
			if(!m_errors[i].load_Datas(currerrors))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeDnRemoveResponse::give_Datas(NEWPKI_EE_DN_REMOVE_RESPONSE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_DN_REMOVE_RESPONSE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ERROR_ENTRY * currerrors;
	size_t i;
	if(!(*Datas)->errors && !((*Datas)->errors = SKM_sk_new_null(ERROR_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_errors.size() ; i++)
	{
		currerrors = NULL;
		if(!m_errors[i].give_Datas(&currerrors))
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			currerrors = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ERROR_ENTRY, (*Datas)->errors, currerrors) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool NewpkiEeDnRemoveResponse::operator=(const NewpkiEeDnRemoveResponse & other)
{
	Clear();
	m_errors = other.m_errors;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeDnRemoveResponse::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_DN_REMOVE_RESPONSE);
}
NewpkiEeUpdateCertStatusResponse NewpkiEeUpdateCertStatusResponse::EmptyInstance;
bool NewpkiEeUpdateCertStatusResponse::set_errors(const mVector< ErrorEntry > & c_errors)
{
	m_errors = c_errors;
	return true;
}

const mVector< ErrorEntry > & NewpkiEeUpdateCertStatusResponse::get_errors() const
{
	return m_errors;
}

mVector< ErrorEntry > & NewpkiEeUpdateCertStatusResponse::get_errors()
{
	return m_errors;
}

NewpkiEeUpdateCertStatusResponse::NewpkiEeUpdateCertStatusResponse():NewPKIObject()
{
	resetAll();
}

NewpkiEeUpdateCertStatusResponse::NewpkiEeUpdateCertStatusResponse(const NewpkiEeUpdateCertStatusResponse & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeUpdateCertStatusResponse::~NewpkiEeUpdateCertStatusResponse()
{
	Clear();
}

void NewpkiEeUpdateCertStatusResponse::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeUpdateCertStatusResponse::freeAll()
{
}

void NewpkiEeUpdateCertStatusResponse::resetAll()
{
	m_errors.clear();
}

bool NewpkiEeUpdateCertStatusResponse::load_Datas(const NEWPKI_EE_UPDATE_CERT_STATUS_RESPONSE * Datas)
{
	Clear();
	int i;
	ERROR_ENTRY * currerrors;
	if(Datas->errors)
	{
		for(i=0; i<SKM_sk_num(ERROR_ENTRY, Datas->errors); i++)
		{
			currerrors = SKM_sk_value(ERROR_ENTRY, Datas->errors, i);
			if(!currerrors)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_errors.insert(m_errors.begin() + i);
			if(!m_errors[i].load_Datas(currerrors))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeUpdateCertStatusResponse::give_Datas(NEWPKI_EE_UPDATE_CERT_STATUS_RESPONSE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_UPDATE_CERT_STATUS_RESPONSE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ERROR_ENTRY * currerrors;
	size_t i;
	if(!(*Datas)->errors && !((*Datas)->errors = SKM_sk_new_null(ERROR_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_errors.size() ; i++)
	{
		currerrors = NULL;
		if(!m_errors[i].give_Datas(&currerrors))
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			currerrors = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ERROR_ENTRY, (*Datas)->errors, currerrors) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool NewpkiEeUpdateCertStatusResponse::operator=(const NewpkiEeUpdateCertStatusResponse & other)
{
	Clear();
	m_errors = other.m_errors;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeUpdateCertStatusResponse::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_UPDATE_CERT_STATUS_RESPONSE);
}
NewpkiEeCertPublishResponse NewpkiEeCertPublishResponse::EmptyInstance;
bool NewpkiEeCertPublishResponse::set_errors(const mVector< ErrorEntry > & c_errors)
{
	m_errors = c_errors;
	return true;
}

const mVector< ErrorEntry > & NewpkiEeCertPublishResponse::get_errors() const
{
	return m_errors;
}

mVector< ErrorEntry > & NewpkiEeCertPublishResponse::get_errors()
{
	return m_errors;
}

NewpkiEeCertPublishResponse::NewpkiEeCertPublishResponse():NewPKIObject()
{
	resetAll();
}

NewpkiEeCertPublishResponse::NewpkiEeCertPublishResponse(const NewpkiEeCertPublishResponse & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

NewpkiEeCertPublishResponse::~NewpkiEeCertPublishResponse()
{
	Clear();
}

void NewpkiEeCertPublishResponse::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiEeCertPublishResponse::freeAll()
{
}

void NewpkiEeCertPublishResponse::resetAll()
{
	m_errors.clear();
}

bool NewpkiEeCertPublishResponse::load_Datas(const NEWPKI_EE_CERT_PUBLISH_RESPONSE * Datas)
{
	Clear();
	int i;
	ERROR_ENTRY * currerrors;
	if(Datas->errors)
	{
		for(i=0; i<SKM_sk_num(ERROR_ENTRY, Datas->errors); i++)
		{
			currerrors = SKM_sk_value(ERROR_ENTRY, Datas->errors, i);
			if(!currerrors)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_errors.insert(m_errors.begin() + i);
			if(!m_errors[i].load_Datas(currerrors))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool NewpkiEeCertPublishResponse::give_Datas(NEWPKI_EE_CERT_PUBLISH_RESPONSE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_EE_CERT_PUBLISH_RESPONSE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ERROR_ENTRY * currerrors;
	size_t i;
	if(!(*Datas)->errors && !((*Datas)->errors = SKM_sk_new_null(ERROR_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_errors.size() ; i++)
	{
		currerrors = NULL;
		if(!m_errors[i].give_Datas(&currerrors))
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			currerrors = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ERROR_ENTRY, (*Datas)->errors, currerrors) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool NewpkiEeCertPublishResponse::operator=(const NewpkiEeCertPublishResponse & other)
{
	Clear();
	m_errors = other.m_errors;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiEeCertPublishResponse::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_EE_CERT_PUBLISH_RESPONSE);
}
NewpkiResponse NewpkiResponse::EmptyInstance;
bool NewpkiResponse::set_type(int c_type)
{
	Clear();
	m_type = c_type;
	if(!malloc_byType(m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

int NewpkiResponse::get_type() const
{
	 return m_type;
}

bool NewpkiResponse::set_certResponse(const NewpkiCertResponse & c_certResponse)
{
	if(m_type != 0)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_certResponse) = c_certResponse;
	m_isOk=true;
	return true;
}

const NewpkiCertResponse & NewpkiResponse::get_certResponse() const
{
	if((m_type != 0) || !m_certResponse)
	{
		return NewpkiCertResponse::EmptyInstance;
	}
	return (*m_certResponse);
}

NewpkiCertResponse & NewpkiResponse::get_certResponse()
{
	if((m_type != 0) || !m_certResponse)
	{
		return NewpkiCertResponse::EmptyInstance;
	}
	return (*m_certResponse);
}

bool NewpkiResponse::set_eeCertPublishResponse(const NewpkiEeCertPublishResponse & c_eeCertPublishResponse)
{
	if(m_type != 12)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeCertPublishResponse) = c_eeCertPublishResponse;
	m_isOk=true;
	return true;
}

const NewpkiEeCertPublishResponse & NewpkiResponse::get_eeCertPublishResponse() const
{
	if((m_type != 12) || !m_eeCertPublishResponse)
	{
		return NewpkiEeCertPublishResponse::EmptyInstance;
	}
	return (*m_eeCertPublishResponse);
}

NewpkiEeCertPublishResponse & NewpkiResponse::get_eeCertPublishResponse()
{
	if((m_type != 12) || !m_eeCertPublishResponse)
	{
		return NewpkiEeCertPublishResponse::EmptyInstance;
	}
	return (*m_eeCertPublishResponse);
}

bool NewpkiResponse::set_eeCertResponse(const NewpkiEeCertResponse & c_eeCertResponse)
{
	if(m_type != 7)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeCertResponse) = c_eeCertResponse;
	m_isOk=true;
	return true;
}

const NewpkiEeCertResponse & NewpkiResponse::get_eeCertResponse() const
{
	if((m_type != 7) || !m_eeCertResponse)
	{
		return NewpkiEeCertResponse::EmptyInstance;
	}
	return (*m_eeCertResponse);
}

NewpkiEeCertResponse & NewpkiResponse::get_eeCertResponse()
{
	if((m_type != 7) || !m_eeCertResponse)
	{
		return NewpkiEeCertResponse::EmptyInstance;
	}
	return (*m_eeCertResponse);
}

bool NewpkiResponse::set_eeDnPublishResponse(const NewpkiEeDnPublishResponse & c_eeDnPublishResponse)
{
	if(m_type != 5)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeDnPublishResponse) = c_eeDnPublishResponse;
	m_isOk=true;
	return true;
}

const NewpkiEeDnPublishResponse & NewpkiResponse::get_eeDnPublishResponse() const
{
	if((m_type != 5) || !m_eeDnPublishResponse)
	{
		return NewpkiEeDnPublishResponse::EmptyInstance;
	}
	return (*m_eeDnPublishResponse);
}

NewpkiEeDnPublishResponse & NewpkiResponse::get_eeDnPublishResponse()
{
	if((m_type != 5) || !m_eeDnPublishResponse)
	{
		return NewpkiEeDnPublishResponse::EmptyInstance;
	}
	return (*m_eeDnPublishResponse);
}

bool NewpkiResponse::set_eeDnRemoveResponse(const NewpkiEeDnRemoveResponse & c_eeDnRemoveResponse)
{
	if(m_type != 6)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeDnRemoveResponse) = c_eeDnRemoveResponse;
	m_isOk=true;
	return true;
}

const NewpkiEeDnRemoveResponse & NewpkiResponse::get_eeDnRemoveResponse() const
{
	if((m_type != 6) || !m_eeDnRemoveResponse)
	{
		return NewpkiEeDnRemoveResponse::EmptyInstance;
	}
	return (*m_eeDnRemoveResponse);
}

NewpkiEeDnRemoveResponse & NewpkiResponse::get_eeDnRemoveResponse()
{
	if((m_type != 6) || !m_eeDnRemoveResponse)
	{
		return NewpkiEeDnRemoveResponse::EmptyInstance;
	}
	return (*m_eeDnRemoveResponse);
}

bool NewpkiResponse::set_eeRevResponse(const NewpkiEeRevResponse & c_eeRevResponse)
{
	if(m_type != 10)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeRevResponse) = c_eeRevResponse;
	m_isOk=true;
	return true;
}

const NewpkiEeRevResponse & NewpkiResponse::get_eeRevResponse() const
{
	if((m_type != 10) || !m_eeRevResponse)
	{
		return NewpkiEeRevResponse::EmptyInstance;
	}
	return (*m_eeRevResponse);
}

NewpkiEeRevResponse & NewpkiResponse::get_eeRevResponse()
{
	if((m_type != 10) || !m_eeRevResponse)
	{
		return NewpkiEeRevResponse::EmptyInstance;
	}
	return (*m_eeRevResponse);
}

bool NewpkiResponse::set_eeUpdCertStatusResponse(const NewpkiEeUpdateCertStatusResponse & c_eeUpdCertStatusResponse)
{
	if(m_type != 11)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeUpdCertStatusResponse) = c_eeUpdCertStatusResponse;
	m_isOk=true;
	return true;
}

const NewpkiEeUpdateCertStatusResponse & NewpkiResponse::get_eeUpdCertStatusResponse() const
{
	if((m_type != 11) || !m_eeUpdCertStatusResponse)
	{
		return NewpkiEeUpdateCertStatusResponse::EmptyInstance;
	}
	return (*m_eeUpdCertStatusResponse);
}

NewpkiEeUpdateCertStatusResponse & NewpkiResponse::get_eeUpdCertStatusResponse()
{
	if((m_type != 11) || !m_eeUpdCertStatusResponse)
	{
		return NewpkiEeUpdateCertStatusResponse::EmptyInstance;
	}
	return (*m_eeUpdCertStatusResponse);
}

bool NewpkiResponse::set_eeValResponse(const NewpkiEeValResponse & c_eeValResponse)
{
	if(m_type != 4)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeValResponse) = c_eeValResponse;
	m_isOk=true;
	return true;
}

const NewpkiEeValResponse & NewpkiResponse::get_eeValResponse() const
{
	if((m_type != 4) || !m_eeValResponse)
	{
		return NewpkiEeValResponse::EmptyInstance;
	}
	return (*m_eeValResponse);
}

NewpkiEeValResponse & NewpkiResponse::get_eeValResponse()
{
	if((m_type != 4) || !m_eeValResponse)
	{
		return NewpkiEeValResponse::EmptyInstance;
	}
	return (*m_eeValResponse);
}

bool NewpkiResponse::set_errors(const mVector< ErrorEntry > & c_errors)
{
	if(m_type != 2)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_errors) = c_errors;
	m_isOk=true;
	return true;
}

const mVector< ErrorEntry > & NewpkiResponse::get_errors() const
{
	if((m_type != 2) || !m_errors)
	{
		return mVector< ErrorEntry >::EmptyInstance;
	}
	return (*m_errors);
}

mVector< ErrorEntry > & NewpkiResponse::get_errors()
{
	if((m_type != 2) || !m_errors)
	{
		return mVector< ErrorEntry >::EmptyInstance;
	}
	return (*m_errors);
}

bool NewpkiResponse::set_pubResponse(const NewpkiPubResponse & c_pubResponse)
{
	if(m_type != 3)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_pubResponse) = c_pubResponse;
	m_isOk=true;
	return true;
}

const NewpkiPubResponse & NewpkiResponse::get_pubResponse() const
{
	if((m_type != 3) || !m_pubResponse)
	{
		return NewpkiPubResponse::EmptyInstance;
	}
	return (*m_pubResponse);
}

NewpkiPubResponse & NewpkiResponse::get_pubResponse()
{
	if((m_type != 3) || !m_pubResponse)
	{
		return NewpkiPubResponse::EmptyInstance;
	}
	return (*m_pubResponse);
}

bool NewpkiResponse::set_revResponse(const NewpkiRevResponse & c_revResponse)
{
	if(m_type != 1)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_revResponse) = c_revResponse;
	m_isOk=true;
	return true;
}

const NewpkiRevResponse & NewpkiResponse::get_revResponse() const
{
	if((m_type != 1) || !m_revResponse)
	{
		return NewpkiRevResponse::EmptyInstance;
	}
	return (*m_revResponse);
}

NewpkiRevResponse & NewpkiResponse::get_revResponse()
{
	if((m_type != 1) || !m_revResponse)
	{
		return NewpkiRevResponse::EmptyInstance;
	}
	return (*m_revResponse);
}

bool NewpkiResponse::set_suspResponse(const NewpkiSuspResponse & c_suspResponse)
{
	if(m_type != 8)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_suspResponse) = c_suspResponse;
	m_isOk=true;
	return true;
}

const NewpkiSuspResponse & NewpkiResponse::get_suspResponse() const
{
	if((m_type != 8) || !m_suspResponse)
	{
		return NewpkiSuspResponse::EmptyInstance;
	}
	return (*m_suspResponse);
}

NewpkiSuspResponse & NewpkiResponse::get_suspResponse()
{
	if((m_type != 8) || !m_suspResponse)
	{
		return NewpkiSuspResponse::EmptyInstance;
	}
	return (*m_suspResponse);
}

bool NewpkiResponse::set_unsuspResponse(const NewpkiUnsuspResponse & c_unsuspResponse)
{
	if(m_type != 9)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_unsuspResponse) = c_unsuspResponse;
	m_isOk=true;
	return true;
}

const NewpkiUnsuspResponse & NewpkiResponse::get_unsuspResponse() const
{
	if((m_type != 9) || !m_unsuspResponse)
	{
		return NewpkiUnsuspResponse::EmptyInstance;
	}
	return (*m_unsuspResponse);
}

NewpkiUnsuspResponse & NewpkiResponse::get_unsuspResponse()
{
	if((m_type != 9) || !m_unsuspResponse)
	{
		return NewpkiUnsuspResponse::EmptyInstance;
	}
	return (*m_unsuspResponse);
}

bool NewpkiResponse::malloc_byType (int c_type)
{
	switch(m_type)
	{
		case 0:
			m_certResponse = new NewpkiCertResponse();
			if(!m_certResponse)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 12:
			m_eeCertPublishResponse = new NewpkiEeCertPublishResponse();
			if(!m_eeCertPublishResponse)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 7:
			m_eeCertResponse = new NewpkiEeCertResponse();
			if(!m_eeCertResponse)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 5:
			m_eeDnPublishResponse = new NewpkiEeDnPublishResponse();
			if(!m_eeDnPublishResponse)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 6:
			m_eeDnRemoveResponse = new NewpkiEeDnRemoveResponse();
			if(!m_eeDnRemoveResponse)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 10:
			m_eeRevResponse = new NewpkiEeRevResponse();
			if(!m_eeRevResponse)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 11:
			m_eeUpdCertStatusResponse = new NewpkiEeUpdateCertStatusResponse();
			if(!m_eeUpdCertStatusResponse)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 4:
			m_eeValResponse = new NewpkiEeValResponse();
			if(!m_eeValResponse)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 2:
			m_errors = new mVector< ErrorEntry >;
			if(!m_errors)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 3:
			m_pubResponse = new NewpkiPubResponse();
			if(!m_pubResponse)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 1:
			m_revResponse = new NewpkiRevResponse();
			if(!m_revResponse)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 8:
			m_suspResponse = new NewpkiSuspResponse();
			if(!m_suspResponse)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 9:
			m_unsuspResponse = new NewpkiUnsuspResponse();
			if(!m_unsuspResponse)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
	}

	return true;
}

bool NewpkiResponse::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	NEWPKI_RESPONSE * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool NewpkiResponse::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	NEWPKI_RESPONSE * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

NewpkiResponse::NewpkiResponse():NewPKIObject(), NewPKISignCryptObject()
{
	resetAll();
}

NewpkiResponse::NewpkiResponse(const NewpkiResponse & other):NewPKIObject(), NewPKISignCryptObject()
{
	resetAll();
	*this = other;
}

NewpkiResponse::~NewpkiResponse()
{
	Clear();
}

void NewpkiResponse::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void NewpkiResponse::freeAll()
{
	if(m_certResponse)
	{
		delete m_certResponse;
	}
	if(m_eeCertPublishResponse)
	{
		delete m_eeCertPublishResponse;
	}
	if(m_eeCertResponse)
	{
		delete m_eeCertResponse;
	}
	if(m_eeDnPublishResponse)
	{
		delete m_eeDnPublishResponse;
	}
	if(m_eeDnRemoveResponse)
	{
		delete m_eeDnRemoveResponse;
	}
	if(m_eeRevResponse)
	{
		delete m_eeRevResponse;
	}
	if(m_eeUpdCertStatusResponse)
	{
		delete m_eeUpdCertStatusResponse;
	}
	if(m_eeValResponse)
	{
		delete m_eeValResponse;
	}
	if(m_errors)
	{
		delete m_errors;
	}
	if(m_pubResponse)
	{
		delete m_pubResponse;
	}
	if(m_revResponse)
	{
		delete m_revResponse;
	}
	if(m_suspResponse)
	{
		delete m_suspResponse;
	}
	if(m_unsuspResponse)
	{
		delete m_unsuspResponse;
	}
}

void NewpkiResponse::resetAll()
{
	m_type = -1;
	m_certResponse = NULL;
	m_eeCertPublishResponse = NULL;
	m_eeCertResponse = NULL;
	m_eeDnPublishResponse = NULL;
	m_eeDnRemoveResponse = NULL;
	m_eeRevResponse = NULL;
	m_eeUpdCertStatusResponse = NULL;
	m_eeValResponse = NULL;
	m_errors = NULL;
	m_pubResponse = NULL;
	m_revResponse = NULL;
	m_suspResponse = NULL;
	m_unsuspResponse = NULL;
}

bool NewpkiResponse::load_Datas(const NEWPKI_RESPONSE * Datas)
{
	Clear();
	int i;
	ERROR_ENTRY * currerrors;
	if(!set_type(Datas->type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(Datas->type)
	{
		case 0:
			if(Datas->d.cert_response)
			{
				if(!(*m_certResponse).load_Datas(Datas->d.cert_response))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 12:
			if(Datas->d.ee_cert_publish_response)
			{
				if(!(*m_eeCertPublishResponse).load_Datas(Datas->d.ee_cert_publish_response))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 7:
			if(Datas->d.ee_cert_response)
			{
				if(!(*m_eeCertResponse).load_Datas(Datas->d.ee_cert_response))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 5:
			if(Datas->d.ee_dn_publish_response)
			{
				if(!(*m_eeDnPublishResponse).load_Datas(Datas->d.ee_dn_publish_response))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 6:
			if(Datas->d.ee_dn_remove_response)
			{
				if(!(*m_eeDnRemoveResponse).load_Datas(Datas->d.ee_dn_remove_response))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 10:
			if(Datas->d.ee_rev_response)
			{
				if(!(*m_eeRevResponse).load_Datas(Datas->d.ee_rev_response))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 11:
			if(Datas->d.ee_upd_cert_status_response)
			{
				if(!(*m_eeUpdCertStatusResponse).load_Datas(Datas->d.ee_upd_cert_status_response))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 4:
			if(Datas->d.ee_val_response)
			{
				if(!(*m_eeValResponse).load_Datas(Datas->d.ee_val_response))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 2:
			if(Datas->d.errors)
			{
				for(i=0; i<SKM_sk_num(ERROR_ENTRY, Datas->d.errors); i++)
				{
					currerrors = SKM_sk_value(ERROR_ENTRY, Datas->d.errors, i);
					if(!currerrors)
					{
						NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
						return false;
					}
					(*m_errors).insert((*m_errors).begin() + i);
					if(!(*m_errors)[i].load_Datas(currerrors))
					{
						NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
						return false;
					}
				}
			}
			break;
		case 3:
			if(Datas->d.pub_response)
			{
				if(!(*m_pubResponse).load_Datas(Datas->d.pub_response))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 1:
			if(Datas->d.rev_response)
			{
				if(!(*m_revResponse).load_Datas(Datas->d.rev_response))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 8:
			if(Datas->d.susp_response)
			{
				if(!(*m_suspResponse).load_Datas(Datas->d.susp_response))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 9:
			if(Datas->d.unsusp_response)
			{
				if(!(*m_unsuspResponse).load_Datas(Datas->d.unsusp_response))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}

bool NewpkiResponse::give_Datas(NEWPKI_RESPONSE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (NEWPKI_RESPONSE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
			ERROR_ENTRY * currerrors;
	size_t i;
	(*Datas)->type = m_type;
	switch(m_type)
	{
		case 0:
			if(!((*Datas)->d.cert_response = (NEWPKI_CERT_RESPONSE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_CERT_RESPONSE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_certResponse).give_Datas(&(*Datas)->d.cert_response))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.cert_response, ASN1_ITEM_rptr(NEWPKI_CERT_RESPONSE));
				(*Datas)->d.cert_response = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 12:
			if(!((*Datas)->d.ee_cert_publish_response = (NEWPKI_EE_CERT_PUBLISH_RESPONSE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_CERT_PUBLISH_RESPONSE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeCertPublishResponse).give_Datas(&(*Datas)->d.ee_cert_publish_response))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_cert_publish_response, ASN1_ITEM_rptr(NEWPKI_EE_CERT_PUBLISH_RESPONSE));
				(*Datas)->d.ee_cert_publish_response = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 7:
			if(!((*Datas)->d.ee_cert_response = (NEWPKI_EE_CERT_RESPONSE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_CERT_RESPONSE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeCertResponse).give_Datas(&(*Datas)->d.ee_cert_response))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_cert_response, ASN1_ITEM_rptr(NEWPKI_EE_CERT_RESPONSE));
				(*Datas)->d.ee_cert_response = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 5:
			if(!((*Datas)->d.ee_dn_publish_response = (NEWPKI_EE_DN_PUBLISH_RESPONSE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_DN_PUBLISH_RESPONSE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeDnPublishResponse).give_Datas(&(*Datas)->d.ee_dn_publish_response))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_dn_publish_response, ASN1_ITEM_rptr(NEWPKI_EE_DN_PUBLISH_RESPONSE));
				(*Datas)->d.ee_dn_publish_response = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 6:
			if(!((*Datas)->d.ee_dn_remove_response = (NEWPKI_EE_DN_REMOVE_RESPONSE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_DN_REMOVE_RESPONSE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeDnRemoveResponse).give_Datas(&(*Datas)->d.ee_dn_remove_response))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_dn_remove_response, ASN1_ITEM_rptr(NEWPKI_EE_DN_REMOVE_RESPONSE));
				(*Datas)->d.ee_dn_remove_response = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 10:
			if(!((*Datas)->d.ee_rev_response = (NEWPKI_EE_REV_RESPONSE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_REV_RESPONSE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeRevResponse).give_Datas(&(*Datas)->d.ee_rev_response))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_rev_response, ASN1_ITEM_rptr(NEWPKI_EE_REV_RESPONSE));
				(*Datas)->d.ee_rev_response = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 11:
			if(!((*Datas)->d.ee_upd_cert_status_response = (NEWPKI_EE_UPDATE_CERT_STATUS_RESPONSE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_UPDATE_CERT_STATUS_RESPONSE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeUpdCertStatusResponse).give_Datas(&(*Datas)->d.ee_upd_cert_status_response))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_upd_cert_status_response, ASN1_ITEM_rptr(NEWPKI_EE_UPDATE_CERT_STATUS_RESPONSE));
				(*Datas)->d.ee_upd_cert_status_response = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 4:
			if(!((*Datas)->d.ee_val_response = (NEWPKI_EE_VAL_RESPONSE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_VAL_RESPONSE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeValResponse).give_Datas(&(*Datas)->d.ee_val_response))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_val_response, ASN1_ITEM_rptr(NEWPKI_EE_VAL_RESPONSE));
				(*Datas)->d.ee_val_response = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 2:
			if(!((*Datas)->d.errors = SKM_sk_new_null(ERROR_ENTRY)))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			for(i = 0 ; i < (*m_errors).size() ; i++)
			{
				currerrors = NULL;
				if(!(*m_errors)[i].give_Datas(&currerrors))
				{
					ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
					currerrors = NULL;
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
				if(SKM_sk_push(ERROR_ENTRY, (*Datas)->d.errors, currerrors) < 0)
				{
					ASN1_item_free((ASN1_VALUE*)currerrors, ASN1_ITEM_rptr(ERROR_ENTRY));
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
					return false;
				}
			}
			break;
		case 3:
			if(!((*Datas)->d.pub_response = (NEWPKI_PUB_RESPONSE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_PUB_RESPONSE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_pubResponse).give_Datas(&(*Datas)->d.pub_response))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.pub_response, ASN1_ITEM_rptr(NEWPKI_PUB_RESPONSE));
				(*Datas)->d.pub_response = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 1:
			if(!((*Datas)->d.rev_response = (NEWPKI_REV_RESPONSE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_REV_RESPONSE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_revResponse).give_Datas(&(*Datas)->d.rev_response))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.rev_response, ASN1_ITEM_rptr(NEWPKI_REV_RESPONSE));
				(*Datas)->d.rev_response = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 8:
			if(!((*Datas)->d.susp_response = (NEWPKI_SUSP_RESPONSE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_SUSP_RESPONSE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_suspResponse).give_Datas(&(*Datas)->d.susp_response))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.susp_response, ASN1_ITEM_rptr(NEWPKI_SUSP_RESPONSE));
				(*Datas)->d.susp_response = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 9:
			if(!((*Datas)->d.unsusp_response = (NEWPKI_UNSUSP_RESPONSE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_UNSUSP_RESPONSE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_unsuspResponse).give_Datas(&(*Datas)->d.unsusp_response))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.unsusp_response, ASN1_ITEM_rptr(NEWPKI_UNSUSP_RESPONSE));
				(*Datas)->d.unsusp_response = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
	}
	return true;
}

bool NewpkiResponse::operator=(const NewpkiResponse & other)
{
	Clear();
	if(!set_type(other.m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(other.m_type)
	{
		case 0:
			if(!other.m_certResponse)
				break;
			(*m_certResponse) = *(other.m_certResponse);
			break;
		case 12:
			if(!other.m_eeCertPublishResponse)
				break;
			(*m_eeCertPublishResponse) = *(other.m_eeCertPublishResponse);
			break;
		case 7:
			if(!other.m_eeCertResponse)
				break;
			(*m_eeCertResponse) = *(other.m_eeCertResponse);
			break;
		case 5:
			if(!other.m_eeDnPublishResponse)
				break;
			(*m_eeDnPublishResponse) = *(other.m_eeDnPublishResponse);
			break;
		case 6:
			if(!other.m_eeDnRemoveResponse)
				break;
			(*m_eeDnRemoveResponse) = *(other.m_eeDnRemoveResponse);
			break;
		case 10:
			if(!other.m_eeRevResponse)
				break;
			(*m_eeRevResponse) = *(other.m_eeRevResponse);
			break;
		case 11:
			if(!other.m_eeUpdCertStatusResponse)
				break;
			(*m_eeUpdCertStatusResponse) = *(other.m_eeUpdCertStatusResponse);
			break;
		case 4:
			if(!other.m_eeValResponse)
				break;
			(*m_eeValResponse) = *(other.m_eeValResponse);
			break;
		case 2:
			if(!other.m_errors)
				break;
			(*m_errors) = *(other.m_errors);
			break;
		case 3:
			if(!other.m_pubResponse)
				break;
			(*m_pubResponse) = *(other.m_pubResponse);
			break;
		case 1:
			if(!other.m_revResponse)
				break;
			(*m_revResponse) = *(other.m_revResponse);
			break;
		case 8:
			if(!other.m_suspResponse)
				break;
			(*m_suspResponse) = *(other.m_suspResponse);
			break;
		case 9:
			if(!other.m_unsuspResponse)
				break;
			(*m_unsuspResponse) = *(other.m_unsuspResponse);
			break;
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * NewpkiResponse::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(NEWPKI_RESPONSE);
}
CryptedNewpkiResponse CryptedNewpkiResponse::EmptyInstance;
bool CryptedNewpkiResponse::set_response(const Asn1EncryptSign & c_response)
{
	m_response = c_response;
	return true;
}

const Asn1EncryptSign & CryptedNewpkiResponse::get_response() const
{
	return m_response;
}

Asn1EncryptSign & CryptedNewpkiResponse::get_response()
{
	return m_response;
}

bool CryptedNewpkiResponse::set_recipient(const X509_PUBKEY * c_recipient)
{
	if(m_recipient)
		ASN1_item_free((ASN1_VALUE*)m_recipient, ASN1_ITEM_rptr(X509_PUBKEY));
	m_recipient = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (void*)c_recipient);
	if(!m_recipient)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_PUBKEY * CryptedNewpkiResponse::get_recipient() const
{
	if(!m_recipient)
		((CryptedNewpkiResponse*)this)->m_recipient = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
	return m_recipient;
}

X509_PUBKEY * CryptedNewpkiResponse::get_recipient()
{
	if(!m_recipient)
		m_recipient = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
	return m_recipient;
}

bool CryptedNewpkiResponse::set_sender(const X509_PUBKEY * c_sender)
{
	if(m_sender)
		ASN1_item_free((ASN1_VALUE*)m_sender, ASN1_ITEM_rptr(X509_PUBKEY));
	m_sender = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (void*)c_sender);
	if(!m_sender)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_PUBKEY * CryptedNewpkiResponse::get_sender() const
{
	if(!m_sender)
		((CryptedNewpkiResponse*)this)->m_sender = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
	return m_sender;
}

X509_PUBKEY * CryptedNewpkiResponse::get_sender()
{
	if(!m_sender)
		m_sender = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
	return m_sender;
}

bool CryptedNewpkiResponse::set_transactionid(const Asn1OctetString & c_transactionid)
{
	m_transactionid = c_transactionid;
	return true;
}

const Asn1OctetString & CryptedNewpkiResponse::get_transactionid() const
{
	return m_transactionid;
}

Asn1OctetString & CryptedNewpkiResponse::get_transactionid()
{
	return m_transactionid;
}

bool CryptedNewpkiResponse::to_PEM(mString & PemDatas) const
{
	CRYPTED_NEWPKI_RESPONSE * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toPEM("CRYPTED NEWPKI RESPONSE", get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool CryptedNewpkiResponse::from_PEM(const mString & PemDatas)
{
	CRYPTED_NEWPKI_RESPONSE * c_localvar = NULL;
	if(!Private_fromPEM("CRYPTED NEWPKI RESPONSE", get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

CryptedNewpkiResponse::CryptedNewpkiResponse():NewPKIObject()
{
	resetAll();
}

CryptedNewpkiResponse::CryptedNewpkiResponse(const CryptedNewpkiResponse & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

CryptedNewpkiResponse::~CryptedNewpkiResponse()
{
	Clear();
}

void CryptedNewpkiResponse::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void CryptedNewpkiResponse::freeAll()
{
	if(m_recipient)
	{
		ASN1_item_free((ASN1_VALUE*)m_recipient, ASN1_ITEM_rptr(X509_PUBKEY));
	}
	if(m_sender)
	{
		ASN1_item_free((ASN1_VALUE*)m_sender, ASN1_ITEM_rptr(X509_PUBKEY));
	}
}

void CryptedNewpkiResponse::resetAll()
{
	m_response.Clear();
	m_recipient = NULL;
	m_sender = NULL;
	m_transactionid.Clear();
}

bool CryptedNewpkiResponse::load_Datas(const CRYPTED_NEWPKI_RESPONSE * Datas)
{
	Clear();
	if(Datas->c_response)
	{
		if(!m_response.load_Datas(Datas->c_response))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->recipient)
	{
		if(m_recipient)
			ASN1_item_free((ASN1_VALUE*)m_recipient, ASN1_ITEM_rptr(X509_PUBKEY));
		m_recipient = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), Datas->recipient);
		if(!m_recipient)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->sender)
	{
		if(m_sender)
			ASN1_item_free((ASN1_VALUE*)m_sender, ASN1_ITEM_rptr(X509_PUBKEY));
		m_sender = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), Datas->sender);
		if(!m_sender)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->transactionID)
	{
		if(!m_transactionid.load_Datas(Datas->transactionID))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool CryptedNewpkiResponse::give_Datas(CRYPTED_NEWPKI_RESPONSE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (CRYPTED_NEWPKI_RESPONSE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->c_response && !((*Datas)->c_response = (ASN1_ENCRYPT_SIGN*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_ENCRYPT_SIGN))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_response.give_Datas(&(*Datas)->c_response))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->c_response, ASN1_ITEM_rptr(ASN1_ENCRYPT_SIGN));
		(*Datas)->c_response = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(m_recipient)
	{
		if((*Datas)->recipient)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->recipient, ASN1_ITEM_rptr(X509_PUBKEY));
		if(!((*Datas)->recipient = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (ASN1_VALUE*)m_recipient)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->recipient)
		{
			(*Datas)->recipient = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
			if(!(*Datas)->recipient)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(m_sender)
	{
		if((*Datas)->sender)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->sender, ASN1_ITEM_rptr(X509_PUBKEY));
		if(!((*Datas)->sender = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (ASN1_VALUE*)m_sender)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->sender)
		{
			(*Datas)->sender = (X509_PUBKEY*)ASN1_item_new(ASN1_ITEM_rptr(X509_PUBKEY));
			if(!(*Datas)->sender)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->transactionID && !((*Datas)->transactionID = (ASN1_OCTET_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_OCTET_STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_transactionid.give_Datas(&(*Datas)->transactionID))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->transactionID, ASN1_ITEM_rptr(ASN1_OCTET_STRING));
		(*Datas)->transactionID = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool CryptedNewpkiResponse::operator=(const CryptedNewpkiResponse & other)
{
	Clear();
	m_response = other.m_response;
	if(other.m_recipient)
	{
		if(m_recipient)
			ASN1_item_free((ASN1_VALUE*)m_recipient, ASN1_ITEM_rptr(X509_PUBKEY));
		m_recipient = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (void*)other.m_recipient);
		if(!m_recipient)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(other.m_sender)
	{
		if(m_sender)
			ASN1_item_free((ASN1_VALUE*)m_sender, ASN1_ITEM_rptr(X509_PUBKEY));
		m_sender = (X509_PUBKEY*)ASN1_item_dup(ASN1_ITEM_rptr(X509_PUBKEY), (void*)other.m_sender);
		if(!m_sender)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_transactionid = other.m_transactionid;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * CryptedNewpkiResponse::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(CRYPTED_NEWPKI_RESPONSE);
}
CryptedNewpkiResponses CryptedNewpkiResponses::EmptyInstance;
bool CryptedNewpkiResponses::set_responses(const mVector< CryptedNewpkiResponse > & c_responses)
{
	m_responses = c_responses;
	return true;
}

const mVector< CryptedNewpkiResponse > & CryptedNewpkiResponses::get_responses() const
{
	return m_responses;
}

mVector< CryptedNewpkiResponse > & CryptedNewpkiResponses::get_responses()
{
	return m_responses;
}

CryptedNewpkiResponses::CryptedNewpkiResponses():NewPKIObject()
{
	resetAll();
}

CryptedNewpkiResponses::CryptedNewpkiResponses(const CryptedNewpkiResponses & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

CryptedNewpkiResponses::~CryptedNewpkiResponses()
{
	Clear();
}

void CryptedNewpkiResponses::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void CryptedNewpkiResponses::freeAll()
{
}

void CryptedNewpkiResponses::resetAll()
{
	m_responses.clear();
}

bool CryptedNewpkiResponses::load_Datas(const CRYPTED_NEWPKI_RESPONSES * Datas)
{
	Clear();
	int i;
	CRYPTED_NEWPKI_RESPONSE * currresponses;
	if(Datas->responses)
	{
		for(i=0; i<SKM_sk_num(CRYPTED_NEWPKI_RESPONSE, Datas->responses); i++)
		{
			currresponses = SKM_sk_value(CRYPTED_NEWPKI_RESPONSE, Datas->responses, i);
			if(!currresponses)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_responses.insert(m_responses.begin() + i);
			if(!m_responses[i].load_Datas(currresponses))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool CryptedNewpkiResponses::give_Datas(CRYPTED_NEWPKI_RESPONSES ** Datas) const
{
	if(!(*Datas) && !(*Datas = (CRYPTED_NEWPKI_RESPONSES*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	CRYPTED_NEWPKI_RESPONSE * currresponses;
	size_t i;
	if(!(*Datas)->responses && !((*Datas)->responses = SKM_sk_new_null(CRYPTED_NEWPKI_RESPONSE)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_responses.size() ; i++)
	{
		currresponses = NULL;
		if(!m_responses[i].give_Datas(&currresponses))
		{
			ASN1_item_free((ASN1_VALUE*)currresponses, ASN1_ITEM_rptr(CRYPTED_NEWPKI_RESPONSE));
			currresponses = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(CRYPTED_NEWPKI_RESPONSE, (*Datas)->responses, currresponses) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currresponses, ASN1_ITEM_rptr(CRYPTED_NEWPKI_RESPONSE));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool CryptedNewpkiResponses::operator=(const CryptedNewpkiResponses & other)
{
	Clear();
	m_responses = other.m_responses;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * CryptedNewpkiResponses::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(CRYPTED_NEWPKI_RESPONSES);
}
WaitingNewpkiObjectBody WaitingNewpkiObjectBody::EmptyInstance;
bool WaitingNewpkiObjectBody::set_type(int c_type)
{
	Clear();
	m_type = c_type;
	if(!malloc_byType(m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

int WaitingNewpkiObjectBody::get_type() const
{
	 return m_type;
}

bool WaitingNewpkiObjectBody::set_request(const CryptedNewpkiRequest & c_request)
{
	if(m_type != 0)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_request) = c_request;
	m_isOk=true;
	return true;
}

const CryptedNewpkiRequest & WaitingNewpkiObjectBody::get_request() const
{
	if((m_type != 0) || !m_request)
	{
		return CryptedNewpkiRequest::EmptyInstance;
	}
	return (*m_request);
}

CryptedNewpkiRequest & WaitingNewpkiObjectBody::get_request()
{
	if((m_type != 0) || !m_request)
	{
		return CryptedNewpkiRequest::EmptyInstance;
	}
	return (*m_request);
}

bool WaitingNewpkiObjectBody::set_response(const CryptedNewpkiResponse & c_response)
{
	if(m_type != 1)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_response) = c_response;
	m_isOk=true;
	return true;
}

const CryptedNewpkiResponse & WaitingNewpkiObjectBody::get_response() const
{
	if((m_type != 1) || !m_response)
	{
		return CryptedNewpkiResponse::EmptyInstance;
	}
	return (*m_response);
}

CryptedNewpkiResponse & WaitingNewpkiObjectBody::get_response()
{
	if((m_type != 1) || !m_response)
	{
		return CryptedNewpkiResponse::EmptyInstance;
	}
	return (*m_response);
}

bool WaitingNewpkiObjectBody::set_transactionid(const Asn1OctetString & c_transactionid)
{
	if(m_type != 2)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_transactionid) = c_transactionid;
	m_isOk=true;
	return true;
}

const Asn1OctetString & WaitingNewpkiObjectBody::get_transactionid() const
{
	if((m_type != 2) || !m_transactionid)
	{
		return Asn1OctetString::EmptyInstance;
	}
	return (*m_transactionid);
}

Asn1OctetString & WaitingNewpkiObjectBody::get_transactionid()
{
	if((m_type != 2) || !m_transactionid)
	{
		return Asn1OctetString::EmptyInstance;
	}
	return (*m_transactionid);
}

bool WaitingNewpkiObjectBody::malloc_byType (int c_type)
{
	switch(m_type)
	{
		case 0:
			m_request = new CryptedNewpkiRequest();
			if(!m_request)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 1:
			m_response = new CryptedNewpkiResponse();
			if(!m_response)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 2:
			m_transactionid = new Asn1OctetString();
			if(!m_transactionid)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
	}

	return true;
}

WaitingNewpkiObjectBody::WaitingNewpkiObjectBody():NewPKIObject()
{
	resetAll();
}

WaitingNewpkiObjectBody::WaitingNewpkiObjectBody(const WaitingNewpkiObjectBody & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

WaitingNewpkiObjectBody::~WaitingNewpkiObjectBody()
{
	Clear();
}

void WaitingNewpkiObjectBody::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void WaitingNewpkiObjectBody::freeAll()
{
	if(m_request)
	{
		delete m_request;
	}
	if(m_response)
	{
		delete m_response;
	}
	if(m_transactionid)
	{
		delete m_transactionid;
	}
}

void WaitingNewpkiObjectBody::resetAll()
{
	m_type = -1;
	m_request = NULL;
	m_response = NULL;
	m_transactionid = NULL;
}

bool WaitingNewpkiObjectBody::load_Datas(const WAITING_NEWPKI_OBJECT_BODY * Datas)
{
	Clear();
	if(!set_type(Datas->type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(Datas->type)
	{
		case 0:
			if(Datas->d.request)
			{
				if(!(*m_request).load_Datas(Datas->d.request))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 1:
			if(Datas->d.response)
			{
				if(!(*m_response).load_Datas(Datas->d.response))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 2:
			if(Datas->d.transactionID)
			{
				if(!(*m_transactionid).load_Datas(Datas->d.transactionID))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}

bool WaitingNewpkiObjectBody::give_Datas(WAITING_NEWPKI_OBJECT_BODY ** Datas) const
{
	if(!(*Datas) && !(*Datas = (WAITING_NEWPKI_OBJECT_BODY*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	(*Datas)->type = m_type;
	switch(m_type)
	{
		case 0:
			if(!((*Datas)->d.request = (CRYPTED_NEWPKI_REQUEST*)ASN1_item_new(ASN1_ITEM_rptr(CRYPTED_NEWPKI_REQUEST))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_request).give_Datas(&(*Datas)->d.request))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.request, ASN1_ITEM_rptr(CRYPTED_NEWPKI_REQUEST));
				(*Datas)->d.request = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 1:
			if(!((*Datas)->d.response = (CRYPTED_NEWPKI_RESPONSE*)ASN1_item_new(ASN1_ITEM_rptr(CRYPTED_NEWPKI_RESPONSE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_response).give_Datas(&(*Datas)->d.response))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.response, ASN1_ITEM_rptr(CRYPTED_NEWPKI_RESPONSE));
				(*Datas)->d.response = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 2:
			if(!((*Datas)->d.transactionID = (ASN1_OCTET_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_OCTET_STRING))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_transactionid).give_Datas(&(*Datas)->d.transactionID))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.transactionID, ASN1_ITEM_rptr(ASN1_OCTET_STRING));
				(*Datas)->d.transactionID = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
	}
	return true;
}

bool WaitingNewpkiObjectBody::operator=(const WaitingNewpkiObjectBody & other)
{
	Clear();
	if(!set_type(other.m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(other.m_type)
	{
		case 0:
			if(!other.m_request)
				break;
			(*m_request) = *(other.m_request);
			break;
		case 1:
			if(!other.m_response)
				break;
			(*m_response) = *(other.m_response);
			break;
		case 2:
			if(!other.m_transactionid)
				break;
			(*m_transactionid) = *(other.m_transactionid);
			break;
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * WaitingNewpkiObjectBody::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(WAITING_NEWPKI_OBJECT_BODY);
}
TransactionIds TransactionIds::EmptyInstance;
bool TransactionIds::set_transactionids(const mVector< Asn1OctetString > & c_transactionids)
{
	m_transactionids = c_transactionids;
	return true;
}

const mVector< Asn1OctetString > & TransactionIds::get_transactionids() const
{
	return m_transactionids;
}

mVector< Asn1OctetString > & TransactionIds::get_transactionids()
{
	return m_transactionids;
}

TransactionIds::TransactionIds():NewPKIObject()
{
	resetAll();
}

TransactionIds::TransactionIds(const TransactionIds & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

TransactionIds::~TransactionIds()
{
	Clear();
}

void TransactionIds::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void TransactionIds::freeAll()
{
}

void TransactionIds::resetAll()
{
	m_transactionids.clear();
}

bool TransactionIds::load_Datas(const TRANSACTION_IDS * Datas)
{
	Clear();
	int i;
	ASN1_OCTET_STRING * currtransactionids;
	if(Datas->transactionIds)
	{
		for(i=0; i<SKM_sk_num(ASN1_OCTET_STRING, Datas->transactionIds); i++)
		{
			currtransactionids = SKM_sk_value(ASN1_OCTET_STRING, Datas->transactionIds, i);
			if(!currtransactionids)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_transactionids.insert(m_transactionids.begin() + i);
			if(!m_transactionids[i].load_Datas(currtransactionids))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	m_isOk=true;
	return true;
}

bool TransactionIds::give_Datas(TRANSACTION_IDS ** Datas) const
{
	if(!(*Datas) && !(*Datas = (TRANSACTION_IDS*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ASN1_OCTET_STRING * currtransactionids;
	size_t i;
	if(!(*Datas)->transactionIds && !((*Datas)->transactionIds = SKM_sk_new_null(ASN1_OCTET_STRING)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_transactionids.size() ; i++)
	{
		currtransactionids = NULL;
		if(!m_transactionids[i].give_Datas(&currtransactionids))
		{
			ASN1_item_free((ASN1_VALUE*)currtransactionids, ASN1_ITEM_rptr(ASN1_OCTET_STRING));
			currtransactionids = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ASN1_OCTET_STRING, (*Datas)->transactionIds, currtransactionids) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currtransactionids, ASN1_ITEM_rptr(ASN1_OCTET_STRING));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	return true;
}

bool TransactionIds::operator=(const TransactionIds & other)
{
	Clear();
	m_transactionids = other.m_transactionids;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * TransactionIds::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(TRANSACTION_IDS);
}
WaitingNewpkiObject WaitingNewpkiObject::EmptyInstance;
bool WaitingNewpkiObject::set_object(const WaitingNewpkiObjectBody & c_object)
{
	m_object = c_object;
	return true;
}

const WaitingNewpkiObjectBody & WaitingNewpkiObject::get_object() const
{
	return m_object;
}

WaitingNewpkiObjectBody & WaitingNewpkiObject::get_object()
{
	return m_object;
}

bool WaitingNewpkiObject::set_repPath(const STACK_OF(X509_PUBKEY) * c_repPath)
{
	if(!m_repPath)
	{
		m_repPath = sk_new_null();
		if(!m_repPath)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(!STACK_cpy(ASN1_ITEM_rptr(X509_PUBKEY), c_repPath, m_repPath))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const STACK_OF(X509_PUBKEY) * WaitingNewpkiObject::get_repPath() const
{
	if(!m_repPath)
		((WaitingNewpkiObject*)this)->m_repPath = SKM_sk_new_null(X509_PUBKEY);
	return m_repPath;
}

STACK_OF(X509_PUBKEY) * WaitingNewpkiObject::get_repPath()
{
	if(!m_repPath)
		m_repPath = SKM_sk_new_null(X509_PUBKEY);
	return m_repPath;
}

bool WaitingNewpkiObject::to_PEM(mString & PemDatas) const
{
	WAITING_NEWPKI_OBJECT * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toPEM("NEWPKI WAITING OBJECT", get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool WaitingNewpkiObject::from_PEM(const mString & PemDatas)
{
	WAITING_NEWPKI_OBJECT * c_localvar = NULL;
	if(!Private_fromPEM("NEWPKI WAITING OBJECT", get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

WaitingNewpkiObject::WaitingNewpkiObject():NewPKIObject()
{
	resetAll();
}

WaitingNewpkiObject::WaitingNewpkiObject(const WaitingNewpkiObject & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

WaitingNewpkiObject::~WaitingNewpkiObject()
{
	Clear();
}

void WaitingNewpkiObject::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void WaitingNewpkiObject::freeAll()
{
	if(m_repPath)
	{
		STACK_free(ASN1_ITEM_rptr(X509_PUBKEY), m_repPath);
	}
}

void WaitingNewpkiObject::resetAll()
{
	m_object.Clear();
	m_repPath = NULL;
}

bool WaitingNewpkiObject::load_Datas(const WAITING_NEWPKI_OBJECT * Datas)
{
	Clear();
	if(Datas->object)
	{
		if(!m_object.load_Datas(Datas->object))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->rep_path)
	{
		if(m_repPath)
			STACK_free(ASN1_ITEM_rptr(X509_PUBKEY), m_repPath);
		m_repPath = STACK_dup(ASN1_ITEM_rptr(X509_PUBKEY), Datas->rep_path);
		if(!m_repPath)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool WaitingNewpkiObject::give_Datas(WAITING_NEWPKI_OBJECT ** Datas) const
{
	if(!(*Datas) && !(*Datas = (WAITING_NEWPKI_OBJECT*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->object && !((*Datas)->object = (WAITING_NEWPKI_OBJECT_BODY*)ASN1_item_new(ASN1_ITEM_rptr(WAITING_NEWPKI_OBJECT_BODY))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_object.give_Datas(&(*Datas)->object))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->object, ASN1_ITEM_rptr(WAITING_NEWPKI_OBJECT_BODY));
		(*Datas)->object = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(m_repPath)
	{
		if((*Datas)->rep_path)
			STACK_free(ASN1_ITEM_rptr(X509_PUBKEY), (*Datas)->rep_path);
		if(!((*Datas)->rep_path = STACK_dup(ASN1_ITEM_rptr(X509_PUBKEY), m_repPath)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->rep_path)
		{
			(*Datas)->rep_path = SKM_sk_new_null(X509_PUBKEY);
			if(!(*Datas)->rep_path)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	return true;
}

bool WaitingNewpkiObject::operator=(const WaitingNewpkiObject & other)
{
	Clear();
	m_object = other.m_object;
	if(other.m_repPath)
	{
		if(!m_repPath && !(m_repPath = SKM_sk_new_null(X509_PUBKEY)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!STACK_cpy(ASN1_ITEM_rptr(X509_PUBKEY), other.m_repPath, m_repPath))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * WaitingNewpkiObject::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(WAITING_NEWPKI_OBJECT);
}
ObjectsListSynchro ObjectsListSynchro::EmptyInstance;
bool ObjectsListSynchro::set_deleteResponses(const TransactionIds & c_deleteResponses)
{
	m_deleteResponses = c_deleteResponses;
	return true;
}

const TransactionIds & ObjectsListSynchro::get_deleteResponses() const
{
	return m_deleteResponses;
}

TransactionIds & ObjectsListSynchro::get_deleteResponses()
{
	return m_deleteResponses;
}

bool ObjectsListSynchro::set_knownRequests(const TransactionIds & c_knownRequests)
{
	m_knownRequests = c_knownRequests;
	return true;
}

const TransactionIds & ObjectsListSynchro::get_knownRequests() const
{
	return m_knownRequests;
}

TransactionIds & ObjectsListSynchro::get_knownRequests()
{
	return m_knownRequests;
}

bool ObjectsListSynchro::set_knownResponses(const TransactionIds & c_knownResponses)
{
	m_knownResponses = c_knownResponses;
	return true;
}

const TransactionIds & ObjectsListSynchro::get_knownResponses() const
{
	return m_knownResponses;
}

TransactionIds & ObjectsListSynchro::get_knownResponses()
{
	return m_knownResponses;
}

bool ObjectsListSynchro::set_objects(const mVector< WaitingNewpkiObject > & c_objects)
{
	m_objects = c_objects;
	return true;
}

const mVector< WaitingNewpkiObject > & ObjectsListSynchro::get_objects() const
{
	return m_objects;
}

mVector< WaitingNewpkiObject > & ObjectsListSynchro::get_objects()
{
	return m_objects;
}

bool ObjectsListSynchro::set_wantRequests(const TransactionIds & c_wantRequests)
{
	m_wantRequests = c_wantRequests;
	return true;
}

const TransactionIds & ObjectsListSynchro::get_wantRequests() const
{
	return m_wantRequests;
}

TransactionIds & ObjectsListSynchro::get_wantRequests()
{
	return m_wantRequests;
}

bool ObjectsListSynchro::set_wantResponses(const TransactionIds & c_wantResponses)
{
	m_wantResponses = c_wantResponses;
	return true;
}

const TransactionIds & ObjectsListSynchro::get_wantResponses() const
{
	return m_wantResponses;
}

TransactionIds & ObjectsListSynchro::get_wantResponses()
{
	return m_wantResponses;
}

ObjectsListSynchro::ObjectsListSynchro():NewPKIObject()
{
	resetAll();
}

ObjectsListSynchro::ObjectsListSynchro(const ObjectsListSynchro & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

ObjectsListSynchro::~ObjectsListSynchro()
{
	Clear();
}

void ObjectsListSynchro::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void ObjectsListSynchro::freeAll()
{
}

void ObjectsListSynchro::resetAll()
{
	m_deleteResponses.Clear();
	m_knownRequests.Clear();
	m_knownResponses.Clear();
	m_objects.clear();
	m_wantRequests.Clear();
	m_wantResponses.Clear();
}

bool ObjectsListSynchro::load_Datas(const OBJECTS_LIST_SYNCHRO * Datas)
{
	Clear();
	int i;
	WAITING_NEWPKI_OBJECT * currobjects;
	if(Datas->delete_responses)
	{
		if(!m_deleteResponses.load_Datas(Datas->delete_responses))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->known_requests)
	{
		if(!m_knownRequests.load_Datas(Datas->known_requests))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->known_responses)
	{
		if(!m_knownResponses.load_Datas(Datas->known_responses))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->objects)
	{
		for(i=0; i<SKM_sk_num(WAITING_NEWPKI_OBJECT, Datas->objects); i++)
		{
			currobjects = SKM_sk_value(WAITING_NEWPKI_OBJECT, Datas->objects, i);
			if(!currobjects)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_objects.insert(m_objects.begin() + i);
			if(!m_objects[i].load_Datas(currobjects))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->want_requests)
	{
		if(!m_wantRequests.load_Datas(Datas->want_requests))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->want_responses)
	{
		if(!m_wantResponses.load_Datas(Datas->want_responses))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool ObjectsListSynchro::give_Datas(OBJECTS_LIST_SYNCHRO ** Datas) const
{
	if(!(*Datas) && !(*Datas = (OBJECTS_LIST_SYNCHRO*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	WAITING_NEWPKI_OBJECT * currobjects;
	size_t i;
	if(!(*Datas)->delete_responses && !((*Datas)->delete_responses = (TRANSACTION_IDS*)ASN1_item_new(ASN1_ITEM_rptr(TRANSACTION_IDS))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_deleteResponses.give_Datas(&(*Datas)->delete_responses))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->delete_responses, ASN1_ITEM_rptr(TRANSACTION_IDS));
		(*Datas)->delete_responses = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->known_requests && !((*Datas)->known_requests = (TRANSACTION_IDS*)ASN1_item_new(ASN1_ITEM_rptr(TRANSACTION_IDS))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_knownRequests.give_Datas(&(*Datas)->known_requests))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->known_requests, ASN1_ITEM_rptr(TRANSACTION_IDS));
		(*Datas)->known_requests = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->known_responses && !((*Datas)->known_responses = (TRANSACTION_IDS*)ASN1_item_new(ASN1_ITEM_rptr(TRANSACTION_IDS))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_knownResponses.give_Datas(&(*Datas)->known_responses))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->known_responses, ASN1_ITEM_rptr(TRANSACTION_IDS));
		(*Datas)->known_responses = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->objects && !((*Datas)->objects = SKM_sk_new_null(WAITING_NEWPKI_OBJECT)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_objects.size() ; i++)
	{
		currobjects = NULL;
		if(!m_objects[i].give_Datas(&currobjects))
		{
			ASN1_item_free((ASN1_VALUE*)currobjects, ASN1_ITEM_rptr(WAITING_NEWPKI_OBJECT));
			currobjects = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(WAITING_NEWPKI_OBJECT, (*Datas)->objects, currobjects) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)currobjects, ASN1_ITEM_rptr(WAITING_NEWPKI_OBJECT));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->want_requests && !((*Datas)->want_requests = (TRANSACTION_IDS*)ASN1_item_new(ASN1_ITEM_rptr(TRANSACTION_IDS))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_wantRequests.give_Datas(&(*Datas)->want_requests))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->want_requests, ASN1_ITEM_rptr(TRANSACTION_IDS));
		(*Datas)->want_requests = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->want_responses && !((*Datas)->want_responses = (TRANSACTION_IDS*)ASN1_item_new(ASN1_ITEM_rptr(TRANSACTION_IDS))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_wantResponses.give_Datas(&(*Datas)->want_responses))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->want_responses, ASN1_ITEM_rptr(TRANSACTION_IDS));
		(*Datas)->want_responses = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool ObjectsListSynchro::operator=(const ObjectsListSynchro & other)
{
	Clear();
	m_deleteResponses = other.m_deleteResponses;
	m_knownRequests = other.m_knownRequests;
	m_knownResponses = other.m_knownResponses;
	m_objects = other.m_objects;
	m_wantRequests = other.m_wantRequests;
	m_wantResponses = other.m_wantResponses;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * ObjectsListSynchro::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(OBJECTS_LIST_SYNCHRO);
}
InternalCaKey InternalCaKey::EmptyInstance;
bool InternalCaKey::set_type(int c_type)
{
	Clear();
	m_type = c_type;
	if(!malloc_byType(m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

int InternalCaKey::get_type() const
{
	 return m_type;
}

bool InternalCaKey::set_keyid(const mString & c_keyid)
{
	if(m_type != 1)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_keyid) = c_keyid;
	m_isOk=true;
	return true;
}

const mString & InternalCaKey::get_keyid() const
{
	if((m_type != 1) || !m_keyid)
	{
		return mString::EmptyInstance;
	}
	return (*m_keyid);
}

mString & InternalCaKey::get_keyid()
{
	if((m_type != 1) || !m_keyid)
	{
		return mString::EmptyInstance;
	}
	return (*m_keyid);
}

bool InternalCaKey::set_privkey(const RSA * c_privkey)
{
	if(m_type != 0)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	if(m_privkey)
		ASN1_item_free((ASN1_VALUE*)m_privkey, ASN1_ITEM_rptr(RSAPrivateKey));
	m_privkey = (RSA*)ASN1_item_dup(ASN1_ITEM_rptr(RSAPrivateKey), (void*)c_privkey);
	if(!m_privkey)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	m_isOk=true;
	return true;
}

const RSA * InternalCaKey::get_privkey() const
{
	if((m_type != 0) || !m_privkey)
	{
		return NULL;
	}
	if(!m_privkey)
		((InternalCaKey*)this)->m_privkey = (RSA*)ASN1_item_new(ASN1_ITEM_rptr(RSAPrivateKey));
	return m_privkey;
}

RSA * InternalCaKey::get_privkey()
{
	if((m_type != 0) || !m_privkey)
	{
		return NULL;
	}
	if(!m_privkey)
		m_privkey = (RSA*)ASN1_item_new(ASN1_ITEM_rptr(RSAPrivateKey));
	return m_privkey;
}

bool InternalCaKey::malloc_byType (int c_type)
{
	switch(m_type)
	{
		case 1:
			m_keyid = new mString();
			if(!m_keyid)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 0:
			m_privkey = (RSA*)ASN1_item_new(ASN1_ITEM_rptr(RSAPrivateKey));
			if(!m_privkey)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
	}

	return true;
}

InternalCaKey::InternalCaKey():NewPKIObject()
{
	resetAll();
}

InternalCaKey::InternalCaKey(const InternalCaKey & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

InternalCaKey::~InternalCaKey()
{
	Clear();
}

void InternalCaKey::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void InternalCaKey::freeAll()
{
	if(m_keyid)
	{
		delete m_keyid;
	}
	if(m_privkey)
	{
		ASN1_item_free((ASN1_VALUE*)m_privkey, ASN1_ITEM_rptr(RSAPrivateKey));
	}
}

void InternalCaKey::resetAll()
{
	m_type = -1;
	m_keyid = NULL;
	m_privkey = NULL;
}

bool InternalCaKey::load_Datas(const INTERNAL_CA_KEY * Datas)
{
	Clear();
	if(!set_type(Datas->type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(Datas->type)
	{
		case 1:
			if(Datas->d.keyid)
			{
				(*m_keyid) = Datas->d.keyid;
			}
			break;
		case 0:
			if(Datas->d.privkey)
			{
				if(m_privkey)
					ASN1_item_free((ASN1_VALUE*)m_privkey, ASN1_ITEM_rptr(RSAPrivateKey));
				m_privkey = (RSA*)ASN1_item_dup(ASN1_ITEM_rptr(RSAPrivateKey), Datas->d.privkey);
				if(!m_privkey)
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}

bool InternalCaKey::give_Datas(INTERNAL_CA_KEY ** Datas) const
{
	if(!(*Datas) && !(*Datas = (INTERNAL_CA_KEY*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	(*Datas)->type = m_type;
	switch(m_type)
	{
		case 1:
			if(!((*Datas)->d.keyid = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_keyid).c_ASN1_UTF8STRING(&(*Datas)->d.keyid))
			{
				ASN1_UTF8STRING_free((*Datas)->d.keyid);
				(*Datas)->d.keyid = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 0:
			if(m_privkey)
			{
				if((*Datas)->d.privkey)
					ASN1_item_free((ASN1_VALUE*)(*Datas)->d.privkey, ASN1_ITEM_rptr(RSAPrivateKey));
				if(!((*Datas)->d.privkey = (RSA*)ASN1_item_dup(ASN1_ITEM_rptr(RSAPrivateKey), (ASN1_VALUE*)m_privkey)))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
					return false;
				}
			}
			else
			{
				if(!(*Datas)->d.privkey)
				{
					(*Datas)->d.privkey = (RSA*)ASN1_item_new(ASN1_ITEM_rptr(RSAPrivateKey));
					if(!(*Datas)->d.privkey)
					{
						NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
						return false;
					}
				}
			}
			break;
	}
	return true;
}

bool InternalCaKey::operator=(const InternalCaKey & other)
{
	Clear();
	if(!set_type(other.m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(other.m_type)
	{
		case 1:
			if(!other.m_keyid)
				break;
			(*m_keyid) = *(other.m_keyid);
			break;
		case 0:
			if(other.m_privkey)
			{
				if(m_privkey)
					ASN1_item_free((ASN1_VALUE*)m_privkey, ASN1_ITEM_rptr(RSAPrivateKey));
				m_privkey = (RSA*)ASN1_item_dup(ASN1_ITEM_rptr(RSAPrivateKey), (void*)other.m_privkey);
				if(!m_privkey)
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * InternalCaKey::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(INTERNAL_CA_KEY);
}
InternalCa InternalCa::EmptyInstance;
bool InternalCa::set_caCert(const PKI_CERT & c_caCert)
{
	m_caCert = c_caCert;
	return true;
}

const PKI_CERT & InternalCa::get_caCert() const
{
	return m_caCert;
}

PKI_CERT & InternalCa::get_caCert()
{
	return m_caCert;
}

bool InternalCa::set_caKey(const InternalCaKey & c_caKey)
{
	m_caKey = c_caKey;
	return true;
}

const InternalCaKey & InternalCa::get_caKey() const
{
	return m_caKey;
}

InternalCaKey & InternalCa::get_caKey()
{
	return m_caKey;
}

bool InternalCa::set_cryptedBody(const Asn1EncryptSign & c_cryptedBody)
{
	m_cryptedBody = c_cryptedBody;
	return true;
}

const Asn1EncryptSign & InternalCa::get_cryptedBody() const
{
	return m_cryptedBody;
}

Asn1EncryptSign & InternalCa::get_cryptedBody()
{
	return m_cryptedBody;
}

bool InternalCa::to_PEM(mString & PemDatas) const
{
	INTERNAL_CA * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toPEM("NEWPKI INTERNAL CA", get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool InternalCa::from_PEM(const mString & PemDatas)
{
	INTERNAL_CA * c_localvar = NULL;
	if(!Private_fromPEM("NEWPKI INTERNAL CA", get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

InternalCa::InternalCa():NewPKIObject()
{
	resetAll();
}

InternalCa::InternalCa(const InternalCa & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

InternalCa::~InternalCa()
{
	Clear();
}

void InternalCa::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void InternalCa::freeAll()
{
}

void InternalCa::resetAll()
{
	m_caCert.Clear();
	m_caKey.Clear();
	m_cryptedBody.Clear();
}

bool InternalCa::load_Datas(const INTERNAL_CA * Datas)
{
	Clear();
	if(Datas->ca_cert)
	{
		if(!m_caCert.load_Datas(Datas->ca_cert))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->ca_key)
	{
		if(!m_caKey.load_Datas(Datas->ca_key))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->crypted_body)
	{
		if(!m_cryptedBody.load_Datas(Datas->crypted_body))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool InternalCa::give_Datas(INTERNAL_CA ** Datas) const
{
	if(!(*Datas) && !(*Datas = (INTERNAL_CA*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->ca_cert && !((*Datas)->ca_cert = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_caCert.give_Datas(&(*Datas)->ca_cert))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->ca_cert, ASN1_ITEM_rptr(X509));
		(*Datas)->ca_cert = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->ca_key && !((*Datas)->ca_key = (INTERNAL_CA_KEY*)ASN1_item_new(ASN1_ITEM_rptr(INTERNAL_CA_KEY))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_caKey.give_Datas(&(*Datas)->ca_key))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->ca_key, ASN1_ITEM_rptr(INTERNAL_CA_KEY));
		(*Datas)->ca_key = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->crypted_body && !((*Datas)->crypted_body = (ASN1_ENCRYPT_SIGN*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_ENCRYPT_SIGN))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_cryptedBody.give_Datas(&(*Datas)->crypted_body))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->crypted_body, ASN1_ITEM_rptr(ASN1_ENCRYPT_SIGN));
		(*Datas)->crypted_body = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool InternalCa::operator=(const InternalCa & other)
{
	Clear();
	m_caCert = other.m_caCert;
	m_caKey = other.m_caKey;
	m_cryptedBody = other.m_cryptedBody;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * InternalCa::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(INTERNAL_CA);
}
#include "Asn1Conf.h"

bool ValidateRequestConstraints(int entityType, int reqType, const NewpkiRequestCertBody & request, int minpwdlen, int minkeylen, const ASN1_BIT_STRING * confFlags)
{
	bool vpwd;
	int keylen;
	int flagsP10;
	int flagsP12;
	int flagsSC;
	PKI_CSR	req;
	mString ttDatas;

	switch(entityType)
	{
		case ENTITY_TYPE_EE:
			flagsP10 = EE_ALLOW_PKCS10_IMPORT;
			flagsP12 = EE_ALLOW_SERVER_SIDE_KEY_GEN;
			flagsSC = EE_ALLOW_SC_KEY_GEN;
			vpwd = false;
			break;
		case ENTITY_TYPE_RA:
			flagsP10 = RA_ALLOW_PKCS10_IMPORT;
			flagsP12 = RA_ALLOW_SERVER_SIDE_KEY_GEN;
			flagsSC = RA_ALLOW_OP_SC_KEY_GEN;
			// If the RA is supposed to generate the PKCS#12 password we don't
			// do a length verification
			if(ASN1_BIT_STRING_get_bit((ASN1_BIT_STRING*)confFlags, REQUEST_CERT_FLAG_RA_GENERATE_P12_PASSWD))
				vpwd = false;
			else
				vpwd = true;
			break;
		default:
			NEWPKIerr(PKI_ERROR_TXT, ERROR_BAD_DATAS);
			return false;
			break;
	}
	switch(reqType)
	{
		case NEWPKI_PROFILE_CERT_TYPE_PKCS10:
			if(request.get_type() != REQUEST_CERT_BODY_PKCS10)
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_BAD_DATAS);
				return false;
			}
			if(!ASN1_BIT_STRING_get_bit((ASN1_BIT_STRING*)confFlags, flagsP10))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_NOT_ALLOWED);
				return false;
			}
			keylen = request.get_pkcs10().GetKeyLen();
			break;
		case NEWPKI_PROFILE_CERT_TYPE_PKCS12:
			if(request.get_type() != REQUEST_CERT_BODY_PKCS12)
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_BAD_DATAS);
				return false;
			}
			if(!ASN1_BIT_STRING_get_bit((ASN1_BIT_STRING*)confFlags, flagsP12))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_NOT_ALLOWED);
				return false;
			}

			//Let's verify the password length
			if(vpwd && (int)request.get_p12Privdatas().get_passwd().size() < minpwdlen)
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_BAD_PASSWORD_LEN);
				ttDatas.sprintf("%ld", minpwdlen);
				ERR_add_error_data(1, ttDatas.c_str());
				return false;
			}
			keylen = request.get_p12Privdatas().get_keylen();
			break;
		case NEWPKI_PROFILE_CERT_TYPE_SC:
			if(request.get_type() != REQUEST_CERT_BODY_PKCS10)
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_BAD_DATAS);
				return false;
			}
			if(!ASN1_BIT_STRING_get_bit((ASN1_BIT_STRING*)confFlags, flagsSC))
			{
				NEWPKIerr(PKI_ERROR_TXT, ERROR_NOT_ALLOWED);
				return false;
			}
			keylen = request.get_pkcs10().GetKeyLen();
			break;
		default:
			NEWPKIerr(PKI_ERROR_TXT, ERROR_BAD_DATAS);
			return false;
	}
	//Let's verify the key length
	if(keylen < minkeylen)
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_BAD_KEY_LEN);
		ttDatas.sprintf("%ld", minkeylen);
		ERR_add_error_data(1, ttDatas.c_str());
		return false;
	}
	return true;
}

