/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "Asn1Req.h"
#include <PKI_ERR.h>
#include <openssl/asn1t.h>

ASN1_SEQUENCE(WEBUSER_CHANGE_PASSWD) = {
	ASN1_SIMPLE(WEBUSER_CHANGE_PASSWD, user_id, ASN1_INTEGER),
	ASN1_SIMPLE(WEBUSER_CHANGE_PASSWD, old_password, ASN1_UTF8STRING),
	ASN1_SIMPLE(WEBUSER_CHANGE_PASSWD, password, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(WEBUSER_CHANGE_PASSWD)
ASN1_SEQUENCE(CA_P12_IMPORT) = {
	ASN1_SIMPLE(CA_P12_IMPORT, p12, PKCS12),
	ASN1_SIMPLE(CA_P12_IMPORT, password, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(CA_P12_IMPORT)
ASN1_SEQUENCE(DN_VALIDATION) = {
	ASN1_SIMPLE(DN_VALIDATION, id, ASN1_UTF8STRING),
	ASN1_SIMPLE(DN_VALIDATION, dn, X509_NAME),
}ASN1_SEQUENCE_END(DN_VALIDATION)
ASN1_SEQUENCE(ADMIN_REQ_LOGIN) = {
	ASN1_SIMPLE(ADMIN_REQ_LOGIN, entity, ASN1_UTF8STRING),
	ASN1_SIMPLE(ADMIN_REQ_LOGIN, username, ASN1_UTF8STRING),
	ASN1_SIMPLE(ADMIN_REQ_LOGIN, password, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(ADMIN_REQ_LOGIN)
ASN1_SEQUENCE(WEB_REQ_LOGIN) = {
	ASN1_SIMPLE(WEB_REQ_LOGIN, email, ASN1_UTF8STRING),
	ASN1_SIMPLE(WEB_REQ_LOGIN, password, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(WEB_REQ_LOGIN)
ASN1_SEQUENCE(WEB_REQ_CREATE) = {
	ASN1_SIMPLE(WEB_REQ_CREATE, email, ASN1_UTF8STRING),
	ASN1_SIMPLE(WEB_REQ_CREATE, password, ASN1_UTF8STRING),
	ASN1_SIMPLE(WEB_REQ_CREATE, dn, X509_NAME),
}ASN1_SEQUENCE_END(WEB_REQ_CREATE)
ASN1_SEQUENCE(S_ENTITY_MAIL_CONF) = {
	ASN1_SIMPLE(S_ENTITY_MAIL_CONF, entity_cert, X509),
	ASN1_SIMPLE(S_ENTITY_MAIL_CONF, mail_conf, EMAIL_CONF),
}ASN1_SEQUENCE_END(S_ENTITY_MAIL_CONF)
ASN1_SEQUENCE(S_ENTITY_ACL) = {
	ASN1_SIMPLE(S_ENTITY_ACL, entity_cert, X509),
	ASN1_SEQUENCE_OF(S_ENTITY_ACL, acl_entries, ACL_ENTRY),
}ASN1_SEQUENCE_END(S_ENTITY_ACL)
ASN1_SEQUENCE(S_ENTITY_CONF) = {
	ASN1_SIMPLE(S_ENTITY_CONF, entity_cert, X509),
	ASN1_SIMPLE(S_ENTITY_CONF, conf, ENTITY_CONF_BODY),
}ASN1_SEQUENCE_END(S_ENTITY_CONF)
ASN1_SEQUENCE(MAIL_DATAS) = {
	ASN1_SIMPLE(MAIL_DATAS, Subject, ASN1_UTF8STRING),
	ASN1_SIMPLE(MAIL_DATAS, Body, ASN1_UTF8STRING),
	ASN1_SIMPLE(MAIL_DATAS, SignMail, ASN1_INTEGER),
	ASN1_SIMPLE(MAIL_DATAS, Attach, ASN1_OCTET_STRING),
	ASN1_SIMPLE(MAIL_DATAS, AttachName, ASN1_UTF8STRING),
	ASN1_SIMPLE(MAIL_DATAS, AttachType, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(MAIL_DATAS)
ASN1_SEQUENCE(S_ENTITY_AUDITS) = {
	ASN1_SIMPLE(S_ENTITY_AUDITS, entity_cert, X509),
	ASN1_SEQUENCE_OF(S_ENTITY_AUDITS, audits, ENTITY_AUDIT_ENTRY),
}ASN1_SEQUENCE_END(S_ENTITY_AUDITS)
ASN1_SEQUENCE(OBJECTS_ENUM) = {
	ASN1_SIMPLE(OBJECTS_ENUM, state, ASN1_INTEGER),
	ASN1_SIMPLE(OBJECTS_ENUM, index, ASN1_INTEGER),
	ASN1_SIMPLE(OBJECTS_ENUM, num, ASN1_INTEGER),
	ASN1_SIMPLE(OBJECTS_ENUM, filter, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(OBJECTS_ENUM)
ASN1_SEQUENCE(SIGN_CSR) = {
	ASN1_SIMPLE(SIGN_CSR, days, ASN1_INTEGER),
	ASN1_SIMPLE(SIGN_CSR, request, X509_REQ),
	ASN1_SIMPLE(SIGN_CSR, uid, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(SIGN_CSR)
ASN1_SEQUENCE(S_RENAME_GROUP) = {
	ASN1_SIMPLE(S_RENAME_GROUP, id, ASN1_INTEGER),
	ASN1_SIMPLE(S_RENAME_GROUP, name, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(S_RENAME_GROUP)
ASN1_SEQUENCE(PROFILE_CHANGE_UID) = {
	ASN1_SIMPLE(PROFILE_CHANGE_UID, profile_id, ASN1_INTEGER),
	ASN1_SIMPLE(PROFILE_CHANGE_UID, ldap_uid, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(PROFILE_CHANGE_UID)
ASN1_SEQUENCE(PROFILE_CHANGE_OWNER) = {
	ASN1_SIMPLE(PROFILE_CHANGE_OWNER, profile_id, ASN1_INTEGER),
	ASN1_SIMPLE(PROFILE_CHANGE_OWNER, owner_group_serial, ASN1_INTEGER),
}ASN1_SEQUENCE_END(PROFILE_CHANGE_OWNER)
ASN1_SEQUENCE(PROFILE_CHANGE_DN) = {
	ASN1_SIMPLE(PROFILE_CHANGE_DN, profile_id, ASN1_INTEGER),
	ASN1_SIMPLE(PROFILE_CHANGE_DN, dn, X509_NAME),
}ASN1_SEQUENCE_END(PROFILE_CHANGE_DN)
ASN1_SEQUENCE(PROFILE_REJECT) = {
	ASN1_SIMPLE(PROFILE_REJECT, profile_id, ASN1_INTEGER),
	ASN1_SIMPLE(PROFILE_REJECT, reason, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(PROFILE_REJECT)
ASN1_SEQUENCE(WEBUSER_REVOKE_CERT) = {
	ASN1_SIMPLE(WEBUSER_REVOKE_CERT, user_id, ASN1_INTEGER),
	ASN1_SIMPLE(WEBUSER_REVOKE_CERT, cert_id, ASN1_INTEGER),
}ASN1_SEQUENCE_END(WEBUSER_REVOKE_CERT)
ASN1_CHOICE(ADMIN_REQUEST_BODY) = {
	ASN1_EXP(ADMIN_REQUEST_BODY, d.login, ADMIN_REQ_LOGIN, ADMIN_REQ_TYPE_LOGIN),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.cre_entity, ENTITY_CREATION_REQ, ADMIN_REQ_TYPE_CREATE_ENTITY),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.entity_name, ASN1_UTF8STRING, ADMIN_REQ_TYPE_DELETE_ENTITY),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_ENUM_ENTITIES),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.cre_user, USER_INFO, ADMIN_REQ_TYPE_CREATE_USER),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_ENUM_USERS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.upd_user, USER_ENTRY, ADMIN_REQ_TYPE_UPDATE_USER),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.enum_logs, ADMIN_REQ_ENUM_LOGS, ADMIN_REQ_TYPE_ENUM_LOGS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.chg_user_pwd, CHANGE_USER_PASSWD, ADMIN_REQ_TYPE_CHG_USER_PASSWD),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.chg_pwd, CHANGE_PASSWD, ADMIN_REQ_TYPE_CHG_PASSWD),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.sign_entity, ENTITY_SIGNATURE_REQ, ADMIN_REQ_TYPE_SIGN_ENTITY),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.create_pki_user, CREATE_PKI_USER_REQUEST, ADMIN_REQ_TYPE_CREATE_PKI_USER),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.serial, ASN1_INTEGER, ADMIN_REQ_TYPE_REVOKE_USER),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.serial, ASN1_INTEGER, ADMIN_REQ_TYPE_REVOKE_ENTITY),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.conf, EXPORTED_PKI_CONF, ADMIN_REQ_TYPE_PUSH_CONFIG),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.offline, ASN1_INTEGER, ADMIN_REQ_TYPE_SET_OFFLINE),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_GET_OFFLINE),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_GET_MY_ACL),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_GET_CONFIG),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_GET_MY_CONFIG),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.init_entity, ENTITY_INIT_REQ, ADMIN_REQ_TYPE_INIT_ENTITY),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.entity_cert, X509, ADMIN_REQ_TYPE_GET_ENTITY_CONF),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_GET_REPOSITORIES),
	ASN1_EXP_SEQUENCE_OF(ADMIN_REQUEST_BODY, d.repositories, REP_ENTRY_INFO, ADMIN_REQ_TYPE_SET_REPOSITORIES),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_GET_LOGS_TYPE),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.resource_name, ASN1_UTF8STRING, ADMIN_REQ_TYPE_LOCK_RESOURCE),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.resource_name, ASN1_UTF8STRING, ADMIN_REQ_TYPE_UNLOCK_RESOURCE),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.entity_cert, X509, ADMIN_REQ_TYPE_GET_ENTITY_ACL),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.entity_cert, X509, ADMIN_REQ_TYPE_GET_ENTITY_MAIL_CONF),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.entity_acl, S_ENTITY_ACL, ADMIN_REQ_TYPE_SET_ENTITY_ACL),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.entity_mail_conf, S_ENTITY_MAIL_CONF, ADMIN_REQ_TYPE_SET_ENTITY_MAIL_CONF),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.entity_conf, S_ENTITY_CONF, ADMIN_REQ_TYPE_SET_ENTITY_CONF),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.admin_mail, MAIL_DATAS, ADMIN_REQ_TYPE_SEND_ADMIN_MAIL),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.entity_cert, X509, ADMIN_REQ_TYPE_GET_ENTITY_AUDITS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.entity_audits, S_ENTITY_AUDITS, ADMIN_REQ_TYPE_SET_ENTITY_AUDITS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.entity_type, ASN1_INTEGER, ADMIN_REQ_TYPE_GET_ENTITY_LOGS_TYPE),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_GET_ENTITIES_LINKS),
	ASN1_EXP_SEQUENCE_OF(ADMIN_REQUEST_BODY, d.entities_links, ENTITY_LINKS, ADMIN_REQ_TYPE_SET_ENTITIES_LINKS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.waiting_obj, WAITING_NEWPKI_OBJECT, ADMIN_REQ_TYPE_PUSH_NEWPKI_OBJECTS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.create_root_ca, REQ_CREATE_ROOT_CA, ADMIN_REQ_TYPE_CREATE_ROOT_CA),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_GET_CA_STATUS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.transactions_ids, TRANSACTION_IDS, ADMIN_REQ_TYPE_GET_MY_REQS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.enum_objects, OBJECTS_ENUM, ADMIN_REQ_TYPE_ENUM_CERTS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.enum_objects, OBJECTS_ENUM, ADMIN_REQ_TYPE_ENUM_CRLS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.sign_csr, SIGN_CSR, ADMIN_REQ_TYPE_SIGN_CSR),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.create_child_ca, REQ_CREATE_CHILD_CA, ADMIN_REQ_TYPE_CREATE_CHILD_CA),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.p7b, PKCS7, ADMIN_REQ_TYPE_IMPORT_CHILD_CA_CERT),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.serial, ASN1_INTEGER, ADMIN_REQ_TYPE_REVOKE_CERT),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_GET_GROUPS),
	ASN1_EXP_SEQUENCE_OF(ADMIN_REQUEST_BODY, d.groups, USERS_GROUP, ADMIN_REQ_TYPE_SET_GROUPS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.group_name, ASN1_UTF8STRING, ADMIN_REQ_TYPE_ADD_GROUP),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.group_id, ASN1_INTEGER, ADMIN_REQ_TYPE_DEL_GROUP),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.rename_group, S_RENAME_GROUP, ADMIN_REQ_TYPE_REN_GROUP),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_CHECK_LOGS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.profile, NEWPKI_PROFILE, ADMIN_REQ_TYPE_IMPORT_PROFILE),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_GET_LOCAL_CONF),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.new_req, CRYPTED_NEWPKI_REQUEST, ADMIN_REQ_TYPE_PUSH_REQ),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.new_resp, CRYPTED_NEWPKI_RESPONSE, ADMIN_REQ_TYPE_PUSH_RESP),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.transactions_ids, TRANSACTION_IDS, ADMIN_REQ_TYPE_GET_MY_RESPS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.enum_objects, OBJECTS_ENUM, ADMIN_REQ_TYPE_ENUM_PROFILES),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.cert_request, NEWPKI_REQUEST_CERT, ADMIN_REQ_TYPE_REQUEST_CERT),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_GENERATE_CRL),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.known_objects, OBJECTS_LIST_SYNCHRO, ADMIN_REQ_TYPE_SYNCH_OBJECTS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.other, ASN1_NULL, ADMIN_REQ_TYPE_GET_CA_P7B),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.serial, ASN1_INTEGER, ADMIN_REQ_TYPE_DELETE_PKCS12),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.enum_logs, ADMIN_REQ_ENUM_LOGS, ADMIN_REQ_TYPE_GET_LOGS_COUNT),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.ldap_search, ASN1_UTF8STRING, ADMIN_REQ_TYPE_SEARCH_LDAP),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.transaction_id, ASN1_OCTET_STRING, ADMIN_REQ_TYPE_DELETE_RESPONSE),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.profile_uid, PROFILE_CHANGE_UID, ADMIN_REQ_TYPE_CHANGE_PROFILE_UID),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.profile_owner, PROFILE_CHANGE_OWNER, ADMIN_REQ_TYPE_CHANGE_PROFILE_OWNER),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.profile_id, ASN1_INTEGER, ADMIN_REQ_TYPE_DELETE_PROFILE),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.profile_dn, PROFILE_CHANGE_DN, ADMIN_REQ_TYPE_CHANGE_PROFILE_DN),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.entity_name, ASN1_UTF8STRING, ADMIN_REQ_TYPE_LOAD_ENTITY),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.entity_name, ASN1_UTF8STRING, ADMIN_REQ_TYPE_UNLOAD_ENTITY),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.request_id, ASN1_INTEGER, ADMIN_REQ_TYPE_DELETE_REQUEST),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.p12_import, CA_P12_IMPORT, ADMIN_REQ_TYPE_IMPORT_CA_P12),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.dn_val, DN_VALIDATION, ADMIN_REQ_TYPE_DN_VALIDATION),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.dn_id, ASN1_UTF8STRING, ADMIN_REQ_TYPE_GET_DN_VALIDATION),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.webcreate, WEB_REQ_CREATE, ADMIN_REQ_TYPE_WEBUSER_CREATE),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.weblogin, WEB_REQ_LOGIN, ADMIN_REQ_TYPE_WEBUSER_LOGIN),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.webactivate, ASN1_UTF8STRING, ADMIN_REQ_TYPE_WEBUSER_ACTIVATE),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.profile_id, ASN1_INTEGER, ADMIN_REQ_TYPE_ACCEPT_PROFILE),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.reject_profile, PROFILE_REJECT, ADMIN_REQ_TYPE_REJECT_PROFILE),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.ee_cert_request, NEWPKI_EE_REQUEST_CERT, ADMIN_REQ_TYPE_EE_REQUEST_CERT),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.profile_id, ASN1_INTEGER, ADMIN_REQ_TYPE_WEBUSER_ENUM_CERTS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.serial, ASN1_INTEGER, ADMIN_REQ_TYPE_SUSPEND_CERT),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.serial, ASN1_INTEGER, ADMIN_REQ_TYPE_UNSUSPEND_CERT),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.profile_id, ASN1_INTEGER, ADMIN_REQ_TYPE_WEBUSER_GET_DN),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.ee_cert_revoke, WEBUSER_REVOKE_CERT, ADMIN_REQ_TYPE_EE_REVOKE_CERT),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.enum_objects, OBJECTS_ENUM, ADMIN_REQ_TYPE_ENUM_EE_USERS),
	ASN1_EXP(ADMIN_REQUEST_BODY, d.web_chg_passwd, WEBUSER_CHANGE_PASSWD, ADMIN_REQ_TYPE_WEBUSER_CHANGE_PASSWD),
} ASN1_CHOICE_END(ADMIN_REQUEST_BODY)
ASN1_SEQUENCE(ADMIN_REQUEST) = {
	ASN1_SIMPLE(ADMIN_REQUEST, body, ADMIN_REQUEST_BODY),
}ASN1_SEQUENCE_END(ADMIN_REQUEST)
WebuserChangePasswd WebuserChangePasswd::EmptyInstance;
bool WebuserChangePasswd::set_oldPassword(const mString & c_oldPassword)
{
	m_oldPassword = c_oldPassword;
	return true;
}

const mString & WebuserChangePasswd::get_oldPassword() const
{
	return m_oldPassword;
}

mString & WebuserChangePasswd::get_oldPassword()
{
	return m_oldPassword;
}

bool WebuserChangePasswd::set_password(const mString & c_password)
{
	m_password = c_password;
	return true;
}

const mString & WebuserChangePasswd::get_password() const
{
	return m_password;
}

mString & WebuserChangePasswd::get_password()
{
	return m_password;
}

bool WebuserChangePasswd::set_userId(unsigned long c_userId)
{
	m_userId = c_userId;
	return true;
}

unsigned long WebuserChangePasswd::get_userId() const
{
	return m_userId;
}

WebuserChangePasswd::WebuserChangePasswd():NewPKIObject()
{
	resetAll();
}

WebuserChangePasswd::WebuserChangePasswd(const WebuserChangePasswd & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

WebuserChangePasswd::~WebuserChangePasswd()
{
	Clear();
}

void WebuserChangePasswd::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void WebuserChangePasswd::freeAll()
{
}

void WebuserChangePasswd::resetAll()
{
	m_oldPassword = "";
	m_password = "";
	m_userId = 0;
}

bool WebuserChangePasswd::load_Datas(const WEBUSER_CHANGE_PASSWD * Datas)
{
	Clear();
	if(Datas->old_password)
	{
		m_oldPassword = Datas->old_password;
	}
	if(Datas->password)
	{
		m_password = Datas->password;
	}
	if(Datas->user_id)
	{
		m_userId = ASN1_INTEGER_GET(Datas->user_id);
	}
	m_isOk=true;
	return true;
}

bool WebuserChangePasswd::give_Datas(WEBUSER_CHANGE_PASSWD ** Datas) const
{
	if(!(*Datas) && !(*Datas = (WEBUSER_CHANGE_PASSWD*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->old_password && !((*Datas)->old_password = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_oldPassword.c_ASN1_UTF8STRING(&(*Datas)->old_password))
	{
		ASN1_UTF8STRING_free((*Datas)->old_password);
		(*Datas)->old_password = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->password && !((*Datas)->password = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_password.c_ASN1_UTF8STRING(&(*Datas)->password))
	{
		ASN1_UTF8STRING_free((*Datas)->password);
		(*Datas)->password = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->user_id && !((*Datas)->user_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->user_id, m_userId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->user_id);
		(*Datas)->user_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool WebuserChangePasswd::operator=(const WebuserChangePasswd & other)
{
	Clear();
	m_oldPassword = other.m_oldPassword;
	m_password = other.m_password;
	m_userId = other.m_userId;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * WebuserChangePasswd::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(WEBUSER_CHANGE_PASSWD);
}
CaP12Import CaP12Import::EmptyInstance;
bool CaP12Import::set_p12(const PKI_PKCS12 & c_p12)
{
	m_p12 = c_p12;
	return true;
}

const PKI_PKCS12 & CaP12Import::get_p12() const
{
	return m_p12;
}

PKI_PKCS12 & CaP12Import::get_p12()
{
	return m_p12;
}

bool CaP12Import::set_password(const mString & c_password)
{
	m_password = c_password;
	return true;
}

const mString & CaP12Import::get_password() const
{
	return m_password;
}

mString & CaP12Import::get_password()
{
	return m_password;
}

CaP12Import::CaP12Import():NewPKIObject()
{
	resetAll();
}

CaP12Import::CaP12Import(const CaP12Import & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

CaP12Import::~CaP12Import()
{
	Clear();
}

void CaP12Import::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void CaP12Import::freeAll()
{
}

void CaP12Import::resetAll()
{
	m_p12.Clear();
	m_password = "";
}

bool CaP12Import::load_Datas(const CA_P12_IMPORT * Datas)
{
	Clear();
	if(Datas->p12)
	{
		if(!m_p12.load_Datas(Datas->p12))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->password)
	{
		m_password = Datas->password;
	}
	m_isOk=true;
	return true;
}

bool CaP12Import::give_Datas(CA_P12_IMPORT ** Datas) const
{
	if(!(*Datas) && !(*Datas = (CA_P12_IMPORT*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->p12 && !((*Datas)->p12 = (PKCS12*)ASN1_item_new(ASN1_ITEM_rptr(PKCS12))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_p12.give_Datas(&(*Datas)->p12))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->p12, ASN1_ITEM_rptr(PKCS12));
		(*Datas)->p12 = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->password && !((*Datas)->password = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_password.c_ASN1_UTF8STRING(&(*Datas)->password))
	{
		ASN1_UTF8STRING_free((*Datas)->password);
		(*Datas)->password = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool CaP12Import::operator=(const CaP12Import & other)
{
	Clear();
	m_p12 = other.m_p12;
	m_password = other.m_password;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * CaP12Import::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(CA_P12_IMPORT);
}
DnValidation DnValidation::EmptyInstance;
bool DnValidation::set_dn(const X509_NAME * c_dn)
{
	if(m_dn)
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)c_dn);
	if(!m_dn)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_NAME * DnValidation::get_dn() const
{
	if(!m_dn)
		((DnValidation*)this)->m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

X509_NAME * DnValidation::get_dn()
{
	if(!m_dn)
		m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

bool DnValidation::set_id(const mString & c_id)
{
	m_id = c_id;
	return true;
}

const mString & DnValidation::get_id() const
{
	return m_id;
}

mString & DnValidation::get_id()
{
	return m_id;
}

DnValidation::DnValidation():NewPKIObject()
{
	resetAll();
}

DnValidation::DnValidation(const DnValidation & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

DnValidation::~DnValidation()
{
	Clear();
}

void DnValidation::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void DnValidation::freeAll()
{
	if(m_dn)
	{
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	}
}

void DnValidation::resetAll()
{
	m_dn = NULL;
	m_id = "";
}

bool DnValidation::load_Datas(const DN_VALIDATION * Datas)
{
	Clear();
	if(Datas->dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), Datas->dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->id)
	{
		m_id = Datas->id;
	}
	m_isOk=true;
	return true;
}

bool DnValidation::give_Datas(DN_VALIDATION ** Datas) const
{
	if(!(*Datas) && !(*Datas = (DN_VALIDATION*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(m_dn)
	{
		if((*Datas)->dn)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->dn, ASN1_ITEM_rptr(X509_NAME));
		if(!((*Datas)->dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (ASN1_VALUE*)m_dn)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->dn)
		{
			(*Datas)->dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
			if(!(*Datas)->dn)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->id && !((*Datas)->id = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_id.c_ASN1_UTF8STRING(&(*Datas)->id))
	{
		ASN1_UTF8STRING_free((*Datas)->id);
		(*Datas)->id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool DnValidation::operator=(const DnValidation & other)
{
	Clear();
	if(other.m_dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)other.m_dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_id = other.m_id;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * DnValidation::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(DN_VALIDATION);
}
AdminReqLogin AdminReqLogin::EmptyInstance;
bool AdminReqLogin::set_entity(const mString & c_entity)
{
	m_entity = c_entity;
	return true;
}

const mString & AdminReqLogin::get_entity() const
{
	return m_entity;
}

mString & AdminReqLogin::get_entity()
{
	return m_entity;
}

bool AdminReqLogin::set_password(const mString & c_password)
{
	m_password = c_password;
	return true;
}

const mString & AdminReqLogin::get_password() const
{
	return m_password;
}

mString & AdminReqLogin::get_password()
{
	return m_password;
}

bool AdminReqLogin::set_username(const mString & c_username)
{
	m_username = c_username;
	return true;
}

const mString & AdminReqLogin::get_username() const
{
	return m_username;
}

mString & AdminReqLogin::get_username()
{
	return m_username;
}

AdminReqLogin::AdminReqLogin():NewPKIObject()
{
	resetAll();
}

AdminReqLogin::AdminReqLogin(const AdminReqLogin & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

AdminReqLogin::~AdminReqLogin()
{
	Clear();
}

void AdminReqLogin::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void AdminReqLogin::freeAll()
{
}

void AdminReqLogin::resetAll()
{
	m_entity = "";
	m_password = "";
	m_username = "";
}

bool AdminReqLogin::load_Datas(const ADMIN_REQ_LOGIN * Datas)
{
	Clear();
	if(Datas->entity)
	{
		m_entity = Datas->entity;
	}
	if(Datas->password)
	{
		m_password = Datas->password;
	}
	if(Datas->username)
	{
		m_username = Datas->username;
	}
	m_isOk=true;
	return true;
}

bool AdminReqLogin::give_Datas(ADMIN_REQ_LOGIN ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ADMIN_REQ_LOGIN*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->entity && !((*Datas)->entity = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_entity.c_ASN1_UTF8STRING(&(*Datas)->entity))
	{
		ASN1_UTF8STRING_free((*Datas)->entity);
		(*Datas)->entity = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->password && !((*Datas)->password = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_password.c_ASN1_UTF8STRING(&(*Datas)->password))
	{
		ASN1_UTF8STRING_free((*Datas)->password);
		(*Datas)->password = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->username && !((*Datas)->username = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_username.c_ASN1_UTF8STRING(&(*Datas)->username))
	{
		ASN1_UTF8STRING_free((*Datas)->username);
		(*Datas)->username = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool AdminReqLogin::operator=(const AdminReqLogin & other)
{
	Clear();
	m_entity = other.m_entity;
	m_password = other.m_password;
	m_username = other.m_username;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * AdminReqLogin::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ADMIN_REQ_LOGIN);
}
WebReqLogin WebReqLogin::EmptyInstance;
bool WebReqLogin::set_email(const mString & c_email)
{
	m_email = c_email;
	return true;
}

const mString & WebReqLogin::get_email() const
{
	return m_email;
}

mString & WebReqLogin::get_email()
{
	return m_email;
}

bool WebReqLogin::set_password(const mString & c_password)
{
	m_password = c_password;
	return true;
}

const mString & WebReqLogin::get_password() const
{
	return m_password;
}

mString & WebReqLogin::get_password()
{
	return m_password;
}

WebReqLogin::WebReqLogin():NewPKIObject()
{
	resetAll();
}

WebReqLogin::WebReqLogin(const WebReqLogin & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

WebReqLogin::~WebReqLogin()
{
	Clear();
}

void WebReqLogin::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void WebReqLogin::freeAll()
{
}

void WebReqLogin::resetAll()
{
	m_email = "";
	m_password = "";
}

bool WebReqLogin::load_Datas(const WEB_REQ_LOGIN * Datas)
{
	Clear();
	if(Datas->email)
	{
		m_email = Datas->email;
	}
	if(Datas->password)
	{
		m_password = Datas->password;
	}
	m_isOk=true;
	return true;
}

bool WebReqLogin::give_Datas(WEB_REQ_LOGIN ** Datas) const
{
	if(!(*Datas) && !(*Datas = (WEB_REQ_LOGIN*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->email && !((*Datas)->email = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_email.c_ASN1_UTF8STRING(&(*Datas)->email))
	{
		ASN1_UTF8STRING_free((*Datas)->email);
		(*Datas)->email = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->password && !((*Datas)->password = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_password.c_ASN1_UTF8STRING(&(*Datas)->password))
	{
		ASN1_UTF8STRING_free((*Datas)->password);
		(*Datas)->password = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool WebReqLogin::operator=(const WebReqLogin & other)
{
	Clear();
	m_email = other.m_email;
	m_password = other.m_password;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * WebReqLogin::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(WEB_REQ_LOGIN);
}
WebReqCreate WebReqCreate::EmptyInstance;
bool WebReqCreate::set_dn(const X509_NAME * c_dn)
{
	if(m_dn)
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)c_dn);
	if(!m_dn)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_NAME * WebReqCreate::get_dn() const
{
	if(!m_dn)
		((WebReqCreate*)this)->m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

X509_NAME * WebReqCreate::get_dn()
{
	if(!m_dn)
		m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

bool WebReqCreate::set_email(const mString & c_email)
{
	m_email = c_email;
	return true;
}

const mString & WebReqCreate::get_email() const
{
	return m_email;
}

mString & WebReqCreate::get_email()
{
	return m_email;
}

bool WebReqCreate::set_password(const mString & c_password)
{
	m_password = c_password;
	return true;
}

const mString & WebReqCreate::get_password() const
{
	return m_password;
}

mString & WebReqCreate::get_password()
{
	return m_password;
}

WebReqCreate::WebReqCreate():NewPKIObject()
{
	resetAll();
}

WebReqCreate::WebReqCreate(const WebReqCreate & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

WebReqCreate::~WebReqCreate()
{
	Clear();
}

void WebReqCreate::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void WebReqCreate::freeAll()
{
	if(m_dn)
	{
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	}
}

void WebReqCreate::resetAll()
{
	m_dn = NULL;
	m_email = "";
	m_password = "";
}

bool WebReqCreate::load_Datas(const WEB_REQ_CREATE * Datas)
{
	Clear();
	if(Datas->dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), Datas->dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->email)
	{
		m_email = Datas->email;
	}
	if(Datas->password)
	{
		m_password = Datas->password;
	}
	m_isOk=true;
	return true;
}

bool WebReqCreate::give_Datas(WEB_REQ_CREATE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (WEB_REQ_CREATE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(m_dn)
	{
		if((*Datas)->dn)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->dn, ASN1_ITEM_rptr(X509_NAME));
		if(!((*Datas)->dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (ASN1_VALUE*)m_dn)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->dn)
		{
			(*Datas)->dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
			if(!(*Datas)->dn)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->email && !((*Datas)->email = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_email.c_ASN1_UTF8STRING(&(*Datas)->email))
	{
		ASN1_UTF8STRING_free((*Datas)->email);
		(*Datas)->email = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->password && !((*Datas)->password = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_password.c_ASN1_UTF8STRING(&(*Datas)->password))
	{
		ASN1_UTF8STRING_free((*Datas)->password);
		(*Datas)->password = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool WebReqCreate::operator=(const WebReqCreate & other)
{
	Clear();
	if(other.m_dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)other.m_dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_email = other.m_email;
	m_password = other.m_password;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * WebReqCreate::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(WEB_REQ_CREATE);
}
SEntityMailConf SEntityMailConf::EmptyInstance;
bool SEntityMailConf::set_entityCert(const PKI_CERT & c_entityCert)
{
	m_entityCert = c_entityCert;
	return true;
}

const PKI_CERT & SEntityMailConf::get_entityCert() const
{
	return m_entityCert;
}

PKI_CERT & SEntityMailConf::get_entityCert()
{
	return m_entityCert;
}

bool SEntityMailConf::set_mailConf(const EmailConf & c_mailConf)
{
	m_mailConf = c_mailConf;
	return true;
}

const EmailConf & SEntityMailConf::get_mailConf() const
{
	return m_mailConf;
}

EmailConf & SEntityMailConf::get_mailConf()
{
	return m_mailConf;
}

SEntityMailConf::SEntityMailConf():NewPKIObject()
{
	resetAll();
}

SEntityMailConf::SEntityMailConf(const SEntityMailConf & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

SEntityMailConf::~SEntityMailConf()
{
	Clear();
}

void SEntityMailConf::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void SEntityMailConf::freeAll()
{
}

void SEntityMailConf::resetAll()
{
	m_entityCert.Clear();
	m_mailConf.Clear();
}

bool SEntityMailConf::load_Datas(const S_ENTITY_MAIL_CONF * Datas)
{
	Clear();
	if(Datas->entity_cert)
	{
		if(!m_entityCert.load_Datas(Datas->entity_cert))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->mail_conf)
	{
		if(!m_mailConf.load_Datas(Datas->mail_conf))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool SEntityMailConf::give_Datas(S_ENTITY_MAIL_CONF ** Datas) const
{
	if(!(*Datas) && !(*Datas = (S_ENTITY_MAIL_CONF*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->entity_cert && !((*Datas)->entity_cert = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_entityCert.give_Datas(&(*Datas)->entity_cert))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->entity_cert, ASN1_ITEM_rptr(X509));
		(*Datas)->entity_cert = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->mail_conf && !((*Datas)->mail_conf = (EMAIL_CONF*)ASN1_item_new(ASN1_ITEM_rptr(EMAIL_CONF))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_mailConf.give_Datas(&(*Datas)->mail_conf))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->mail_conf, ASN1_ITEM_rptr(EMAIL_CONF));
		(*Datas)->mail_conf = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool SEntityMailConf::operator=(const SEntityMailConf & other)
{
	Clear();
	m_entityCert = other.m_entityCert;
	m_mailConf = other.m_mailConf;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * SEntityMailConf::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(S_ENTITY_MAIL_CONF);
}
SEntityAcl SEntityAcl::EmptyInstance;
bool SEntityAcl::set_aclEntries(const mVector< AclEntry > & c_aclEntries)
{
	m_aclEntries = c_aclEntries;
	return true;
}

const mVector< AclEntry > & SEntityAcl::get_aclEntries() const
{
	return m_aclEntries;
}

mVector< AclEntry > & SEntityAcl::get_aclEntries()
{
	return m_aclEntries;
}

bool SEntityAcl::set_entityCert(const PKI_CERT & c_entityCert)
{
	m_entityCert = c_entityCert;
	return true;
}

const PKI_CERT & SEntityAcl::get_entityCert() const
{
	return m_entityCert;
}

PKI_CERT & SEntityAcl::get_entityCert()
{
	return m_entityCert;
}

SEntityAcl::SEntityAcl():NewPKIObject()
{
	resetAll();
}

SEntityAcl::SEntityAcl(const SEntityAcl & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

SEntityAcl::~SEntityAcl()
{
	Clear();
}

void SEntityAcl::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void SEntityAcl::freeAll()
{
}

void SEntityAcl::resetAll()
{
	m_aclEntries.clear();
	m_entityCert.Clear();
}

bool SEntityAcl::load_Datas(const S_ENTITY_ACL * Datas)
{
	Clear();
	int i;
	ACL_ENTRY * curraclEntries;
	if(Datas->acl_entries)
	{
		for(i=0; i<SKM_sk_num(ACL_ENTRY, Datas->acl_entries); i++)
		{
			curraclEntries = SKM_sk_value(ACL_ENTRY, Datas->acl_entries, i);
			if(!curraclEntries)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_aclEntries.insert(m_aclEntries.begin() + i);
			if(!m_aclEntries[i].load_Datas(curraclEntries))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->entity_cert)
	{
		if(!m_entityCert.load_Datas(Datas->entity_cert))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool SEntityAcl::give_Datas(S_ENTITY_ACL ** Datas) const
{
	if(!(*Datas) && !(*Datas = (S_ENTITY_ACL*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ACL_ENTRY * curraclEntries;
	size_t i;
	if(!(*Datas)->acl_entries && !((*Datas)->acl_entries = SKM_sk_new_null(ACL_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_aclEntries.size() ; i++)
	{
		curraclEntries = NULL;
		if(!m_aclEntries[i].give_Datas(&curraclEntries))
		{
			ASN1_item_free((ASN1_VALUE*)curraclEntries, ASN1_ITEM_rptr(ACL_ENTRY));
			curraclEntries = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ACL_ENTRY, (*Datas)->acl_entries, curraclEntries) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)curraclEntries, ASN1_ITEM_rptr(ACL_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->entity_cert && !((*Datas)->entity_cert = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_entityCert.give_Datas(&(*Datas)->entity_cert))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->entity_cert, ASN1_ITEM_rptr(X509));
		(*Datas)->entity_cert = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool SEntityAcl::operator=(const SEntityAcl & other)
{
	Clear();
	m_aclEntries = other.m_aclEntries;
	m_entityCert = other.m_entityCert;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * SEntityAcl::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(S_ENTITY_ACL);
}
SEntityConf SEntityConf::EmptyInstance;
bool SEntityConf::set_conf(const EntityConfBody & c_conf)
{
	m_conf = c_conf;
	return true;
}

const EntityConfBody & SEntityConf::get_conf() const
{
	return m_conf;
}

EntityConfBody & SEntityConf::get_conf()
{
	return m_conf;
}

bool SEntityConf::set_entityCert(const PKI_CERT & c_entityCert)
{
	m_entityCert = c_entityCert;
	return true;
}

const PKI_CERT & SEntityConf::get_entityCert() const
{
	return m_entityCert;
}

PKI_CERT & SEntityConf::get_entityCert()
{
	return m_entityCert;
}

SEntityConf::SEntityConf():NewPKIObject()
{
	resetAll();
}

SEntityConf::SEntityConf(const SEntityConf & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

SEntityConf::~SEntityConf()
{
	Clear();
}

void SEntityConf::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void SEntityConf::freeAll()
{
}

void SEntityConf::resetAll()
{
	m_conf.Clear();
	m_entityCert.Clear();
}

bool SEntityConf::load_Datas(const S_ENTITY_CONF * Datas)
{
	Clear();
	if(Datas->conf)
	{
		if(!m_conf.load_Datas(Datas->conf))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->entity_cert)
	{
		if(!m_entityCert.load_Datas(Datas->entity_cert))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool SEntityConf::give_Datas(S_ENTITY_CONF ** Datas) const
{
	if(!(*Datas) && !(*Datas = (S_ENTITY_CONF*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->conf && !((*Datas)->conf = (ENTITY_CONF_BODY*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CONF_BODY))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_conf.give_Datas(&(*Datas)->conf))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->conf, ASN1_ITEM_rptr(ENTITY_CONF_BODY));
		(*Datas)->conf = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->entity_cert && !((*Datas)->entity_cert = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_entityCert.give_Datas(&(*Datas)->entity_cert))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->entity_cert, ASN1_ITEM_rptr(X509));
		(*Datas)->entity_cert = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool SEntityConf::operator=(const SEntityConf & other)
{
	Clear();
	m_conf = other.m_conf;
	m_entityCert = other.m_entityCert;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * SEntityConf::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(S_ENTITY_CONF);
}
MailDatas MailDatas::EmptyInstance;
bool MailDatas::set_attach(const Asn1OctetString & c_attach)
{
	m_attach = c_attach;
	return true;
}

const Asn1OctetString & MailDatas::get_attach() const
{
	return m_attach;
}

Asn1OctetString & MailDatas::get_attach()
{
	return m_attach;
}

bool MailDatas::set_attachname(const mString & c_attachname)
{
	m_attachname = c_attachname;
	return true;
}

const mString & MailDatas::get_attachname() const
{
	return m_attachname;
}

mString & MailDatas::get_attachname()
{
	return m_attachname;
}

bool MailDatas::set_attachtype(const mString & c_attachtype)
{
	m_attachtype = c_attachtype;
	return true;
}

const mString & MailDatas::get_attachtype() const
{
	return m_attachtype;
}

mString & MailDatas::get_attachtype()
{
	return m_attachtype;
}

bool MailDatas::set_body(const mString & c_body)
{
	m_body = c_body;
	return true;
}

const mString & MailDatas::get_body() const
{
	return m_body;
}

mString & MailDatas::get_body()
{
	return m_body;
}

bool MailDatas::set_signmail(unsigned long c_signmail)
{
	m_signmail = c_signmail;
	return true;
}

unsigned long MailDatas::get_signmail() const
{
	return m_signmail;
}

bool MailDatas::set_subject(const mString & c_subject)
{
	m_subject = c_subject;
	return true;
}

const mString & MailDatas::get_subject() const
{
	return m_subject;
}

mString & MailDatas::get_subject()
{
	return m_subject;
}

MailDatas::MailDatas():NewPKIObject()
{
	resetAll();
}

MailDatas::MailDatas(const MailDatas & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

MailDatas::~MailDatas()
{
	Clear();
}

void MailDatas::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void MailDatas::freeAll()
{
}

void MailDatas::resetAll()
{
	m_attach.Clear();
	m_attachname = "";
	m_attachtype = "";
	m_body = "";
	m_signmail = 0;
	m_subject = "";
}

bool MailDatas::load_Datas(const MAIL_DATAS * Datas)
{
	Clear();
	if(Datas->Attach)
	{
		if(!m_attach.load_Datas(Datas->Attach))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->AttachName)
	{
		m_attachname = Datas->AttachName;
	}
	if(Datas->AttachType)
	{
		m_attachtype = Datas->AttachType;
	}
	if(Datas->Body)
	{
		m_body = Datas->Body;
	}
	if(Datas->SignMail)
	{
		m_signmail = ASN1_INTEGER_GET(Datas->SignMail);
	}
	if(Datas->Subject)
	{
		m_subject = Datas->Subject;
	}
	m_isOk=true;
	return true;
}

bool MailDatas::give_Datas(MAIL_DATAS ** Datas) const
{
	if(!(*Datas) && !(*Datas = (MAIL_DATAS*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->Attach && !((*Datas)->Attach = (ASN1_OCTET_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_OCTET_STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_attach.give_Datas(&(*Datas)->Attach))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->Attach, ASN1_ITEM_rptr(ASN1_OCTET_STRING));
		(*Datas)->Attach = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->AttachName && !((*Datas)->AttachName = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_attachname.c_ASN1_UTF8STRING(&(*Datas)->AttachName))
	{
		ASN1_UTF8STRING_free((*Datas)->AttachName);
		(*Datas)->AttachName = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->AttachType && !((*Datas)->AttachType = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_attachtype.c_ASN1_UTF8STRING(&(*Datas)->AttachType))
	{
		ASN1_UTF8STRING_free((*Datas)->AttachType);
		(*Datas)->AttachType = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Body && !((*Datas)->Body = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_body.c_ASN1_UTF8STRING(&(*Datas)->Body))
	{
		ASN1_UTF8STRING_free((*Datas)->Body);
		(*Datas)->Body = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->SignMail && !((*Datas)->SignMail = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->SignMail, m_signmail) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->SignMail);
		(*Datas)->SignMail = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->Subject && !((*Datas)->Subject = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_subject.c_ASN1_UTF8STRING(&(*Datas)->Subject))
	{
		ASN1_UTF8STRING_free((*Datas)->Subject);
		(*Datas)->Subject = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool MailDatas::operator=(const MailDatas & other)
{
	Clear();
	m_attach = other.m_attach;
	m_attachname = other.m_attachname;
	m_attachtype = other.m_attachtype;
	m_body = other.m_body;
	m_signmail = other.m_signmail;
	m_subject = other.m_subject;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * MailDatas::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(MAIL_DATAS);
}
SEntityAudits SEntityAudits::EmptyInstance;
bool SEntityAudits::set_audits(const mVector< EntityAuditEntry > & c_audits)
{
	m_audits = c_audits;
	return true;
}

const mVector< EntityAuditEntry > & SEntityAudits::get_audits() const
{
	return m_audits;
}

mVector< EntityAuditEntry > & SEntityAudits::get_audits()
{
	return m_audits;
}

bool SEntityAudits::set_entityCert(const PKI_CERT & c_entityCert)
{
	m_entityCert = c_entityCert;
	return true;
}

const PKI_CERT & SEntityAudits::get_entityCert() const
{
	return m_entityCert;
}

PKI_CERT & SEntityAudits::get_entityCert()
{
	return m_entityCert;
}

SEntityAudits::SEntityAudits():NewPKIObject()
{
	resetAll();
}

SEntityAudits::SEntityAudits(const SEntityAudits & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

SEntityAudits::~SEntityAudits()
{
	Clear();
}

void SEntityAudits::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void SEntityAudits::freeAll()
{
}

void SEntityAudits::resetAll()
{
	m_audits.clear();
	m_entityCert.Clear();
}

bool SEntityAudits::load_Datas(const S_ENTITY_AUDITS * Datas)
{
	Clear();
	int i;
	ENTITY_AUDIT_ENTRY * curraudits;
	if(Datas->audits)
	{
		for(i=0; i<SKM_sk_num(ENTITY_AUDIT_ENTRY, Datas->audits); i++)
		{
			curraudits = SKM_sk_value(ENTITY_AUDIT_ENTRY, Datas->audits, i);
			if(!curraudits)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			m_audits.insert(m_audits.begin() + i);
			if(!m_audits[i].load_Datas(curraudits))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
		}
	}
	if(Datas->entity_cert)
	{
		if(!m_entityCert.load_Datas(Datas->entity_cert))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool SEntityAudits::give_Datas(S_ENTITY_AUDITS ** Datas) const
{
	if(!(*Datas) && !(*Datas = (S_ENTITY_AUDITS*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	ENTITY_AUDIT_ENTRY * curraudits;
	size_t i;
	if(!(*Datas)->audits && !((*Datas)->audits = SKM_sk_new_null(ENTITY_AUDIT_ENTRY)))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	for(i = 0 ; i < m_audits.size() ; i++)
	{
		curraudits = NULL;
		if(!m_audits[i].give_Datas(&curraudits))
		{
			ASN1_item_free((ASN1_VALUE*)curraudits, ASN1_ITEM_rptr(ENTITY_AUDIT_ENTRY));
			curraudits = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
		if(SKM_sk_push(ENTITY_AUDIT_ENTRY, (*Datas)->audits, curraudits) < 0)
		{
			ASN1_item_free((ASN1_VALUE*)curraudits, ASN1_ITEM_rptr(ENTITY_AUDIT_ENTRY));
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
			return false;
		}
	}
	if(!(*Datas)->entity_cert && !((*Datas)->entity_cert = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_entityCert.give_Datas(&(*Datas)->entity_cert))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->entity_cert, ASN1_ITEM_rptr(X509));
		(*Datas)->entity_cert = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool SEntityAudits::operator=(const SEntityAudits & other)
{
	Clear();
	m_audits = other.m_audits;
	m_entityCert = other.m_entityCert;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * SEntityAudits::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(S_ENTITY_AUDITS);
}
ObjectsEnum ObjectsEnum::EmptyInstance;
bool ObjectsEnum::set_filter(const mString & c_filter)
{
	m_filter = c_filter;
	return true;
}

const mString & ObjectsEnum::get_filter() const
{
	return m_filter;
}

mString & ObjectsEnum::get_filter()
{
	return m_filter;
}

bool ObjectsEnum::set_index(unsigned long c_index)
{
	m_index = c_index;
	return true;
}

unsigned long ObjectsEnum::get_index() const
{
	return m_index;
}

bool ObjectsEnum::set_num(unsigned long c_num)
{
	m_num = c_num;
	return true;
}

unsigned long ObjectsEnum::get_num() const
{
	return m_num;
}

bool ObjectsEnum::set_state(unsigned long c_state)
{
	m_state = c_state;
	return true;
}

unsigned long ObjectsEnum::get_state() const
{
	return m_state;
}

ObjectsEnum::ObjectsEnum():NewPKIObject()
{
	resetAll();
}

ObjectsEnum::ObjectsEnum(const ObjectsEnum & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

ObjectsEnum::~ObjectsEnum()
{
	Clear();
}

void ObjectsEnum::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void ObjectsEnum::freeAll()
{
}

void ObjectsEnum::resetAll()
{
	m_filter = "";
	m_index = 0;
	m_num = 0;
	m_state = 0;
}

bool ObjectsEnum::load_Datas(const OBJECTS_ENUM * Datas)
{
	Clear();
	if(Datas->filter)
	{
		m_filter = Datas->filter;
	}
	if(Datas->index)
	{
		m_index = ASN1_INTEGER_GET(Datas->index);
	}
	if(Datas->num)
	{
		m_num = ASN1_INTEGER_GET(Datas->num);
	}
	if(Datas->state)
	{
		m_state = ASN1_INTEGER_GET(Datas->state);
	}
	m_isOk=true;
	return true;
}

bool ObjectsEnum::give_Datas(OBJECTS_ENUM ** Datas) const
{
	if(!(*Datas) && !(*Datas = (OBJECTS_ENUM*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->filter && !((*Datas)->filter = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_filter.c_ASN1_UTF8STRING(&(*Datas)->filter))
	{
		ASN1_UTF8STRING_free((*Datas)->filter);
		(*Datas)->filter = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->index && !((*Datas)->index = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->index, m_index) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->index);
		(*Datas)->index = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->num && !((*Datas)->num = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->num, m_num) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->num);
		(*Datas)->num = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->state && !((*Datas)->state = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->state, m_state) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->state);
		(*Datas)->state = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool ObjectsEnum::operator=(const ObjectsEnum & other)
{
	Clear();
	m_filter = other.m_filter;
	m_index = other.m_index;
	m_num = other.m_num;
	m_state = other.m_state;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * ObjectsEnum::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(OBJECTS_ENUM);
}
SignCsr SignCsr::EmptyInstance;
bool SignCsr::set_days(unsigned long c_days)
{
	m_days = c_days;
	return true;
}

unsigned long SignCsr::get_days() const
{
	return m_days;
}

bool SignCsr::set_request(const PKI_CSR & c_request)
{
	m_request = c_request;
	return true;
}

const PKI_CSR & SignCsr::get_request() const
{
	return m_request;
}

PKI_CSR & SignCsr::get_request()
{
	return m_request;
}

bool SignCsr::set_uid(const mString & c_uid)
{
	m_uid = c_uid;
	return true;
}

const mString & SignCsr::get_uid() const
{
	return m_uid;
}

mString & SignCsr::get_uid()
{
	return m_uid;
}

SignCsr::SignCsr():NewPKIObject()
{
	resetAll();
}

SignCsr::SignCsr(const SignCsr & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

SignCsr::~SignCsr()
{
	Clear();
}

void SignCsr::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void SignCsr::freeAll()
{
}

void SignCsr::resetAll()
{
	m_days = 0;
	m_request.Clear();
	m_uid = "";
}

bool SignCsr::load_Datas(const SIGN_CSR * Datas)
{
	Clear();
	if(Datas->days)
	{
		m_days = ASN1_INTEGER_GET(Datas->days);
	}
	if(Datas->request)
	{
		if(!m_request.load_Datas(Datas->request))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(Datas->uid)
	{
		m_uid = Datas->uid;
	}
	m_isOk=true;
	return true;
}

bool SignCsr::give_Datas(SIGN_CSR ** Datas) const
{
	if(!(*Datas) && !(*Datas = (SIGN_CSR*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->days && !((*Datas)->days = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->days, m_days) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->days);
		(*Datas)->days = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->request && !((*Datas)->request = (X509_REQ*)ASN1_item_new(ASN1_ITEM_rptr(X509_REQ))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_request.give_Datas(&(*Datas)->request))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->request, ASN1_ITEM_rptr(X509_REQ));
		(*Datas)->request = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->uid && !((*Datas)->uid = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_uid.c_ASN1_UTF8STRING(&(*Datas)->uid))
	{
		ASN1_UTF8STRING_free((*Datas)->uid);
		(*Datas)->uid = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool SignCsr::operator=(const SignCsr & other)
{
	Clear();
	m_days = other.m_days;
	m_request = other.m_request;
	m_uid = other.m_uid;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * SignCsr::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(SIGN_CSR);
}
SRenameGroup SRenameGroup::EmptyInstance;
bool SRenameGroup::set_id(unsigned long c_id)
{
	m_id = c_id;
	return true;
}

unsigned long SRenameGroup::get_id() const
{
	return m_id;
}

bool SRenameGroup::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & SRenameGroup::get_name() const
{
	return m_name;
}

mString & SRenameGroup::get_name()
{
	return m_name;
}

SRenameGroup::SRenameGroup():NewPKIObject()
{
	resetAll();
}

SRenameGroup::SRenameGroup(const SRenameGroup & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

SRenameGroup::~SRenameGroup()
{
	Clear();
}

void SRenameGroup::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void SRenameGroup::freeAll()
{
}

void SRenameGroup::resetAll()
{
	m_id = 0;
	m_name = "";
}

bool SRenameGroup::load_Datas(const S_RENAME_GROUP * Datas)
{
	Clear();
	if(Datas->id)
	{
		m_id = ASN1_INTEGER_GET(Datas->id);
	}
	if(Datas->name)
	{
		m_name = Datas->name;
	}
	m_isOk=true;
	return true;
}

bool SRenameGroup::give_Datas(S_RENAME_GROUP ** Datas) const
{
	if(!(*Datas) && !(*Datas = (S_RENAME_GROUP*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->id && !((*Datas)->id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->id, m_id) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->id);
		(*Datas)->id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->name && !((*Datas)->name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->name))
	{
		ASN1_UTF8STRING_free((*Datas)->name);
		(*Datas)->name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool SRenameGroup::operator=(const SRenameGroup & other)
{
	Clear();
	m_id = other.m_id;
	m_name = other.m_name;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * SRenameGroup::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(S_RENAME_GROUP);
}
ProfileChangeUid ProfileChangeUid::EmptyInstance;
bool ProfileChangeUid::set_ldapUid(const mString & c_ldapUid)
{
	m_ldapUid = c_ldapUid;
	return true;
}

const mString & ProfileChangeUid::get_ldapUid() const
{
	return m_ldapUid;
}

mString & ProfileChangeUid::get_ldapUid()
{
	return m_ldapUid;
}

bool ProfileChangeUid::set_profileId(unsigned long c_profileId)
{
	m_profileId = c_profileId;
	return true;
}

unsigned long ProfileChangeUid::get_profileId() const
{
	return m_profileId;
}

ProfileChangeUid::ProfileChangeUid():NewPKIObject()
{
	resetAll();
}

ProfileChangeUid::ProfileChangeUid(const ProfileChangeUid & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

ProfileChangeUid::~ProfileChangeUid()
{
	Clear();
}

void ProfileChangeUid::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void ProfileChangeUid::freeAll()
{
}

void ProfileChangeUid::resetAll()
{
	m_ldapUid = "";
	m_profileId = 0;
}

bool ProfileChangeUid::load_Datas(const PROFILE_CHANGE_UID * Datas)
{
	Clear();
	if(Datas->ldap_uid)
	{
		m_ldapUid = Datas->ldap_uid;
	}
	if(Datas->profile_id)
	{
		m_profileId = ASN1_INTEGER_GET(Datas->profile_id);
	}
	m_isOk=true;
	return true;
}

bool ProfileChangeUid::give_Datas(PROFILE_CHANGE_UID ** Datas) const
{
	if(!(*Datas) && !(*Datas = (PROFILE_CHANGE_UID*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->ldap_uid && !((*Datas)->ldap_uid = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_ldapUid.c_ASN1_UTF8STRING(&(*Datas)->ldap_uid))
	{
		ASN1_UTF8STRING_free((*Datas)->ldap_uid);
		(*Datas)->ldap_uid = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->profile_id && !((*Datas)->profile_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->profile_id, m_profileId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->profile_id);
		(*Datas)->profile_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool ProfileChangeUid::operator=(const ProfileChangeUid & other)
{
	Clear();
	m_ldapUid = other.m_ldapUid;
	m_profileId = other.m_profileId;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * ProfileChangeUid::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(PROFILE_CHANGE_UID);
}
ProfileChangeOwner ProfileChangeOwner::EmptyInstance;
bool ProfileChangeOwner::set_ownerGroupSerial(unsigned long c_ownerGroupSerial)
{
	m_ownerGroupSerial = c_ownerGroupSerial;
	return true;
}

unsigned long ProfileChangeOwner::get_ownerGroupSerial() const
{
	return m_ownerGroupSerial;
}

bool ProfileChangeOwner::set_profileId(unsigned long c_profileId)
{
	m_profileId = c_profileId;
	return true;
}

unsigned long ProfileChangeOwner::get_profileId() const
{
	return m_profileId;
}

ProfileChangeOwner::ProfileChangeOwner():NewPKIObject()
{
	resetAll();
}

ProfileChangeOwner::ProfileChangeOwner(const ProfileChangeOwner & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

ProfileChangeOwner::~ProfileChangeOwner()
{
	Clear();
}

void ProfileChangeOwner::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void ProfileChangeOwner::freeAll()
{
}

void ProfileChangeOwner::resetAll()
{
	m_ownerGroupSerial = 0;
	m_profileId = 0;
}

bool ProfileChangeOwner::load_Datas(const PROFILE_CHANGE_OWNER * Datas)
{
	Clear();
	if(Datas->owner_group_serial)
	{
		m_ownerGroupSerial = ASN1_INTEGER_GET(Datas->owner_group_serial);
	}
	if(Datas->profile_id)
	{
		m_profileId = ASN1_INTEGER_GET(Datas->profile_id);
	}
	m_isOk=true;
	return true;
}

bool ProfileChangeOwner::give_Datas(PROFILE_CHANGE_OWNER ** Datas) const
{
	if(!(*Datas) && !(*Datas = (PROFILE_CHANGE_OWNER*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->owner_group_serial && !((*Datas)->owner_group_serial = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->owner_group_serial, m_ownerGroupSerial) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->owner_group_serial);
		(*Datas)->owner_group_serial = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->profile_id && !((*Datas)->profile_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->profile_id, m_profileId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->profile_id);
		(*Datas)->profile_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool ProfileChangeOwner::operator=(const ProfileChangeOwner & other)
{
	Clear();
	m_ownerGroupSerial = other.m_ownerGroupSerial;
	m_profileId = other.m_profileId;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * ProfileChangeOwner::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(PROFILE_CHANGE_OWNER);
}
ProfileChangeDn ProfileChangeDn::EmptyInstance;
bool ProfileChangeDn::set_dn(const X509_NAME * c_dn)
{
	if(m_dn)
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)c_dn);
	if(!m_dn)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_NAME * ProfileChangeDn::get_dn() const
{
	if(!m_dn)
		((ProfileChangeDn*)this)->m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

X509_NAME * ProfileChangeDn::get_dn()
{
	if(!m_dn)
		m_dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
	return m_dn;
}

bool ProfileChangeDn::set_profileId(unsigned long c_profileId)
{
	m_profileId = c_profileId;
	return true;
}

unsigned long ProfileChangeDn::get_profileId() const
{
	return m_profileId;
}

ProfileChangeDn::ProfileChangeDn():NewPKIObject()
{
	resetAll();
}

ProfileChangeDn::ProfileChangeDn(const ProfileChangeDn & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

ProfileChangeDn::~ProfileChangeDn()
{
	Clear();
}

void ProfileChangeDn::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void ProfileChangeDn::freeAll()
{
	if(m_dn)
	{
		ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
	}
}

void ProfileChangeDn::resetAll()
{
	m_dn = NULL;
	m_profileId = 0;
}

bool ProfileChangeDn::load_Datas(const PROFILE_CHANGE_DN * Datas)
{
	Clear();
	if(Datas->dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), Datas->dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->profile_id)
	{
		m_profileId = ASN1_INTEGER_GET(Datas->profile_id);
	}
	m_isOk=true;
	return true;
}

bool ProfileChangeDn::give_Datas(PROFILE_CHANGE_DN ** Datas) const
{
	if(!(*Datas) && !(*Datas = (PROFILE_CHANGE_DN*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(m_dn)
	{
		if((*Datas)->dn)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->dn, ASN1_ITEM_rptr(X509_NAME));
		if(!((*Datas)->dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (ASN1_VALUE*)m_dn)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->dn)
		{
			(*Datas)->dn = (X509_NAME*)ASN1_item_new(ASN1_ITEM_rptr(X509_NAME));
			if(!(*Datas)->dn)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(!(*Datas)->profile_id && !((*Datas)->profile_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->profile_id, m_profileId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->profile_id);
		(*Datas)->profile_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool ProfileChangeDn::operator=(const ProfileChangeDn & other)
{
	Clear();
	if(other.m_dn)
	{
		if(m_dn)
			ASN1_item_free((ASN1_VALUE*)m_dn, ASN1_ITEM_rptr(X509_NAME));
		m_dn = (X509_NAME*)ASN1_item_dup(ASN1_ITEM_rptr(X509_NAME), (void*)other.m_dn);
		if(!m_dn)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_profileId = other.m_profileId;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * ProfileChangeDn::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(PROFILE_CHANGE_DN);
}
ProfileReject ProfileReject::EmptyInstance;
bool ProfileReject::set_profileId(unsigned long c_profileId)
{
	m_profileId = c_profileId;
	return true;
}

unsigned long ProfileReject::get_profileId() const
{
	return m_profileId;
}

bool ProfileReject::set_reason(const mString & c_reason)
{
	m_reason = c_reason;
	return true;
}

const mString & ProfileReject::get_reason() const
{
	return m_reason;
}

mString & ProfileReject::get_reason()
{
	return m_reason;
}

ProfileReject::ProfileReject():NewPKIObject()
{
	resetAll();
}

ProfileReject::ProfileReject(const ProfileReject & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

ProfileReject::~ProfileReject()
{
	Clear();
}

void ProfileReject::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void ProfileReject::freeAll()
{
}

void ProfileReject::resetAll()
{
	m_profileId = 0;
	m_reason = "";
}

bool ProfileReject::load_Datas(const PROFILE_REJECT * Datas)
{
	Clear();
	if(Datas->profile_id)
	{
		m_profileId = ASN1_INTEGER_GET(Datas->profile_id);
	}
	if(Datas->reason)
	{
		m_reason = Datas->reason;
	}
	m_isOk=true;
	return true;
}

bool ProfileReject::give_Datas(PROFILE_REJECT ** Datas) const
{
	if(!(*Datas) && !(*Datas = (PROFILE_REJECT*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->profile_id && !((*Datas)->profile_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->profile_id, m_profileId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->profile_id);
		(*Datas)->profile_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->reason && !((*Datas)->reason = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_reason.c_ASN1_UTF8STRING(&(*Datas)->reason))
	{
		ASN1_UTF8STRING_free((*Datas)->reason);
		(*Datas)->reason = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool ProfileReject::operator=(const ProfileReject & other)
{
	Clear();
	m_profileId = other.m_profileId;
	m_reason = other.m_reason;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * ProfileReject::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(PROFILE_REJECT);
}
WebuserRevokeCert WebuserRevokeCert::EmptyInstance;
bool WebuserRevokeCert::set_certId(unsigned long c_certId)
{
	m_certId = c_certId;
	return true;
}

unsigned long WebuserRevokeCert::get_certId() const
{
	return m_certId;
}

bool WebuserRevokeCert::set_userId(unsigned long c_userId)
{
	m_userId = c_userId;
	return true;
}

unsigned long WebuserRevokeCert::get_userId() const
{
	return m_userId;
}

WebuserRevokeCert::WebuserRevokeCert():NewPKIObject()
{
	resetAll();
}

WebuserRevokeCert::WebuserRevokeCert(const WebuserRevokeCert & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

WebuserRevokeCert::~WebuserRevokeCert()
{
	Clear();
}

void WebuserRevokeCert::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void WebuserRevokeCert::freeAll()
{
}

void WebuserRevokeCert::resetAll()
{
	m_certId = 0;
	m_userId = 0;
}

bool WebuserRevokeCert::load_Datas(const WEBUSER_REVOKE_CERT * Datas)
{
	Clear();
	if(Datas->cert_id)
	{
		m_certId = ASN1_INTEGER_GET(Datas->cert_id);
	}
	if(Datas->user_id)
	{
		m_userId = ASN1_INTEGER_GET(Datas->user_id);
	}
	m_isOk=true;
	return true;
}

bool WebuserRevokeCert::give_Datas(WEBUSER_REVOKE_CERT ** Datas) const
{
	if(!(*Datas) && !(*Datas = (WEBUSER_REVOKE_CERT*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->cert_id && !((*Datas)->cert_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->cert_id, m_certId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->cert_id);
		(*Datas)->cert_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->user_id && !((*Datas)->user_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->user_id, m_userId) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->user_id);
		(*Datas)->user_id = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	return true;
}

bool WebuserRevokeCert::operator=(const WebuserRevokeCert & other)
{
	Clear();
	m_certId = other.m_certId;
	m_userId = other.m_userId;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * WebuserRevokeCert::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(WEBUSER_REVOKE_CERT);
}
AdminRequestBody AdminRequestBody::EmptyInstance;
bool AdminRequestBody::set_type(int c_type)
{
	Clear();
	m_type = c_type;
	if(!malloc_byType(m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

int AdminRequestBody::get_type() const
{
	 return m_type;
}

bool AdminRequestBody::set_adminMail(const MailDatas & c_adminMail)
{
	if(m_type != 32)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_adminMail) = c_adminMail;
	m_isOk=true;
	return true;
}

const MailDatas & AdminRequestBody::get_adminMail() const
{
	if((m_type != 32) || !m_adminMail)
	{
		return MailDatas::EmptyInstance;
	}
	return (*m_adminMail);
}

MailDatas & AdminRequestBody::get_adminMail()
{
	if((m_type != 32) || !m_adminMail)
	{
		return MailDatas::EmptyInstance;
	}
	return (*m_adminMail);
}

bool AdminRequestBody::set_certRequest(const NewpkiRequestCert & c_certRequest)
{
	if(m_type != 60)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_certRequest) = c_certRequest;
	m_isOk=true;
	return true;
}

const NewpkiRequestCert & AdminRequestBody::get_certRequest() const
{
	if((m_type != 60) || !m_certRequest)
	{
		return NewpkiRequestCert::EmptyInstance;
	}
	return (*m_certRequest);
}

NewpkiRequestCert & AdminRequestBody::get_certRequest()
{
	if((m_type != 60) || !m_certRequest)
	{
		return NewpkiRequestCert::EmptyInstance;
	}
	return (*m_certRequest);
}

bool AdminRequestBody::set_chgPwd(const ChangePasswd & c_chgPwd)
{
	if(m_type != 9)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_chgPwd) = c_chgPwd;
	m_isOk=true;
	return true;
}

const ChangePasswd & AdminRequestBody::get_chgPwd() const
{
	if((m_type != 9) || !m_chgPwd)
	{
		return ChangePasswd::EmptyInstance;
	}
	return (*m_chgPwd);
}

ChangePasswd & AdminRequestBody::get_chgPwd()
{
	if((m_type != 9) || !m_chgPwd)
	{
		return ChangePasswd::EmptyInstance;
	}
	return (*m_chgPwd);
}

bool AdminRequestBody::set_chgUserPwd(const ChangeUserPasswd & c_chgUserPwd)
{
	if(m_type != 8)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_chgUserPwd) = c_chgUserPwd;
	m_isOk=true;
	return true;
}

const ChangeUserPasswd & AdminRequestBody::get_chgUserPwd() const
{
	if((m_type != 8) || !m_chgUserPwd)
	{
		return ChangeUserPasswd::EmptyInstance;
	}
	return (*m_chgUserPwd);
}

ChangeUserPasswd & AdminRequestBody::get_chgUserPwd()
{
	if((m_type != 8) || !m_chgUserPwd)
	{
		return ChangeUserPasswd::EmptyInstance;
	}
	return (*m_chgUserPwd);
}

bool AdminRequestBody::set_conf(const ExportedPkiConf & c_conf)
{
	if(m_type != 14)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_conf) = c_conf;
	m_isOk=true;
	return true;
}

const ExportedPkiConf & AdminRequestBody::get_conf() const
{
	if((m_type != 14) || !m_conf)
	{
		return ExportedPkiConf::EmptyInstance;
	}
	return (*m_conf);
}

ExportedPkiConf & AdminRequestBody::get_conf()
{
	if((m_type != 14) || !m_conf)
	{
		return ExportedPkiConf::EmptyInstance;
	}
	return (*m_conf);
}

bool AdminRequestBody::set_creEntity(const EntityCreationReq & c_creEntity)
{
	if(m_type != 1)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_creEntity) = c_creEntity;
	m_isOk=true;
	return true;
}

const EntityCreationReq & AdminRequestBody::get_creEntity() const
{
	if((m_type != 1) || !m_creEntity)
	{
		return EntityCreationReq::EmptyInstance;
	}
	return (*m_creEntity);
}

EntityCreationReq & AdminRequestBody::get_creEntity()
{
	if((m_type != 1) || !m_creEntity)
	{
		return EntityCreationReq::EmptyInstance;
	}
	return (*m_creEntity);
}

bool AdminRequestBody::set_creUser(const UserInfo & c_creUser)
{
	if(m_type != 4)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_creUser) = c_creUser;
	m_isOk=true;
	return true;
}

const UserInfo & AdminRequestBody::get_creUser() const
{
	if((m_type != 4) || !m_creUser)
	{
		return UserInfo::EmptyInstance;
	}
	return (*m_creUser);
}

UserInfo & AdminRequestBody::get_creUser()
{
	if((m_type != 4) || !m_creUser)
	{
		return UserInfo::EmptyInstance;
	}
	return (*m_creUser);
}

bool AdminRequestBody::set_createChildCa(const ReqCreateChildCa & c_createChildCa)
{
	if(m_type != 45)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_createChildCa) = c_createChildCa;
	m_isOk=true;
	return true;
}

const ReqCreateChildCa & AdminRequestBody::get_createChildCa() const
{
	if((m_type != 45) || !m_createChildCa)
	{
		return ReqCreateChildCa::EmptyInstance;
	}
	return (*m_createChildCa);
}

ReqCreateChildCa & AdminRequestBody::get_createChildCa()
{
	if((m_type != 45) || !m_createChildCa)
	{
		return ReqCreateChildCa::EmptyInstance;
	}
	return (*m_createChildCa);
}

bool AdminRequestBody::set_createPkiUser(const CreatePkiUserRequest & c_createPkiUser)
{
	if(m_type != 11)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_createPkiUser) = c_createPkiUser;
	m_isOk=true;
	return true;
}

const CreatePkiUserRequest & AdminRequestBody::get_createPkiUser() const
{
	if((m_type != 11) || !m_createPkiUser)
	{
		return CreatePkiUserRequest::EmptyInstance;
	}
	return (*m_createPkiUser);
}

CreatePkiUserRequest & AdminRequestBody::get_createPkiUser()
{
	if((m_type != 11) || !m_createPkiUser)
	{
		return CreatePkiUserRequest::EmptyInstance;
	}
	return (*m_createPkiUser);
}

bool AdminRequestBody::set_createRootCa(const ReqCreateRootCa & c_createRootCa)
{
	if(m_type != 39)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_createRootCa) = c_createRootCa;
	m_isOk=true;
	return true;
}

const ReqCreateRootCa & AdminRequestBody::get_createRootCa() const
{
	if((m_type != 39) || !m_createRootCa)
	{
		return ReqCreateRootCa::EmptyInstance;
	}
	return (*m_createRootCa);
}

ReqCreateRootCa & AdminRequestBody::get_createRootCa()
{
	if((m_type != 39) || !m_createRootCa)
	{
		return ReqCreateRootCa::EmptyInstance;
	}
	return (*m_createRootCa);
}

bool AdminRequestBody::set_dnId(const mString & c_dnId)
{
	if(m_type != 77)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_dnId) = c_dnId;
	m_isOk=true;
	return true;
}

const mString & AdminRequestBody::get_dnId() const
{
	if((m_type != 77) || !m_dnId)
	{
		return mString::EmptyInstance;
	}
	return (*m_dnId);
}

mString & AdminRequestBody::get_dnId()
{
	if((m_type != 77) || !m_dnId)
	{
		return mString::EmptyInstance;
	}
	return (*m_dnId);
}

bool AdminRequestBody::set_dnVal(const DnValidation & c_dnVal)
{
	if(m_type != 76)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_dnVal) = c_dnVal;
	m_isOk=true;
	return true;
}

const DnValidation & AdminRequestBody::get_dnVal() const
{
	if((m_type != 76) || !m_dnVal)
	{
		return DnValidation::EmptyInstance;
	}
	return (*m_dnVal);
}

DnValidation & AdminRequestBody::get_dnVal()
{
	if((m_type != 76) || !m_dnVal)
	{
		return DnValidation::EmptyInstance;
	}
	return (*m_dnVal);
}

bool AdminRequestBody::set_eeCertRequest(const NewpkiEeRequestCert & c_eeCertRequest)
{
	if(m_type != 83)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeCertRequest) = c_eeCertRequest;
	m_isOk=true;
	return true;
}

const NewpkiEeRequestCert & AdminRequestBody::get_eeCertRequest() const
{
	if((m_type != 83) || !m_eeCertRequest)
	{
		return NewpkiEeRequestCert::EmptyInstance;
	}
	return (*m_eeCertRequest);
}

NewpkiEeRequestCert & AdminRequestBody::get_eeCertRequest()
{
	if((m_type != 83) || !m_eeCertRequest)
	{
		return NewpkiEeRequestCert::EmptyInstance;
	}
	return (*m_eeCertRequest);
}

bool AdminRequestBody::set_eeCertRevoke(const WebuserRevokeCert & c_eeCertRevoke)
{
	if(m_type != 88)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_eeCertRevoke) = c_eeCertRevoke;
	m_isOk=true;
	return true;
}

const WebuserRevokeCert & AdminRequestBody::get_eeCertRevoke() const
{
	if((m_type != 88) || !m_eeCertRevoke)
	{
		return WebuserRevokeCert::EmptyInstance;
	}
	return (*m_eeCertRevoke);
}

WebuserRevokeCert & AdminRequestBody::get_eeCertRevoke()
{
	if((m_type != 88) || !m_eeCertRevoke)
	{
		return WebuserRevokeCert::EmptyInstance;
	}
	return (*m_eeCertRevoke);
}

bool AdminRequestBody::set_entitiesLinks(const mVector< EntityLinks > & c_entitiesLinks)
{
	if(m_type != 37)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_entitiesLinks) = c_entitiesLinks;
	m_isOk=true;
	return true;
}

const mVector< EntityLinks > & AdminRequestBody::get_entitiesLinks() const
{
	if((m_type != 37) || !m_entitiesLinks)
	{
		return mVector< EntityLinks >::EmptyInstance;
	}
	return (*m_entitiesLinks);
}

mVector< EntityLinks > & AdminRequestBody::get_entitiesLinks()
{
	if((m_type != 37) || !m_entitiesLinks)
	{
		return mVector< EntityLinks >::EmptyInstance;
	}
	return (*m_entitiesLinks);
}

bool AdminRequestBody::set_entityAcl(const SEntityAcl & c_entityAcl)
{
	if(m_type != 29)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_entityAcl) = c_entityAcl;
	m_isOk=true;
	return true;
}

const SEntityAcl & AdminRequestBody::get_entityAcl() const
{
	if((m_type != 29) || !m_entityAcl)
	{
		return SEntityAcl::EmptyInstance;
	}
	return (*m_entityAcl);
}

SEntityAcl & AdminRequestBody::get_entityAcl()
{
	if((m_type != 29) || !m_entityAcl)
	{
		return SEntityAcl::EmptyInstance;
	}
	return (*m_entityAcl);
}

bool AdminRequestBody::set_entityAudits(const SEntityAudits & c_entityAudits)
{
	if(m_type != 34)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_entityAudits) = c_entityAudits;
	m_isOk=true;
	return true;
}

const SEntityAudits & AdminRequestBody::get_entityAudits() const
{
	if((m_type != 34) || !m_entityAudits)
	{
		return SEntityAudits::EmptyInstance;
	}
	return (*m_entityAudits);
}

SEntityAudits & AdminRequestBody::get_entityAudits()
{
	if((m_type != 34) || !m_entityAudits)
	{
		return SEntityAudits::EmptyInstance;
	}
	return (*m_entityAudits);
}

bool AdminRequestBody::set_entityCert(const PKI_CERT & c_entityCert)
{
	if(m_type != 21 && m_type != 27 && m_type != 28 && m_type != 33)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_entityCert) = c_entityCert;
	m_isOk=true;
	return true;
}

const PKI_CERT & AdminRequestBody::get_entityCert() const
{
	if((m_type != 21 && m_type != 27 && m_type != 28 && m_type != 33) || !m_entityCert)
	{
		return PKI_CERT::EmptyInstance;
	}
	return (*m_entityCert);
}

PKI_CERT & AdminRequestBody::get_entityCert()
{
	if((m_type != 21 && m_type != 27 && m_type != 28 && m_type != 33) || !m_entityCert)
	{
		return PKI_CERT::EmptyInstance;
	}
	return (*m_entityCert);
}

bool AdminRequestBody::set_entityConf(const SEntityConf & c_entityConf)
{
	if(m_type != 31)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_entityConf) = c_entityConf;
	m_isOk=true;
	return true;
}

const SEntityConf & AdminRequestBody::get_entityConf() const
{
	if((m_type != 31) || !m_entityConf)
	{
		return SEntityConf::EmptyInstance;
	}
	return (*m_entityConf);
}

SEntityConf & AdminRequestBody::get_entityConf()
{
	if((m_type != 31) || !m_entityConf)
	{
		return SEntityConf::EmptyInstance;
	}
	return (*m_entityConf);
}

bool AdminRequestBody::set_entityMailConf(const SEntityMailConf & c_entityMailConf)
{
	if(m_type != 30)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_entityMailConf) = c_entityMailConf;
	m_isOk=true;
	return true;
}

const SEntityMailConf & AdminRequestBody::get_entityMailConf() const
{
	if((m_type != 30) || !m_entityMailConf)
	{
		return SEntityMailConf::EmptyInstance;
	}
	return (*m_entityMailConf);
}

SEntityMailConf & AdminRequestBody::get_entityMailConf()
{
	if((m_type != 30) || !m_entityMailConf)
	{
		return SEntityMailConf::EmptyInstance;
	}
	return (*m_entityMailConf);
}

bool AdminRequestBody::set_entityName(const mString & c_entityName)
{
	if(m_type != 2 && m_type != 72 && m_type != 73)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_entityName) = c_entityName;
	m_isOk=true;
	return true;
}

const mString & AdminRequestBody::get_entityName() const
{
	if((m_type != 2 && m_type != 72 && m_type != 73) || !m_entityName)
	{
		return mString::EmptyInstance;
	}
	return (*m_entityName);
}

mString & AdminRequestBody::get_entityName()
{
	if((m_type != 2 && m_type != 72 && m_type != 73) || !m_entityName)
	{
		return mString::EmptyInstance;
	}
	return (*m_entityName);
}

bool AdminRequestBody::set_entityType(unsigned long c_entityType)
{
	if(m_type != 35)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_entityType) = c_entityType;
	m_isOk=true;
	return true;
}

unsigned long AdminRequestBody::get_entityType() const
{
	if((m_type != 35) || !m_entityType)
	{
		return 0;
	}
	return (*m_entityType);
}

bool AdminRequestBody::set_enumLogs(const AdminReqEnumLogs & c_enumLogs)
{
	if(m_type != 7 && m_type != 65)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_enumLogs) = c_enumLogs;
	m_isOk=true;
	return true;
}

const AdminReqEnumLogs & AdminRequestBody::get_enumLogs() const
{
	if((m_type != 7 && m_type != 65) || !m_enumLogs)
	{
		return AdminReqEnumLogs::EmptyInstance;
	}
	return (*m_enumLogs);
}

AdminReqEnumLogs & AdminRequestBody::get_enumLogs()
{
	if((m_type != 7 && m_type != 65) || !m_enumLogs)
	{
		return AdminReqEnumLogs::EmptyInstance;
	}
	return (*m_enumLogs);
}

bool AdminRequestBody::set_enumObjects(const ObjectsEnum & c_enumObjects)
{
	if(m_type != 42 && m_type != 43 && m_type != 59 && m_type != 89)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_enumObjects) = c_enumObjects;
	m_isOk=true;
	return true;
}

const ObjectsEnum & AdminRequestBody::get_enumObjects() const
{
	if((m_type != 42 && m_type != 43 && m_type != 59 && m_type != 89) || !m_enumObjects)
	{
		return ObjectsEnum::EmptyInstance;
	}
	return (*m_enumObjects);
}

ObjectsEnum & AdminRequestBody::get_enumObjects()
{
	if((m_type != 42 && m_type != 43 && m_type != 59 && m_type != 89) || !m_enumObjects)
	{
		return ObjectsEnum::EmptyInstance;
	}
	return (*m_enumObjects);
}

bool AdminRequestBody::set_groupId(unsigned long c_groupId)
{
	if(m_type != 51)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_groupId) = c_groupId;
	m_isOk=true;
	return true;
}

unsigned long AdminRequestBody::get_groupId() const
{
	if((m_type != 51) || !m_groupId)
	{
		return 0;
	}
	return (*m_groupId);
}

bool AdminRequestBody::set_groupName(const mString & c_groupName)
{
	if(m_type != 50)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_groupName) = c_groupName;
	m_isOk=true;
	return true;
}

const mString & AdminRequestBody::get_groupName() const
{
	if((m_type != 50) || !m_groupName)
	{
		return mString::EmptyInstance;
	}
	return (*m_groupName);
}

mString & AdminRequestBody::get_groupName()
{
	if((m_type != 50) || !m_groupName)
	{
		return mString::EmptyInstance;
	}
	return (*m_groupName);
}

bool AdminRequestBody::set_groups(const mVector< UsersGroup > & c_groups)
{
	if(m_type != 49)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_groups) = c_groups;
	m_isOk=true;
	return true;
}

const mVector< UsersGroup > & AdminRequestBody::get_groups() const
{
	if((m_type != 49) || !m_groups)
	{
		return mVector< UsersGroup >::EmptyInstance;
	}
	return (*m_groups);
}

mVector< UsersGroup > & AdminRequestBody::get_groups()
{
	if((m_type != 49) || !m_groups)
	{
		return mVector< UsersGroup >::EmptyInstance;
	}
	return (*m_groups);
}

bool AdminRequestBody::set_initEntity(const EntityInitReq & c_initEntity)
{
	if(m_type != 20)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_initEntity) = c_initEntity;
	m_isOk=true;
	return true;
}

const EntityInitReq & AdminRequestBody::get_initEntity() const
{
	if((m_type != 20) || !m_initEntity)
	{
		return EntityInitReq::EmptyInstance;
	}
	return (*m_initEntity);
}

EntityInitReq & AdminRequestBody::get_initEntity()
{
	if((m_type != 20) || !m_initEntity)
	{
		return EntityInitReq::EmptyInstance;
	}
	return (*m_initEntity);
}

bool AdminRequestBody::set_knownObjects(const ObjectsListSynchro & c_knownObjects)
{
	if(m_type != 62)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_knownObjects) = c_knownObjects;
	m_isOk=true;
	return true;
}

const ObjectsListSynchro & AdminRequestBody::get_knownObjects() const
{
	if((m_type != 62) || !m_knownObjects)
	{
		return ObjectsListSynchro::EmptyInstance;
	}
	return (*m_knownObjects);
}

ObjectsListSynchro & AdminRequestBody::get_knownObjects()
{
	if((m_type != 62) || !m_knownObjects)
	{
		return ObjectsListSynchro::EmptyInstance;
	}
	return (*m_knownObjects);
}

bool AdminRequestBody::set_ldapSearch(const mString & c_ldapSearch)
{
	if(m_type != 66)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_ldapSearch) = c_ldapSearch;
	m_isOk=true;
	return true;
}

const mString & AdminRequestBody::get_ldapSearch() const
{
	if((m_type != 66) || !m_ldapSearch)
	{
		return mString::EmptyInstance;
	}
	return (*m_ldapSearch);
}

mString & AdminRequestBody::get_ldapSearch()
{
	if((m_type != 66) || !m_ldapSearch)
	{
		return mString::EmptyInstance;
	}
	return (*m_ldapSearch);
}

bool AdminRequestBody::set_login(const AdminReqLogin & c_login)
{
	if(m_type != 0)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_login) = c_login;
	m_isOk=true;
	return true;
}

const AdminReqLogin & AdminRequestBody::get_login() const
{
	if((m_type != 0) || !m_login)
	{
		return AdminReqLogin::EmptyInstance;
	}
	return (*m_login);
}

AdminReqLogin & AdminRequestBody::get_login()
{
	if((m_type != 0) || !m_login)
	{
		return AdminReqLogin::EmptyInstance;
	}
	return (*m_login);
}

bool AdminRequestBody::set_newReq(const CryptedNewpkiRequest & c_newReq)
{
	if(m_type != 56)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_newReq) = c_newReq;
	m_isOk=true;
	return true;
}

const CryptedNewpkiRequest & AdminRequestBody::get_newReq() const
{
	if((m_type != 56) || !m_newReq)
	{
		return CryptedNewpkiRequest::EmptyInstance;
	}
	return (*m_newReq);
}

CryptedNewpkiRequest & AdminRequestBody::get_newReq()
{
	if((m_type != 56) || !m_newReq)
	{
		return CryptedNewpkiRequest::EmptyInstance;
	}
	return (*m_newReq);
}

bool AdminRequestBody::set_newResp(const CryptedNewpkiResponse & c_newResp)
{
	if(m_type != 57)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_newResp) = c_newResp;
	m_isOk=true;
	return true;
}

const CryptedNewpkiResponse & AdminRequestBody::get_newResp() const
{
	if((m_type != 57) || !m_newResp)
	{
		return CryptedNewpkiResponse::EmptyInstance;
	}
	return (*m_newResp);
}

CryptedNewpkiResponse & AdminRequestBody::get_newResp()
{
	if((m_type != 57) || !m_newResp)
	{
		return CryptedNewpkiResponse::EmptyInstance;
	}
	return (*m_newResp);
}

bool AdminRequestBody::set_offline(unsigned long c_offline)
{
	if(m_type != 15)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_offline) = c_offline;
	m_isOk=true;
	return true;
}

unsigned long AdminRequestBody::get_offline() const
{
	if((m_type != 15) || !m_offline)
	{
		return 0;
	}
	return (*m_offline);
}

bool AdminRequestBody::set_other(const ASN1_NULL * c_other)
{
	if(m_type != 3 && m_type != 5 && m_type != 16 && m_type != 17 && m_type != 18 && m_type != 19 && m_type != 22 && m_type != 24 && m_type != 36 && m_type != 40 && m_type != 48 && m_type != 53 && m_type != 55 && m_type != 61 && m_type != 63)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	if(m_other)
		ASN1_item_free((ASN1_VALUE*)m_other, ASN1_ITEM_rptr(ASN1_NULL));
	m_other = (ASN1_NULL*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_NULL), (void*)c_other);
	if(!m_other)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	m_isOk=true;
	return true;
}

const ASN1_NULL * AdminRequestBody::get_other() const
{
	if((m_type != 3 && m_type != 5 && m_type != 16 && m_type != 17 && m_type != 18 && m_type != 19 && m_type != 22 && m_type != 24 && m_type != 36 && m_type != 40 && m_type != 48 && m_type != 53 && m_type != 55 && m_type != 61 && m_type != 63) || !m_other)
	{
		return NULL;
	}
	if(!m_other)
		((AdminRequestBody*)this)->m_other = (ASN1_NULL*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_NULL));
	return m_other;
}

ASN1_NULL * AdminRequestBody::get_other()
{
	if((m_type != 3 && m_type != 5 && m_type != 16 && m_type != 17 && m_type != 18 && m_type != 19 && m_type != 22 && m_type != 24 && m_type != 36 && m_type != 40 && m_type != 48 && m_type != 53 && m_type != 55 && m_type != 61 && m_type != 63) || !m_other)
	{
		return NULL;
	}
	if(!m_other)
		m_other = (ASN1_NULL*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_NULL));
	return m_other;
}

bool AdminRequestBody::set_p12Import(const CaP12Import & c_p12Import)
{
	if(m_type != 75)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_p12Import) = c_p12Import;
	m_isOk=true;
	return true;
}

const CaP12Import & AdminRequestBody::get_p12Import() const
{
	if((m_type != 75) || !m_p12Import)
	{
		return CaP12Import::EmptyInstance;
	}
	return (*m_p12Import);
}

CaP12Import & AdminRequestBody::get_p12Import()
{
	if((m_type != 75) || !m_p12Import)
	{
		return CaP12Import::EmptyInstance;
	}
	return (*m_p12Import);
}

bool AdminRequestBody::set_p7b(const PKI_P7B & c_p7b)
{
	if(m_type != 46)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_p7b) = c_p7b;
	m_isOk=true;
	return true;
}

const PKI_P7B & AdminRequestBody::get_p7b() const
{
	if((m_type != 46) || !m_p7b)
	{
		return PKI_P7B::EmptyInstance;
	}
	return (*m_p7b);
}

PKI_P7B & AdminRequestBody::get_p7b()
{
	if((m_type != 46) || !m_p7b)
	{
		return PKI_P7B::EmptyInstance;
	}
	return (*m_p7b);
}

bool AdminRequestBody::set_profile(const NewpkiProfile & c_profile)
{
	if(m_type != 54)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_profile) = c_profile;
	m_isOk=true;
	return true;
}

const NewpkiProfile & AdminRequestBody::get_profile() const
{
	if((m_type != 54) || !m_profile)
	{
		return NewpkiProfile::EmptyInstance;
	}
	return (*m_profile);
}

NewpkiProfile & AdminRequestBody::get_profile()
{
	if((m_type != 54) || !m_profile)
	{
		return NewpkiProfile::EmptyInstance;
	}
	return (*m_profile);
}

bool AdminRequestBody::set_profileDn(const ProfileChangeDn & c_profileDn)
{
	if(m_type != 71)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_profileDn) = c_profileDn;
	m_isOk=true;
	return true;
}

const ProfileChangeDn & AdminRequestBody::get_profileDn() const
{
	if((m_type != 71) || !m_profileDn)
	{
		return ProfileChangeDn::EmptyInstance;
	}
	return (*m_profileDn);
}

ProfileChangeDn & AdminRequestBody::get_profileDn()
{
	if((m_type != 71) || !m_profileDn)
	{
		return ProfileChangeDn::EmptyInstance;
	}
	return (*m_profileDn);
}

bool AdminRequestBody::set_profileId(unsigned long c_profileId)
{
	if(m_type != 70 && m_type != 81 && m_type != 84 && m_type != 87)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_profileId) = c_profileId;
	m_isOk=true;
	return true;
}

unsigned long AdminRequestBody::get_profileId() const
{
	if((m_type != 70 && m_type != 81 && m_type != 84 && m_type != 87) || !m_profileId)
	{
		return 0;
	}
	return (*m_profileId);
}

bool AdminRequestBody::set_profileOwner(const ProfileChangeOwner & c_profileOwner)
{
	if(m_type != 69)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_profileOwner) = c_profileOwner;
	m_isOk=true;
	return true;
}

const ProfileChangeOwner & AdminRequestBody::get_profileOwner() const
{
	if((m_type != 69) || !m_profileOwner)
	{
		return ProfileChangeOwner::EmptyInstance;
	}
	return (*m_profileOwner);
}

ProfileChangeOwner & AdminRequestBody::get_profileOwner()
{
	if((m_type != 69) || !m_profileOwner)
	{
		return ProfileChangeOwner::EmptyInstance;
	}
	return (*m_profileOwner);
}

bool AdminRequestBody::set_profileUid(const ProfileChangeUid & c_profileUid)
{
	if(m_type != 68)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_profileUid) = c_profileUid;
	m_isOk=true;
	return true;
}

const ProfileChangeUid & AdminRequestBody::get_profileUid() const
{
	if((m_type != 68) || !m_profileUid)
	{
		return ProfileChangeUid::EmptyInstance;
	}
	return (*m_profileUid);
}

ProfileChangeUid & AdminRequestBody::get_profileUid()
{
	if((m_type != 68) || !m_profileUid)
	{
		return ProfileChangeUid::EmptyInstance;
	}
	return (*m_profileUid);
}

bool AdminRequestBody::set_rejectProfile(const ProfileReject & c_rejectProfile)
{
	if(m_type != 82)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_rejectProfile) = c_rejectProfile;
	m_isOk=true;
	return true;
}

const ProfileReject & AdminRequestBody::get_rejectProfile() const
{
	if((m_type != 82) || !m_rejectProfile)
	{
		return ProfileReject::EmptyInstance;
	}
	return (*m_rejectProfile);
}

ProfileReject & AdminRequestBody::get_rejectProfile()
{
	if((m_type != 82) || !m_rejectProfile)
	{
		return ProfileReject::EmptyInstance;
	}
	return (*m_rejectProfile);
}

bool AdminRequestBody::set_renameGroup(const SRenameGroup & c_renameGroup)
{
	if(m_type != 52)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_renameGroup) = c_renameGroup;
	m_isOk=true;
	return true;
}

const SRenameGroup & AdminRequestBody::get_renameGroup() const
{
	if((m_type != 52) || !m_renameGroup)
	{
		return SRenameGroup::EmptyInstance;
	}
	return (*m_renameGroup);
}

SRenameGroup & AdminRequestBody::get_renameGroup()
{
	if((m_type != 52) || !m_renameGroup)
	{
		return SRenameGroup::EmptyInstance;
	}
	return (*m_renameGroup);
}

bool AdminRequestBody::set_repositories(const mVector< RepEntryInfo > & c_repositories)
{
	if(m_type != 23)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_repositories) = c_repositories;
	m_isOk=true;
	return true;
}

const mVector< RepEntryInfo > & AdminRequestBody::get_repositories() const
{
	if((m_type != 23) || !m_repositories)
	{
		return mVector< RepEntryInfo >::EmptyInstance;
	}
	return (*m_repositories);
}

mVector< RepEntryInfo > & AdminRequestBody::get_repositories()
{
	if((m_type != 23) || !m_repositories)
	{
		return mVector< RepEntryInfo >::EmptyInstance;
	}
	return (*m_repositories);
}

bool AdminRequestBody::set_requestId(unsigned long c_requestId)
{
	if(m_type != 74)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_requestId) = c_requestId;
	m_isOk=true;
	return true;
}

unsigned long AdminRequestBody::get_requestId() const
{
	if((m_type != 74) || !m_requestId)
	{
		return 0;
	}
	return (*m_requestId);
}

bool AdminRequestBody::set_resourceName(const mString & c_resourceName)
{
	if(m_type != 25 && m_type != 26)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_resourceName) = c_resourceName;
	m_isOk=true;
	return true;
}

const mString & AdminRequestBody::get_resourceName() const
{
	if((m_type != 25 && m_type != 26) || !m_resourceName)
	{
		return mString::EmptyInstance;
	}
	return (*m_resourceName);
}

mString & AdminRequestBody::get_resourceName()
{
	if((m_type != 25 && m_type != 26) || !m_resourceName)
	{
		return mString::EmptyInstance;
	}
	return (*m_resourceName);
}

bool AdminRequestBody::set_serial(unsigned long c_serial)
{
	if(m_type != 12 && m_type != 13 && m_type != 47 && m_type != 64 && m_type != 85 && m_type != 86)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_serial) = c_serial;
	m_isOk=true;
	return true;
}

unsigned long AdminRequestBody::get_serial() const
{
	if((m_type != 12 && m_type != 13 && m_type != 47 && m_type != 64 && m_type != 85 && m_type != 86) || !m_serial)
	{
		return 0;
	}
	return (*m_serial);
}

bool AdminRequestBody::set_signCsr(const SignCsr & c_signCsr)
{
	if(m_type != 44)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_signCsr) = c_signCsr;
	m_isOk=true;
	return true;
}

const SignCsr & AdminRequestBody::get_signCsr() const
{
	if((m_type != 44) || !m_signCsr)
	{
		return SignCsr::EmptyInstance;
	}
	return (*m_signCsr);
}

SignCsr & AdminRequestBody::get_signCsr()
{
	if((m_type != 44) || !m_signCsr)
	{
		return SignCsr::EmptyInstance;
	}
	return (*m_signCsr);
}

bool AdminRequestBody::set_signEntity(const EntitySignatureReq & c_signEntity)
{
	if(m_type != 10)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_signEntity) = c_signEntity;
	m_isOk=true;
	return true;
}

const EntitySignatureReq & AdminRequestBody::get_signEntity() const
{
	if((m_type != 10) || !m_signEntity)
	{
		return EntitySignatureReq::EmptyInstance;
	}
	return (*m_signEntity);
}

EntitySignatureReq & AdminRequestBody::get_signEntity()
{
	if((m_type != 10) || !m_signEntity)
	{
		return EntitySignatureReq::EmptyInstance;
	}
	return (*m_signEntity);
}

bool AdminRequestBody::set_transactionId(const Asn1OctetString & c_transactionId)
{
	if(m_type != 67)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_transactionId) = c_transactionId;
	m_isOk=true;
	return true;
}

const Asn1OctetString & AdminRequestBody::get_transactionId() const
{
	if((m_type != 67) || !m_transactionId)
	{
		return Asn1OctetString::EmptyInstance;
	}
	return (*m_transactionId);
}

Asn1OctetString & AdminRequestBody::get_transactionId()
{
	if((m_type != 67) || !m_transactionId)
	{
		return Asn1OctetString::EmptyInstance;
	}
	return (*m_transactionId);
}

bool AdminRequestBody::set_transactionsIds(const TransactionIds & c_transactionsIds)
{
	if(m_type != 41 && m_type != 58)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_transactionsIds) = c_transactionsIds;
	m_isOk=true;
	return true;
}

const TransactionIds & AdminRequestBody::get_transactionsIds() const
{
	if((m_type != 41 && m_type != 58) || !m_transactionsIds)
	{
		return TransactionIds::EmptyInstance;
	}
	return (*m_transactionsIds);
}

TransactionIds & AdminRequestBody::get_transactionsIds()
{
	if((m_type != 41 && m_type != 58) || !m_transactionsIds)
	{
		return TransactionIds::EmptyInstance;
	}
	return (*m_transactionsIds);
}

bool AdminRequestBody::set_updUser(const UserEntry & c_updUser)
{
	if(m_type != 6)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_updUser) = c_updUser;
	m_isOk=true;
	return true;
}

const UserEntry & AdminRequestBody::get_updUser() const
{
	if((m_type != 6) || !m_updUser)
	{
		return UserEntry::EmptyInstance;
	}
	return (*m_updUser);
}

UserEntry & AdminRequestBody::get_updUser()
{
	if((m_type != 6) || !m_updUser)
	{
		return UserEntry::EmptyInstance;
	}
	return (*m_updUser);
}

bool AdminRequestBody::set_waitingObj(const WaitingNewpkiObject & c_waitingObj)
{
	if(m_type != 38)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_waitingObj) = c_waitingObj;
	m_isOk=true;
	return true;
}

const WaitingNewpkiObject & AdminRequestBody::get_waitingObj() const
{
	if((m_type != 38) || !m_waitingObj)
	{
		return WaitingNewpkiObject::EmptyInstance;
	}
	return (*m_waitingObj);
}

WaitingNewpkiObject & AdminRequestBody::get_waitingObj()
{
	if((m_type != 38) || !m_waitingObj)
	{
		return WaitingNewpkiObject::EmptyInstance;
	}
	return (*m_waitingObj);
}

bool AdminRequestBody::set_webChgPasswd(const WebuserChangePasswd & c_webChgPasswd)
{
	if(m_type != 90)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_webChgPasswd) = c_webChgPasswd;
	m_isOk=true;
	return true;
}

const WebuserChangePasswd & AdminRequestBody::get_webChgPasswd() const
{
	if((m_type != 90) || !m_webChgPasswd)
	{
		return WebuserChangePasswd::EmptyInstance;
	}
	return (*m_webChgPasswd);
}

WebuserChangePasswd & AdminRequestBody::get_webChgPasswd()
{
	if((m_type != 90) || !m_webChgPasswd)
	{
		return WebuserChangePasswd::EmptyInstance;
	}
	return (*m_webChgPasswd);
}

bool AdminRequestBody::set_webactivate(const mString & c_webactivate)
{
	if(m_type != 80)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_webactivate) = c_webactivate;
	m_isOk=true;
	return true;
}

const mString & AdminRequestBody::get_webactivate() const
{
	if((m_type != 80) || !m_webactivate)
	{
		return mString::EmptyInstance;
	}
	return (*m_webactivate);
}

mString & AdminRequestBody::get_webactivate()
{
	if((m_type != 80) || !m_webactivate)
	{
		return mString::EmptyInstance;
	}
	return (*m_webactivate);
}

bool AdminRequestBody::set_webcreate(const WebReqCreate & c_webcreate)
{
	if(m_type != 78)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_webcreate) = c_webcreate;
	m_isOk=true;
	return true;
}

const WebReqCreate & AdminRequestBody::get_webcreate() const
{
	if((m_type != 78) || !m_webcreate)
	{
		return WebReqCreate::EmptyInstance;
	}
	return (*m_webcreate);
}

WebReqCreate & AdminRequestBody::get_webcreate()
{
	if((m_type != 78) || !m_webcreate)
	{
		return WebReqCreate::EmptyInstance;
	}
	return (*m_webcreate);
}

bool AdminRequestBody::set_weblogin(const WebReqLogin & c_weblogin)
{
	if(m_type != 79)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		return false;
	}
	(*m_weblogin) = c_weblogin;
	m_isOk=true;
	return true;
}

const WebReqLogin & AdminRequestBody::get_weblogin() const
{
	if((m_type != 79) || !m_weblogin)
	{
		return WebReqLogin::EmptyInstance;
	}
	return (*m_weblogin);
}

WebReqLogin & AdminRequestBody::get_weblogin()
{
	if((m_type != 79) || !m_weblogin)
	{
		return WebReqLogin::EmptyInstance;
	}
	return (*m_weblogin);
}

bool AdminRequestBody::malloc_byType (int c_type)
{
	switch(m_type)
	{
		case 32:
			m_adminMail = new MailDatas();
			if(!m_adminMail)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 60:
			m_certRequest = new NewpkiRequestCert();
			if(!m_certRequest)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 9:
			m_chgPwd = new ChangePasswd();
			if(!m_chgPwd)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 8:
			m_chgUserPwd = new ChangeUserPasswd();
			if(!m_chgUserPwd)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 14:
			m_conf = new ExportedPkiConf();
			if(!m_conf)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 1:
			m_creEntity = new EntityCreationReq();
			if(!m_creEntity)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 4:
			m_creUser = new UserInfo();
			if(!m_creUser)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 45:
			m_createChildCa = new ReqCreateChildCa();
			if(!m_createChildCa)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 11:
			m_createPkiUser = new CreatePkiUserRequest();
			if(!m_createPkiUser)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 39:
			m_createRootCa = new ReqCreateRootCa();
			if(!m_createRootCa)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 77:
			m_dnId = new mString();
			if(!m_dnId)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 76:
			m_dnVal = new DnValidation();
			if(!m_dnVal)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 83:
			m_eeCertRequest = new NewpkiEeRequestCert();
			if(!m_eeCertRequest)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 88:
			m_eeCertRevoke = new WebuserRevokeCert();
			if(!m_eeCertRevoke)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 37:
			m_entitiesLinks = new mVector< EntityLinks >;
			if(!m_entitiesLinks)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 29:
			m_entityAcl = new SEntityAcl();
			if(!m_entityAcl)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 34:
			m_entityAudits = new SEntityAudits();
			if(!m_entityAudits)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 21:
		case 27:
		case 28:
		case 33:
			m_entityCert = new PKI_CERT();
			if(!m_entityCert)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 31:
			m_entityConf = new SEntityConf();
			if(!m_entityConf)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 30:
			m_entityMailConf = new SEntityMailConf();
			if(!m_entityMailConf)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 2:
		case 72:
		case 73:
			m_entityName = new mString();
			if(!m_entityName)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 35:
			m_entityType = (unsigned long*)malloc(sizeof(unsigned long));
			if(!m_entityType)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 7:
		case 65:
			m_enumLogs = new AdminReqEnumLogs();
			if(!m_enumLogs)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 42:
		case 43:
		case 59:
		case 89:
			m_enumObjects = new ObjectsEnum();
			if(!m_enumObjects)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 51:
			m_groupId = (unsigned long*)malloc(sizeof(unsigned long));
			if(!m_groupId)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 50:
			m_groupName = new mString();
			if(!m_groupName)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 49:
			m_groups = new mVector< UsersGroup >;
			if(!m_groups)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 20:
			m_initEntity = new EntityInitReq();
			if(!m_initEntity)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 62:
			m_knownObjects = new ObjectsListSynchro();
			if(!m_knownObjects)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 66:
			m_ldapSearch = new mString();
			if(!m_ldapSearch)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 0:
			m_login = new AdminReqLogin();
			if(!m_login)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 56:
			m_newReq = new CryptedNewpkiRequest();
			if(!m_newReq)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 57:
			m_newResp = new CryptedNewpkiResponse();
			if(!m_newResp)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 15:
			m_offline = (unsigned long*)malloc(sizeof(unsigned long));
			if(!m_offline)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 3:
		case 5:
		case 16:
		case 17:
		case 18:
		case 19:
		case 22:
		case 24:
		case 36:
		case 40:
		case 48:
		case 53:
		case 55:
		case 61:
		case 63:
			m_other = (ASN1_NULL*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_NULL));
			if(!m_other)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 75:
			m_p12Import = new CaP12Import();
			if(!m_p12Import)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 46:
			m_p7b = new PKI_P7B();
			if(!m_p7b)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 54:
			m_profile = new NewpkiProfile();
			if(!m_profile)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 71:
			m_profileDn = new ProfileChangeDn();
			if(!m_profileDn)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 70:
		case 81:
		case 84:
		case 87:
			m_profileId = (unsigned long*)malloc(sizeof(unsigned long));
			if(!m_profileId)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 69:
			m_profileOwner = new ProfileChangeOwner();
			if(!m_profileOwner)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 68:
			m_profileUid = new ProfileChangeUid();
			if(!m_profileUid)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 82:
			m_rejectProfile = new ProfileReject();
			if(!m_rejectProfile)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 52:
			m_renameGroup = new SRenameGroup();
			if(!m_renameGroup)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 23:
			m_repositories = new mVector< RepEntryInfo >;
			if(!m_repositories)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 74:
			m_requestId = (unsigned long*)malloc(sizeof(unsigned long));
			if(!m_requestId)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 25:
		case 26:
			m_resourceName = new mString();
			if(!m_resourceName)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 12:
		case 13:
		case 47:
		case 64:
		case 85:
		case 86:
			m_serial = (unsigned long*)malloc(sizeof(unsigned long));
			if(!m_serial)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 44:
			m_signCsr = new SignCsr();
			if(!m_signCsr)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 10:
			m_signEntity = new EntitySignatureReq();
			if(!m_signEntity)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 67:
			m_transactionId = new Asn1OctetString();
			if(!m_transactionId)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 41:
		case 58:
			m_transactionsIds = new TransactionIds();
			if(!m_transactionsIds)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 6:
			m_updUser = new UserEntry();
			if(!m_updUser)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 38:
			m_waitingObj = new WaitingNewpkiObject();
			if(!m_waitingObj)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 90:
			m_webChgPasswd = new WebuserChangePasswd();
			if(!m_webChgPasswd)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 80:
			m_webactivate = new mString();
			if(!m_webactivate)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 78:
			m_webcreate = new WebReqCreate();
			if(!m_webcreate)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
		case 79:
			m_weblogin = new WebReqLogin();
			if(!m_weblogin)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			break;
	}

	return true;
}

AdminRequestBody::AdminRequestBody():NewPKIObject()
{
	resetAll();
}

AdminRequestBody::AdminRequestBody(const AdminRequestBody & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

AdminRequestBody::~AdminRequestBody()
{
	Clear();
}

void AdminRequestBody::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void AdminRequestBody::freeAll()
{
	if(m_adminMail)
	{
		delete m_adminMail;
	}
	if(m_certRequest)
	{
		delete m_certRequest;
	}
	if(m_chgPwd)
	{
		delete m_chgPwd;
	}
	if(m_chgUserPwd)
	{
		delete m_chgUserPwd;
	}
	if(m_conf)
	{
		delete m_conf;
	}
	if(m_creEntity)
	{
		delete m_creEntity;
	}
	if(m_creUser)
	{
		delete m_creUser;
	}
	if(m_createChildCa)
	{
		delete m_createChildCa;
	}
	if(m_createPkiUser)
	{
		delete m_createPkiUser;
	}
	if(m_createRootCa)
	{
		delete m_createRootCa;
	}
	if(m_dnId)
	{
		delete m_dnId;
	}
	if(m_dnVal)
	{
		delete m_dnVal;
	}
	if(m_eeCertRequest)
	{
		delete m_eeCertRequest;
	}
	if(m_eeCertRevoke)
	{
		delete m_eeCertRevoke;
	}
	if(m_entitiesLinks)
	{
		delete m_entitiesLinks;
	}
	if(m_entityAcl)
	{
		delete m_entityAcl;
	}
	if(m_entityAudits)
	{
		delete m_entityAudits;
	}
	if(m_entityCert)
	{
		delete m_entityCert;
	}
	if(m_entityConf)
	{
		delete m_entityConf;
	}
	if(m_entityMailConf)
	{
		delete m_entityMailConf;
	}
	if(m_entityName)
	{
		delete m_entityName;
	}
	if(m_entityType)
	{
		free(m_entityType);
	}
	if(m_enumLogs)
	{
		delete m_enumLogs;
	}
	if(m_enumObjects)
	{
		delete m_enumObjects;
	}
	if(m_groupId)
	{
		free(m_groupId);
	}
	if(m_groupName)
	{
		delete m_groupName;
	}
	if(m_groups)
	{
		delete m_groups;
	}
	if(m_initEntity)
	{
		delete m_initEntity;
	}
	if(m_knownObjects)
	{
		delete m_knownObjects;
	}
	if(m_ldapSearch)
	{
		delete m_ldapSearch;
	}
	if(m_login)
	{
		delete m_login;
	}
	if(m_newReq)
	{
		delete m_newReq;
	}
	if(m_newResp)
	{
		delete m_newResp;
	}
	if(m_offline)
	{
		free(m_offline);
	}
	if(m_other)
	{
		ASN1_item_free((ASN1_VALUE*)m_other, ASN1_ITEM_rptr(ASN1_NULL));
	}
	if(m_p12Import)
	{
		delete m_p12Import;
	}
	if(m_p7b)
	{
		delete m_p7b;
	}
	if(m_profile)
	{
		delete m_profile;
	}
	if(m_profileDn)
	{
		delete m_profileDn;
	}
	if(m_profileId)
	{
		free(m_profileId);
	}
	if(m_profileOwner)
	{
		delete m_profileOwner;
	}
	if(m_profileUid)
	{
		delete m_profileUid;
	}
	if(m_rejectProfile)
	{
		delete m_rejectProfile;
	}
	if(m_renameGroup)
	{
		delete m_renameGroup;
	}
	if(m_repositories)
	{
		delete m_repositories;
	}
	if(m_requestId)
	{
		free(m_requestId);
	}
	if(m_resourceName)
	{
		delete m_resourceName;
	}
	if(m_serial)
	{
		free(m_serial);
	}
	if(m_signCsr)
	{
		delete m_signCsr;
	}
	if(m_signEntity)
	{
		delete m_signEntity;
	}
	if(m_transactionId)
	{
		delete m_transactionId;
	}
	if(m_transactionsIds)
	{
		delete m_transactionsIds;
	}
	if(m_updUser)
	{
		delete m_updUser;
	}
	if(m_waitingObj)
	{
		delete m_waitingObj;
	}
	if(m_webChgPasswd)
	{
		delete m_webChgPasswd;
	}
	if(m_webactivate)
	{
		delete m_webactivate;
	}
	if(m_webcreate)
	{
		delete m_webcreate;
	}
	if(m_weblogin)
	{
		delete m_weblogin;
	}
}

void AdminRequestBody::resetAll()
{
	m_type = -1;
	m_adminMail = NULL;
	m_certRequest = NULL;
	m_chgPwd = NULL;
	m_chgUserPwd = NULL;
	m_conf = NULL;
	m_creEntity = NULL;
	m_creUser = NULL;
	m_createChildCa = NULL;
	m_createPkiUser = NULL;
	m_createRootCa = NULL;
	m_dnId = NULL;
	m_dnVal = NULL;
	m_eeCertRequest = NULL;
	m_eeCertRevoke = NULL;
	m_entitiesLinks = NULL;
	m_entityAcl = NULL;
	m_entityAudits = NULL;
	m_entityCert = NULL;
	m_entityConf = NULL;
	m_entityMailConf = NULL;
	m_entityName = NULL;
	m_entityType = NULL;
	m_enumLogs = NULL;
	m_enumObjects = NULL;
	m_groupId = NULL;
	m_groupName = NULL;
	m_groups = NULL;
	m_initEntity = NULL;
	m_knownObjects = NULL;
	m_ldapSearch = NULL;
	m_login = NULL;
	m_newReq = NULL;
	m_newResp = NULL;
	m_offline = NULL;
	m_other = NULL;
	m_p12Import = NULL;
	m_p7b = NULL;
	m_profile = NULL;
	m_profileDn = NULL;
	m_profileId = NULL;
	m_profileOwner = NULL;
	m_profileUid = NULL;
	m_rejectProfile = NULL;
	m_renameGroup = NULL;
	m_repositories = NULL;
	m_requestId = NULL;
	m_resourceName = NULL;
	m_serial = NULL;
	m_signCsr = NULL;
	m_signEntity = NULL;
	m_transactionId = NULL;
	m_transactionsIds = NULL;
	m_updUser = NULL;
	m_waitingObj = NULL;
	m_webChgPasswd = NULL;
	m_webactivate = NULL;
	m_webcreate = NULL;
	m_weblogin = NULL;
}

bool AdminRequestBody::load_Datas(const ADMIN_REQUEST_BODY * Datas)
{
	Clear();
	REP_ENTRY_INFO * currrepositories;
	USERS_GROUP * currgroups;
	int i;
	ENTITY_LINKS * currentitiesLinks;
	if(!set_type(Datas->type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(Datas->type)
	{
		case 32:
			if(Datas->d.admin_mail)
			{
				if(!(*m_adminMail).load_Datas(Datas->d.admin_mail))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 60:
			if(Datas->d.cert_request)
			{
				if(!(*m_certRequest).load_Datas(Datas->d.cert_request))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 9:
			if(Datas->d.chg_pwd)
			{
				if(!(*m_chgPwd).load_Datas(Datas->d.chg_pwd))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 8:
			if(Datas->d.chg_user_pwd)
			{
				if(!(*m_chgUserPwd).load_Datas(Datas->d.chg_user_pwd))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 14:
			if(Datas->d.conf)
			{
				if(!(*m_conf).load_Datas(Datas->d.conf))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 1:
			if(Datas->d.cre_entity)
			{
				if(!(*m_creEntity).load_Datas(Datas->d.cre_entity))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 4:
			if(Datas->d.cre_user)
			{
				if(!(*m_creUser).load_Datas(Datas->d.cre_user))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 45:
			if(Datas->d.create_child_ca)
			{
				if(!(*m_createChildCa).load_Datas(Datas->d.create_child_ca))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 11:
			if(Datas->d.create_pki_user)
			{
				if(!(*m_createPkiUser).load_Datas(Datas->d.create_pki_user))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 39:
			if(Datas->d.create_root_ca)
			{
				if(!(*m_createRootCa).load_Datas(Datas->d.create_root_ca))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 77:
			if(Datas->d.dn_id)
			{
				(*m_dnId) = Datas->d.dn_id;
			}
			break;
		case 76:
			if(Datas->d.dn_val)
			{
				if(!(*m_dnVal).load_Datas(Datas->d.dn_val))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 83:
			if(Datas->d.ee_cert_request)
			{
				if(!(*m_eeCertRequest).load_Datas(Datas->d.ee_cert_request))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 88:
			if(Datas->d.ee_cert_revoke)
			{
				if(!(*m_eeCertRevoke).load_Datas(Datas->d.ee_cert_revoke))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 37:
			if(Datas->d.entities_links)
			{
				for(i=0; i<SKM_sk_num(ENTITY_LINKS, Datas->d.entities_links); i++)
				{
					currentitiesLinks = SKM_sk_value(ENTITY_LINKS, Datas->d.entities_links, i);
					if(!currentitiesLinks)
					{
						NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
						return false;
					}
					(*m_entitiesLinks).insert((*m_entitiesLinks).begin() + i);
					if(!(*m_entitiesLinks)[i].load_Datas(currentitiesLinks))
					{
						NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
						return false;
					}
				}
			}
			break;
		case 29:
			if(Datas->d.entity_acl)
			{
				if(!(*m_entityAcl).load_Datas(Datas->d.entity_acl))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 34:
			if(Datas->d.entity_audits)
			{
				if(!(*m_entityAudits).load_Datas(Datas->d.entity_audits))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 21:
		case 27:
		case 28:
		case 33:
			if(Datas->d.entity_cert)
			{
				if(!(*m_entityCert).load_Datas(Datas->d.entity_cert))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 31:
			if(Datas->d.entity_conf)
			{
				if(!(*m_entityConf).load_Datas(Datas->d.entity_conf))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 30:
			if(Datas->d.entity_mail_conf)
			{
				if(!(*m_entityMailConf).load_Datas(Datas->d.entity_mail_conf))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 2:
		case 72:
		case 73:
			if(Datas->d.entity_name)
			{
				(*m_entityName) = Datas->d.entity_name;
			}
			break;
		case 35:
			if(Datas->d.entity_type)
			{
				(*m_entityType) = ASN1_INTEGER_GET(Datas->d.entity_type);
			}
			break;
		case 7:
		case 65:
			if(Datas->d.enum_logs)
			{
				if(!(*m_enumLogs).load_Datas(Datas->d.enum_logs))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 42:
		case 43:
		case 59:
		case 89:
			if(Datas->d.enum_objects)
			{
				if(!(*m_enumObjects).load_Datas(Datas->d.enum_objects))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 51:
			if(Datas->d.group_id)
			{
				(*m_groupId) = ASN1_INTEGER_GET(Datas->d.group_id);
			}
			break;
		case 50:
			if(Datas->d.group_name)
			{
				(*m_groupName) = Datas->d.group_name;
			}
			break;
		case 49:
			if(Datas->d.groups)
			{
				for(i=0; i<SKM_sk_num(USERS_GROUP, Datas->d.groups); i++)
				{
					currgroups = SKM_sk_value(USERS_GROUP, Datas->d.groups, i);
					if(!currgroups)
					{
						NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
						return false;
					}
					(*m_groups).insert((*m_groups).begin() + i);
					if(!(*m_groups)[i].load_Datas(currgroups))
					{
						NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
						return false;
					}
				}
			}
			break;
		case 20:
			if(Datas->d.init_entity)
			{
				if(!(*m_initEntity).load_Datas(Datas->d.init_entity))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 62:
			if(Datas->d.known_objects)
			{
				if(!(*m_knownObjects).load_Datas(Datas->d.known_objects))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 66:
			if(Datas->d.ldap_search)
			{
				(*m_ldapSearch) = Datas->d.ldap_search;
			}
			break;
		case 0:
			if(Datas->d.login)
			{
				if(!(*m_login).load_Datas(Datas->d.login))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 56:
			if(Datas->d.new_req)
			{
				if(!(*m_newReq).load_Datas(Datas->d.new_req))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 57:
			if(Datas->d.new_resp)
			{
				if(!(*m_newResp).load_Datas(Datas->d.new_resp))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 15:
			if(Datas->d.offline)
			{
				(*m_offline) = ASN1_INTEGER_GET(Datas->d.offline);
			}
			break;
		case 3:
		case 5:
		case 16:
		case 17:
		case 18:
		case 19:
		case 22:
		case 24:
		case 36:
		case 40:
		case 48:
		case 53:
		case 55:
		case 61:
		case 63:
			if(Datas->d.other)
			{
				if(m_other)
					ASN1_item_free((ASN1_VALUE*)m_other, ASN1_ITEM_rptr(ASN1_NULL));
				m_other = (ASN1_NULL*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_NULL), Datas->d.other);
				if(!m_other)
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
					return false;
				}
			}
			break;
		case 75:
			if(Datas->d.p12_import)
			{
				if(!(*m_p12Import).load_Datas(Datas->d.p12_import))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 46:
			if(Datas->d.p7b)
			{
				if(!(*m_p7b).load_Datas(Datas->d.p7b))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 54:
			if(Datas->d.profile)
			{
				if(!(*m_profile).load_Datas(Datas->d.profile))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 71:
			if(Datas->d.profile_dn)
			{
				if(!(*m_profileDn).load_Datas(Datas->d.profile_dn))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 70:
		case 81:
		case 84:
		case 87:
			if(Datas->d.profile_id)
			{
				(*m_profileId) = ASN1_INTEGER_GET(Datas->d.profile_id);
			}
			break;
		case 69:
			if(Datas->d.profile_owner)
			{
				if(!(*m_profileOwner).load_Datas(Datas->d.profile_owner))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 68:
			if(Datas->d.profile_uid)
			{
				if(!(*m_profileUid).load_Datas(Datas->d.profile_uid))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 82:
			if(Datas->d.reject_profile)
			{
				if(!(*m_rejectProfile).load_Datas(Datas->d.reject_profile))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 52:
			if(Datas->d.rename_group)
			{
				if(!(*m_renameGroup).load_Datas(Datas->d.rename_group))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 23:
			if(Datas->d.repositories)
			{
				for(i=0; i<SKM_sk_num(REP_ENTRY_INFO, Datas->d.repositories); i++)
				{
					currrepositories = SKM_sk_value(REP_ENTRY_INFO, Datas->d.repositories, i);
					if(!currrepositories)
					{
						NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
						return false;
					}
					(*m_repositories).insert((*m_repositories).begin() + i);
					if(!(*m_repositories)[i].load_Datas(currrepositories))
					{
						NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
						return false;
					}
				}
			}
			break;
		case 74:
			if(Datas->d.request_id)
			{
				(*m_requestId) = ASN1_INTEGER_GET(Datas->d.request_id);
			}
			break;
		case 25:
		case 26:
			if(Datas->d.resource_name)
			{
				(*m_resourceName) = Datas->d.resource_name;
			}
			break;
		case 12:
		case 13:
		case 47:
		case 64:
		case 85:
		case 86:
			if(Datas->d.serial)
			{
				(*m_serial) = ASN1_INTEGER_GET(Datas->d.serial);
			}
			break;
		case 44:
			if(Datas->d.sign_csr)
			{
				if(!(*m_signCsr).load_Datas(Datas->d.sign_csr))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 10:
			if(Datas->d.sign_entity)
			{
				if(!(*m_signEntity).load_Datas(Datas->d.sign_entity))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 67:
			if(Datas->d.transaction_id)
			{
				if(!(*m_transactionId).load_Datas(Datas->d.transaction_id))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 41:
		case 58:
			if(Datas->d.transactions_ids)
			{
				if(!(*m_transactionsIds).load_Datas(Datas->d.transactions_ids))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 6:
			if(Datas->d.upd_user)
			{
				if(!(*m_updUser).load_Datas(Datas->d.upd_user))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 38:
			if(Datas->d.waiting_obj)
			{
				if(!(*m_waitingObj).load_Datas(Datas->d.waiting_obj))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 90:
			if(Datas->d.web_chg_passwd)
			{
				if(!(*m_webChgPasswd).load_Datas(Datas->d.web_chg_passwd))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 80:
			if(Datas->d.webactivate)
			{
				(*m_webactivate) = Datas->d.webactivate;
			}
			break;
		case 78:
			if(Datas->d.webcreate)
			{
				if(!(*m_webcreate).load_Datas(Datas->d.webcreate))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 79:
			if(Datas->d.weblogin)
			{
				if(!(*m_weblogin).load_Datas(Datas->d.weblogin))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
	}
	m_isOk=true;
	return true;
}

bool AdminRequestBody::give_Datas(ADMIN_REQUEST_BODY ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ADMIN_REQUEST_BODY*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
			REP_ENTRY_INFO * currrepositories;
			USERS_GROUP * currgroups;
			ENTITY_LINKS * currentitiesLinks;
	size_t i;
	(*Datas)->type = m_type;
	switch(m_type)
	{
		case 32:
			if(!((*Datas)->d.admin_mail = (MAIL_DATAS*)ASN1_item_new(ASN1_ITEM_rptr(MAIL_DATAS))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_adminMail).give_Datas(&(*Datas)->d.admin_mail))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.admin_mail, ASN1_ITEM_rptr(MAIL_DATAS));
				(*Datas)->d.admin_mail = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 60:
			if(!((*Datas)->d.cert_request = (NEWPKI_REQUEST_CERT*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_REQUEST_CERT))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_certRequest).give_Datas(&(*Datas)->d.cert_request))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.cert_request, ASN1_ITEM_rptr(NEWPKI_REQUEST_CERT));
				(*Datas)->d.cert_request = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 9:
			if(!((*Datas)->d.chg_pwd = (CHANGE_PASSWD*)ASN1_item_new(ASN1_ITEM_rptr(CHANGE_PASSWD))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_chgPwd).give_Datas(&(*Datas)->d.chg_pwd))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.chg_pwd, ASN1_ITEM_rptr(CHANGE_PASSWD));
				(*Datas)->d.chg_pwd = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 8:
			if(!((*Datas)->d.chg_user_pwd = (CHANGE_USER_PASSWD*)ASN1_item_new(ASN1_ITEM_rptr(CHANGE_USER_PASSWD))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_chgUserPwd).give_Datas(&(*Datas)->d.chg_user_pwd))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.chg_user_pwd, ASN1_ITEM_rptr(CHANGE_USER_PASSWD));
				(*Datas)->d.chg_user_pwd = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 14:
			if(!((*Datas)->d.conf = (EXPORTED_PKI_CONF*)ASN1_item_new(ASN1_ITEM_rptr(EXPORTED_PKI_CONF))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_conf).give_Datas(&(*Datas)->d.conf))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.conf, ASN1_ITEM_rptr(EXPORTED_PKI_CONF));
				(*Datas)->d.conf = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 1:
			if(!((*Datas)->d.cre_entity = (ENTITY_CREATION_REQ*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_CREATION_REQ))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_creEntity).give_Datas(&(*Datas)->d.cre_entity))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.cre_entity, ASN1_ITEM_rptr(ENTITY_CREATION_REQ));
				(*Datas)->d.cre_entity = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 4:
			if(!((*Datas)->d.cre_user = (USER_INFO*)ASN1_item_new(ASN1_ITEM_rptr(USER_INFO))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_creUser).give_Datas(&(*Datas)->d.cre_user))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.cre_user, ASN1_ITEM_rptr(USER_INFO));
				(*Datas)->d.cre_user = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 45:
			if(!((*Datas)->d.create_child_ca = (REQ_CREATE_CHILD_CA*)ASN1_item_new(ASN1_ITEM_rptr(REQ_CREATE_CHILD_CA))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_createChildCa).give_Datas(&(*Datas)->d.create_child_ca))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.create_child_ca, ASN1_ITEM_rptr(REQ_CREATE_CHILD_CA));
				(*Datas)->d.create_child_ca = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 11:
			if(!((*Datas)->d.create_pki_user = (CREATE_PKI_USER_REQUEST*)ASN1_item_new(ASN1_ITEM_rptr(CREATE_PKI_USER_REQUEST))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_createPkiUser).give_Datas(&(*Datas)->d.create_pki_user))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.create_pki_user, ASN1_ITEM_rptr(CREATE_PKI_USER_REQUEST));
				(*Datas)->d.create_pki_user = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 39:
			if(!((*Datas)->d.create_root_ca = (REQ_CREATE_ROOT_CA*)ASN1_item_new(ASN1_ITEM_rptr(REQ_CREATE_ROOT_CA))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_createRootCa).give_Datas(&(*Datas)->d.create_root_ca))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.create_root_ca, ASN1_ITEM_rptr(REQ_CREATE_ROOT_CA));
				(*Datas)->d.create_root_ca = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 77:
			if(!((*Datas)->d.dn_id = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_dnId).c_ASN1_UTF8STRING(&(*Datas)->d.dn_id))
			{
				ASN1_UTF8STRING_free((*Datas)->d.dn_id);
				(*Datas)->d.dn_id = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 76:
			if(!((*Datas)->d.dn_val = (DN_VALIDATION*)ASN1_item_new(ASN1_ITEM_rptr(DN_VALIDATION))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_dnVal).give_Datas(&(*Datas)->d.dn_val))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.dn_val, ASN1_ITEM_rptr(DN_VALIDATION));
				(*Datas)->d.dn_val = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 83:
			if(!((*Datas)->d.ee_cert_request = (NEWPKI_EE_REQUEST_CERT*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_EE_REQUEST_CERT))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeCertRequest).give_Datas(&(*Datas)->d.ee_cert_request))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_cert_request, ASN1_ITEM_rptr(NEWPKI_EE_REQUEST_CERT));
				(*Datas)->d.ee_cert_request = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 88:
			if(!((*Datas)->d.ee_cert_revoke = (WEBUSER_REVOKE_CERT*)ASN1_item_new(ASN1_ITEM_rptr(WEBUSER_REVOKE_CERT))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_eeCertRevoke).give_Datas(&(*Datas)->d.ee_cert_revoke))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.ee_cert_revoke, ASN1_ITEM_rptr(WEBUSER_REVOKE_CERT));
				(*Datas)->d.ee_cert_revoke = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 37:
			if(!((*Datas)->d.entities_links = SKM_sk_new_null(ENTITY_LINKS)))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			for(i = 0 ; i < (*m_entitiesLinks).size() ; i++)
			{
				currentitiesLinks = NULL;
				if(!(*m_entitiesLinks)[i].give_Datas(&currentitiesLinks))
				{
					ASN1_item_free((ASN1_VALUE*)currentitiesLinks, ASN1_ITEM_rptr(ENTITY_LINKS));
					currentitiesLinks = NULL;
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
				if(SKM_sk_push(ENTITY_LINKS, (*Datas)->d.entities_links, currentitiesLinks) < 0)
				{
					ASN1_item_free((ASN1_VALUE*)currentitiesLinks, ASN1_ITEM_rptr(ENTITY_LINKS));
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
					return false;
				}
			}
			break;
		case 29:
			if(!((*Datas)->d.entity_acl = (S_ENTITY_ACL*)ASN1_item_new(ASN1_ITEM_rptr(S_ENTITY_ACL))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_entityAcl).give_Datas(&(*Datas)->d.entity_acl))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.entity_acl, ASN1_ITEM_rptr(S_ENTITY_ACL));
				(*Datas)->d.entity_acl = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 34:
			if(!((*Datas)->d.entity_audits = (S_ENTITY_AUDITS*)ASN1_item_new(ASN1_ITEM_rptr(S_ENTITY_AUDITS))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_entityAudits).give_Datas(&(*Datas)->d.entity_audits))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.entity_audits, ASN1_ITEM_rptr(S_ENTITY_AUDITS));
				(*Datas)->d.entity_audits = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 21:
		case 27:
		case 28:
		case 33:
			if(!((*Datas)->d.entity_cert = (X509*)ASN1_item_new(ASN1_ITEM_rptr(X509))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_entityCert).give_Datas(&(*Datas)->d.entity_cert))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.entity_cert, ASN1_ITEM_rptr(X509));
				(*Datas)->d.entity_cert = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 31:
			if(!((*Datas)->d.entity_conf = (S_ENTITY_CONF*)ASN1_item_new(ASN1_ITEM_rptr(S_ENTITY_CONF))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_entityConf).give_Datas(&(*Datas)->d.entity_conf))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.entity_conf, ASN1_ITEM_rptr(S_ENTITY_CONF));
				(*Datas)->d.entity_conf = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 30:
			if(!((*Datas)->d.entity_mail_conf = (S_ENTITY_MAIL_CONF*)ASN1_item_new(ASN1_ITEM_rptr(S_ENTITY_MAIL_CONF))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_entityMailConf).give_Datas(&(*Datas)->d.entity_mail_conf))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.entity_mail_conf, ASN1_ITEM_rptr(S_ENTITY_MAIL_CONF));
				(*Datas)->d.entity_mail_conf = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 2:
		case 72:
		case 73:
			if(!((*Datas)->d.entity_name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_entityName).c_ASN1_UTF8STRING(&(*Datas)->d.entity_name))
			{
				ASN1_UTF8STRING_free((*Datas)->d.entity_name);
				(*Datas)->d.entity_name = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 35:
			if(!((*Datas)->d.entity_type = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(ASN1_INTEGER_set((*Datas)->d.entity_type, (*m_entityType)) <= 0)
			{
				ASN1_INTEGER_free((*Datas)->d.entity_type);
				(*Datas)->d.entity_type = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
				return false;
			}
			break;
		case 7:
		case 65:
			if(!((*Datas)->d.enum_logs = (ADMIN_REQ_ENUM_LOGS*)ASN1_item_new(ASN1_ITEM_rptr(ADMIN_REQ_ENUM_LOGS))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_enumLogs).give_Datas(&(*Datas)->d.enum_logs))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.enum_logs, ASN1_ITEM_rptr(ADMIN_REQ_ENUM_LOGS));
				(*Datas)->d.enum_logs = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 42:
		case 43:
		case 59:
		case 89:
			if(!((*Datas)->d.enum_objects = (OBJECTS_ENUM*)ASN1_item_new(ASN1_ITEM_rptr(OBJECTS_ENUM))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_enumObjects).give_Datas(&(*Datas)->d.enum_objects))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.enum_objects, ASN1_ITEM_rptr(OBJECTS_ENUM));
				(*Datas)->d.enum_objects = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 51:
			if(!((*Datas)->d.group_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(ASN1_INTEGER_set((*Datas)->d.group_id, (*m_groupId)) <= 0)
			{
				ASN1_INTEGER_free((*Datas)->d.group_id);
				(*Datas)->d.group_id = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
				return false;
			}
			break;
		case 50:
			if(!((*Datas)->d.group_name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_groupName).c_ASN1_UTF8STRING(&(*Datas)->d.group_name))
			{
				ASN1_UTF8STRING_free((*Datas)->d.group_name);
				(*Datas)->d.group_name = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 49:
			if(!((*Datas)->d.groups = SKM_sk_new_null(USERS_GROUP)))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			for(i = 0 ; i < (*m_groups).size() ; i++)
			{
				currgroups = NULL;
				if(!(*m_groups)[i].give_Datas(&currgroups))
				{
					ASN1_item_free((ASN1_VALUE*)currgroups, ASN1_ITEM_rptr(USERS_GROUP));
					currgroups = NULL;
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
				if(SKM_sk_push(USERS_GROUP, (*Datas)->d.groups, currgroups) < 0)
				{
					ASN1_item_free((ASN1_VALUE*)currgroups, ASN1_ITEM_rptr(USERS_GROUP));
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
					return false;
				}
			}
			break;
		case 20:
			if(!((*Datas)->d.init_entity = (ENTITY_INIT_REQ*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_INIT_REQ))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_initEntity).give_Datas(&(*Datas)->d.init_entity))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.init_entity, ASN1_ITEM_rptr(ENTITY_INIT_REQ));
				(*Datas)->d.init_entity = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 62:
			if(!((*Datas)->d.known_objects = (OBJECTS_LIST_SYNCHRO*)ASN1_item_new(ASN1_ITEM_rptr(OBJECTS_LIST_SYNCHRO))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_knownObjects).give_Datas(&(*Datas)->d.known_objects))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.known_objects, ASN1_ITEM_rptr(OBJECTS_LIST_SYNCHRO));
				(*Datas)->d.known_objects = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 66:
			if(!((*Datas)->d.ldap_search = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_ldapSearch).c_ASN1_UTF8STRING(&(*Datas)->d.ldap_search))
			{
				ASN1_UTF8STRING_free((*Datas)->d.ldap_search);
				(*Datas)->d.ldap_search = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 0:
			if(!((*Datas)->d.login = (ADMIN_REQ_LOGIN*)ASN1_item_new(ASN1_ITEM_rptr(ADMIN_REQ_LOGIN))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_login).give_Datas(&(*Datas)->d.login))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.login, ASN1_ITEM_rptr(ADMIN_REQ_LOGIN));
				(*Datas)->d.login = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 56:
			if(!((*Datas)->d.new_req = (CRYPTED_NEWPKI_REQUEST*)ASN1_item_new(ASN1_ITEM_rptr(CRYPTED_NEWPKI_REQUEST))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_newReq).give_Datas(&(*Datas)->d.new_req))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.new_req, ASN1_ITEM_rptr(CRYPTED_NEWPKI_REQUEST));
				(*Datas)->d.new_req = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 57:
			if(!((*Datas)->d.new_resp = (CRYPTED_NEWPKI_RESPONSE*)ASN1_item_new(ASN1_ITEM_rptr(CRYPTED_NEWPKI_RESPONSE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_newResp).give_Datas(&(*Datas)->d.new_resp))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.new_resp, ASN1_ITEM_rptr(CRYPTED_NEWPKI_RESPONSE));
				(*Datas)->d.new_resp = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 15:
			if(!((*Datas)->d.offline = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(ASN1_INTEGER_set((*Datas)->d.offline, (*m_offline)) <= 0)
			{
				ASN1_INTEGER_free((*Datas)->d.offline);
				(*Datas)->d.offline = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
				return false;
			}
			break;
		case 3:
		case 5:
		case 16:
		case 17:
		case 18:
		case 19:
		case 22:
		case 24:
		case 36:
		case 40:
		case 48:
		case 53:
		case 55:
		case 61:
		case 63:
			if(m_other)
			{
				if((*Datas)->d.other)
					ASN1_item_free((ASN1_VALUE*)(*Datas)->d.other, ASN1_ITEM_rptr(ASN1_NULL));
				if(!((*Datas)->d.other = (ASN1_NULL*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_NULL), (ASN1_VALUE*)m_other)))
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
					return false;
				}
			}
			else
			{
				if(!(*Datas)->d.other)
				{
					(*Datas)->d.other = (ASN1_NULL*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_NULL));
					if(!(*Datas)->d.other)
					{
						NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
						return false;
					}
				}
			}
			break;
		case 75:
			if(!((*Datas)->d.p12_import = (CA_P12_IMPORT*)ASN1_item_new(ASN1_ITEM_rptr(CA_P12_IMPORT))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_p12Import).give_Datas(&(*Datas)->d.p12_import))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.p12_import, ASN1_ITEM_rptr(CA_P12_IMPORT));
				(*Datas)->d.p12_import = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 46:
			if(!((*Datas)->d.p7b = (PKCS7*)ASN1_item_new(ASN1_ITEM_rptr(PKCS7))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_p7b).give_Datas(&(*Datas)->d.p7b))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.p7b, ASN1_ITEM_rptr(PKCS7));
				(*Datas)->d.p7b = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 54:
			if(!((*Datas)->d.profile = (NEWPKI_PROFILE*)ASN1_item_new(ASN1_ITEM_rptr(NEWPKI_PROFILE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_profile).give_Datas(&(*Datas)->d.profile))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.profile, ASN1_ITEM_rptr(NEWPKI_PROFILE));
				(*Datas)->d.profile = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 71:
			if(!((*Datas)->d.profile_dn = (PROFILE_CHANGE_DN*)ASN1_item_new(ASN1_ITEM_rptr(PROFILE_CHANGE_DN))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_profileDn).give_Datas(&(*Datas)->d.profile_dn))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.profile_dn, ASN1_ITEM_rptr(PROFILE_CHANGE_DN));
				(*Datas)->d.profile_dn = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 70:
		case 81:
		case 84:
		case 87:
			if(!((*Datas)->d.profile_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(ASN1_INTEGER_set((*Datas)->d.profile_id, (*m_profileId)) <= 0)
			{
				ASN1_INTEGER_free((*Datas)->d.profile_id);
				(*Datas)->d.profile_id = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
				return false;
			}
			break;
		case 69:
			if(!((*Datas)->d.profile_owner = (PROFILE_CHANGE_OWNER*)ASN1_item_new(ASN1_ITEM_rptr(PROFILE_CHANGE_OWNER))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_profileOwner).give_Datas(&(*Datas)->d.profile_owner))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.profile_owner, ASN1_ITEM_rptr(PROFILE_CHANGE_OWNER));
				(*Datas)->d.profile_owner = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 68:
			if(!((*Datas)->d.profile_uid = (PROFILE_CHANGE_UID*)ASN1_item_new(ASN1_ITEM_rptr(PROFILE_CHANGE_UID))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_profileUid).give_Datas(&(*Datas)->d.profile_uid))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.profile_uid, ASN1_ITEM_rptr(PROFILE_CHANGE_UID));
				(*Datas)->d.profile_uid = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 82:
			if(!((*Datas)->d.reject_profile = (PROFILE_REJECT*)ASN1_item_new(ASN1_ITEM_rptr(PROFILE_REJECT))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_rejectProfile).give_Datas(&(*Datas)->d.reject_profile))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.reject_profile, ASN1_ITEM_rptr(PROFILE_REJECT));
				(*Datas)->d.reject_profile = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 52:
			if(!((*Datas)->d.rename_group = (S_RENAME_GROUP*)ASN1_item_new(ASN1_ITEM_rptr(S_RENAME_GROUP))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_renameGroup).give_Datas(&(*Datas)->d.rename_group))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.rename_group, ASN1_ITEM_rptr(S_RENAME_GROUP));
				(*Datas)->d.rename_group = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 23:
			if(!((*Datas)->d.repositories = SKM_sk_new_null(REP_ENTRY_INFO)))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			for(i = 0 ; i < (*m_repositories).size() ; i++)
			{
				currrepositories = NULL;
				if(!(*m_repositories)[i].give_Datas(&currrepositories))
				{
					ASN1_item_free((ASN1_VALUE*)currrepositories, ASN1_ITEM_rptr(REP_ENTRY_INFO));
					currrepositories = NULL;
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
				if(SKM_sk_push(REP_ENTRY_INFO, (*Datas)->d.repositories, currrepositories) < 0)
				{
					ASN1_item_free((ASN1_VALUE*)currrepositories, ASN1_ITEM_rptr(REP_ENTRY_INFO));
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
					return false;
				}
			}
			break;
		case 74:
			if(!((*Datas)->d.request_id = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(ASN1_INTEGER_set((*Datas)->d.request_id, (*m_requestId)) <= 0)
			{
				ASN1_INTEGER_free((*Datas)->d.request_id);
				(*Datas)->d.request_id = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
				return false;
			}
			break;
		case 25:
		case 26:
			if(!((*Datas)->d.resource_name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_resourceName).c_ASN1_UTF8STRING(&(*Datas)->d.resource_name))
			{
				ASN1_UTF8STRING_free((*Datas)->d.resource_name);
				(*Datas)->d.resource_name = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 12:
		case 13:
		case 47:
		case 64:
		case 85:
		case 86:
			if(!((*Datas)->d.serial = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(ASN1_INTEGER_set((*Datas)->d.serial, (*m_serial)) <= 0)
			{
				ASN1_INTEGER_free((*Datas)->d.serial);
				(*Datas)->d.serial = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
				return false;
			}
			break;
		case 44:
			if(!((*Datas)->d.sign_csr = (SIGN_CSR*)ASN1_item_new(ASN1_ITEM_rptr(SIGN_CSR))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_signCsr).give_Datas(&(*Datas)->d.sign_csr))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.sign_csr, ASN1_ITEM_rptr(SIGN_CSR));
				(*Datas)->d.sign_csr = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 10:
			if(!((*Datas)->d.sign_entity = (ENTITY_SIGNATURE_REQ*)ASN1_item_new(ASN1_ITEM_rptr(ENTITY_SIGNATURE_REQ))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_signEntity).give_Datas(&(*Datas)->d.sign_entity))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.sign_entity, ASN1_ITEM_rptr(ENTITY_SIGNATURE_REQ));
				(*Datas)->d.sign_entity = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 67:
			if(!((*Datas)->d.transaction_id = (ASN1_OCTET_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_OCTET_STRING))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_transactionId).give_Datas(&(*Datas)->d.transaction_id))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.transaction_id, ASN1_ITEM_rptr(ASN1_OCTET_STRING));
				(*Datas)->d.transaction_id = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 41:
		case 58:
			if(!((*Datas)->d.transactions_ids = (TRANSACTION_IDS*)ASN1_item_new(ASN1_ITEM_rptr(TRANSACTION_IDS))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_transactionsIds).give_Datas(&(*Datas)->d.transactions_ids))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.transactions_ids, ASN1_ITEM_rptr(TRANSACTION_IDS));
				(*Datas)->d.transactions_ids = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 6:
			if(!((*Datas)->d.upd_user = (USER_ENTRY*)ASN1_item_new(ASN1_ITEM_rptr(USER_ENTRY))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_updUser).give_Datas(&(*Datas)->d.upd_user))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.upd_user, ASN1_ITEM_rptr(USER_ENTRY));
				(*Datas)->d.upd_user = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 38:
			if(!((*Datas)->d.waiting_obj = (WAITING_NEWPKI_OBJECT*)ASN1_item_new(ASN1_ITEM_rptr(WAITING_NEWPKI_OBJECT))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_waitingObj).give_Datas(&(*Datas)->d.waiting_obj))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.waiting_obj, ASN1_ITEM_rptr(WAITING_NEWPKI_OBJECT));
				(*Datas)->d.waiting_obj = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 90:
			if(!((*Datas)->d.web_chg_passwd = (WEBUSER_CHANGE_PASSWD*)ASN1_item_new(ASN1_ITEM_rptr(WEBUSER_CHANGE_PASSWD))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_webChgPasswd).give_Datas(&(*Datas)->d.web_chg_passwd))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.web_chg_passwd, ASN1_ITEM_rptr(WEBUSER_CHANGE_PASSWD));
				(*Datas)->d.web_chg_passwd = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 80:
			if(!((*Datas)->d.webactivate = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_webactivate).c_ASN1_UTF8STRING(&(*Datas)->d.webactivate))
			{
				ASN1_UTF8STRING_free((*Datas)->d.webactivate);
				(*Datas)->d.webactivate = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 78:
			if(!((*Datas)->d.webcreate = (WEB_REQ_CREATE*)ASN1_item_new(ASN1_ITEM_rptr(WEB_REQ_CREATE))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_webcreate).give_Datas(&(*Datas)->d.webcreate))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.webcreate, ASN1_ITEM_rptr(WEB_REQ_CREATE));
				(*Datas)->d.webcreate = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
		case 79:
			if(!((*Datas)->d.weblogin = (WEB_REQ_LOGIN*)ASN1_item_new(ASN1_ITEM_rptr(WEB_REQ_LOGIN))))
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
			if(!(*m_weblogin).give_Datas(&(*Datas)->d.weblogin))
			{
				ASN1_item_free((ASN1_VALUE*)(*Datas)->d.weblogin, ASN1_ITEM_rptr(WEB_REQ_LOGIN));
				(*Datas)->d.weblogin = NULL;
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
				return false;
			}
			break;
	}
	return true;
}

bool AdminRequestBody::operator=(const AdminRequestBody & other)
{
	Clear();
	if(!set_type(other.m_type))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	switch(other.m_type)
	{
		case 32:
			if(!other.m_adminMail)
				break;
			(*m_adminMail) = *(other.m_adminMail);
			break;
		case 60:
			if(!other.m_certRequest)
				break;
			(*m_certRequest) = *(other.m_certRequest);
			break;
		case 9:
			if(!other.m_chgPwd)
				break;
			(*m_chgPwd) = *(other.m_chgPwd);
			break;
		case 8:
			if(!other.m_chgUserPwd)
				break;
			(*m_chgUserPwd) = *(other.m_chgUserPwd);
			break;
		case 14:
			if(!other.m_conf)
				break;
			(*m_conf) = *(other.m_conf);
			break;
		case 1:
			if(!other.m_creEntity)
				break;
			(*m_creEntity) = *(other.m_creEntity);
			break;
		case 4:
			if(!other.m_creUser)
				break;
			(*m_creUser) = *(other.m_creUser);
			break;
		case 45:
			if(!other.m_createChildCa)
				break;
			(*m_createChildCa) = *(other.m_createChildCa);
			break;
		case 11:
			if(!other.m_createPkiUser)
				break;
			(*m_createPkiUser) = *(other.m_createPkiUser);
			break;
		case 39:
			if(!other.m_createRootCa)
				break;
			(*m_createRootCa) = *(other.m_createRootCa);
			break;
		case 77:
			if(!other.m_dnId)
				break;
			(*m_dnId) = *(other.m_dnId);
			break;
		case 76:
			if(!other.m_dnVal)
				break;
			(*m_dnVal) = *(other.m_dnVal);
			break;
		case 83:
			if(!other.m_eeCertRequest)
				break;
			(*m_eeCertRequest) = *(other.m_eeCertRequest);
			break;
		case 88:
			if(!other.m_eeCertRevoke)
				break;
			(*m_eeCertRevoke) = *(other.m_eeCertRevoke);
			break;
		case 37:
			if(!other.m_entitiesLinks)
				break;
			(*m_entitiesLinks) = *(other.m_entitiesLinks);
			break;
		case 29:
			if(!other.m_entityAcl)
				break;
			(*m_entityAcl) = *(other.m_entityAcl);
			break;
		case 34:
			if(!other.m_entityAudits)
				break;
			(*m_entityAudits) = *(other.m_entityAudits);
			break;
		case 21:
		case 27:
		case 28:
		case 33:
			if(!other.m_entityCert)
				break;
			(*m_entityCert) = *(other.m_entityCert);
			break;
		case 31:
			if(!other.m_entityConf)
				break;
			(*m_entityConf) = *(other.m_entityConf);
			break;
		case 30:
			if(!other.m_entityMailConf)
				break;
			(*m_entityMailConf) = *(other.m_entityMailConf);
			break;
		case 2:
		case 72:
		case 73:
			if(!other.m_entityName)
				break;
			(*m_entityName) = *(other.m_entityName);
			break;
		case 35:
			if(!other.m_entityType)
				break;
			(*m_entityType) = *(other.m_entityType);
			break;
		case 7:
		case 65:
			if(!other.m_enumLogs)
				break;
			(*m_enumLogs) = *(other.m_enumLogs);
			break;
		case 42:
		case 43:
		case 59:
		case 89:
			if(!other.m_enumObjects)
				break;
			(*m_enumObjects) = *(other.m_enumObjects);
			break;
		case 51:
			if(!other.m_groupId)
				break;
			(*m_groupId) = *(other.m_groupId);
			break;
		case 50:
			if(!other.m_groupName)
				break;
			(*m_groupName) = *(other.m_groupName);
			break;
		case 49:
			if(!other.m_groups)
				break;
			(*m_groups) = *(other.m_groups);
			break;
		case 20:
			if(!other.m_initEntity)
				break;
			(*m_initEntity) = *(other.m_initEntity);
			break;
		case 62:
			if(!other.m_knownObjects)
				break;
			(*m_knownObjects) = *(other.m_knownObjects);
			break;
		case 66:
			if(!other.m_ldapSearch)
				break;
			(*m_ldapSearch) = *(other.m_ldapSearch);
			break;
		case 0:
			if(!other.m_login)
				break;
			(*m_login) = *(other.m_login);
			break;
		case 56:
			if(!other.m_newReq)
				break;
			(*m_newReq) = *(other.m_newReq);
			break;
		case 57:
			if(!other.m_newResp)
				break;
			(*m_newResp) = *(other.m_newResp);
			break;
		case 15:
			if(!other.m_offline)
				break;
			(*m_offline) = *(other.m_offline);
			break;
		case 3:
		case 5:
		case 16:
		case 17:
		case 18:
		case 19:
		case 22:
		case 24:
		case 36:
		case 40:
		case 48:
		case 53:
		case 55:
		case 61:
		case 63:
			if(other.m_other)
			{
				if(m_other)
					ASN1_item_free((ASN1_VALUE*)m_other, ASN1_ITEM_rptr(ASN1_NULL));
				m_other = (ASN1_NULL*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_NULL), (void*)other.m_other);
				if(!m_other)
				{
					NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
					return false;
				}
			}
			break;
		case 75:
			if(!other.m_p12Import)
				break;
			(*m_p12Import) = *(other.m_p12Import);
			break;
		case 46:
			if(!other.m_p7b)
				break;
			(*m_p7b) = *(other.m_p7b);
			break;
		case 54:
			if(!other.m_profile)
				break;
			(*m_profile) = *(other.m_profile);
			break;
		case 71:
			if(!other.m_profileDn)
				break;
			(*m_profileDn) = *(other.m_profileDn);
			break;
		case 70:
		case 81:
		case 84:
		case 87:
			if(!other.m_profileId)
				break;
			(*m_profileId) = *(other.m_profileId);
			break;
		case 69:
			if(!other.m_profileOwner)
				break;
			(*m_profileOwner) = *(other.m_profileOwner);
			break;
		case 68:
			if(!other.m_profileUid)
				break;
			(*m_profileUid) = *(other.m_profileUid);
			break;
		case 82:
			if(!other.m_rejectProfile)
				break;
			(*m_rejectProfile) = *(other.m_rejectProfile);
			break;
		case 52:
			if(!other.m_renameGroup)
				break;
			(*m_renameGroup) = *(other.m_renameGroup);
			break;
		case 23:
			if(!other.m_repositories)
				break;
			(*m_repositories) = *(other.m_repositories);
			break;
		case 74:
			if(!other.m_requestId)
				break;
			(*m_requestId) = *(other.m_requestId);
			break;
		case 25:
		case 26:
			if(!other.m_resourceName)
				break;
			(*m_resourceName) = *(other.m_resourceName);
			break;
		case 12:
		case 13:
		case 47:
		case 64:
		case 85:
		case 86:
			if(!other.m_serial)
				break;
			(*m_serial) = *(other.m_serial);
			break;
		case 44:
			if(!other.m_signCsr)
				break;
			(*m_signCsr) = *(other.m_signCsr);
			break;
		case 10:
			if(!other.m_signEntity)
				break;
			(*m_signEntity) = *(other.m_signEntity);
			break;
		case 67:
			if(!other.m_transactionId)
				break;
			(*m_transactionId) = *(other.m_transactionId);
			break;
		case 41:
		case 58:
			if(!other.m_transactionsIds)
				break;
			(*m_transactionsIds) = *(other.m_transactionsIds);
			break;
		case 6:
			if(!other.m_updUser)
				break;
			(*m_updUser) = *(other.m_updUser);
			break;
		case 38:
			if(!other.m_waitingObj)
				break;
			(*m_waitingObj) = *(other.m_waitingObj);
			break;
		case 90:
			if(!other.m_webChgPasswd)
				break;
			(*m_webChgPasswd) = *(other.m_webChgPasswd);
			break;
		case 80:
			if(!other.m_webactivate)
				break;
			(*m_webactivate) = *(other.m_webactivate);
			break;
		case 78:
			if(!other.m_webcreate)
				break;
			(*m_webcreate) = *(other.m_webcreate);
			break;
		case 79:
			if(!other.m_weblogin)
				break;
			(*m_weblogin) = *(other.m_weblogin);
			break;
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * AdminRequestBody::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ADMIN_REQUEST_BODY);
}
AdminRequest AdminRequest::EmptyInstance;
bool AdminRequest::set_body(const AdminRequestBody & c_body)
{
	m_body = c_body;
	return true;
}

const AdminRequestBody & AdminRequest::get_body() const
{
	return m_body;
}

AdminRequestBody & AdminRequest::get_body()
{
	return m_body;
}

AdminRequest::AdminRequest():NewPKIObject()
{
	resetAll();
}

AdminRequest::AdminRequest(const AdminRequest & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

AdminRequest::~AdminRequest()
{
	Clear();
}

void AdminRequest::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void AdminRequest::freeAll()
{
}

void AdminRequest::resetAll()
{
	m_body.Clear();
}

bool AdminRequest::load_Datas(const ADMIN_REQUEST * Datas)
{
	Clear();
	if(Datas->body)
	{
		if(!m_body.load_Datas(Datas->body))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool AdminRequest::give_Datas(ADMIN_REQUEST ** Datas) const
{
	if(!(*Datas) && !(*Datas = (ADMIN_REQUEST*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->body && !((*Datas)->body = (ADMIN_REQUEST_BODY*)ASN1_item_new(ASN1_ITEM_rptr(ADMIN_REQUEST_BODY))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_body.give_Datas(&(*Datas)->body))
	{
		ASN1_item_free((ASN1_VALUE*)(*Datas)->body, ASN1_ITEM_rptr(ADMIN_REQUEST_BODY));
		(*Datas)->body = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool AdminRequest::operator=(const AdminRequest & other)
{
	Clear();
	m_body = other.m_body;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * AdminRequest::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(ADMIN_REQUEST);
}
