/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// HashTable_String.h: interface for the HashTable_String class.
//
//////////////////////////////////////////////////////////////////////

#ifndef HASHTABLE_STRING_H
#define HASHTABLE_STRING_H



#include "PKI_HashTable.h"
#include <ASN1/Asn1HashVal.h>
#include <mVector.h>



/*!
  This class holds a hahtable of Strings
*/
class HashTable_String : public PKI_HashTable
{
public:
	/*! \brief This is the constructor.
	 */
	HashTable_String();

	/*! \brief This is the destructor.
	 */
	virtual ~HashTable_String();

	/*! \brief This function adds one entry to the hashtable.
	 *  \param Name [IN] The Name of the new entry to add.
	 *  \param Value [IN] The value associated with the new entry.
	 *  \return true on success, false on failure.
	 */
	bool Add(const char * Name, const char * Value);
	
	/*! \brief This function modify an entry of the hashtable.
	 *  \param Name [IN] The Name of the new entry to modify.
	 *  \param Value [IN] The new value associated with the entry Name.
	 *  \return true on success, false on failure.
	 */
	bool Modify(const char * Name, const char * Value);
	
	/*! \brief This function returns one entry.
	 *  \param Name [IN] The name of the entry to return.
	 *  \return The entry.
	 */
	const char * Get(const char * Name) const;

	/*! \brief This function returns one entry.
	 *  \param Pos [IN] The position of the entry to return.
	 *  \return The entry.
	 */
	const char * Get(long Pos) const;

	/*! \brief This operator copies one HashTable_String into another.
	 *  \param other [IN] The other hashtable to copy from.
	 *  \return true on success, false on failure.
	 */
	bool operator=(const HashTable_String &other);

	/*! \brief This function is used to validate a policy.
	 *  \param Name [IN] The policy name.
	 *  \param Value [IN] The policy value.
	 *  \return The type of policy.
	 */
	static DN_TYPE IsValidPolicyField(const mString & Name, const mString & Value);

	/*! \brief This function loads the hashtable from a list of EXTENSION_VALUE.
	 *  \param Exts [IN] The list of EXTENSION_VALUE.
	 *  \return true on success, false on failure.
	 */
	bool From_EXTENSION_VALUE(const mVector<ExtensionValue> & Exts);

	/*! \brief This function converts the hashtable to a list of EXTENSION_VALUE.
	 *  \param Exts [OUT] The list of EXTENSION_VALUE.
	 *  \return true on success, false on failure.
	 */
	bool To_EXTENSION_VALUE(mVector<ExtensionValue> & Exts);

	/*! \brief This function loads the hashtable from a list of PLUG_OPTION.
	 *  \param Options [IN] The list of PLUG_OPTION.
	 *  \return true on success, false on failure.
	 */
	bool From_PLUG_OPTION(const mVector<PlugOption> & Options);

	/*! \brief This function converts the hashtable to a list of PLUG_OPTION.
	 *  \param Options [OUT] The list of PLUG_OPTION.
	 *  \return true on success, false on failure.
	 */
	bool To_PLUG_OPTION(mVector<PlugOption> & Options);

	/*! \brief This function loads the hashtable from a list of POLICY_VALUE.
	 *  \param Policies [IN] The list of POLICY_VALUE.
	 *  \return true on success, false on failure.
	 */
	bool From_POLICY_VALUE(const mVector<PolicyValue> & Policies);

	/*! \brief This function converts the hashtable to a list of POLICY_VALUE.
	 *  \param Policies [OUT] The list of POLICY_VALUE.
	 *  \return true on success, false on failure.
	 */
	bool To_POLICY_VALUE(mVector<PolicyValue> & Policies);
};




#endif
