/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#ifndef OBJECTS_H
#define OBJECTS_H

#include <string.h>
#include <mString.h>
#include <openssl/objects.h>

/*! \brief This function validates that an Openssl object is valid (commonName, etc).
 *  \param ObjectName [IN] The name of the object to validate.
 *  \return 1 when object is valid, 0 when obect is invalid.
 */
int IsValidObject(const mString & ObjectName);


/*! \brief This function strips the possible XXX.commonName.
 *  \param Object [IN] The name of the object to format.
 *  \return The formated object name.
 */
const char * FormatObject(const char * Object);

/*! \brief This functions converts an ASN1 time syntax into a time_t.
 *  \param s [IN] The time in ASN1 syntax.
 *  \return The time_t corresponding to s.
 */
time_t ASN1_TIME_to_timet(char *s);

/*! \brief This returns the time in GMT.
 *  \param tim [OUT] The time in GMT.
 */
void time_gmt(time_t * tim);

/*! \brief This sets the value of an OpenSSL's ASN1_TIME, without doing any kind of conversion.
 *  \param s [OUT] The time in ASN1 syntax, can be NULL.
 *  \param t [IN] The time.
 *  \return The time in ASN1 syntax.
 */
ASN1_TIME *ASN1_TIME_set_localtime(ASN1_TIME *s, time_t t);

void NewPKI_InitErr();
void NewPKI_LockErr();
void NewPKI_UnlockErr();


#endif

