/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef SSLCONNECTION_H
#define SSLCONNECTION_H

#include "Connection.h"
#include <openssl/ssl.h>
#include "SessionsCache.h"
#include "PKI_CERT.h"
#include <mString.h>


/*!
	This class represents a SSL client connection
*/
class SslConnection : public Connection
{
public:
	/*! \brief This is the constructor.
	 *  \param cache [IN] The sessions cache.
	 */
	SslConnection(SessionsCache & cache);

	/*! \brief This is the constructor.
	 */
	~SslConnection();
	
	bool connect();
	
	void close();
	
	/*! \brief This function enables the SSL sessions cache.
	 *  \param enabled [IN] true to activate the sessions caching, false to deactivate it.
	 */
	void enable_Cache(bool enabled);
	
	/*! \brief This function sets the certificate to use for connection.
	 *  \param cert [IN] The certificate.
	 *  \return true on success, false on failure.
	 */
	bool set_certificate(const PKI_CERT & cert);
	
	bool SendRequest(const AdminRequest &request, AdminResponse &response, int ReadTimeout = 0);
	
	/*! \brief This function returns the server certificate.
	 *  \param PeerCert [OUT] The certificate.
	 *  \return true on success, false on failure.
	 */
	bool GetPeerCertificate(PKI_CERT & PeerCert);
private:
	static int verify_callback(int ok, X509_STORE_CTX *ctx);
	SSL * m_ssl;
	SSL_CTX * m_ctx;
	BIO * m_connection;
	SessionsCache & m_cache;
	bool m_enabledCache;
	mString m_dn;
};

#endif
