/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include <CriticalSection.h>
#include <openssl/crypto.h>
#include <ASN1/Asn1Conf.h>
#include <assert.h>

static void my_locking_callback(int mode,int type,const char *file,int line);
#ifndef _WIN32
static unsigned long pthreads_thread_id(void);
#endif


CriticalSection * lock_cs[NEWPKI_NUM_LOCKS];
CriticalSection ListLock;

void OSSL_locks_setup(void)
{
	int i;
	#ifndef _WIN32
		CRYPTO_set_id_callback(pthreads_thread_id);
	#endif

	for(i=0; i<NEWPKI_NUM_LOCKS; i++)
	{
		lock_cs[i] = NULL;
	}

	CRYPTO_set_locking_callback(my_locking_callback);
}

void OSSL_locks_cleanup(void)
{
	int i;
	CRYPTO_set_locking_callback(NULL);
	for(i=0; i<NEWPKI_NUM_LOCKS; i++)
	{
		if(lock_cs[i])
		{
			delete lock_cs[i];
			lock_cs[i] = NULL;
		}
	}
}

static void my_locking_callback(int mode, int type, const char *file, int line)
{
	if(!lock_cs)
	{
		return;
	}

	assert(type <= NEWPKI_NUM_LOCKS);

	ListLock.EnterCS();
	if(!lock_cs[type])
	{
		lock_cs[type] = new CriticalSection();
		if(!lock_cs[type])
		{
			ListLock.LeaveCS();
			return;
		}
	}
	ListLock.LeaveCS();

	if (mode & CRYPTO_LOCK)
	{
		lock_cs[type]->EnterCS();
	}
	else
	{
		lock_cs[type]->LeaveCS();
	}
}

#ifndef _WIN32
static unsigned long pthreads_thread_id(void)
{
	unsigned long ret;

	ret=(unsigned long)pthread_self();
	return(ret);
}
#endif

