// publication_file.cpp : Defines the entry point for the DLL application.
//

#ifdef _WIN32
#pragma warning(disable:4786)
#else
#include <unistd.h>
#endif

#include "publication_file.h"


#include <PKI_PLUG_PUB.h>
#include <mString.h>

#include <map>
using namespace std;

#include <sys/stat.h>

static int InitLib(const HashTable_String & Options);
static int ClearLib(const HashTable_String & Options);
static int OnNewCertificate(const HashTable_String & Options, const PKI_CERT & Certificate, const PKI_P7B & P7B, const mString & file_uid);
static int OnNewRevocation(const HashTable_String & Options, const PKI_CERT & Certificate, const mString & file_uid);
static int OnNewCrl(const HashTable_String & Options, const PKI_CRL & Crl);
static const char * GetLibLastError();




static PKI_PLUG_PUB st_functions={
	InitLib,
	ClearLib,
	OnNewCertificate,
	OnNewRevocation,
	OnNewCrl,
	GetLibLastError
};

extern "C" void * m_GetFunctions()
{
	return &st_functions;
}


mString LastError;

static int InitLib(const HashTable_String & Options)
{
	ERR_clear_error();
	
	LastError = "";
	return 1;
}

static int ClearLib(const HashTable_String & Options)
{
	ERR_clear_error();
	LastError = "";
	ERR_remove_state(0);
	return 1;
}

static int GenerateCertFileName(const HashTable_String & Options, const PKI_CERT & Certificate, mString & CertFilename, const mString & ldap_uid)
{
	mString Directory;
	mString Filename;

	mString Token;
	mString fToken;
	mString vToken;
	mString dnToken;
	const char * dnEntry;
	long pos;
	mString tplFilename;
	char * subOpening;
	char * subClosing;


	Directory = Options.Get("Directory");
	if(!Directory.size())
	{
		LastError.sprintf("%s : %s", NEWPKIerrGetStr(ERROR_BAD_DATAS), "Directory");
		return 0;
	}
	Filename = Options.Get("Filename");
	if(!Filename.size())
	{
		LastError.sprintf("%s : %s", NEWPKIerrGetStr(ERROR_BAD_DATAS), "Filename");
		return 0;
	}


	if(tplFilename.sprintf(Filename.c_str()) <= 0)
	{
		LastError.sprintf("%s : %s", NEWPKIerrGetStr(ERROR_BAD_DATAS), "tplFilename.sprintf");
		return 0;
	}

	// Get the special tokens in the filename
	subOpening = (char*)tplFilename.c_str();
	while( (subOpening = strchr(subOpening, '{')) )
	{
		subOpening++;
		subClosing = strchr(subOpening, '}');
		if(!subClosing)
		{
			LastError.sprintf("%s : %s", NEWPKIerrGetStr(ERROR_BAD_DATAS), "Mismatching { and }");
			return 0;
		}
		*subClosing = '\0';

		Token = subOpening;

		vToken = "";
		if(Token.Left(8) == "SUBJECT:")
		{
			dnToken = Token.Right(Token.size() - 8);
			if(dnToken.size() &&
				(pos = Certificate.GetCertDN().
						SeekEntryName(dnToken.c_str(), HASHTABLE_NOT_FOUND)) !=
					HASHTABLE_NOT_FOUND && 
				(dnEntry = Certificate.GetCertDN().Get(pos)) 
			)
			{
				vToken = dnEntry;
			}
		}
		else if(Token.Left(7) == "ISSUER:")
		{
			dnToken = Token.Right(Token.size() - 7);
			if(dnToken.size() &&
				(pos = Certificate.GetIssuerDN().
						SeekEntryName(dnToken.c_str(), HASHTABLE_NOT_FOUND)) !=
					HASHTABLE_NOT_FOUND && 
				(dnEntry = Certificate.GetIssuerDN().Get(pos)) 
			)
			{
				vToken = dnEntry;
			}
		}
		else if(Token == "SERIAL")
		{
			vToken.sprintf("%ld", Certificate.GetSerial());
		}
		else if(Token == "UID")
		{
			vToken = ldap_uid;
		}

		fToken.sprintf("{%s}", Token.c_str());
		Filename.replaceall(fToken, vToken);

		subOpening = subClosing + 1;
	}

	CertFilename.sprintf("%s%s", Directory.c_str(), Filename.c_str());

	return 1;
}

static int OnNewCertificate(const HashTable_String & Options, const PKI_CERT & Certificate, const PKI_P7B & P7B, const mString & ldap_uid)
{
	mString Encoding;
	mString Type;

	mString Filename;
	FILE * fd;


	ERR_clear_error();
	LastError = "";


	Encoding = Options.Get("Encoding");
	if(!Encoding.size())
	{
		LastError.sprintf("%s : %s", NEWPKIerrGetStr(ERROR_BAD_DATAS), "Encoding");
		return 0;
	}
	Type = Options.Get("Type");
	if(!Type.size())
	{
		LastError.sprintf("%s : %s", NEWPKIerrGetStr(ERROR_BAD_DATAS), "Type");
		return 0;
	}

	if(!GenerateCertFileName(Options, Certificate, Filename, ldap_uid))
	{
		return 0;
	}
	
	fd = fopen(Filename.c_str() , "wb");
	if(!fd)
	{
		LastError.sprintf("%s : %s (%s)", NEWPKIerrGetStr(ERROR_UNKNOWN), Filename.c_str(), strerror(errno));
		return 0;
	}

	if(Type == "PKCS7")
	{
		if(Encoding == "DER")
		{
			if(i2d_PKCS7_fp(fd, P7B.GetPKCS7()) <= 0)
			{
				LastError.sprintf("%s : %s (%s)", NEWPKIerrGetStr(ERROR_UNKNOWN), Filename.c_str(), "Failed to write DER PKCS#7");
				fclose(fd);
				return 0;
			}
		}
		else
		{	
			if(PEM_write_PKCS7(fd, P7B.GetPKCS7()) <= 0)
			{
				LastError.sprintf("%s : %s (%s)", NEWPKIerrGetStr(ERROR_UNKNOWN), Filename.c_str(), "Failed to write PEM PKCS#7");
				fclose(fd);
				return 0;
			}
		}
	}
	else
	{
		if(Encoding == "DER")
		{
			if(i2d_X509_fp(fd, Certificate.GetX509()) <= 0)
			{
				LastError.sprintf("%s : %s (%s)", NEWPKIerrGetStr(ERROR_UNKNOWN), Filename.c_str(), "Failed to write DER certificate");
				fclose(fd);
				return 0;
			}
		}
		else
		{	
			if(PEM_write_X509(fd, Certificate.GetX509()) <= 0)
			{
				LastError.sprintf("%s : %s (%s)", NEWPKIerrGetStr(ERROR_UNKNOWN), Filename.c_str(), "Failed to write PEM certificate");
				fclose(fd);
				return 0;
			}
		}
	}
	fclose(fd);

	return 1;
}

static int OnNewRevocation(const HashTable_String & Options, const PKI_CERT & Certificate, const mString & ldap_uid)
{
	mString Filename;
	struct stat st;

	ERR_clear_error();
	LastError = "";

	if(!GenerateCertFileName(Options, Certificate, Filename, ldap_uid))
	{
		return 0;
	}

	if(stat(Filename.c_str(), &st) == -1)
	{
		return 1;
	}

	if(unlink(Filename.c_str()) == -1)
	{
		LastError.sprintf("%s : %s (%s)", NEWPKIerrGetStr(ERROR_UNKNOWN), Filename.c_str(), strerror(errno));
		return 0;
	}
		
	return 1;
}

static int OnNewCrl(const HashTable_String & Options, const PKI_CRL & Crl)
{
	mString Filename;
	mString Encoding;

	FILE * fd;


	ERR_clear_error();
	LastError = "";


	Filename = Options.Get("Filename");
	if(!Filename.size())
	{
		LastError.sprintf("%s : %s", NEWPKIerrGetStr(ERROR_BAD_DATAS), "Filename");
		return 0;
	}
	Encoding = Options.Get("Encoding");
	if(!Encoding.size())
	{
		LastError.sprintf("%s : %s", NEWPKIerrGetStr(ERROR_BAD_DATAS), "Encoding");
		return 0;
	}

	fd = fopen(Filename.c_str() , "wb");
	if(!fd)
	{
		LastError.sprintf("%s : %s (%s)", NEWPKIerrGetStr(ERROR_UNKNOWN), Filename.c_str(), strerror(errno));
		return 0;
	}

	if(Encoding == "DER")
	{
		if(i2d_X509_CRL_fp(fd, Crl.GetX509_CRL()) <= 0)
		{
			LastError.sprintf("%s : %s (%s)", NEWPKIerrGetStr(ERROR_UNKNOWN), Filename.c_str(), "Failed to write DER CRL");
			fclose(fd);
			return 0;
		}
	}
	else
	{	
		if(PEM_write_X509_CRL(fd, Crl.GetX509_CRL()) <= 0)
		{
			LastError.sprintf("%s : %s (%s)", NEWPKIerrGetStr(ERROR_UNKNOWN), Filename.c_str(), "Failed to write PEM CRL");
			fclose(fd);
			return 0;
		}
	}
	fclose(fd);

	return 1;
}

static const char * GetLibLastError()
{
	return LastError.c_str();
}
