/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#ifndef ASYNCHJOBS_ASN1_H
#define ASYNCHJOBS_ASN1_H

#include <mVector.h>
#include <ASN1/NewPKIObject.h>
#include <openssl/asn1.h>
#include <ASN1/Asn1Req.h>

/*!
	This structure represent an email to be sent
*/
typedef struct st_MAIL_QUEUE_ENTRY
{
	STACK_OF(ASN1_UTF8STRING) * Recipients;	//!< The recipient(s)
	MAIL_DATAS * mail;						//!< The mail
	ASN1_UTF8STRING * Author;				//!< The author
	ASN1_INTEGER * AdminMail;				//!< Is is an admin mail?
}MAIL_QUEUE_ENTRY;
DECLARE_ASN1_ITEM(MAIL_QUEUE_ENTRY)


/*!
  This class is the representation of MAIL_QUEUE_ENTRY
*/
class MailQueueEntry : public NewPKIObject
{
public:
	/*! \brief This is the constructor.
	 */
	MailQueueEntry();

	/*! \brief This is the constructor.
	 *  \param other [IN] the datas to copy from.
	 */
	MailQueueEntry(const MailQueueEntry & other);

	/*! \brief This is the destructor.
	 */
	~MailQueueEntry();


	/*! \brief This function converts a MAIL_QUEUE_ENTRY to a MailQueueEntry.
	 *  \param Datas [IN] the datas to load from.
	 *  \return true on success, false on failure.
	 */
	bool load_Datas(const MAIL_QUEUE_ENTRY * Datas);

	/*! \brief This function converts a MailQueueEntry to a MAIL_QUEUE_ENTRY.
	 *  \param Datas [OUT] the datas to copy to.
	 *  \return true on success, false on failure.
	 */
	bool give_Datas(MAIL_QUEUE_ENTRY ** Datas) const;

	/*! \brief This function clears all the internals.
	 */
	void Clear();

	/*! \brief This function returns the ASN1_ITEM of MAIL_QUEUE_ENTRY.
	 *  \return The ASN1_ITEM.
	 */
	static const ASN1_ITEM * get_ASN1_ITEM();

	void set_id(unsigned long c_id);
	unsigned long get_id() const;
	/*! \brief This function sets ASN1_INTEGER::AdminMail.
	 *  \param c_adminmail [IN] the datas.
	 *  \return true on success, false on failure.
	 */
	bool set_adminmail(unsigned long c_adminmail);

	/*! \brief This function returns ASN1_INTEGER::AdminMail.
	 *  \return The value of ASN1_INTEGER::AdminMail.
	 */
	unsigned long get_adminmail() const;


	/*! \brief This function sets ASN1_UTF8STRING::Author.
	 *  \param c_author [IN] the datas.
	 *  \return true on success, false on failure.
	 */
	bool set_author(const mString & c_author);

	/*! \brief This function returns ASN1_UTF8STRING::Author.
	 *  \return The value of ASN1_UTF8STRING::Author.
	 */
	const mString & get_author() const;

	/*! \brief This function returns ASN1_UTF8STRING::Author.
	 *  \return The value of ASN1_UTF8STRING::Author.
	 */
	mString & get_author();


	/*! \brief This function sets ASN1_UTF8STRING::Recipients.
	 *  \param c_recipients [IN] the datas.
	 *  \return true on success, false on failure.
	 */
	bool set_recipients(const mVector< mString > & c_recipients);

	/*! \brief This function returns ASN1_UTF8STRING::Recipients.
	 *  \return The value of ASN1_UTF8STRING::Recipients.
	 */
	const mVector< mString > & get_recipients() const;

	/*! \brief This function returns ASN1_UTF8STRING::Recipients.
	 *  \return The value of ASN1_UTF8STRING::Recipients.
	 */
	mVector< mString > & get_recipients();


	/*! \brief This function sets MAIL_DATAS::mail.
	 *  \param c_mail [IN] the datas.
	 *  \return true on success, false on failure.
	 */
	bool set_mail(const MailDatas & c_mail);

	/*! \brief This function returns MAIL_DATAS::mail.
	 *  \return The value of MAIL_DATAS::mail.
	 */
	const MailDatas & get_mail() const;

	/*! \brief This function returns MAIL_DATAS::mail.
	 *  \return The value of MAIL_DATAS::mail.
	 */
	MailDatas & get_mail();


	/*! \brief This funciton generates the PEM representation of the local instance.
	 *  \param PemDatas [OUT] the PEM output.
	 *  \return true on success, false on failure.
	 */
	bool to_PEM(mString & PemDatas) const;

	/*! \brief This function loads the local instance from a PEM representation.
	 *  \param PemDatas [IN] the PEM input.
	 *  \return true on success, false on failure.
	 */
	bool from_PEM(const mString & PemDatas);


	/*! \brief This function copies a MailQueueEntry to another.
	 *  \param other [IN] the datas to copy from.
	 *  \return true on success, false on failure.
	 */
	bool operator=(const MailQueueEntry & other);
	/*! \brief This member is an empty instance of MailQueueEntry.
	 */
	static MailQueueEntry EmptyInstance;

private:
	unsigned long m_adminmail;
	mString m_author;
	mVector< mString > m_recipients;
	MailDatas m_mail;
	void resetAll();
	void freeAll();
	unsigned long m_id;
protected:
};


#endif // #ifndef ASYNCHJOBS_ASN1_H
