/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// Entity_RA.h: interface for the Entity_RA class.
//
//////////////////////////////////////////////////////////////////////

#ifndef ENTITY_RA_H
#define ENTITY_RA_H


#include "Entity.h"
#include "Entity_RA_ASN1.h"
#include "RaStore.h"
#include "ClientLDAP.h"
#include "AutoSynchLDAP.h"


/*!
	This class represents a RA Entity
*/
class Entity_RA : public Entity
{
public:
	Entity_RA(ENTITY_CONSTRUCTOR_PARAMETERS);
	virtual ~Entity_RA();

	bool Requester_OnNewResponse(const Asn1OctetString & transactionID, const X509_PUBKEY * sender, const NewpkiResponse & Response);
	bool Responder_ValidateRequest(const NewpkiRequest & Request, const X509_PUBKEY * Requester, mString & SenderName);
	bool Responder_TreatRequestAsynch(const NewpkiRequest & Request, const Asn1OctetString & transactionId, const mString & SenderName);

	bool Load();
	bool Create(const EntityCreationDatas & Params, AdminResponseBody & response);
	bool Upgrade(const char * Version);
	bool Init(const EntitySignatureResp & init_datas);
	bool ParseAdminCommand(AdminResponseBody & response, const PKI_CERT & ClientCert, const AdminRequest & AdminRequest);
	void PrintInfo(FILE * out);

	/*! \brief This function returns the list of types of logs the entity generates.
	 *  \param cLogsType [OUT] The list.
	 */
	static void LogsTypeGet(mVector<unsigned long> & cLogsType);

	/*! \brief This function returns the list of types of ACL the entity handles.
	 *  \param acl_list [OUT] The list.
	 */
	static void GetACL_List(mVector<unsigned long> & acl_list);
private:
	bool PrepareConfToWrite();
	bool ChangeProfileUID(COMMAND_PARAMETERS);
	bool ChangeProfileOwner(COMMAND_PARAMETERS);
	bool ChangeProfileDN(COMMAND_PARAMETERS);
	bool DeleteProfile(COMMAND_PARAMETERS);
	bool DeleteRequest(COMMAND_PARAMETERS);
	bool SearchLdap(COMMAND_PARAMETERS);
	bool DeletePkcs12(COMMAND_PARAMETERS);
	bool RevokeCert(COMMAND_PARAMETERS);
	bool SuspendCert(COMMAND_PARAMETERS);
	bool UnsuspendCert(COMMAND_PARAMETERS);
	bool RequestCert(COMMAND_PARAMETERS);
	bool ImportProfile(COMMAND_PARAMETERS);
	bool AcceptProfile(COMMAND_PARAMETERS);
	bool RejectProfile(COMMAND_PARAMETERS);
	bool Private_RevokeCert(const PKI_CERT & UserCert, bool CheckOwner, unsigned long id);
	void Forward_CertResponseToEE(unsigned long CertReqId, const NewpkiResponse & Response, const Asn1OctetString & respTID);
	void Forward_RevResponseToEE(unsigned long CertReqId, const NewpkiResponse & Response, const Asn1OctetString & respTID);
	void Forward_CertStatusToEE(unsigned long CertReqId, int Status, const PKI_CRL & lastCrl);
	void Forward_CertToEE(unsigned long CertReqId, const NewpkiResponse &Response);

	bool LoginUser(UserHandle & hUser, int & UserType);
	void LogoutUser(const UserHandle & hUser);
	
	static bool Private_ParseAdminCommand(bool ExecuteCmd, Entity * me_this, mVector<unsigned long> &  mLogsType, AdminResponseBody & response, const PKI_CERT & ClientCert, const AdminRequest & AdminRequest, UserHandle & hUser);
	static void ThreadCheckExpire(const NewpkiThread * Thread, void *param);
	void WarnCertOwnerOfExpiry(const NewpkiProfileDatasCert & cert, const NewpkiProfileDatas & Profile, int Days);
	bool ProceedWithRequest(const NewpkiRequest & req, const Asn1OctetString & transactionId, const mString & SenderName, LOG_MESSAGE_TYPE & LogType, mString & ObjectName, mString & Err);
	bool RequestCertForEE(const Asn1OctetString & transactionId, const mString & eename, const NewpkiEeRequestCert & cert_request);
	bool RevokeCertForEE(const Asn1OctetString & transactionId, const mString & eename, unsigned long cert_id);
	const X509_PUBKEY* GetOwnerProfileEeKey(unsigned long CertReqId, unsigned long & ee_id);

	bool GetLocalConf(COMMAND_PARAMETERS);
	bool GetUsersGroups(COMMAND_PARAMETERS);
	bool EnumProfiles(COMMAND_PARAMETERS);

	bool ParseNewConf();
	
	LocalRaConf myConf;

	NewpkiThread hThreadCheckExpire;
	HashTable_String m_Policies;
	RaStore lStore;
	ClientLDAP LdapClient;
	AutoSynchLDAP LdapSynch;
	
	
	DECLARE_COMMAND_PARSER(Entity_RA);
};

#endif
