/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "RepStore_ASN1.h"
#include <PKI_ERR.h>
#include <openssl/asn1t.h>

ASN1_SEQUENCE(REP_STORE_SIG) = {
	ASN1_SIMPLE(REP_STORE_SIG, signature, ASN1_BIT_STRING),
	ASN1_SIMPLE(REP_STORE_SIG, sig_alg, X509_ALGOR),
}ASN1_SEQUENCE_END(REP_STORE_SIG)
RepStoreSig RepStoreSig::EmptyInstance;
bool RepStoreSig::set_sigAlg(const X509_ALGOR * c_sigAlg)
{
	if(m_sigAlg)
		ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
	m_sigAlg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), (void*)c_sigAlg);
	if(!m_sigAlg)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_ALGOR * RepStoreSig::get_sigAlg() const
{
	if(!m_sigAlg)
		((RepStoreSig*)this)->m_sigAlg = (X509_ALGOR*)ASN1_item_new(ASN1_ITEM_rptr(X509_ALGOR));
	return m_sigAlg;
}

X509_ALGOR * RepStoreSig::get_sigAlg()
{
	if(!m_sigAlg)
		m_sigAlg = (X509_ALGOR*)ASN1_item_new(ASN1_ITEM_rptr(X509_ALGOR));
	return m_sigAlg;
}

bool RepStoreSig::set_signature(const ASN1_BIT_STRING * c_signature)
{
	if(m_signature)
		ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	m_signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)c_signature);
	if(!m_signature)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const ASN1_BIT_STRING * RepStoreSig::get_signature() const
{
	if(!m_signature)
		((RepStoreSig*)this)->m_signature = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_signature;
}

ASN1_BIT_STRING * RepStoreSig::get_signature()
{
	if(!m_signature)
		m_signature = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_signature;
}

bool RepStoreSig::to_PEM(mString & PemDatas) const
{
	REP_STORE_SIG * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toPEM("NEWPKI REP STORE SIGNATURE", get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool RepStoreSig::from_PEM(const mString & PemDatas)
{
	REP_STORE_SIG * c_localvar = NULL;
	if(!Private_fromPEM("NEWPKI REP STORE SIGNATURE", get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

RepStoreSig::RepStoreSig():NewPKIObject()
{
	resetAll();
}

RepStoreSig::RepStoreSig(const RepStoreSig & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

RepStoreSig::~RepStoreSig()
{
	Clear();
}

void RepStoreSig::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void RepStoreSig::freeAll()
{
	if(m_sigAlg)
	{
		ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
	}
	if(m_signature)
	{
		ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	}
}

void RepStoreSig::resetAll()
{
	m_sigAlg = NULL;
	m_signature = NULL;
}

bool RepStoreSig::load_Datas(const REP_STORE_SIG * Datas)
{
	Clear();
	if(Datas->sig_alg)
	{
		if(m_sigAlg)
			ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
		m_sigAlg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), Datas->sig_alg);
		if(!m_sigAlg)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->signature)
	{
		if(m_signature)
			ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), Datas->signature);
		if(!m_signature)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool RepStoreSig::give_Datas(REP_STORE_SIG ** Datas) const
{
	if(!(*Datas) && !(*Datas = (REP_STORE_SIG*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(m_sigAlg)
	{
		if((*Datas)->sig_alg)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->sig_alg, ASN1_ITEM_rptr(X509_ALGOR));
		if(!((*Datas)->sig_alg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), (ASN1_VALUE*)m_sigAlg)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->sig_alg)
		{
			(*Datas)->sig_alg = (X509_ALGOR*)ASN1_item_new(ASN1_ITEM_rptr(X509_ALGOR));
			if(!(*Datas)->sig_alg)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(m_signature)
	{
		if((*Datas)->signature)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		if(!((*Datas)->signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (ASN1_VALUE*)m_signature)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->signature)
		{
			(*Datas)->signature = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
			if(!(*Datas)->signature)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	return true;
}

bool RepStoreSig::operator=(const RepStoreSig & other)
{
	Clear();
	if(other.m_sigAlg)
	{
		if(m_sigAlg)
			ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
		m_sigAlg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), (void*)other.m_sigAlg);
		if(!m_sigAlg)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(other.m_signature)
	{
		if(m_signature)
			ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)other.m_signature);
		if(!m_signature)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * RepStoreSig::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(REP_STORE_SIG);
}
