/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// SQL.h: interface for the SQL class.
//
//////////////////////////////////////////////////////////////////////

#ifndef SQL_H
#define SQL_H




#ifdef WIN32
	#include <windows.h>
#endif
#include <stdio.h>
#include <mString.h>
#include <mysql/mysql.h>
#include "SQL_Conn.h"
#include <ExceptionNewPKI.h>

#include <PKI_ERR.h>

#ifndef WIN32
	#define stricmp strcasecmp
#endif

#include <mString.h>

typedef enum
{
	SQL_ACCESS_READ,
	SQL_ACCESS_WRITE
}SQL_ACCESS;

/*!
  This class is the SQL abstraction layer
 */
class SQL  
{
public:
	/*! \brief This is the constructor.
	 *  \param DB_Connection [IN] A pointer to a valid database connection.
	 *  \param access [IN] The type of access.
	 */
	SQL(const class SQL_Connection * DB_Connection, SQL_ACCESS access);

	/*! \brief This is the destructor.
	 */
	virtual ~SQL();

	/*! \brief This function returns the last PrimaryKey on a "Insert".
	 *  \return The last inserted key.
	 */
	long GetLastID();

	/*! \brief This function format a mString to make it SQL compatible.
	 *  \param String [IN] The mString to convert.
	 *  \return The SQL formated string.
	 */
	mString FormatString(const mString & String);

	/*! \brief This function returns one value after a select.
	 *  \param RowNum [IN] The row number, starting from 0 to (NumRows-1).
	 *  \param Name [IN] The name of the field to get.
	 *  \param result [OUT] The value.
	 *  \return true on success, false on failure.
	 */
	bool Value(int RowNum, const mString & Name, mString & result);

	/*! \brief This function returns one value after a select.
	 *  \param RowNum [IN] The row number, starting from 0 to (NumRows-1).
	 *  \param ColNum [IN] The col number of the field to get.
	 *  \param result [OUT] The value.
	 *  \return true on success, false on failure.
	 */
	bool Value(int RowNum, int ColNum, mString & result);
	
	/*! \brief This function returns the number of rows in the result of a select.
	 *  \param num_rows [OUT] A pointer that will be field by the number of rows.
	 *  \return true on success, false on failure.
	 */
	bool NumRows(long *num_rows);

	/*! \brief This function executes a SQL query.
	 *  \param req [IN] The sql query to execute.
	 *  \return true on success, false on failure.
	 */
	bool Execute(const mString & req);
	
	/*! \brief This function creates a database.
	 *  \param DataBaseName [IN] The name of the database to create.
	 *  \return true on success, false on failure.
	 */
	bool CreateDatabase(const mString & DataBaseName);

	/*! \brief This function drops a database.
	 *  \param DataBaseName [IN] The name of the database to create.
	 *  \return true on success, false on failure.
	 */
	bool DropDatabase(const mString & DataBaseName);

	/*! \brief This function optimizes a table.
	 *  \param TableName [IN] The name of the table to optimize.
	 *  \return true on success, false on failure.
	 */
	bool OptimizeTable(const mString & TableName);
private:
	MYSQL	  * sqlHND;
	MYSQL_RES * res;
	const SQL_Connection * m_Connection;
	SQL_ACCESS m_access;
};

#endif

