/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// SockServerOCSP.h: interface for the SockServerOCSP class.
//
//////////////////////////////////////////////////////////////////////

#ifndef SOCKSERVEROCSP_H
#define SOCKSERVEROCSP_H

#include "PKIX_Central.h"
#include <PKI_CERT.h>
#include "SOCK_SERVER.h"


#ifndef MAX_OCSP_CONNECTIONS
	#define MAX_OCSP_CONNECTIONS	10
#endif

/*!
	This class handles the OCSP protocol
*/
class SockServerOCSP : public SOCK_SERVER  
{
public:
	/*! \brief This is the constructor.
	 */
	SockServerOCSP();

	/*! \brief This is the destructor.
	 */
	virtual ~SockServerOCSP();

	/*! \brief This function loads the provider.
	 *  \param Central [IN] The accessor to the entities.
	 *  \param PubEntityName [IN] The name of the publication entity.
	 */
	bool Load(PKIX_Central *Central, const mString & PubEntityName);

private:
	void OnServerStarted();
	void OnConnection(const char * Ip, SOCKET connection);
	void OnServerStopped();
	PKIX_Central * m_Central;
	mString m_PubEntityName;
};

#endif
