/*  VER 082  TAB P   $Id: despool.c,v 1.13 1999/04/07 08:02:11 src Exp $
 *
 *  do the posting 
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: despool.c,v $
 *  Revision 1.13  1999/04/07 08:02:11  src
 *  Implemented --profile
 *
 *  Revision 1.12  1999/03/16 08:03:29  src
 *  Renamed lock() to do_lock()
 *
 *  Revision 1.11  1999/03/07 14:58:18  src
 *  Read newsconfig supported. Storage API supported.
 *
 *  Revision 1.10  1998/11/22 08:00:07  src
 *  Option --no-queue
 *
 *  Revision 1.9  1998/09/11 16:37:43  src
 *  Lockfile for logfile of posted articles and for posted article folder.
 *
 *  Revision 1.8  1998/09/09 07:32:10  src
 *  Version 1.1
 *
 *  Revision 1.7  1998/09/03 02:49:29  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.6  1998/07/12 09:39:27  src
 *  newsx version 1.0
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "news.h"
#include "newsconfig.h"
#include "stat.h"

/* 
 *  globals for despool_line
 */
char basicname[PATH_MAX];
char retryname[PATH_MAX];
char togoname[PATH_MAX];
char old_name[PATH_MAX];
FILE *togofp = NULL;
FILE *retryfp = NULL;
char buf[BUFSIZ];
int articles = 0;

/*
 *  despool, find next article_name
 *  also handles cleaning up afterwards
 *  return static pointer, NULL if no more
 */
char *
despool_line(void)
{
    char *p;
    int sts;
    FILE *f,*f2;
    struct stat st;

    if (!togofp) {
	progtitle("locking outgoing spool");

	/* file not open yet: prepare names */
	build_alt_filename(basicname,cfg_batch,spoolname,NULL);

	if (inn_opt) {
	    /* 
	     * INN style:
	     * 1. apply lock for other newsxes    
	     *    filename is: LOCK.name-of-spool
	     * 2. open outgoing spool
	     * 3. if a spool.togo exists: rename/append it to spool.retry
	     * 4. rename the spool file to spool.togo
	     * 5. do a ctlinnd flush spoolname
	     * 6. if a spool.retry exists: append it to spool.togo and erase
	     * 
	     * when posting:
	     * 7. any articles with problems go to spool.retry
	     *
	     * when finished:
	     * 8. get rid of spool.togo
	     * 9. rename spool.retry to spool.togo if it exists
	     *
	     * suggested by Arne Georg Gleditsch <arnegl@ifi.uio.no>
	     * and J. Richard Sladkey <jrs@foliage.com>
	     */

	    /* lock other accesses to the spool first */
	    char lockname[PATH_MAX];

	    build_filename(lockname,I_LOCK,spoolname,NULL,NULL);
	    do_lock(NULL,lockname,0);

	    /* prepare the names we will be using */
	    /* BUG: spoolname.togo */
	    build_filename(togoname,basicname,_TOGO,NULL,NULL);
	    build_filename(retryname,basicname,_RETRY,NULL,NULL);
	    build_filename(old_name,basicname,_OLD,NULL,NULL);

	    /* open spool file proper */
	    progtitle("open spool");
	    if ((togofp = fopen(basicname,"r+")) == NULL) {
		log_msg(L_ERRno,"can't open INN spool \"%s\"", basicname);
		if (conterr) return NULL; /* continue fetching... */
		exit_cleanup(5);
	    }

	    /* verify that it is a regular file */
	    if (!is_regular(togofp,basicname,NULL)) {
		/* NOTE: will usually mean we use INN flag under C News */
		if (S_ISDIR(st.st_mode)) {
		    /* see if probable C News spool */
		    build_filename(togoname,basicname,"/",C_TOGO,NULL);
		    if (stat(togoname,&st) >= 0 && S_ISREG(st.st_mode)) {
			log_msg(L_ERR,"you specified '-i' for a C News spool");
		    }
		}
		fclose(togofp);
		exit_cleanup(5);
	    }

	    /* check that previous articles must be handled */
	    if ((f=fopen(togoname,"r"))) {
		/* yes, is there a previous .retry file also? */
		if ((f2=fopen(retryname,"r+"))) {
		    if (!append_file(f2,retryname,f)) exit_cleanup(5);
		    fclose(f);
		    fclose(f2);
		    unlink(togoname);
		} else {
		    fclose(f);
		    if (!rename_file(togoname,retryname)) exit_cleanup(5);
		}
	    }

	    progtitle("rename spool");
	    if (!rename_file(basicname,togoname)) exit_cleanup(5);
			
	    /* make innd flush this spool */
	    progtitle("ctlinnd flush");
	    if ((sts=ctlinnd(INN_CTL_FLUSH,spoolname)) != 0) {
		/* ctlinnd failed... */
		log_msg(L_ERR,"ctlinnd %s failed, returned status %d",
			       INN_CTL_FLUSH,sts);
		if (conterr) return NULL; /* continue fetching... */
		exit_cleanup(5);
	    }
	
	    /* append the contents from any previous retries... */
	    if ((f=fopen(retryname,"r"))) {
		if (!append_file(togofp,togoname,f)) exit_cleanup(5);
		fclose(f); 
		unlink(retryname);
	    }

	} else {
	    /* 
	     * C News style:
	     * 1. lock togo-file
	     * 2. open togo-file
	     */

	    /* lock file first */
	    do_lock(basicname,C_LOCK,0);

	    /* then prepare name of file */
	    build_alt_filename(togoname,basicname,C_TOGO,togo);

	    progtitle("open spool");
	    log_msg(L_DEBUGMORE,"opening outgoing \"%s\"",togoname);
	
	    build_filename(retryname,togoname,_RETRY,NULL,NULL);
	    build_filename(old_name,togoname,_OLD,NULL,NULL);
	
	    /* open spool file proper */
	    if ((togofp = fopen(togoname,"r")) == NULL) {
		log_msg(L_ERRno,"can't open C spool \"%s\"", togoname);
		if (conterr) return NULL; /* continue fetching... */
		exit_cleanup(5);
	    }
	    /* verify that it is a regular file */
	    if (!is_regular(togofp,togoname,NULL)) {
		fclose(togofp);
		exit_cleanup(5);
	    }
	
	    log_msg(L_DEBUGMORE,"opened spool file \"%s\"",togoname);
	}
    }

    /* read the next line */
    progtitle("read togo");

    while (fgets(buf,sizeof(buf),togofp)) {
	++articles;
	/* assume that filename is first, regardless */
	/* extract filename proper */
	for (p=buf; *p; ++p) {
	    if (*p == ' ') {
		*p = '\0';
		break;
	    }
	    if (*p == '\n') {
		*p = '\0';
		break;
	    }
	}
	/* if not empty, then it's kosher */
	if (buf[0]) return buf;
    } 

    /* spool file empty, clean up */
    if (fclose(togofp) == EOF) {
	log_msg(L_ERRno,"error reading \"%s\"", togoname);
	exit_cleanup(5);
    }
	
    if (!noaction_opt && articles > 0) {
	/* something happened */
	progtitle("closing spool");

	if (retryfp && fclose(retryfp) == EOF) {
	    log_msg(L_ERRno,"error closing \"%s\"", retryname);
	    exit_cleanup(5);
	}

	/* creating spool backup, overwriting the previous */
	if (!rename_file(togoname,old_name)) exit_cleanup(5);

	if (retryfp) {
	    /* there are failed postings -- keep them untill next time */
	    if (!rename_file(retryname,togoname)) exit_cleanup(5);
	} else {
	    if (!inn_opt) {
		/* C news: must make new empty spool queue */
		if ((togofp = fopen(togoname, "w")) == NULL
		    || fclose(togofp) == EOF) {
		    log_msg(L_ERRno,"can't create spool \"%s\"", togoname);
		    exit_cleanup(5);
		}
	    }
	}

	if (!keep_old_opt) {
	    /* and finally remove the old togo-file */
	    if (unlink(old_name) == EOF) {
		log_msg(L_ERRno,"can't unlink batch file \"%s\"", old_name);
		exit_cleanup(5);
	    }
	}
    }
    return (char *)0;
}

/*
 *  initial article_name is given
 */
void 
despool(char *article_name)
{
    do {
	/* post the article in question */
	if (!submit_article(article_name)) {
	    /* no success: write to temp file */

	    if (!noaction_opt) {
		if (!retryfp) {
		    /* open "retry" file */
		    if ((retryfp = fopen(retryname, "a")) == NULL) {
			log_msg(L_ERRno,"can't create \"%s\"",
							    retryname);
			exit_cleanup(5);
		    }
		}
	
		/* NOTE: looses rest of line -
		 * OK since probably only we'll ever see it again */
		strcat(buf,"\n");
		if (fputs(buf, retryfp) == EOF) {
		    log_msg(L_ERRno,"can't write \"%s\"", retryname);
		    exit_cleanup(5);
		}
	    }
	}
    } while ((article_name = despool_line()));
}
