/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Environment;
import gnu.mapping.Future;
import gnu.mapping.OutPort;
import gnu.mapping.Printable;
import gnu.mapping.TtyInPort;
import gnu.text.LineBufferedReader;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InPort
extends LineBufferedReader
implements Printable {
    private static InPort systemInPort;
    private static InPort defaultInPort;
    public char readState = (char)10;

    public InPort(Reader in) {
        super(in);
    }

    public InPort(Reader in, String name) {
        this(in);
        this.setName(name);
    }

    public InPort(InputStream in) {
        super(in);
    }

    public InPort(InputStream in, String name) {
        this(in);
        this.setName(name);
    }

    public static Reader convertToReader(InputStream in, Object conv) {
        if (conv != null && conv != Boolean.TRUE) {
            String enc = conv == Boolean.FALSE ? "8859_1" : conv.toString();
            try {
                return new InputStreamReader(in, enc);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("unknown character encoding: " + enc);
            }
        }
        return new InputStreamReader(in);
    }

    public InPort(InputStream in, String name, Object conv) throws UnsupportedEncodingException {
        this(InPort.convertToReader(in, conv), name);
        if (conv == Boolean.FALSE) {
            try {
                this.setBuffer(new char[2048]);
            }
            catch (IOException ex) {}
        } else {
            this.setConvertCR(true);
        }
    }

    public static InPort inDefault() {
        Thread thread = Thread.currentThread();
        if (thread instanceof Future) {
            return ((Future)thread).in;
        }
        return defaultInPort;
    }

    public static void setInDefault(InPort in) {
        Thread thread = Thread.currentThread();
        if (thread instanceof Future) {
            ((Future)thread).in = in;
        } else {
            defaultInPort = in;
        }
    }

    public static InPort openFile(String fname) throws UnsupportedEncodingException, FileNotFoundException {
        InputStream strm = new FileInputStream(fname);
        strm = new BufferedInputStream(strm);
        return InPort.openFile(strm, fname);
    }

    public static InPort openFile(InputStream strm, String fname) throws UnsupportedEncodingException {
        return new InPort(strm, fname, Environment.user().get("port-char-encoding"));
    }

    public char getReadState() {
        return this.readState;
    }

    @Override
    public void print(PrintWriter ps) {
        ps.print("#<input-port");
        String name = this.getName();
        if (name != null) {
            ps.print(' ');
            ps.print(name);
        }
        ps.print('>');
    }

    static {
        defaultInPort = systemInPort = new TtyInPort(System.in, "<stdin>", OutPort.outDefault());
    }
}

