/*
 *  Nikwi Deluxe
 *  Copyright (C) 2006  Kostas Michalopoulos
 *  
 *  A game by Kostas "Bad Sector" Michalopoulos
 *  email: badsector@slashstone.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
** Nikwi Engine - Image screen
*/

#include "nikwi.h"

ImageScreen	*imageScreen = NULL;

ImageScreen::ImageScreen()
{
	image = NULL;
	exitAfter = false;
	nextImageFile = NULL;
}

ImageScreen::~ImageScreen()
{
	if (image)
		SDL_FreeSurface(image);
}

void ImageScreen::showImage(Screen *from, char *file, int timeOutIn)
{
	backScreen = from;
	if (image)
		SDL_FreeSurface(image);
	image = loadImage(file);
	imageFile = file;
	
	activate();
	
	DoubleLinesTransition	*trans = new DoubleLinesTransition;
	trans->begin();
	draw();
	trans->play();
	delete trans;
	
	if (timeOutIn != -1)
	{
		timeOutEnabled = true;
		timeOut = timeOutIn;
		timeValue = 0;
	}
	else
		timeOutEnabled =false;

	if (exitAfter)
		SDL_Delay(2000);
	
	resetTimer();
}

void ImageScreen::timer()
{
	if (!timeOutEnabled)
		return;
	timeValue++;
	if (timeValue == timeOut)
	{
		SDL_FreeSurface(image);
		image = NULL;
		if (nextImageFile)
		{
			char	*save = nextImageFile;
			nextImageFile = NULL;
			showImage(backScreen, save, timeOut);
			return;
		}
		if (exitAfter)
			running = false;
		else
			backScreen->activate();
	}
}

void ImageScreen::draw()
{
	int	r;
	if ((r=SDL_BlitSurface(image, NULL, screen, NULL)) != 0)
	{
		if (r == -2)
		{
			SDL_FreeSurface(image);
			image = loadImage(imageFile);
		}
		SDL_Delay(100);
		draw();
		return;
	}
}

void ImageScreen::handleEvent(SDL_Event &e)
{
	if (e.type == SDL_KEYDOWN)
	{
		playSample(findSample(makeCode("tick")));
		SDL_FreeSurface(image);
		image = NULL;
		if (nextImageFile)
		{
			char	*save = nextImageFile;
			nextImageFile = NULL;
			showImage(backScreen, save, timeOut);
			return;
		}
		if (exitAfter)
			running = false;
		else
			backScreen->activate();
	}
}

