.\"
.\" %nmhwarning%
.\" $Id: mhparam.man,v 1.5 2001/01/25 21:15:55 ssen Exp $
.\"
.TH MHPARAM %manext1% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
mhparam \- print nmh profile components
.SH SYNOPSIS
.na
.B mhparam
.RI [ components ]
.RB [ \-all ]
.RB [ \-component " | " \-nocomponent ]
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
.B Mhparam
writes the value of the specified profile component to the
standard output separated by newlines.  If the profile component is not
present, the default value (or nothing if there is no default) is printed.
.PP
If the switch
.B \-component
is given, then the component name is displayed
along with the profile components value.  This can be disabled with the
switch
.BR \-nocomponent .
.PP
If more than one component is specified in the
.I components
list, then
the switch
.B \-component
is on by default.  If only one component is
specified, then the switch
.B \-nocomponent
is on by default.
.PP
If
.B \-all
is specified, then all components in the nmh profile are
displayed and other arguments are ignored.
.PP
Examples:
.PP
.RS 5
.nf
.ta \w'AliasFile:'u+2n
% mhparam path
Mail

% mhparam mhlproc
%libdir%/mhl

% mhparam \-component path
Path: Mail

% mhparam AliasFile rmmproc
AliasFile: aliases
rmmproc: rmmproc

% mhparam \-nocomponent AliasFile rmmproc
aliases
rmmproc
.fi
.RE
.PP
.B Mhparam
is also useful in back\-quoted operations:
.PP
.RS 5
.nf
% fgrep cornell.edu `mhpath +`/`mhparam aliasfile`
.fi
.RE
.PP

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
.fi

.SH "SEE ALSO"
mh-profile(5)

.SH DEFAULTS
.nf
.RB ` \-nocomponent "' if only one component is specified"
.RB ` \-component "' if more than one component is specified"
.RB ` components "' defaults to none"
.fi

.SH CONTEXT
None
