.\"
.\" %nmhwarning%
.\" $Id: sortm.man,v 1.5 2001/01/25 21:15:59 ssen Exp $
.\"
.TH SORTM %manext1% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
sortm \- sort messages
.SH SYNOPSIS
.HP 5
.na
.B sortm
.RI [ +folder ]
.RI [ msgs ]
.RB [ \-datefield
.IR field ]
.RB [ \-textfield
.IR field ]
.RB [ \-notextfield ]
.RB [ \-limit
.IR days ]
.RB [ \-nolimit ]
.RB [ \-verbose " | " \-noverbose ]
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
.B Sortm
sorts the specified messages in the named folder according
to the chronological order of the \*(lqDate:\*(rq field of each message.
.PP
The
.B \-verbose
switch directs
.B sortm
to tell the user the general
actions that it is taking to place the folder in sorted order.
.PP
The
.B \-datefield
.I field
switch tells
.B sortm
the name of the field to
use when making the date comparison.  If the user has a special field in
each message, such as \*(lqBB\-Posted:\*(rq or \*(lqDelivery\-Date:\*(rq,
then the
.B \-datefield
switch can be used to direct
.B sortm
which field to examine.
.PP
The
.B \-textfield
.I field
switch causes
.B sortm
to sort messages
by the specified text field.  If this field is \*(lqsubject\*(rq, any
leading "re:" is stripped off.  In any case, all characters except
letters and numbers are stripped and the resulting strings are sorted
datefield\-major, textfield\-minor, using a case insensitive comparison.
.PP
With
.B \-textfield
.IR field ,
if
.B \-limit
.I days
is specified, messages
with similar textfields that are dated within `days' of each other
appear together.  Specifying
.B \-nolimit
makes the limit infinity.
With
.B \-limit
.IR 0 ,
the sort is instead made textfield\-major, date\-minor.
.PP
For example, to order a folder by date-major, subject-minor, use:
.PP
.RS 5
sortm -textfield subject +folder
.RE

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
.fi

.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
.fi

.SH "SEE ALSO"
folder(1)

.SH DEFAULTS
.nf
.RB ` +folder "' defaults to the current folder"
.RB ` msgs"' defaults to all"
.RB ` \-datefield "' defaults to date"
.RB ` \-notextfield '
.RB ` \-noverbose '
.RB ` \-nolimit '
.fi

.SH CONTEXT
If a folder is given, it will become the current folder.  If the current
message is moved,
.B sortm
 will preserve its status as current.

.SH HISTORY
Timezones used to be ignored when comparing dates: they aren't any more.
.PP
Messages which were in the folder, but not specified by `msgs', used to
be moved to the end of the folder; now such messages are left untouched.
.PP
.B Sortm
sometimes did not preserve the message numbering in a folder
(e.g., messages 1, 3, and 5, might have been renumbered to 1, 2, 3 after
sorting).  This was a bug, and has been fixed.  To compress the message
numbering in a folder, use
.RB \*(lq "folder\ \-pack" \*(rq
as always.

.SH BUGS
If
.B sortm
encounters a message without a date\-field, or if the
message has a date\-field that
.B sortm
cannot parse, then
.B sortm
attempts to keep the message in the same relative position.  This does
not always work.  For instance, if the first message encountered lacks
a date which can be parsed, then it will usually be placed at the end
of the messages being sorted.
.PP
When
.B sortm
complains about a message which it can't temporally
order, it complains about the message number
.B prior
to sorting.
It should indicate what the message number will be
.B after
sorting.
