/****************************************************************************/
/* ##   ##         #####   #####  ##     **       NoSQL RDBMS - column      */
/* ###  ##        ####### ####### ##     **        $Revision: 1.1.1.1 $       */
/* #### ##        ###     ##   ## ##     ************************************/
/* #######  ####  #####   ##   ## ##     **   Carlo Strozzi (c) 1998-2000   */
/* ####### ######   ##### ## # ## ##     ************************************/
/* ## #### ##  ##     ### ##  ### ##     **           Written by            */
/* ##  ### ###### ####### ######  ###### **     Maurizio Sartori Masar      */
/* ##   ##  ####   #####   #### # ###### **    email: masar@mi.linux.it     */
/****************************************************************************/
/*  NoSQL RDBMS, Copyright (C) 1998 Carlo Strozzi.                          */
/*  This program comes with ABSOLUTELY NO WARRANTY; for details             */
/*  refer to the GNU General Public License.                                */
/**************************************************************************** 
   $Id: column.cpp,v 1.1.1.1 2003/03/17 09:49:20 carlo Exp $
 ****************************************************************************/

static char Psz_RCS [] =
    "$Id: column.cpp,v 1.1.1.1 2003/03/17 09:49:20 carlo Exp $";

/****************************************************************************/

#include <cstdlib>
#include <cctype>
#include <iostream.h>

#include <mcl/util/adb.hpp>


/****************************************************************************/
/*                                 main ()                                  */
/****************************************************************************/
int main (int argc, const char * argv [])
   {
   *Psz_RCS = *Psz_RCS;                 // To fake compiler warnings

   int i, j;
   int fLast     = 0;
   int fNoHeader = 0;
   int fPosition = 0;
   int fVerbose  = 0;

   MCL_ASCII_DB mclAdb (cin, '\t', "");

   /*************************************************************************/
   /* Initialize                                                            */
   /*************************************************************************/
   int *aiFields  = new int[argc];
   int iNumFields = 0;

   if (aiFields == NULL)
      {
      cerr << argv[0] << ": Out of Memory" << endl;
      return (2);
      }

   /*************************************************************************/
   /* Parse Global Options                                                  */
   /*************************************************************************/
   for (i = 1; i < argc; i++)
      {
      if (!strcmp (argv[i], "-f") || !strcmp (argv[i], "--first"))
         {
         // NOP
         }
      else if (!strcmp (argv[i], "-h") || !strcmp (argv[i], "--help"))
         {
         cerr << "Usage: nosql column [options] [PositionalParam | Fields]*" << endl
              << endl
              << "Options:" << endl
              << "   -N --no-header   don't print the headers" << endl
              << "   -p --position    print only column position" << endl
              << "   -v --verbose     print errors to STDERR" << endl
              << endl
              << "Positional Parameters:" << endl
              << "   -f --first       get the first of duplicated fields" << endl
              << "   -l --last        get the last of duplicated fields" << endl
              << "   -I --index       output the byte offset" << endl
              << "   -#               print the column at pos # (1 based)"
              << endl;

         return (4);
         }
      else if (!strcmp (argv[i], "-I") || !strcmp (argv[i], "--index"))
         {
         // NOP
         }
      else if (!strcmp (argv[i], "-l") || !strcmp (argv[i], "--last"))
         {
         // NOP
         }
      else if (!strcmp (argv[i], "-N") || !strcmp (argv[i], "--no-header"))
         {
         fNoHeader = 1;
         }
      else if (!strcmp (argv[i], "-p") || !strcmp (argv[i], "--position"))
         {
         fPosition = 1;
         }
      else if (!strcmp (argv[i], "-v") || !strcmp (argv[i], "--verbose"))
         {
         fVerbose = 1;
         }
      else if ((argv[i][0] == '-') && (atoi (&argv[i][1]) <= 0))
         {
         cerr << argv[0] << ": Parameter not Valid \""
              << &argv[i][0] << "\"" << endl;
         return (5);
         }
      }

   /*************************************************************************/
   /* Parse Positional Options                                              */
   /*************************************************************************/
   if (mclAdb.Next () != MCL_OK)
      {
      cerr << argv[0] << ": No Header" << endl;
      return (3);
      }

   for (i = 1; i < argc; i++)
      {
      if (!strcmp (argv[i], "-f") || !strcmp (argv[i], "--first"))
         {
         fLast = 0;
         }
      else if (!strcmp (argv[i], "-h") || !strcmp (argv[i], "--help"))
         {
         // NOP
         }
      else if (!strcmp (argv[i], "-I") || !strcmp (argv[i], "--index"))
         {
         aiFields[iNumFields] = -1;
         iNumFields++;
         }
      else if (!strcmp (argv[i], "-l") || !strcmp (argv[i], "--last"))
         {
         fLast = 1;
         }
      else if (!strcmp (argv[i], "-N") || !strcmp (argv[i], "--no-header"))
         {
         // NOP
         }
      else if (!strcmp (argv[i], "-p") || !strcmp (argv[i], "--position"))
         {
         // NOP
         }
      else if (!strcmp (argv[i], "-v") || !strcmp (argv[i], "--verbose"))
         {
         // NOP
         }
      else if (argv[i][0] == '-')
         {
         aiFields[iNumFields] = atoi (&argv[i][1]);
         aiFields[iNumFields]--;
         iNumFields++;
         }
      else
         {
         aiFields[iNumFields] = -i -1;
         for (j = 0; j < mclAdb.QueryFields (); j++)
            {
            if (!strcmp (mclAdb[j], argv[i]))
               {
               aiFields[iNumFields] = j;
               if (fLast == 0)
                  {
                  break;
                  }
               }
            }
         if ((aiFields[iNumFields] < 0) && fVerbose)
            {
            cerr << argv[0] << ": Field not found \""
                 << argv[i] << "\"" << endl;
            }
         iNumFields++;
         }
      }

   /*************************************************************************/
   /* Particular case: no fields -> all without duplicates                  */
   /*************************************************************************/
   if (iNumFields == 0)
      {
      delete [] aiFields;
      aiFields  = new int[mclAdb.QueryFields ()];

      if (aiFields == NULL)
         {
         cerr << argv[0] << ": Out of Memory" << endl;
         return (2);
         }

      for (j = 0; j < mclAdb.QueryFields (); j++)
         {
         for (i = 0; (i < j) && strcmp (mclAdb[j], mclAdb[aiFields[i]]); i++)
            {
            // NOP
            }

         if (i == j)
            {
            aiFields[iNumFields++] = j;
            }
         else if (fLast)
            {
            aiFields[i] = j;
            }
         }
      }

   /*************************************************************************/
   /* Print Headers and Separators                                          */
   /*************************************************************************/
   if (!fNoHeader)
      {
      cout << ((aiFields[0] == -1)      ? "lpos" :
               (aiFields[0] < -1)       ? argv[-aiFields[0]-1] :
               (mclAdb[aiFields[0]][0]) ? mclAdb[aiFields[0]] : "c");
      if ((aiFields[0] >= 0) && (mclAdb[aiFields[0]][0] == 0))
         cout << aiFields[0]+1;

      for (i = 1; i < iNumFields; i++)
         {
         cout << '\t'
              << ((aiFields[i] == -1)      ? "lpos" :
                  (aiFields[i] < -1)       ? argv[-aiFields[i]-1] :
                  (mclAdb[aiFields[i]][0]) ? mclAdb[aiFields[i]] : "c");
         if ((aiFields[i] >= 0) && (mclAdb[aiFields[i]][0] == 0))
            cout << aiFields[i]+1;
         }
      cout << "\n";
      }

   /*************************************************************************/
   /* Print Separators                                                      */
   /*************************************************************************/
   if (mclAdb.Next () != MCL_OK)
      {
      cerr << argv[0] << ": No Separators" << endl;
      return (4);
      }

   if (!fNoHeader)
      {
      cout << ((aiFields[0] == -1)      ? "----" :
               (aiFields[0] < -1)       ? "-" :
               (mclAdb[aiFields[0]][0]) ? mclAdb[aiFields[0]] : "-");
      for (i = 1; i < iNumFields; i++)
         {
         cout << '\t'
              << ((aiFields[i] == -1)      ? "----" :
                  (aiFields[i] < -1)       ? "-" :
                  (mclAdb[aiFields[i]][0]) ? mclAdb[aiFields[i]] : "-");
         }
      cout << "\n";
      }

   /*************************************************************************/
   /* Print Data                                                            */
   /*************************************************************************/
   if (fPosition)
      {
      cout << aiFields[0]+1;
      for (i = 1; i < iNumFields; i++)
         {
         cout << '\t'
              << aiFields[i]+1;
         }
      cout << "\n";
      return (0);
      }

   /*************************************************************************/
   /* Print Data                                                            */
   /*************************************************************************/
   while (mclAdb.Next () == MCL_OK)
      {
      if (aiFields[0] == -1)
         {
         cout << mclAdb.QueryPos();
         }
      else
         {
         cout << mclAdb[aiFields[0]];
         }

      for (i = 1; i < iNumFields; i++)
         {
         if (aiFields[i] == -1)
            {
            cout << '\t' << mclAdb.QueryPos();
            }
         else
            {
            cout << '\t' << mclAdb[aiFields[i]];
            }
         }
      cout << '\n';
      }

   cout << flush;

   return (MCL_OK);
   }

/* End of program */
