// file kernel/n/x86-64/dumpreg.S: debugging facilities
/*-----------------------------------------------------------------------+
 |  Copyright 2005-2006, Michel Quercia (michel.quercia@prepas.org)      |
 |                                                                       |
 |  This file is part of Numerix. Numerix is free software; you can      |
 |  redistribute it and/or modify it under the terms of the GNU Lesser   |
 |  General Public License as published by the Free Software Foundation; |
 |  either version 2.1 of the License, or (at your option) any later     |
 |  version.                                                             |
 |                                                                       |
 |  The Numerix Library is distributed in the hope that it will be       |
 |  useful, but WITHOUT ANY WARRANTY; without even the implied warranty  |
 |  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  |
 |  Lesser General Public License for more details.                      |
 |                                                                       |
 |  You should have received a copy of the GNU Lesser General Public     |
 |  License along with the GNU MP Library; see the file COPYING. If not, |
 |  write to the Free Software Foundation, Inc., 59 Temple Place -       |
 |  Suite 330, Boston, MA 02111-1307, USA.                               |
 +-----------------------------------------------------------------------+
 |                                                                       |
 |                   Affichage des registres x86-64                      |
 |                                                                       |
 +-----------------------------------------------------------------------*/


                         # +-------------------------+
                         # |  Affiche les registres  |
                         # +-------------------------+


# format : Flags edi esi ebp esp ebx edx ecx eax
# Flags  : [0  0  0  0]  [0  0  0  0]  [0  0  0  0]  [0  0  vm rf]
#          [0  nt id pl] [of df if tf] [sf zf 0  af] [0  pf 1  cf]
        
        ALIGN(32)
.Lsn_dump_reg:
        
	pushq %rax
	pushq %rbx
	pushq %rcx
	pushq %rdx
	pushf
	pushq %r15
	pushq %r14
	pushq %r13
	pushq %r12
	pushq %r11
	pushq %r10
	pushq %r9
	pushq %r8
	leaq 112(%rsp), %r8
	pushq %r8
	pushq %rbp
	pushq %rdi
	pushq %rsi

	movq   $1, %rdi
	leaq  .Lsn_dump_reg_fmt(%rip), %rsi
	movq   %rcx,  %r8
	movq   %rdx,  %r9
	movq   %rax,  %rdx
	movq   %rbx,  %rcx

	xorq   %rax,  %rax
        call   dprintf
	
	popq  %rsi
	popq  %rdi
	popq  %rbp
	popq  %r8
	popq  %r8
	popq  %r9
	popq  %r10
	popq  %r11
	popq  %r12
	popq  %r13
	popq  %r14
	popq  %r15
	popf
	popq  %rdx
	popq  %rcx
	popq  %rbx
 	popq  %rax

	ret

.Lsn_dump_reg_fmt:
	.string "\nax=%016lX bx=%016lX cx=%016lX dx=%016lX\nsi=%016lX di=%016lX bp=%016lX sp=%016lX\n8 =%016lX 9 =%016lX 10=%016lX 11=%016lX\n12=%016lX 13=%016lX 14=%016lX 15=%016lX\nfl=%016lX\n"
