/* recmeal.c */

/*
    NUT nutrition software 
    Copyright (C) 1996-2007 by Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "anameal.h"
#include "recmeal.h"
#include "food.h"
#include "options.h"
#include "util.h"
#include "db.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

void record_meals()
{
struct food *food_ptr;
struct meal *meal_ptr;
char meal_date[9];
char new_meal_date[9];
char theusual_id[9];
char substring[61];
char buff[61];
char key[61];
char *token;
int meal = 0, modfood, junk;
float ratio = 0, one = 1;
key[0] = '\0';
today(meal_date);
for ( ; ; )
 {
 header("NUT:  Record Meals");
 printf("\n\n\n\n\n\nMeal Date:    %s\n\n",meal_date);
 spacer(8);
 printf("\nType meal date (yyyymmdd) or just press <enter> for today's date:  ");
 get_string(new_meal_date,8);
 if (new_meal_date[0] == '-' || new_meal_date[0] == '+') time_machine(new_meal_date);
 if (strlen(new_meal_date) == 8) strcpy(meal_date,new_meal_date);
 if (strlen(new_meal_date) == 8 || strlen(new_meal_date) == 0) break;
 }
if (options.mealsperday > 1)
 {
 header("NUT:  Record Meals");
 printf("\n\n\n\n\n\nMeal Date:    %s\n\n",meal_date);
 printf("Meal Number:\n\n\n\n");
 meal_list(meal_date);
 spacer(15);
 printf("\nType meal number (1 to %d) or just <enter> to quit:  ",options.mealsperday);
 meal = get_int();
 if (meal < 1 || meal > options.mealsperday) return;
 }
if (options.mealsperday == 1) meal = 1;
for ( ; ; )
 {
 for ( ; ; )
  {
  if ((ratio != -383838) && (meal_find(meal_date,meal) != 0))
   {
   header("NUT:  Record Meals");
   if (! meal_show(meal_date,meal))
    {
    printf("\nPress <enter> to continue...");
    junk = get_int();
    }
   else
    {
    printf("\nEnter food name, # to delete, \".\" to analyze:  ");
    get_string(key,60);
    if (strcmp(key,"") == 0)
     {
     delete_meals(options.delopt); 
     if (meal_find(meal_date,meal) != 0) options.temp_meal_root = prev_meal(meal_find(meal_date,meal));
     return;
     }
    }
   }
  if (( strcmp(key,".") == 0 || strcmp(key,",") == 0 )) analyze_meals(prev_meal(meal_find(meal_date,meal)),1);
  else
   {
   modfood = atoi(key);
   strncpy(buff,key,60);
   token = strtok(buff, ", ");
   token = strtok(NULL,", ");
   if (strcmp(key,"") == 0 || modfood == 0) break;
   modify_meal(meal_date,meal,modfood,token);
   write_meal_db();
   strcpy(key,"");
   }
  }
 key_put(key);
 food_ptr = food_choice("NUT:  Record Meals", 1);
 if (food_ptr == (struct food *) -1 && meal_find(meal_date,meal) != 0) options.temp_meal_root = prev_meal(meal_find(meal_date,meal));
 if (food_ptr == (struct food *) -1) return;
 if (food_ptr == (struct food *)  0) key_clean();
 if (food_ptr == (struct food *)  0) key[0] = '\0';
 if (food_ptr == (struct food *)  0) continue;
 if (food_ptr != (struct food *) -2)
  {
  header("NUT:  Record Meals");
  food_show(food_ptr, &one);
  get_qty(&ratio, &(food_ptr->grams), &(food_ptr->nutrient[ENERC_KCAL]));
  if (ratio == -383838)
   {
   key_take();
   strcpy(key,key_take());
   }
  if (ratio != 0 && ratio != -383838)
   {
   if ((new_meal = malloc(sizeof(struct food))) == NULL)
    {
    printf("We are out of memory.  Bummer.\n");
    abort();
    } 
   new_meal->ndb_no = food_ptr->ndb_no;
   new_meal->food_no = food_ptr->food_no;
   strcpy(new_meal->meal_date,meal_date);
   new_meal->meal = meal;
   new_meal->grams = food_ptr->grams * ratio;
   order_new_meal();
   write_meal_db();
   }
  }
 if (food_ptr == (struct food *) -2)
  {
  key_decode(substring,key);
  meal_ptr = theusual_choice("NUT:  Record Meals",substring);
  if (meal_ptr == 0) continue;
  strcpy(theusual_id,meal_ptr->meal_date);
  while (strcmp(meal_ptr->meal_date,theusual_id) == 0)
   {
   if ((new_meal = malloc(sizeof(struct meal))) == NULL)
    {
    printf("We are out of memory.  Bummer.\n");
    abort();
    } 
   memcpy(new_meal,meal_ptr,sizeof(struct meal));
   strcpy(new_meal->meal_date,meal_date);
   new_meal->meal = meal;
   order_new_meal();
   meal_ptr = meal_ptr->next;
   if (meal_ptr == NULL) break;
   }
  write_meal_db();
  }
 }
}

void today(char *whatever)
{
int c, month = 0;
struct tm *p;
time_t t;
char timestamp[26];
char meal_date[9];
char *thismonth;
char *Months[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
time(&t);
p = localtime(&t);
strcpy(timestamp,asctime(p));
meal_date[0] = timestamp[20];
meal_date[1] = timestamp[21];
meal_date[2] = timestamp[22];
meal_date[3] = timestamp[23];
thismonth = timestamp + 4;
for (c = 0; c < 12 ; c++) if (strncmp(thismonth,Months[c],3) == 0) month = c+1;
sprintf(meal_date+4,"%02d",month);
meal_date[6] = timestamp[8];
meal_date[7] = timestamp[9];
meal_date[8] = '\0';
if (meal_date[6] == ' ') meal_date[6] = '0';
strncpy(whatever,meal_date,9);
}

void time_machine(char *whatever)
{
int c, month = 0, time_travel;
struct tm *p;
time_t t;
char timestamp[26];
char meal_date[9];
char *thismonth;
char *Months[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };
time_travel = 86400 * atoi(whatever);
time(&t);
t += time_travel;
p = localtime(&t);
strcpy(timestamp,asctime(p));
meal_date[0] = timestamp[20];
meal_date[1] = timestamp[21];
meal_date[2] = timestamp[22];
meal_date[3] = timestamp[23];
thismonth = timestamp + 4;
for (c = 0; c < 12 ; c++) if (strncmp(thismonth,Months[c],3) == 0) month = c+1;
sprintf(meal_date+4,"%02d",month);
meal_date[6] = timestamp[8];
meal_date[7] = timestamp[9];
meal_date[8] = '\0';
if (meal_date[6] == ' ') meal_date[6] = '0';
strncpy(whatever,meal_date,9);
}
