/*
 * nvidia-settings: A tool for configuring the NVIDIA X driver on Unix
 * and Linux systems.
 *
 * Copyright (C) 2004 NVIDIA Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of Version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See Version 2
 * of the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the:
 *
 *           Free Software Foundation, Inc.
 *           59 Temple Place - Suite 330
 *           Boston, MA 02111-1307, USA
 *
 */

/*
 * This source file contains a simple routine for uncompressing RGB
 * 1-byte-run-length-encoded images as generated by gimp when saving
 * as "C-Source".
 */

#include "image.h"

#include <stdlib.h>
#include <string.h>

#define GIMP_IMAGE_RUN_LENGTH_DECODE(image_buf, rle_data, size, bpp) \
do {                                                                 \
    unsigned int __bpp;                                              \
    unsigned char *__ip;                                             \
    const unsigned char *__il, *__rd;                                \
                                                                     \
    __bpp = (bpp);                                                   \
    __ip = (image_buf);                                              \
    __il = __ip + (size) * __bpp;                                    \
    __rd = (unsigned char *)(rle_data);                              \
                                                                     \
    if (__bpp > 3) { /* RGBA */                                      \
        while (__ip < __il) {                                        \
            unsigned int __l = *(__rd++);                            \
            if (__l & 128) {                                         \
                __l = __l - 128;                                     \
                do {                                                 \
                    memcpy (__ip, __rd, 4); __ip += 4;               \
                } while (--__l);                                     \
                __rd += 4;                                           \
            } else {                                                 \
                __l *= 4;                                            \
                memcpy (__ip, __rd, __l);                            \
                __ip += __l; __rd += __l;                            \
            }                                                        \
        }                                                            \
    } else { /* RGB */                                               \
        while (__ip < __il) {                                        \
            unsigned int __l = *(__rd++);                            \
            if (__l & 128) {                                         \
                __l = __l - 128;                                     \
                do {                                                 \
                    memcpy (__ip, __rd, 3); __ip += 3;               \
                } while (--__l); __rd += 3;                          \
            } else {                                                 \
                __l *= 3;                                            \
                memcpy (__ip, __rd, __l);                            \
                __ip += __l; __rd += __l;                            \
            }                                                        \
        }                                                            \
    }                                                                \
} while (0)

unsigned char *decompress_image_data(const nv_image_t *img)
{
    unsigned char *buf = malloc(img->width *
                                img->height *
                                img->bytes_per_pixel);

    GIMP_IMAGE_RUN_LENGTH_DECODE(buf, img->rle_pixel_data,
                                 img->width * img->height,
                                 img->bytes_per_pixel);
    return buf;
}


void free_decompressed_image(unsigned char *buf, void *ptr)
{
    free(buf);
}
