/* $Id: whattime.c,v 1.5 2004/08/16 17:25:16 graziano Exp $ */

#include <stdio.h>
#include <string.h>
#if TIME_WITH_SYS_TIME
#	include <sys/time.h>
#	include <time.h>
#else
# if HAVE_SYS_TIME_H
#	include <sys/time.h>
# else
#	include <time.h>
# endif
#endif
#include <stdlib.h>
#include <unistd.h>

#define SWITCHES "af:"

/**
 * print the usage of this executable
 */
void
usage(char *argv[])
{
	fprintf(stderr, "Usage: %s [OPTION] time ...\n", argv[0]);
	fprintf(stderr, "Translate seconds from epoch to friendlier time.\n\n");
	fprintf(stderr, "\t-a        alternative format (for scripts)\n");
	fprintf(stderr, "\t-f file   read from file (1st column is time).\n");
	fflush(stderr);
	exit(1);
}

/**
 * print the translated number
 */
void 
translate(int time_val, int alt)
{
	time_t tmp;
	char s[256];		/* hold the string to print */

	tmp = time_val;

	if (alt == 0) {
		fprintf(stdout,"%d == %s", time_val, ctime(&tmp));
	} else {
		strftime(s, 256, "%d-%m-%Y/%H:%M:%S", localtime(&tmp));
		printf("%s", s);
	}
	fflush(stdout);
}

/**
 * translate seconds from the epoch to some human friendly time. It can
 * print out a date suitable to be used in script (ie gnuplot will
 * understand it easily): use the -a switch.
 */
int
main(int argc, char *argv[])
{
	int time_val = 0;
	int i, alt=0, opt;
	char buffer[256];
	FILE *file = NULL;

	/* parse the command line */
	while ((opt = getopt(argc, argv, SWITCHES)) != EOF) {
		switch (opt) {
		case 'a':
			alt = 1;
			break;
		case 'f':
			file = fopen(optarg, "r");
			if (file == NULL) {
				fprintf(stderr, "Couldn't open %s\n", optarg);
				exit(1);
			}
			break;
		default:
			usage(argv);
			break;
		}
	}

	/* do the work */
	if (file != NULL) {
		while (fgets(buffer, 256, file) != NULL) {
			if (sscanf(buffer, "%d", &time_val) != 0) {
				translate(time_val, alt);
				printf("%s", strchr(buffer, ' '));
			}
		}
	} else {
		for (i = optind; i < argc; i++) {
			time_val = (int)strtol(argv[i], NULL, 10);
			translate(time_val, alt);
		}
	}

	if (file != NULL)
		fclose(file);

	return(0);
}
