/*
 *  Nextview logo images used for window and icon decoration
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation. You find a copy of this
 *  license in the file COPYRIGHT in the root directory of this release.
 *
 *  THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL,
 *  BUT WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
 *  MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *
 *  Description:
 *
 *    This module contains the Nextview EPG logo in 16x16 and 32x32
 *    resolution (8-bit grayscale format, but only 3 colors are used)
 *    and separate masks aka "alpha channels" (8-bit grayscale too, but
 *    here even only two values are used, i.e. opaque/transparent)
 *
 *  Author: Ownership of the Nextview logo is unknown
 *
 *  $Id: nxtv_wm_ico.h,v 1.2 2004/07/11 18:33:58 tom Exp tom $
 */

#ifndef __NXTV_WM_ICO_C
#define __NXTV_WM_ICO_C

#define NXTV_16X16_WIDTH 16
#define NXTV_16X16_HEIGHT 16
static const unsigned char
nxtv_16x16_pgm[NXTV_16X16_WIDTH * NXTV_16X16_HEIGHT] =
{
   255, 255, 255, 255, 255, 255, 255, 188, 0, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 0, 0, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 188, 0, 0, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 0, 0, 0, 186, 0, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 188, 0, 0, 186, 0, 0, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 0, 0, 189, 0, 0, 0, 186, 0, 255, 255, 255,
   255, 255, 255, 255, 189, 0, 186, 0, 0, 0, 186, 0, 0, 255, 255, 255,
   255, 255, 255, 255, 0, 0, 189, 0, 0, 188, 0, 0, 0, 186, 0, 255,
   255, 255, 255, 186, 0, 186, 0, 0, 186, 0, 0, 0, 189, 0, 0, 255,
   255, 255, 186, 0, 189, 0, 0, 189, 0, 0, 0, 186, 0, 0, 0, 255,
   255, 186, 0, 188, 0, 189, 186, 0, 0, 188, 189, 0, 0, 0, 188, 189,
   255, 0, 188, 0, 186, 0, 0, 186, 186, 0, 0, 0, 188, 186, 0, 186,
   255, 186, 0, 188, 0, 188, 186, 0, 0, 189, 188, 186, 0, 0, 0, 188,
   255, 255, 189, 0, 186, 0, 0, 186, 186, 186, 0, 0, 0, 0, 0, 189,
   255, 255, 255, 255, 0, 0, 189, 0, 0, 0, 0, 0, 0, 0, 0, 186,
   255, 255, 255, 255, 255, 255, 186, 188, 186, 188, 186, 188, 188, 186, 188, 186,
};
static const unsigned char
nxtv_16x16_mask_pgm[NXTV_16X16_WIDTH * NXTV_16X16_HEIGHT] =
{
   0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
   0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
   0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,
   0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,
   0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0,
   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
};
#define NXTV_32X32_WIDTH 32
#define NXTV_32X32_HEIGHT 32
static const unsigned char
nxtv_32x32_pgm[NXTV_32X32_WIDTH * NXTV_32X32_HEIGHT] =
{
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   128, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128,
   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0,
   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0,
   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0,
   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0, 0,
   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0, 0,
   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0, 0, 0,
   0, 255, 255, 255, 128, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0, 0, 0,
   0, 255, 255, 128, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0, 0, 0, 0,
   0, 255, 128, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0, 0, 0, 0,
   255, 128, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0, 0, 0, 0, 0,
   255, 128, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0, 0, 0, 0, 255,
   128, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0, 0, 0, 0, 0, 255,
   0, 0, 0, 0, 0, 255, 255, 128, 128, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0, 0, 0, 0, 255, 128,
   0, 0, 0, 0, 0, 255, 128, 128, 0, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0, 0, 0, 0, 255, 128, 0,
   0, 0, 0, 0, 255, 128, 0, 0, 0, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 0, 0, 0, 255, 255, 0, 0,
   0, 0, 0, 255, 128, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 128, 0, 0, 0, 255, 255, 128, 0, 0,
   0, 0, 255, 128, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 255, 255, 128, 0, 0, 0,
   0, 255, 128, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 128, 0, 0, 255, 255, 128, 0, 0, 0, 0,
   255, 128, 0, 0, 0, 0, 0, 0, 255, 255, 0, 128, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 128, 0, 0, 255, 255, 128, 0, 0, 0, 0, 255,
   128, 0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 128, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 0, 0, 255, 255, 128, 0, 0, 0, 0, 255, 128,
   0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 0, 128, 255, 255, 255,
   255, 255, 255, 255, 255, 128, 0, 0, 255, 128, 0, 0, 0, 255, 255, 128, 0,
   0, 0, 0, 0, 255, 255, 128, 0, 0, 0, 0, 128, 255, 255, 255,
   255, 255, 255, 255, 128, 0, 0, 255, 128, 0, 0, 0, 255, 128, 0, 0, 0,
   0, 0, 255, 255, 128, 0, 0, 0, 0, 0, 0, 128, 255, 128, 128,
   255, 255, 255, 128, 0, 0, 255, 128, 0, 0, 0, 255, 128, 0, 0, 0, 0,
   255, 255, 128, 0, 0, 0, 0, 0, 0, 0, 0, 255, 128, 0, 128,
   255, 255, 128, 0, 0, 255, 128, 0, 0, 255, 128, 0, 0, 0, 0, 255, 255,
   128, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 128, 0, 0, 128,
   255, 255, 128, 0, 255, 128, 0, 0, 255, 128, 0, 0, 128, 255, 255, 128, 0,
   0, 0, 0, 0, 255, 255, 255, 255, 128, 0, 0, 0, 0, 0, 128,
   255, 255, 255, 255, 128, 0, 0, 128, 0, 0, 0, 255, 128, 128, 0, 0, 0,
   0, 0, 255, 255, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 128,
   255, 255, 255, 255, 128, 0, 128, 0, 0, 255, 255, 128, 0, 0, 0, 0, 255,
   255, 255, 128, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128,
   255, 255, 255, 255, 255, 255, 0, 0, 255, 0, 0, 0, 0, 0, 0, 255, 128,
   128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 128, 128, 128, 128, 128, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 128, 128, 128, 128,
   128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
};
static const unsigned char
nxtv_32x32_mask_pgm[NXTV_32X32_WIDTH * NXTV_32X32_HEIGHT] =
{
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255,
   255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255,
   255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255,
   255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255,
   255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
   255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
   255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
   255, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
   255, 0, 0, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
   255, 0, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 0, 0, 255, 255, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 0, 255, 255, 255, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
   0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
   0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255,
   255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
};

#endif  // __NXTV_WM_ICO_C
