

%  This example shows how to sample a mathematical function over a
%  volume. A slice 
%  to produce 2D contour lines.
% 
vtk_init;

%  Quadric definition. This is a type of implicit function. Here the 
%  coefficients to the equations are set.
quadric = vtkQuadric();
quadric.SetCoefficients(.5, 1, .2, 0, .1, 0, 0, .2, 0, 0);

%  The vtkSampleFunction uses the quadric function and evaluates function
%  value over a regular lattice (i.e., a volume).
sample = vtkSampleFunction();
sample.SetSampleDimensions(30, 30, 30);
sample.SetImplicitFunction(quadric);
sample.ComputeNormalsOff();
sample.Update();

%  Here a single slice (i.e., image) is extracted 
%  actuality the VOI request causes the sample function to operate on just the
%  slice.)
extract = vtkExtractVOI();
extract.SetInput(sample.GetOutput());
extract.SetVOI(0, 29, 0, 29, 15, 15);
extract.SetSampleRate(1, 2, 3);

%  The image is contoured to produce contour lines. Thirteen contour values
%  ranging 
contours = vtkContourFilter();
contours.SetInput(extract.GetOutput());
contours.GenerateValues(13, 0.0, 1.2);

%  The contour lines are mapped to the graphics library.
contMapper = vtkPolyDataMapper();
contMapper.SetInput(contours.GetOutput());
contMapper.SetScalarRange(0.0, 1.2);

contActor = vtkActor();
contActor.SetMapper(contMapper);

%  Create outline an outline of the sampled data.
outline = vtkOutlineFilter();
outline.SetInput(sample.GetOutput());

outlineMapper = vtkPolyDataMapper();
outlineMapper.SetInput(outline.GetOutput());

outlineActor = vtkActor();
outlineActor.SetMapper(outlineMapper);
outlineActor.GetProperty().SetColor(0, 0, 0);

%  Create the renderer, render window, and interactor.
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);
iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);

%  Set the background color to white. Associate the actors with the
%  renderer.
ren.SetBackground(1, 1, 1);
ren.AddActor(contActor);
ren.AddActor(outlineActor);

%  Zoom in a little bit.
ren.GetActiveCamera().Zoom(1.5);

%  Initialize and start the event loop.

% renWin.Render();
vtkInitializeInteractor(iren);
