

%  This example shows how to extract portions of an unstructured grid
%  using vtkExtractUnstructuredGrid. vtkConnectivityFilter is also used
%  to extract connected components.
% 
%  The data found here represents a blow molding process. Blow molding
%  requires a mold and parison (hot, viscous plastic) which is shaped
%  by the mold into the final form. The data file contains several steps
%  in time for the analysis.

vtk_init;

VTK_DATA_ROOT = vtkGetDataRoot();

%  Create a reader to read the unstructured grid data. We use a
%  vtkDataSetReader which means the type of the output is unknown until
%  the data file is read. So we follow the reader with a
%  vtkCastToConcrete and cast the output to vtkUnstructuredGrid.
reader = vtkDataSetReader();
reader.SetFileName(strcat(VTK_DATA_ROOT,"/Data/blow.vtk"));
reader.SetScalarsName("thickness9");
reader.SetVectorsName("displacement9");
castToUnstructuredGrid = vtkCastToConcrete();
castToUnstructuredGrid.SetInput(reader.GetOutput());
warp = vtkWarpVector();
warp.SetInput(castToUnstructuredGrid.GetUnstructuredGridOutput());

%  The connectivity filter extracts the first two regions. These are
%  know to represent the mold.
connect = vtkConnectivityFilter();
connect.SetInput(warp.GetOutput());
connect.SetExtractionModeToSpecifiedRegions();
connect.AddSpecifiedRegion(0);
connect.AddSpecifiedRegion(1);
moldMapper = vtkDataSetMapper();
moldMapper.SetInput(reader.GetOutput());
moldMapper.ScalarVisibilityOff();
moldActor = vtkActor();
moldActor.SetMapper(moldMapper);
moldActor.GetProperty().SetColor(.2, .2, .2);
moldActor.GetProperty().SetRepresentationToWireframe();

%  Another connectivity filter is used to extract the parison.
connect2 = vtkConnectivityFilter();
connect2.SetInput(warp.GetOutput());
connect2.SetExtractionModeToSpecifiedRegions();
connect2.AddSpecifiedRegion(2);

%  We use vtkExtractUnstructuredGrid because we are interested in
%  looking at just a few cells. We use cell clipping via cell id to
%  extract the portion of the grid we are interested in.
extractGrid = vtkExtractUnstructuredGrid();
extractGrid.SetInput(connect2.GetOutput());
extractGrid.CellClippingOn();
extractGrid.SetCellMinimum(0);
extractGrid.SetCellMaximum(23);
parison = vtkGeometryFilter();
parison.SetInput(extractGrid.GetOutput());
normals2 = vtkPolyDataNormals();
normals2.SetInput(parison.GetOutput());
normals2.SetFeatureAngle(60);
lut = vtkLookupTable();
lut.SetHueRange(0.0, 0.66667);
parisonMapper = vtkPolyDataMapper();
parisonMapper.SetInput(normals2.GetOutput());
parisonMapper.SetLookupTable(lut);
parisonMapper.SetScalarRange(0.12, 1.0);
parisonActor = vtkActor();
parisonActor.SetMapper(parisonMapper);

%  graphics stuff
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);
iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);

%  Add the actors to the renderer, set the background and size
ren.AddActor(parisonActor);
ren.AddActor(moldActor);
ren.SetBackground(1, 1, 1);
ren.GetActiveCamera().Azimuth(60);
ren.GetActiveCamera().Roll(-90);
ren.GetActiveCamera().Dolly(2);
ren.ResetCameraClippingRange();
renWin.SetSize(500, 375);


% renWin.Render();
vtkInitializeInteractor(iren);
