

%  This example shows how to combine data 
%  graphics pipelines. The vtkMergeFilter is used to merge the data
%  

vtk_init;

VTK_DATA_ROOT = vtkGetDataRoot();

%  Read in an image and compute a luminance value. The image is
%  extracted as a set of polygons (vtkImageDataGeometryFilter). We then
%  will warp the plane using the scalar (luminance) values.
reader = vtkBMPReader();
reader.SetFileName(strcat(VTK_DATA_ROOT,"/Data/masonry.bmp"));
luminance = vtkImageLuminance();
luminance.SetInput(reader.GetOutput());
geometry = vtkImageDataGeometryFilter();
geometry.SetInput(luminance.GetOutput());
warp = vtkWarpScalar();
warp.SetInput(geometry.GetOutput());
warp.SetScaleFactor(-0.1);

%  Use vtkMergeFilter to combine the original image with the warped
%  geometry.
merge = vtkMergeFilter();
merge.SetGeometry(warp.GetOutput());
merge.SetScalars(reader.GetOutput());
mapper = vtkDataSetMapper();
mapper.SetInput(merge.GetOutput());
mapper.SetScalarRange(0, 255);
mapper.ImmediateModeRenderingOff();
actor = vtkActor();
actor.SetMapper(mapper);

%  Create renderer stuff
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);
iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);

%  Add the actors to the renderer, set the background and size
ren.AddActor(actor);
ren.GetActiveCamera().Azimuth(20);
ren.GetActiveCamera().Elevation(30);
ren.SetBackground(0.1, 0.2, 0.4);
ren.ResetCameraClippingRange();

renWin.SetSize(250, 250);

cam1 = ren.GetActiveCamera();
cam1.Zoom(1.4);


% renWin.Render();
vtkInitializeInteractor(iren);
