## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} vtk_sombsurf
## Example surface plot of the "sombrero" 2D function.
## @end deftypefn
## @seealso{vtk_sombmesh, vtk_surf}

## Author: Dragan Tubic

function vtk_sombsurf

  ##[x, y] = meshgrid(-8:0.125:8,-8:0.125:8);
  [x, y] = meshgrid(-8:0.5:8,-8:0.5:8);  #reduced gridpoints to see the triangles (and quicker rendering)
  
  z = 10*sin (sqrt (x.^2 + y.^2)) ./ (sqrt (x.^2 + y.^2));
  
  [nr nc] = size(x);
  z(floor(nr/2)+1,floor(nc/2)+1) = 10;
  
  vtk_surf(x,y,z);
  
endfunction
