## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} vtk_imshow(@var{a})
## Displays the unscaled (0-256?) data in @var{a} as an image.  @var{a}
## may be NxM or NxMx3.
## @end deftypefn
## @seealso{vtk_image_demo2}

## Author: Dragan Tubic

function vtk_imshow(a)
  vtk_init;
  
  if ( ndims(a) ~= 2 && ndims(a) ~= 3 )
    error('Input matrix has to be NxM or NxMx3.');
  end
  
  [nr nc] = size(a);
  
  if ( ndims(a) == 2 )
    ncomp = 1;
    image = a(:);
  end
  
  if ( ndims(a) == 3 )
    ncomp = 3;
    len = nr*nc*3;
    image = zeros(len,1);
    image(1:3:len) = a(:,:,1);
    image(2:3:len) = a(:,:,2);
    image(3:3:len) = a(:,:,3);
  end
  
  scalars = vtkUnsignedCharArray;
  %%scalars.SetNumberOfTuples(ncomp);
  %%scalars.SetNumberOfComponents(3);
  scalars.SetArray(image,nr*nc,0);
  
  image_data = vtkImageData;
  image_data.GetPointData().SetScalars(scalars);
  image_data.SetDimensions(nr,nc,1); 
  image_data.SetNumberOfScalarComponents(ncomp)
  image_data.SetScalarTypeToUnsignedChar()
  image_data.SetOrigin(0,0,0); 
  image_data.SetSpacing(1,1,1); 
  
  ia = vtkImageActor();
  ia.SetInput(image_data);
  
  f = vtk_figure(0);	  
  f.renderer.AddActor(ia);
  
  vtk_update(f);
  
endfunction
