## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} vtk_xlim([@var{xlimits}])
##
## Set  x-axis limits for plots.
##
## The argument @var{xlimits} should be a 2 element vector, [xmin, xmax].
##
## @end deftypefn
## @seealso{vtk_axis,vtk_ylim,vtk_zlim,vtk_xlabel,vtk_scalarbar}

## Author: Jonathan Stickel


function vtk_xlim(xlimits)
  
  f = vtk_figure(0);

  if (f.axes.GetUseRanges)
    limits = f.axes.GetRanges;
  else
    limits = f.outline.GetBounds;
  endif

  limits(1:2) = xlimits;
  vtk_axis(limits);
  
endfunction
