// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#include "prop_color_radio.h"

bool Radio::findvalinvalues(const char* val)
{
  std::string tmp=tolower(val);
  return (
	  allowed_values.find(tolower("|"+tmp+"|")) != std::string::npos
	  ||
	  allowed_values.find(tolower("|{"+tmp+"}|")) != std::string::npos
	  );
}

void Radio::defaultvalue(std::string& defval)
{
  // as a fallback, use first value
  int fp = allowed_values.find("|",1);
  if( fp == std::string::npos ) defval=allowed_values;
  else defval = std::string(allowed_values,1,fp-1);

  // now see if a default was specified
  int lp = allowed_values.find("{");
  if(lp != std::string::npos) {
    int rp = allowed_values.find("}");
    defval = std::string(allowed_values,lp+1,rp-lp-1);
  }
}

bool Radio::val(const char* value)
{
  if(findvalinvalues(value)) {
    cur_val = tolower(value);
    return true;
  }

  return false;
}

Radio::Radio(const char* values)
{
  allowed_values = tolower(values);
  defaultvalue(cur_val);
}

void Radio::Get(ocpl::command& com)
{
  com.argout(0,ocpl::str,
            cur_val.size()+1,1,
            const_cast<char*>(cur_val.c_str()));
}

void Radio::Set(ocpl::command& com)
{
  if(com.argin(2)->id != ocpl::str) {
    ret_error(com,"Value of property must be string");
    return;
  }
  
  if(val(com.argin(2)->data)) 
    com.init_argout(0);
  else	
    ret_error(com,"Illegal value in set");
}
