CXXSRCS = y.tab.cc lex.yy.cc idlerr.cc idlutil.cc idltype.cc-
	idlrepoId.cc idlscope.cc idlexpr.cc idlast.cc idlvalidate.cc-
	idldump.cc idlconfig.cc idlpython.cc idlc.cc idlfixed.cc

IDLMODULE_MAJOR   = 2
IDLMODULE_MINOR   = 0
IDLMODULE_VERSION = 0x2420# => CORBA 2.4, front-end 2.0
version=2.0.0

.ifdef PYTHON_1
DIR_CXXNAMEQUAL=/NAMES=UPPERCASE
PYTHON_1_NAME=PYTHON_1
.endif

DIR_CXXMACROS = IDLMODULE_VERSION=""""$(IDLMODULE_VERSION)""""\
	OMNIIDL_EXECUTABLE\
	YY_ALWAYS_INTERACTIVE\
	USE_IDLERROR\
	PYTHON_INCLUDE=""""<Python.h>""""\
	$(PYTHON_1_NAME)

DIR_CXXNOWARN=CODEUNREACHABLE

.IFDEF ALPHA
DIR_ALPHA_CXXLINKFLAGS=/sysexe
.ELSE
DIR_VAX_CXXLINKFLAGS=,SYS$SYSTEM:SYS.STB/selective
.ENDIF
DIR_CXXLINKFLAGS = $(DIR_ALPHA_CXXLINKFLAGS)$(DIR_VAX_CXXLINKFLAGS)/map/full\
/prelink=use_olb
DIR_CXXINCLUDES = PYTHON_INCLUDE:

SUBDIRS = cccp

all ::
	@ $(MakeSubdirs)

export ::
	@ $(MakeSubdirs)

OBJS = y_tab.obj lex_yy.obj idlerr.obj idlutil.obj idltype.obj \
	idlrepoId.obj idlscope.obj idlexpr.obj idlast.obj idlvalidate.obj \
	idldump.obj idlconfig.obj idlfixed.obj

MAINOBJ = idlpython.main
$(MAINOBJ) : idlpython.cc
	$(VERBOSITY) $(CXXCompile)

#############################################################################
#   Make rules for OpenVMS                                                  #
#############################################################################

# Only static linking is currently supported.

libname = _omniidlmodule
staticlib = $(libname).olb

OBJ_LIBS = sys$disk:[]$(staticlib)
OBJ_LIBS_DEPEND = sys$disk:[]$(staticlib)

omniidl=omniidl$(CONFIG_SUFFIX).exe

all :: $(omniidl)

# MMS/DEFINE=file.mms ignores .ifdef statements and erroneously complains about
# macro redefinitions.

.ifdef ALPHA
CORBAFLOAT_Alpha_OBJS = CorbaIEEEFloat.obj
.endif

CORBAFLOAT_VAX_OBJS = CorbaDFloat.obj CorbaGFloat.obj

CORBAFLOAT_OBJS = $(CORBAFLOAT_VAX_OBJS) $(CORBAFLOAT_Alpha_OBJS)

OBJS = y_tab.obj\
	lex_yy.obj\
	idlerr.obj\
	idlutil.obj\
	idltype.obj\
	idlrepoId.obj\
	idlscope.obj\
	idlexpr.obj\
	idlast.obj\
	idlvalidate.obj\
	idldump.obj\
	idlconfig.obj\
	idlfixed.obj\
	$(CORBAFLOAT_OBJS)

$(omniidl) : $(MAINOBJ) $(staticlib)
	$(CXXExecutable)\
	sys$disk:[-]python_$(PYTHON_MAJOR)$(CONFIG_SUFFIX).opt/opt

export :: $(omniidl)
	@ $(ExportExecutable)


clean ::
	$(RM) $(MAINOBJ)

veryclean ::
	$(RM) *.mms

#############################################################################
#   Test executable                                                         #
#############################################################################

all :: $(idlc)

$(idlc) : idlc.obj $(OBJS)
	@ $(CXXExecutable) $(staticlib)/lib
###	if f$search("$(staticlib)").eqs."" then lib/create/log $(staticlib)
###	if f$search("*.OBJ").nes."" then\
### pipe lib/replace/log $(staticlib) *.obj && delete *.obj;*

corbaDFloat.obj : [---.lib.omniORB.orbcore]corbaDFloat.cc
	$(CxxCompile) "/Float=D_Float"

corbaGFloat.obj : [---.lib.omniORB.orbcore]corbaGFloat.cc
	$(CxxCompile) "/Float=G_Float"

corbaIEEEFloat.obj : [---.lib.omniORB.orbcore]corbaIEEEFloat.cc
	$(CxxCompile) "/Float=IEEE_Float/Ieee=underflow"

$(staticlib) : $(OBJS)
	if f$search("$(staticlib)").eqs."" then lib/create/log $(staticlib)
	if f$search("*.OBJ").nes."" then lib/replace/log $(staticlib) *.obj

lex_yy.obj : lex.yy.cc
	$(VERBOSITY) $(CXXCompile)

y_tab.obj : y.tab.cc
	$(VERBOSITY) $(CXXCompile)

show ::
	! DIR_CXXFLAGS=$(DIR_CXXFLAGS)
	! DIR_CXXNAMEQUAL=$(DIR_CXXNAMEQUAL)
	! PYTHON_1=$(PYTHON_1)
