/***************************************************************************
 *   Copyright (C) 2006 by Christian Nitschkowski   *
 *   christian.nitschkowski@kdemail.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "oooqs2.h"
#include "oooqs2configdialog.h"

#include <qhbox.h>

#include <kconfig.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <klocale.h>
#include <kmessagebox.h>

#define Icon(x) KGlobal::instance()->iconLoader()->loadIcon(x, KIcon::NoGroup)

OOoQs2ConfigDialog::OOoQs2ConfigDialog( const bool onError, QWidget* parent )
   : KDialogBase( KDialogBase::IconList, 0, parent, 0, true, QString::null,
   KDialogBase::Ok|KDialogBase::Cancel )
{
   QHBox* boxGeneral = addHBoxPage( i18n( "General" ),
      i18n( "General Settings" ), Icon( "oooqs2" ) );
   QHBox* boxAdvanced = addHBoxPage( i18n( "Advanced" ),
      i18n( "Advanced Settings" ), Icon( "messagebox_warning" ) );

   p_wgtAdvanced = new WgtAdvanced( boxAdvanced );
   p_wgtGeneral = new WgtGeneral( boxGeneral );

   p_wgtGeneral->comboAccess->insertItem( i18n( "Start with template" ) );
   p_wgtGeneral->comboAccess->insertItem( i18n( "OpenOffice.org Base" ) );
   p_wgtGeneral->comboAccess->insertItem( i18n( "OpenOffice.org Calc" ) );
   p_wgtGeneral->comboAccess->insertItem( i18n( "OpenOffice.org Draw" ) );
   p_wgtGeneral->comboAccess->insertItem( i18n( "OpenOffice.org Impress" ) );
   p_wgtGeneral->comboAccess->insertItem( i18n( "OpenOffice.org Math" ) );
   p_wgtGeneral->comboAccess->insertItem( i18n( "OpenOffice.org Writer" ) );

   KConfig* config = KGlobal::config();
   config->setGroup( "General" );

   p_wgtGeneral->comboAccess->setCurrentItem(
      config->readNumEntry( "QuickAccess", 0 )
   );
   p_wgtGeneral->checkAutostart->setChecked(
      config->readBoolEntry( "Autostart", false )
   );

   config->setGroup( "Advanced" );
   p_wgtAdvanced->checkOverride->setChecked(
      config->readBoolEntry( "OverrideAutodetection", false )
   );
   p_wgtAdvanced->urlBinary->setURL(
      config->readPathEntry( "Binary" )
   );
   p_wgtAdvanced->checkPreload->setChecked(
      config->readBoolEntry( "EnablePreload", false )
   );

   connect( p_wgtAdvanced->checkPreload, SIGNAL( toggled( bool ) ),
      this, SLOT( preloadingToggled( bool ) )
   );

   if( onError )
   {
      showPage( 1 );
      p_wgtAdvanced->checkOverride->setChecked( true );
      p_wgtAdvanced->urlBinary->setFocus();
   }
}

OOoQs2ConfigDialog::~OOoQs2ConfigDialog()
{
}

void OOoQs2ConfigDialog::preloadingToggled( bool state )
{
   if( state == false )
   {
      return;
   }

   if( KMessageBox::questionYesNo( this,
      OOoQs2::preloadMessage() ) != KMessageBox::Yes )
   {
      p_wgtAdvanced->checkPreload->setChecked( false );
      return;
   }
}
