<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

function get_admin_tools_r()
{
	$handle=opendir('./admin');
	while ($file = readdir($handle))
    {
		if ( (!ereg("[.]",$file)) && file_exists('./admin/'.$file.'/index.php'))
		{
			$adminlist[] = $file;
		}
	}
	closedir($handle);
    
	if(is_array($adminlist) && count($adminlist)>0)
		return $adminlist;
	else // empty array as last resort.
		return array();
}

function is_legal_admin_type($type)
{
	if(strlen($type)>0 && file_exists('./admin/'.$type.'/index.php'))
		return true;
	else
		return false;
}

/**
	Count from start of array to offset-1, to see if value already
	exists.
*/
function is_earlier_value_found($offset, $arrofvalues)
{
	$value = $arrofvalues[$offset];

	if(strlen($value)>0)
	{
		for($i=0; $i<$offset; $i++)
		{
			// case insensitive!
			if(strcasecmp($arrofvalues[$i],$value)===0)
				return TRUE;
		}
	}

	//else
	return FALSE;
}

/**
	Isolate include of specific admin type config file using
	this function.
*/
function get_admin_config_r($type)
{
	// So we can access the language variables.
	global $LANG_VARS;
	@include("./admin/$type/config.php");

	if(strlen($menu_link_name)>0)
		$type_cfg['menu_link_name'] = $menu_link_name;
	else
		$type_cfg['menu_link_name'] = ucfirst($type);

	if(strlen($type_description)>0)
		$type_cfg['type_description'] = $type_description;

	return $type_cfg;
}
?>