<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/OpenDbSnoopy.class.inc");
include_once("./functions/utils.php");
include_once("./functions/fileutils.php");

/**
* Stub for old functionality.
*/
function open_url($URI, $http_cache=TRUE)
{
	$snoopy =& new OpenDbSnoopy();
	return $snoopy->fetchURI($URI, $http_cache);
}

/**
* Original logic for checking file upload status taken 
* from phpMyAdmin db_details.php script
*/
function is_file_upload_enabled()
{
	global $CONFIG_VARS;
	
	// Allows us to disable file upload at OpenDb level.
	if(!isset($CONFIG_VARS['file_upload_enable']))
		return (ini_get('file_uploads') == 1 || strtolower(ini_get('file_uploads')) == 'on');
	else
		return $CONFIG_VARS['file_upload_enable'];
}

/*
* It seems that some sites have ini_get as a disabled function.  So all the logic
* to ascertain register_globals is in this function, where we can implement a workaround.
*/
function is_register_globals_enabled()
{
	global $CONFIG_VARS;
	
	if(!isset($CONFIG_VARS['register_globals_enabled']))
		return (ini_get('register_globals') == 1 || strtolower(ini_get('register_globals')) == 'on');
	else
		return $CONFIG_VARS['register_globals_enabled'];
}

/**
	Get access to a server variable value in a php
	version independant manner.
*/
function get_http_env($envname)
{
	global $HTTP_SERVER_VARS;
	// Apparently this is unecessary, but since new versions
	// of php break existing functionality all the time, I will
	// leave just in case.
	global $_SERVER;

	if(is_not_empty_array($HTTP_SERVER_VARS))
		return $HTTP_SERVER_VARS[$envname];
	else if(is_not_empty_array($_SERVER))
		return $_SERVER[$envname];
	else
		return NULL; // Should never happen!
}

/**
	Taken from phpMyAdmin libraries/defines.lib.php

	Determines platform (OS)
	Based on a phpBuilder article:
		see http://www.phpbuilder.net/columns/tim20000821.php
*/
function get_user_browser_os()
{
	$http_user_agent = get_http_env('HTTP_USER_AGENT');

    // 1. Platform
    if (strstr($http_user_agent, 'Win'))
		return 'Win';
	else if (strstr($http_user_agent, 'Mac'))
		return 'Mac';
	else if (strstr($http_user_agent, 'Linux'))
		return 'Linux';
	else if (strstr($http_user_agent, 'Unix'))
		return 'Unix';
	else if (strstr($http_user_agent, 'OS/2'))
		return 'OS/2';
	else
		return 'Other';
}

/**
	Taken from phpMyAdmin libraries/common.lib.php
*/
function get_user_browser_crlf()
{
	$browser_os = get_user_browser_os();
	
	if ($browser_os == 'Win')// Win case
		return "\r\n";
	else if (PMA_USR_OS == 'Mac')// Mac case
		return "\r";
	else // Others
		return "\n";
}

/**
	Check if $url has a protocol at the start. 
*/
function is_url_absolute($url)
{
	if(preg_match("!([a-zA-Z]+)://!", $url))
	{
		return TRUE;
	}
	else
		return FALSE;
}

/**
	Fetches site url
*/
function get_site_url()
{
	global $CONFIG_VARS;

	$protocol = get_site_protocol();
	$host = get_site_host();
	$port = get_site_port();
	$path = get_site_path();
	
	// do not display port if default port for either protocol.
	if(($protocol == 'http' && $port == '80') || ($protocol == 'https' && $port == '443'))
		$port = '';
	
	return $protocol."://".$host.(strlen($port)>0?":".$port:"").$path;
}

function get_site_protocol()
{
	global $CONFIG_VARS;
	
	// Override auto
	if(strlen($CONFIG_VARS['site.protocol'])>0)
		return $CONFIG_VARS['site.protocol'];
	else
	{
		if(get_http_env("HTTPS") == "on")
			return "https";
		else
			return "http";
	}
}

function get_site_host()
{
	global $CONFIG_VARS;
	
	// Override auto
	if(strlen($CONFIG_VARS['site.host'])>0)
		return $CONFIG_VARS['site.host'];
	else
		return get_http_env("SERVER_NAME");
}

function get_site_port()
{
	global $CONFIG_VARS;
	
	// Override auto
	if(strlen($CONFIG_VARS['site.port'])>0)
		return $CONFIG_VARS['site.port'];
	else
		return get_http_env("SERVER_PORT");
}

function get_site_path()
{
	global $CONFIG_VARS;
	
	if(strlen($CONFIG_VARS['site.path']))
		return $CONFIG_VARS['site.path'];
	else
	{
		// It seems that Win32 uses PATH_INFO instead of SCRIPT_NAME
		$path = ifempty(get_http_env("PATH_INFO"),
					ifempty(get_http_env("PHP_SELF"), 
						get_http_env("SCRIPT_NAME")));
	
		// Now process path to get rid of anything after last /
		$index = strrpos($path,"/");
		if($index !== FALSE)
			$path = substr($path,0,$index+1);//include last slash!
	
		return $path;
	}
}

/**
	Convert all HTTP variables into a GET string.

	// Does not include empty fields.
*/
function get_url_string($http_vars, $extra_vars_r=NULL, $exclude_keys_r=NULL)
{
	$url = '';

	// Merge - $extra_vars_r may contain new values for existing variables.
	if(is_array($http_vars) && is_array($extra_vars_r))
		$http_vars = array_merge($http_vars,$extra_vars_r);
	else if(is_array($extra_vars_r))
		$http_vars = $extra_vars_r;

	@reset($http_vars);
	while(list($key, $value) = @each($http_vars))
	{
		if(!is_array($exclude_keys_r) || !in_array($key,$exclude_keys_r))
		{
			$url = _get_url_string($url, $key, $value);
		}
	}
	
	return $url;
}

function _get_url_string($url, $key, $value)
{
	if(is_array($value))
	{
		while (list($akey,$avalue) = each($value))
		{
			if(is_numeric($akey))
				$url = _get_url_string($url, $key.'[]', $avalue);
			else
				$url = _get_url_string($url, $key.'['.$akey.']', $avalue);
		}
	}
	else if(strlen($value)>0)
	{
		if(strlen($url)>0)
			$url .= '&';
					
		$url .= $key.'='.rawurlencode($value);
	}
	
	return $url;
}

/**
	Pass all http variables onto next instance...

	Note: Includes empty fields which may cause problems in some situations.
*/
function get_url_fields($http_vars, $extra_vars_r=NULL, $exclude_keys_r = NULL)
{
	$fields = '';

	// Merge - $extra_vars_r may contain new values for existing variables.
	if(is_array($http_vars) && is_array($extra_vars_r))
		$http_vars = array_merge($http_vars,$extra_vars_r);
	else if(is_array($extra_vars_r))
		$http_vars = $extra_vars_r;
		
	@reset($http_vars);
	while (list($key, $value) = @each($http_vars))
	{
		if(!is_array($exclude_keys_r) || !in_array($key,$exclude_keys_r))
		{
			$fields .= _get_url_field($key, $value);
		}
	}
	return $fields;
}

function _get_url_field($key, $value)
{
	$fields = '';
	if(is_array($value))
	{
		while (list($akey,$avalue) = each($value))
		{
			if(is_numeric($akey))
				$fields .= _get_url_field($key.'[]', $avalue);
			else
				$fields .= _get_url_field($key.'['.$akey.']', $avalue);
		}
	}
	else
	{
		$fields .= "\n<input type=\"hidden\" name=\"$key\" value=\"".htmlspecialchars($value)."\">";
	}
	
	return $fields;
}

/**
* Will parse string
*/
function is_uri_domain_in_list($url, $domain_list_r)
{
	if(strlen($url) && is_not_empty_array($domain_list_r))
	{
	
		$url_parts_r = parse_url($url);
	
		$domain = $url_parts_r['host'];
	
		while( ($index = strpos($domain, '.')) !== FALSE )
		{
			if(in_array($domain,$domain_list_r))
			{
				return TRUE;
			}
			else
			{
				$domain = substr($domain, $index+1);
			}
		}
	}
	
	////else
	return FALSE;
}
?>
