<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
include_once("./functions/item.php");
include_once("./functions/parseutils.php");
include_once("./functions/http.php");
include_once("./functions/widgets.php");
include_once("./functions/listutils.php");
include_once("./functions/user.php");
include_once("./functions/item_attribute.php");

/**
* @param $search_vars_r
* 	not_owner_id
* 	owner_id
* 	s_item_type
* 	update_on
*/
function get_last_num_items_rs($num_of_items, $owner_id = NULL, $s_item_type = NULL, $update_on = NULL, $not_owner_id = NULL)
{
	global $CONFIG_VARS;

	if(strlen($owner_id)>0)
		$search_vars_r['owner_id'] = $owner_id;
		
	if(strlen($s_item_type)>0)
		$search_vars_r['s_item_type'] = $s_item_type;
	
	if(strlen($update_on)>0)
		$search_vars_r['update_on'] = $update_on;
		
	if(strlen($not_owner_id)>0)
		$search_vars_r['not_owner_id'] = $not_owner_id;
	
	$results = fetch_item_listing_rs($search_vars_r, $dummy_r, 'update_on', 'DESC', 0, $num_of_items);
	if($results)
	{
		$image_attribute_type_r = NULL;
		while($item_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			$item_r['item_display_url'] = 'item_display.php?item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'];
			
			if($CONFIG_VARS['last_items_list.show_item_image']!==FALSE)
			{
				if(!is_array( $image_attribute_type_r ) || strlen( $image_attribute_type_r[$item_r['s_item_type']] ) == 0)
				{
					$image_attribute_type_r[$item_r['s_item_type']] =  fetch_sfieldtype_item_attribute_type($item_r['s_item_type'], 'IMAGE'); 
				}
				
				//reset it
				$imageurl = '';
	
				// of a IMAGE s_attribute defined for this s_item_type
				if(strlen($image_attribute_type_r[$item_r['s_item_type']])>0)
				{
					$imageurl = fetch_attribute_val($item_r['item_id'], $image_attribute_type_r[$item_r['s_item_type']]);
				}
				
				// if $imageurl not defined or $imageurl refers to non-existent local image, then override
				// with no-image configured theme image.
				if((strlen($imageurl)==0 || (!is_url_absolute($imageurl) && !file_exists($imageurl))) && 
						strlen($CONFIG_VARS['last_items_list.no_image'])>0)
				{
					$imageurl = _theme_image_src($CONFIG_VARS['last_items_list.no_image']);
				}
				
				if(strlen($imageurl)>0)
				{
					$image_r = get_cover_image_r(
							$imageurl,
							$CONFIG_VARS['last_items_list.item_image_size']);
							
					if(strlen($image_r['thumbnailurl'])>0)
						$item_r['cover_image']['url'] = $image_r['thumbnailurl'];
					else
						$item_r['cover_image']['url'] = $image_r['imageurl'];
						
					if(is_numeric($image_r['thumbnailurlsize']['width']))
						$item_r['cover_image']['width'] = $image_r['thumbnailurlsize']['width'];
					if(is_numeric($image_r['thumbnailurlsize']['height']))
						$item_r['cover_image']['height'] = $image_r['thumbnailurlsize']['height'];
				}
			}//if($CONFIG_VARS['last_items_list.show_item_image']!==FALSE)
			
			$item_r['title'] = expand_item_title_mask($item_r, (is_array($CONFIG_VARS['last_items_list.title_display_mask'])?$CONFIG_VARS['last_items_list.title_display_mask']:$CONFIG_VARS['listings.title_display_mask']));
			$item_r['update_on'] = get_localised_timestamp($CONFIG_VARS['last_items_list.datetime_mask'], $item_r['update_on']);
			
			$item_rs[] = $item_r;
			
			unset($item_r);
		}//while
		mysql_free_result($results);
	}
	return $item_rs;
}

function get_last_num_items_block(
						$list_item_rs, 
						$guest_user = NULL, 
						$guest_passwd = NULL, 
						$use_opendb_table_classes = TRUE,
						$item_display_popup = TRUE,
						$columns = 1, 
						$site_url_prefix = NULL)
{
	global $CONFIG_VARS;
	
	$buffer = "\n<table border=0>";
		
	reset($list_item_rs);
	$count = 0;
	while(list(,$list_item_r) = @each($list_item_rs))
	{
		if($count == 0)
			$buffer .= "\n<tr>";
		
		$buffer .= "\n<td valign=top align=center".($use_opendb_table_classes?" class=\"data\"":"").">";

		if($item_display_popup)
			$list_item_r['item_display_url'] .= '&inc_menu=N';
							
		if($site_url_prefix!=NULL && $guest_user != NULL && $guest_passwd != NULL)
		{
			$list_item_r['item_display_url'] = $site_url_prefix."login.php?op=login&uid=".$guest_user."&passwd=".$guest_passwd."&redirect=".urlencode(urlencode($list_item_r['item_display_url']));
		}
		else if($site_url_prefix!=NULL)
		{
		    $list_item_r['item_display_url'] = $site_url_prefix.$list_item_r['item_display_url'];
		}
		
		if(is_not_empty_array($list_item_r['cover_image']))
		{
			if($item_display_popup)
				$imageblock = "<a href=\"javascript:popup('".htmlspecialchars($list_item_r['item_display_url'])."', 640, 480);\">";
			else
				$imageblock = "<a href=\"".htmlspecialchars($list_item_r['item_display_url'])."\">";
			
			if($site_url_prefix!=NULL && 
						strlen($list_item_r['cover_image']['url'])>0 && 
						!is_url_absolute($list_item_r['cover_image']['url']))
			{
				$list_item_r['cover_image']['url'] = $site_url_prefix . $list_item_r['cover_image']['url'];
			}
			
			$imageblock .= "<img src=\"".$list_item_r['cover_image']['url']."\" border=0 title=\"".htmlspecialchars($list_item_r['title'])."\" ";
			
			if(is_numeric($list_item_r['cover_image']['width']))
				$imageblock .= ' width="'.$list_item_r['cover_image']['width'].'"';
			if(is_numeric($list_item_r['cover_image']['height']))
				$imageblock .= ' height="'.$list_item_r['cover_image']['height'].'"';
			
			$imageblock .= ">";
			
			$imageblock .= "</a>";
		}
		
		if($item_display_popup)
				$titleblock = "<a href=\"javascript:popup('".htmlspecialchars($list_item_r['item_display_url'])."', 640, 480);\">";
			else
				$titleblock = "<a href=\"".htmlspecialchars($list_item_r['item_display_url'])."\">";
				
		$titleblock .= $list_item_r['title']."</a>";
		
		$updateonblock = $list_item_r['update_on'];
		
		$buffer .= str_replaces(
				array('{title}', '{image}', '{update_on}'), 
				array($titleblock, $imageblock, $updateonblock), 
				$CONFIG_VARS['last_items_list.item_block']);
				
		$buffer .= "\n</td>";
		$count++;
		
		if($count == $columns)
		{
			$buffer .= "\n</tr>";
			$count = 0;
		}
	}
	
	if($count > 0)
	{	
		for($i=$count; $i<$columns; $i++)
			$buffer .= "\n<td>&nbsp;</td>";
		$buffer .= "\n</tr>";
	}
	$buffer .= "\n</table>";
	
	return $buffer;
}
?>
