<?php
//---------------------------------------------------------------------------------------------------
// Database configuration
$CONFIG_VARS['db_server.host'] = 'localhost';	//OpenDb database host
$CONFIG_VARS['db_server.dbname'] = 'opendb';//OpenDb database name
$CONFIG_VARS['db_server.username'] = 'lender';	//OpenDb database user name
$CONFIG_VARS['db_server.passwd'] = 'test';	//OpenDb user password 
//$CONFIG_VARS['db_server.table_prefix'] = 'opendb_';//Specify a table prefix.  Include the '_' as well!
$CONFIG_VARS['db_server.debug-sql'] = FALSE;//Specify whether all SQL statements should be displayed in the page.

$CONFIG_VARS['session_handler.enable'] = FALSE;
// Note this table will not be prefixed, even if prefixing support is enabled.  You should include the 
// prefix in the session_table variable definition if required.
//$CONFIG_VARS['session_handler.session_table'] = 'php_session';
//$CONFIG_VARS['session_handler.host'] = 'localhost';
//$CONFIG_VARS['session_handler.dbname'] = 'opendb';
//$CONFIG_VARS['session_handler.username'] = 'lender';
//$CONFIG_VARS['session_handler.passwd'] = 'test';
$CONFIG_VARS['session_handler.debug-sql'] = FALSE;

//---------------------------------------------------------------------------------------------------
// Proxy configuration
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['proxy_server.enable'] = FALSE;
$CONFIG_VARS['proxy_server.host'] = 'squid.domain.com.au';
$CONFIG_VARS['proxy_server.port'] = '8080';
$CONFIG_VARS['proxy_server.userid'] = 'jpell';
$CONFIG_VARS['proxy_server.password'] = 'pwd';

//---------------------------------------------------------------------------------------------------
// General site configuration
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['site.enable'] = TRUE; 	// If set to false, then the site is disabled, via index.php.
$CONFIG_VARS['site.title'] = 'OpenDb';// Title of site.
$CONFIG_VARS['site.version'] = '0.81p20'; // YOU MIGHT BREAK SOMETHING IF YOU CHANGE THIS - SO DON'T!!!!!!

// Session duration configuration (1800 = 1/2h)
$CONFIG_VARS['site.idle_timeout'] = 3600; // How long a session can be idle
//$CONFIG_VARS['site.login_timeout'] = 7200; // How long a session can exist

// Change for each site you have on the same host, under the same install of php!
$CONFIG_VARS['site.security_hash'] = '0eXf5yUKlaeDgREQ72091mvFX';
$CONFIG_VARS['site.admin_name'] = 'Jason Pell'; // Site Administrator.
$CONFIG_VARS['site.admin_email'] = 'jason@iamvegan.net'; // Admin email address, including sign-up.
$CONFIG_VARS['site.language'] = 'english';// Default site language.
$CONFIG_VARS['site.theme'] = 'default';// Default site theme.

// Disable file upload functionality, even if provided by PHP.
//$CONFIG_VARS['file_upload_enable'] = TRUE;

// Indicates whether register globals in enabled in the php.ini configuration file.
// This is a workaround for sites where ini_get() is disabled.
//$CONFIG_VARS['register_globals_enabled'] = TRUE;

// Ensure the PHPSESSID cookie is restricted to this OpenDb instance.  
// The $CONFIG_VARS['site.host'] and $CONFIG_VARS['site.path'] variables can be used to override the
// defaults if required.
$CONFIG_VARS['site.restrict_session_cookie_to_host_path'] = FALSE;

//---------------------------------------------------------------------------------------------------
// Override automatic protocol://host:port/path/ information.
//---------------------------------------------------------------------------------------------------
//$CONFIG_VARS['site.protocol'] = 'http';
//$CONFIG_VARS['site.host'] = 'host.domain.com.au';
//$CONFIG_VARS['site.port'] = '80';
//$CONFIG_VARS['site.path'] = '/opendb/';

//---------------------------------------------------------------------------------------------------
// Public access configuration
//---------------------------------------------------------------------------------------------------
// Expose the OpenDb as a public site, with 'guest' userid
$CONFIG_VARS['site.public_access.enable'] = FALSE;

// If the $CONFIG_VARS['site.public_access.enable'] = TRUE, then this user MUST be a valid 
// AND active user.  Otherwise the 'Site is currently disabled' message will be returned.
$CONFIG_VARS['site.public_access.user_id'] = 'guest';

// whether to allow user login while in public access mode.
$CONFIG_VARS['site.public_access.allow_login'] = TRUE;

//---------------------------------------------------------------------------------------------------
// Widgets configuration
//---------------------------------------------------------------------------------------------------
// If you are not interested in using javascript for validation, you can disable it.  This
// will not remove all javascript, but will remove all Input Field validation.  The scripts
// will still validate all the data (server side) anyway.
$CONFIG_VARS['widgets.enable_javascript_validation'] = TRUE;

// Does not currently support <a> or <img>, due to concerns about javascript in these elements
$CONFIG_VARS['widgets.legal_html_tags'] = '<p><b><i><u><s><em><br><strong><strike><big><sup><sub>';

// if widgets should display visual cue that the field is compulsory.
$CONFIG_VARS['widgets.show_prompt_compulsory_ind'] = TRUE;

 //---------------------------------------------------------------------------------------------------
// New User Configuration
//---------------------------------------------------------------------------------------------------
// Whether 'Sign Me Up' link should be provided
$CONFIG_VARS['newuser.signup_enable'] = TRUE;

// control list of user types provided as options in the initial signup screen.  Types other
// than 'N' and 'B' have not been tested, and thus are NOT supported.  If you want to try
// other types, you will need to update the language variable $LANG_VARS['new_account_usertype_intro']
// for each new type you introduce.
$CONFIG_VARS['newuser.signup_restrict_usertypes'] = array('N','B');

//---------------------------------------------------------------------------------------------------
// Output Buffer configuration
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['output_buffer.enable'] = TRUE;
$CONFIG_VARS['output_buffer.handler'] = 'ob_gzhandler';

//---------------------------------------------------------------------------------------------------
// Logging configuration
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['logging.enable'] = TRUE;		//Enable/Disable user logging  ( yes/no )
$CONFIG_VARS['logging.file'] = './log/usagelog.txt';	//If logging is enabled, make sure this directory is "writable"
$CONFIG_VARS['logging.backup_ext_date_format'] = 'DDMONYYYY';	// Specify extension date format for backup of logfile.

//---------------------------------------------------------------------------------------------------
// HTTP Configuration
//---------------------------------------------------------------------------------------------------
// Debug Snoopy HTTP connections.
$CONFIG_VARS['http.debug'] = FALSE;

// use to load external image URL's via the external.php script using Snoopy.
$CONFIG_VARS['http.stream_external_images'] = TRUE;

//restrict streaming of external images to specified list of domain names.  Very useful for working around
// imdb cover image display restrictions without impacting other plugins which work just fine.
$CONFIG_VARS['http.stream_external_images_domain_list'] = array('imdb.com','imdb.org');

//---------------------------------------------------------------------------------------------------
//System Admin toola.
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['system_admin_tools.datetime_mask'] = 'DD/MM/YYYY HH24:MI:SS';

//---------------------------------------------------------------------------------------------------
// HTTP Cache Configuration - See System Admin 'Cache Admin' tool.
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['http_cache.enable'] = TRUE;
$CONFIG_VARS['http_cache.lifetime'] = 86400 * 7; // 7 days
$CONFIG_VARS['http_cache.datetime_mask'] = 'DD/MM/YYYY HH24:MI:SS';
$CONFIG_VARS['http_cache.max_cache_size'] = 1 * 1048576; // in bytes
// if set to zero, no compression of the files will take place.  If set
// to another value between 1 and 9, the content will be compressed
// before being inserted into the database.
$CONFIG_VARS['http_cache.gzcompress.level'] = 1;

//---------------------------------------------------------------------------------------------------
// Email configuration 
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['email.use_php_mail'] = TRUE; // Control whether the email form uses PHP mail or the mailto: protocol.

// Set to FALSE, to disable formatting of email address to include the persons name as well as the email address.
$CONFIG_VARS['email.friendly_email_format'] = TRUE;

// Will format email for delivery, assuming WIN32 SMTP server will be recipient. 
$CONFIG_VARS['email.win32_smtp_email'] = FALSE;

// Whether Sending Email to admin is supported.
$CONFIG_VARS['email.send_to_site_admin'] = TRUE;

// configure the s_address_type and s_attribute_type where EMAIL address is stored in user_address_attribute.
$CONFIG_VARS['email.user_address_attribute'] = array(s_attribute_type=>'EMAIL_ADDR');

//---------------------------------------------------------------------------------------------------
// Install/Patch Functionality
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['patch.enable'] = TRUE; // Set this to false after applying patches/install to disable access.

// If this variable is set to TRUE, then the patch.enable value is ignored,
// as long as an authenticated Administrator trying to access it.
$CONFIG_VARS['patch.allow_admin_override'] = TRUE;

// Whether index.php should perform an upgrade required check each time it is executed.  Index.php
// is actually executed very rarely, so the check is not that much of an issue, but if required the
// check can be turned off.
$CONFIG_VARS['patch.upgrade_check'] = TRUE;

//===================================================================================================
// Page specific configuration
//===================================================================================================

//---------------------------------------------------------------------------------------------------
// Login page configuration
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['login.show_whats_new'] = TRUE;
// whether "Whats New" heading should be displayed before the block.
$CONFIG_VARS['login.show_whats_new_heading'] = TRUE;

$CONFIG_VARS['login.show_last_items_list'] = TRUE;
// whether "Last Items List" heading should be displayed before the block.
$CONFIG_VARS['login.show_last_items_list_heading'] = TRUE;
// whether to exclude current users items from being listed.
$CONFIG_VARS['login.last_items_list.exclude_current_user'] = TRUE;
// whether to restrict list to only those items that have been added since last login for this user.
$CONFIG_VARS['login.last_items_list.restrict_last_login'] = FALSE;

// Disable 'Forgot your password?' link and functionality.
$CONFIG_VARS['login.enable_new_pwd_gen'] = TRUE;

// Should include/language.php use any user_language Session variable setting,
// or go straight to the include/config.php $CONFIG_VARS['site.language'] setting.
$CONFIG_VARS['login.user_language_support'] = TRUE;

// whether admin users can change to another user
$CONFIG_VARS['login.enable_change_user'] = TRUE;

// Should menu be displayed when logging in.  The menu will be displayed once a valid 
// session has been created.
$CONFIG_VARS['login.show_menu'] = FALSE;

// Should menu be displayed when logging out.
$CONFIG_VARS['logout.show_menu'] = FALSE;

//---------------------------------------------------------------------------------------------------
// Whats New configuration
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['whatsnew.borrow_stats'] = TRUE; // Show Items Returned, Reserved, etc
$CONFIG_VARS['whatsnew.review_stats'] = TRUE; // Show number of reviews added.
// whether to exclude current users items from being listed.
$CONFIG_VARS['whatsnew.exclude_current_user'] = TRUE;

//---------------------------------------------------------------------------------------------------
// Last Items List configuration
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['last_items_list.datetime_mask'] = 'DD/MM/YYYY HH24:MI:SS';
$CONFIG_VARS['last_items_list.items_per_column'] = 6;
$CONFIG_VARS['last_items_list.total_num_items'] = 18; // this value should be evenly divisible by items_per_column value.
$CONFIG_VARS['last_items_list.show_item_image'] = TRUE;
$CONFIG_VARS['last_items_list.no_image'] = 'no-image.gif';
$CONFIG_VARS['last_items_list.item_image_size'] = array(height=>'100', width=>'');

// configure how each item block is displayed.  Supported variables are:
// {image}	   - hyperlinked cover image with link to item_display for item (Do not include if $CONFIG_VARS['last_items_list.show_item_image'] == FALSE)
// {title}	   - title as configured by $CONFIG_VARS['????????.title_display_mask']
// {update_on} - formatted datetime as configured by $CONFIG_VARS['last_items_list.datetime_mask']
$CONFIG_VARS['last_items_list.item_block'] = '<br>{image}<br><b>{title}</b><br><br><font class="colortext"><i>{update_on}</i></font><br><br>';

// you can define this specifically for last_items_list, or it will use the listings value.
// $CONFIG_VARS['last_items_list.title_display_mask'] = NULL;

//---------------------------------------------------------------------------------------------------
// Menu configuration
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['menu.other_items_listing'] = TRUE;
$CONFIG_VARS['menu.all_items_listing'] = FALSE;
$CONFIG_VARS['menu.last_items_list'] = FALSE;

//---------------------------------------------------------------------------------------------------
// Import configuration
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['import.row_import_default_initcap_checked'] = TRUE;

// the location of importcache files, minus the actual filename.  This should
// match the filesystem the file is to be saved onto, and can be relative to
// the installation directory.
$CONFIG_VARS['import.file_location'] = './importcache/';

//---------------------------------------------------------------------------------------------------
// User Admin options
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['user_admin.datetime_mask'] = 'DDth Month YYYY HH24:MI'; // Last Visited datetime display formatmask.
$CONFIG_VARS['user_admin.user_themes_support'] = TRUE;//Whether users can change their theme.
$CONFIG_VARS['user_admin.user_passwd_change_allowed'] = TRUE; // On demo sites you can set this to FALSE.

// Note: Not all english text will be replaced, this only provides support for the lang/$_OPENDB_LANGUAGE.inc.php file.
$CONFIG_VARS['user_admin.user_language_support'] = TRUE;//Whether users can change their language.

//
// If the user has any items checked out to them, or checked out to others, the deactivate/delete
// process will abort immediately.
// 
// If 'deactivate':
// 	1) The system will deactivate the user, instead of trying to delete them.
//	2) All outstanding reservations by the user and for the users items will be cancelled
// 	   by the system (without email notification)
// 	3) The users password will be set to empty, to deactivate them.
// If TRUE:
//	Attempt to delete user.  This will depend on the configuration for 'user_delete_with_reviews',
//	user_delete_with_owner_inactive_borrowed_items and user_delete_with_borrower_inactive_borrowed_items
// If FALSE:
//	User deletion is completely disabled.
//
$CONFIG_VARS['user_admin.user_delete_support'] = 'deactivate'; // [TRUE | 'deactivate' | FALSE]

// Allow deletion of user, even if they have authored reviews for items.  These reviews will be
// deleted before the user is.  This setting does not apply to the users own items.  All reviews will be
// removed against these items, regardless of this setting.
$CONFIG_VARS['user_admin.user_delete_with_reviews'] = TRUE;

// A user can be deleted, even if they have inactive borrower borrowed_item records.  If this option
// is set to TRUE, it will allow the deletion of Item history records for other users.
// This config option applies to Closed/Cancelled/Reserved borrowed items only.
$CONFIG_VARS['user_admin.user_delete_with_borrower_inactive_borrowed_items'] = TRUE;

// A user can be deleted, even if there are inactive owner borrowed item records.  If this option is
// set to TRUE, it will allow the deletion of Borrower history records for other users.
// This config option applies to Closed/Cancelled/Reserved borrowed items only.
$CONFIG_VARS['user_admin.user_delete_with_owner_inactive_borrowed_items'] = FALSE;

// whether welcome email should use $CONFIG_VARS['site.admin_email'] or the 
// current administrators email address.
$CONFIG_VARS['user_admin.welcome_email_use_admin_email'] = TRUE;

//---------------------------------------------------------------------------------------------------
// Statistics options - Refer to docs/notes/statistics.txt for more information
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['stats.image_type'] = 'png';//Image format for graphs. Only 'png','gif' or 'jpeg' are supported!

$CONFIG_VARS['stats.piechart_12oclock'] = TRUE; // Options: [TRUE | FALSE]; Default: FALSE
$CONFIG_VARS['stats.piechart_sort'] = 'asc'; // Options [ 'asc' | 'desc' | undefined ]
$CONFIG_VARS['stats.piechart_striped'] = TRUE; // Options: [TRUE | FALSE]; Default: FALSE

$CONFIG_VARS['stats.category_barchart'] = TRUE; // Options: [TRUE | FALSE]; Default: FALSE
$CONFIG_VARS['stats.barchart_sort'] = 'desc'; // Options [ 'asc' | 'desc' | undefined ]

// Specify the gd library extension to load, if not already loaded.  This will only be of use
// if the conditions (!extension_loaded('gd')) AND if((boolean)ini_get('enable_dl')) are true.
$CONFIG_VARS['chart.gd.library'] = 'gd.so';

//---------------------------------------------------------------------------------------------------
// Thumbnail configuration
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['thumbnail.enable'] = TRUE;
$CONFIG_VARS['thumbnail.item_image_size'] = array(height=>'100', width=>'');
$CONFIG_VARS['thumbnail.supported_input_formats'] = array('jpg', 'jpeg', 'png', 'gif'); // gif is supported even if GD does not!
$CONFIG_VARS['thumbnail.output_format'] = 'jpeg'; // options are [gif,png,jpeg] - gif only if GD supports it
// will take the existing file name, and append _T - the jpg extension is hardcoded, because the previous
// configuration item 'output_format' specifies that all thumbnails will be jpg.
$CONFIG_VARS['thumbnail.item_files_thumbnail_mask'] = '{filename}_T.jpg';

//---------------------------------------------------------------------------------------------------
// Item Display options
//---------------------------------------------------------------------------------------------------
// Whether item images should be loaded.  If network down or not available, set this to FALSE
$CONFIG_VARS['item_display.show_item_image'] = TRUE;

// if not defined, will not show any image.
$CONFIG_VARS['item_display.no_image'] = 'no-image.gif';

// Set the display size of all item images.
$CONFIG_VARS['item_display.item_image_size'] = array(height=>'100', width=>'');

$CONFIG_VARS['item_display.owner_email_link'] = TRUE;
$CONFIG_VARS['item_display.borrower_email_link'] = TRUE;

// Format of the Review section date string.
$CONFIG_VARS['item_display.review_datetime_mask'] = 'Day, DDth Month YYYY HH24:MI';

// Display titles in item_display, item_add, item_input, borrow, item_borrow, export, item_review
// DO NOT INCLUDE ANY IMAGE MASK COMPONENTS IN THIS DEFINITION AS THEY WILL CAUSE PROBLEMS WHEN THE
// TITLE VALUE IS DISPLAY IN THE BROWSER TITLE BAR!!!
$CONFIG_VARS['item_display.title_display_mask'] = array(
	'DEFAULT'=>'"{title}"{ifdef(year, " ({year})")}{if(s_status_type!=W,{if(instance_no>1," #{instance_no}")})}',
	'audio'=>'"{title}"{if(s_status_type!=W,{if(instance_no>1," #{instance_no}")})}',
	'GAME'=>'"{title}"{if(s_status_type!=W,{if(instance_no>1," #{instance_no}")})}',
);

//$CONFIG_VARS['item_display.title_display_mask'] = array(
//	'DEFAULT'=>'"{title}"{ifdef(year, " ({year})")}{if(s_status_type!=W,{if(instance_no>1," #{instance_no}")})}',
//	'audio'=>'"{title}"{if(s_status_type!=W,{if(instance_no>1," #{instance_no}")})}',
//	'GAME'=>'"{title}"{if(s_status_type!=W,{if(instance_no>1," #{instance_no}")})}',
//);

$CONFIG_VARS['item_display.show_linked_item_image'] = TRUE;

// If not a legal export type, will not include link.
// WARNING: Do not configure a ROW based plugin here!!!
$CONFIG_VARS['item_display.export_link'] = 'OpenDb_XML';

//---------------------------------------------------------------------------------------------------
// Item Input options
//---------------------------------------------------------------------------------------------------
// Specify whether linked items should be supported.  Existing linked items will still be displayed
// in item_display, item_input, etc; but new linked items will not be allowed, if this is FALSE.
$CONFIG_VARS['item_input.linked_item_support'] = TRUE;
$CONFIG_VARS['item_input.link_same_type_only'] = FALSE;

$CONFIG_VARS['item_input.clone_item_support'] = TRUE;
$CONFIG_VARS['item_input.clone_item_admin_diff_owner_support'] = FALSE;

// These two are also referenced in item_display, but they are more for controlling the actual
// database operations than anything else.  They are referenced in item_display, because there
// is no use providing the ability to start and action that cannot be completed.
$CONFIG_VARS['item_input.item_instance_support'] = TRUE;//Whether item_instance is supported at all.
$CONFIG_VARS['item_input.new_instance_owner_only'] = FALSE; //Whether item_instances can be created across owners.
$CONFIG_VARS['item_input.new_instance_admin_diff_owner_support'] = TRUE;
$CONFIG_VARS['item_input.change_owner_supported'] = TRUE;

// Whether item deletion should be confirmed or not!
$CONFIG_VARS['item_input.confirm_item_delete'] = TRUE;
// Whether linked item deletion should be confirmed or not!
$CONFIG_VARS['item_input.confirm_linked_item_delete'] = TRUE;

// Allow delete of item if only inactive borrowed items exist.  The inactive
// borrowed items will be deleted.  The user will be asked to confirm this
// operation.
$CONFIG_VARS['item_input.allow_delete_with_closed_or_cancelled_borrow_records'] = TRUE;

// Whether duplicates of the same type and owned by the same person should be allowed.
$CONFIG_VARS['item_input.duplicate_title_support'] = TRUE;

// Whether to confirm a title insert, for the situation where a title exists in the database,
// of the same s_item_type, whether owned by current user or not.  The confirm_duplicate_owner_insert
// variable check will actually happen first, so if the user has a copy of the title already the
// owner duplicate confirm check will be displayed, otherwise the site wide title duplicate check
// that this variable controls will be made, and a confirm form displayed if appropriate
$CONFIG_VARS['item_input.confirm_duplicate_insert'] = FALSE;

// Whether a duplicate title insert for same owner should be confirmed (Default: TRUE)
$CONFIG_VARS['item_input.confirm_duplicate_owner_insert'] = TRUE;

// Whether a duplicate title insert for same owner should be confirmed (Default: TRUE)
$CONFIG_VARS['item_input.confirm_duplicate_linked_item_insert'] = TRUE;

// If this variable is defined, any title updates, will move any occurence of the
// article prefix to the end of the title.
$CONFIG_VARS['item_input.title_articles'] = array('The','A','An');

// Must be relative to install directory.
$CONFIG_VARS['item_input.item_attr_save_dir'] =  './upload/';

// Defines the save file mask for attributes which are "upload" or "saveurl" widgets!
$CONFIG_VARS['item_input.item_attr_file_mask'] = '{fieldname}_item{item_id}.{ext}';

// new layered div interface for item addition
$CONFIG_VARS['item_input.item_add_site_div_interface'] = TRUE;

//---------------------------------------------------------------------------------------------------
// Review Configuration
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['item_review.update_support'] = TRUE;
$CONFIG_VARS['item_review.delete_support'] = TRUE;
$CONFIG_VARS['item_review.include_other_title_reviews'] = TRUE;
$CONFIG_VARS['item_review.other_title_reviews_restrict_to_item_type_group'] = TRUE;

//---------------------------------------------------------------------------------------------------
// Listings/Borrowing Pages Configuration
//---------------------------------------------------------------------------------------------------

//
// Hint: For performance disable 'show_refresh_links','show_input_links',
//								 'show_quick_checkout','show_borrow_links'
//
// This controls what type of navigation forms we use, and if set to POST, means that the browser 'Back' button
// cannot be used with any confidence, however if set to GET, you lose the ability to record checked rows accross
// pages
$CONFIG_VARS['listings.navigation_form_method'] = 'POST'; // [ GET | POST ]
$CONFIG_VARS['listings.items_per_page'] = 21; //How many Items will be shown per page.  This is also used by borrow.php!
$CONFIG_VARS['listings.show_input_links'] = TRUE;// Whether item_input links should be shown for owner items.
$CONFIG_VARS['listings.show_refresh_links'] = TRUE;// Whether item_add refresh link should be shown for owner items.
$CONFIG_VARS['listings.show_change_owner_link'] = TRUE; // Whether to show Change Owner links in listings
$CONFIG_VARS['listings.show_borrow_links'] = FALSE; // Whether borrow links should be shown for non-owner items.
$CONFIG_VARS['listings.show_quick_checkout'] = TRUE; // Support 'Quick Checkout' of items by owner.
$CONFIG_VARS['listings.show_borrowed_or_returned'] = TRUE; // Show the 'tick' if a user already borrowed/returned item

//
// Multi-Reserve specific configuration ('listings.show_reserve_action' / 'listings.show_add_to_reserve_basket_action')
//
// If this variable set to FALSE, the 'listings.show_reserve_action' and 'listings.show_add_to_reserve_basket_action'
// will have no effect.
$CONFIG_VARS['listings.show_multi_reserve'] = TRUE; // Whether the Reserve checkboxes and button should be displayed.

// Should a 'Reserve Item(s)' action be provided on the listings page.  The value
// of this variable will not affect, nor be affected by the value of the 
// $CONFIG_VARS['listings.add_to_reserve_basket_action'] below.  
$CONFIG_VARS['listings.show_reserve_action'] = TRUE;

// Should the 'Add to Basket' operation be available from listings, now that multi
// page checking support is provided.  Options are [TRUE | FALSE | 'IF_NOT_EMPTY' ]
// The 'IF_NOT_EMPTY' means provide a 'Add to Basket' if the Reserve Basket is
// not empty, otherwise do not provide a action.  If TRUE always provide a action,
// if FALSE, never provide one.
$CONFIG_VARS['listings.show_add_to_reserve_basket_action'] = TRUE; // [TRUE | FALSE | 'IF_NOT_EMPTY' ]

//
// Generic Listings configuration
//

$CONFIG_VARS['listings.show_item_type_group_lov'] = TRUE; // Restricting listings by s_item_type and/or 'listings.s_item_type_groups' group.
$CONFIG_VARS['listings.show_item_type_lov'] = TRUE; // Restricting listings by s_item_type and/or 'listings.s_item_type_groups' group.

$CONFIG_VARS['listings.show_owner_lov'] = TRUE; // Restrict listing by owner
$CONFIG_VARS['listings.show_s_status_type_lov'] = TRUE; // Restrict listing by s_status_type

$CONFIG_VARS['listings.save_listing_url'] = TRUE; //Save $HTTP_VARS used to generate listing into session var 'listing_url_vars'

// Whether to display all 'theme_img' title mask macro elements in the help section.
$CONFIG_VARS['listings.title_mask_macro_theme_img_help'] = TRUE;

// Configure the display type of the category column, the 'list-link' as second
// argument is probably all you need to worry about.
$CONFIG_VARS['listings.category_display_type_args'] = '%display%, list-link';

// Specify a list of options for the 'Items Per Page' widget.
$CONFIG_VARS['listings.items_per_page_options'] = array('', $CONFIG_VARS['listings.items_per_page'], 31, 41, 51);

$CONFIG_VARS['listing.user_email_link'] = TRUE;

// Define the display of the title column.
// There are no smarts in this mask, if the attribute is empty any formatting around it will be present
// with an empty string.  In the future a smarter formatting language may be introduced, but not today.
// Be sure to always include the {title} otherwise the actual item 'title' itself will not be displayed.
// #### Note: 	The 'DEFAULT' option allows you to default the format mask of all other types.
// ####			You can specify each s_item_type mask individually with no problems.
// ####			Do not add a new s_item_type called DEFAULT, otherwise this logic will not work!
// You can now use options within the {s_attribute_type} variables.  'img', 'display', 'value'
// are all legal.
$CONFIG_VARS['listings.title_display_mask'] = array(
		'DEFAULT'=>'{title}{ifdef(year, " ({year})")}{if(s_status_type!=W,{if(instance_no>1," #{instance_no}")})}',
		//'audio'=>'{title}{ifdef(artist, " / {artist}")}{if(s_status_type!=W,{if(instance_no>1," #{instance_no}")})}',
		'audio'=>'{title}{if(s_status_type!=W,{if(instance_no>1," #{instance_no}")})}',
		'GAME'=>'{title}{ifdef(gamesystem, " {gamesystem.img}")}{if(s_status_type!=W,{if(instance_no>1," #{instance_no}")})}',
);

// A column_id=> column is for a default column that is always built and there is no
// more control over this.  
//	column_id	- Supported include:
//			s_item_type
//			title
//			action_links
//			s_status_type
//			s_status_type
//			category
//
// A column_type=> however is an indication that this column will only be built if it 
//	is mentioned in this structure.
// Column types you can specify are:
//	s_attribute_type
//	s_field_type - RATING, ITEM_ID
//
$CONFIG_VARS['listings.display_columns'] = array(
	'DEFAULT'=>array(
		//array(column_type=>'s_field_type', s_attribute_type=>'S_ITEM_ID'),
		array(column_id=>'s_item_type'),
		array(column_id=>'title'),
		//array(column_type=>'s_attribute_type', s_attribute_type=>'DOCUMENT', printable=>FALSE, orderby=>FALSE),
		//array(column_type=>'s_field_type', s_attribute_type=>'S_RATING'),
		//array(column_type=>'s_attribute_type', s_attribute_type=>'IMDBRATING',column_title=>'IMDB<br>Rating'),
		//array(column_type=>'s_attribute_type', s_attribute_type=>'AGE_RATING'),
		//array(column_type=>'s_attribute_type', s_attribute_type=>'YEAR',column_title=>'Override Prompt'),
		//array(column_type=>'s_attribute_type', s_attribute_type=>'AUDIO_LANG', numeric_orderby=TRUE, orderby=>FALSE, display_type=>'display(%img%, HORIZONTAL)'),
//		array(column_type=>'s_attribute_type', s_attribute_type=>'COVERPRICE', numeric_orderby=>TRUE, orderby=>TRUE, display_type=>'display(%img%, HORIZONTAL)'),
		array(column_id=>'action_links'),
		array(column_id=>'username'),
		array(column_id=>'s_status_type'),
		array(column_id=>'status_comment'),
		array(column_id=>'borrow_status'),
		array(column_id=>'category')
	),
	'video'=>array(
		array(column_type=>'s_field_type', s_attribute_type=>'S_ITEM_ID'),
		array(column_id=>'s_item_type'),
		array(column_id=>'title'),
		array(column_type=>'s_field_type', s_attribute_type=>'S_RATING'),
		array(column_type=>'s_attribute_type', s_attribute_type=>'DIRECTOR'),
		array(column_type=>'s_attribute_type', s_attribute_type=>'AGE_RATING'),
		array(column_id=>'action_links'),
		array(column_id=>'username'),
		array(column_id=>'s_status_type'),
		array(column_id=>'borrow_status'),
		array(column_id=>'category')
	),
	'BOOK'=>array(
		array(column_id=>'s_item_type'),
		array(column_id=>'title'),
		array(column_type=>'s_attribute_type', s_attribute_type=>'AUTHOR'),
//		array(column_type=>'s_field_type', s_attribute_type=>'S_RATING'),
		array(column_id=>'action_links'),
		array(column_id=>'username'),
		array(column_id=>'s_status_type'),
		array(column_id=>'borrow_status'),
		array(column_id=>'category')
	),
	'GAME'=>array(
		array(column_type=>'s_field_type', s_attribute_type=>'S_ITEM_ID'),
		array(column_id=>'s_item_type'),
		array(column_id=>'title'),
		array(column_type=>'s_field_type', s_attribute_type=>'S_RATING'),
		array(column_type=>'s_attribute_type', s_attribute_type=>'GAMEPBLSHR'),
		array(column_type=>'s_attribute_type', s_attribute_type=>'NO_PLAYERS'),
		array(column_id=>'action_links'),
		array(column_id=>'username'),
		array(column_id=>'s_status_type'),
		array(column_id=>'borrow_status'),
		array(column_id=>'category')
	),
	'audio'=>array(
		array(column_type=>'s_field_type', s_attribute_type=>'S_ITEM_ID'),
		array(column_id=>'s_item_type'),
		array(column_id=>'title'),
		array(column_type=>'s_field_type', s_attribute_type=>'S_RATING'),
		array(column_type=>'s_attribute_type', s_attribute_type=>'ARTIST'),
		array(column_id=>'action_links'),
		array(column_id=>'username'),
		array(column_id=>'s_status_type'),
		array(column_id=>'borrow_status'),
		array(column_id=>'category')
	)
);

$CONFIG_VARS['listings.item_image_size'] = array(width=>69, height=>'');

// Whether to display a 'missing' image, if no IMAGE attribute defined for a item.
$CONFIG_VARS['listings.no_image'] = 'no-image.gif';

$CONFIG_VARS['listings.show_item_image'] = FALSE;

// Can a user override $CONFIG_VARS['listings.show_item_image'] value
// for their current login session.
$CONFIG_VARS['listings.allow_override_show_item_image'] = TRUE;

//
// Printable Listing - Format the date displayed under the title.
//
$CONFIG_VARS['print_listing.datetime_mask'] = 'Day, DDth Month YYYY HH24:MI:SS';

//---------------------------------------------------------------------------------------------------
// Borrow page configuration
//---------------------------------------------------------------------------------------------------
$CONFIG_VARS['borrow.enable'] = TRUE;

// These items configure whether item_borrow.php will display a 'More Information' form before
// continuing operation!
$CONFIG_VARS['borrow.reserve_more_information'] = TRUE;
$CONFIG_VARS['borrow.cancel_more_information'] = TRUE;
$CONFIG_VARS['borrow.checkout_more_information'] = TRUE;
$CONFIG_VARS['borrow.checkin_more_information'] = TRUE;
$CONFIG_VARS['borrow.reminder_more_information'] = TRUE;

//enable/disable email notification
$CONFIG_VARS['borrow.reserve_email_notification'] = TRUE;
$CONFIG_VARS['borrow.cancel_email_notification'] = TRUE;
$CONFIG_VARS['borrow.checkout_email_notification'] = TRUE;
$CONFIG_VARS['borrow.quick_checkout_email_notification'] = TRUE;
$CONFIG_VARS['borrow.checkin_email_notification'] = TRUE;

// Enable/disable Quick Checkout support. Email is always enabled for Quick checkout!
$CONFIG_VARS['borrow.quick_checkout'] = TRUE;

// If set to TRUE, a borrower_id list of values will be displayed instead of a 
// borrower text field.
$CONFIG_VARS['borrow.admin_quick_checkout_borrower_lov'] = TRUE;

// Disables all borrow functionality, except for initial reservation, where all but
// the notification email will be bypassed.
$CONFIG_VARS['borrow.reserve_email_only'] = FALSE;

// Configure whether more than one user can reserve item.
$CONFIG_VARS['borrow.allow_multi_reserve'] = TRUE;
$CONFIG_VARS['borrow.allow_reserve_if_borrowed'] = TRUE;

// this affects Quick Checkout and Admin Quick Checkout
$CONFIG_VARS['borrow.quick_checkout_use_existing_reservation'] = TRUE;

// Whether menu items for All borrowed/Reserved items across all users should be
// displayed.  These will only be displayed for borrower user or above.
$CONFIG_VARS['borrow.list_all_borrowed'] = TRUE;
$CONFIG_VARS['borrow.list_all_reserved'] = TRUE;

// Will affect item_display.php / borrow.php as to whether the borrower column
// should be displayed.  This configuration variable, will only be considered
// in borrow.php for the list_all_borrowed / list_all_reserved options.
$CONFIG_VARS['borrow.include_borrower_column'] = TRUE;

// Enable/Disable Reserve Basket support.
$CONFIG_VARS['borrow.reserve_basket'] = TRUE;

// Disable borrow duration support.
$CONFIG_VARS['borrow.duration_support'] = TRUE;

$CONFIG_VARS['borrow.date_mask'] = 'DDth Month YYYY';//Format of dates for Due dates.
$CONFIG_VARS['borrow.datetime_mask'] = 'DD/MM/YYYY HH:MI:SS';

// specify when the reminder job borrow duration range, as follows:
//		+1 = once one day overdue
//		 0 = on day due
//		-1 = one day before due
$CONFIG_VARS['borrow.reminder.duration_range'] = -1;

//---------------------------------------------------------------------------------------------------
// Search page configuration
//---------------------------------------------------------------------------------------------------
// Format the date for listings.php SQL query.
// Refer to functions/datetime.php::get_timestamp_for_datetime(...) for
// list of supported mask variables.
$CONFIG_VARS['search.datetime_mask'] = 'DD/MM/YYYY HH24:MI:SS';

// whether search page should include linked items by default.
$CONFIG_VARS['search.default_include_linked_items'] = TRUE;
?>
