/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

//addEvent(obj,"mouseover",doSomething)
function addEvent(obj, evType, fn, useCapture)
{
	if (obj.addEventListener)
	{
		obj.addEventListener(evType, fn, useCapture);
		return true;
	}
	else if (obj.attachEvent)
	{
		var r = obj.attachEvent("on"+evType, fn);
		return r;
	}
	else
	{
		// support sort-of for IE 5.5 on Mac here.
		obj["on"+evType] = fn;
	}
}

var TabbedSection = new Object();
TabbedSection.onclick = function ( tabId )
{
	var target = document.getElementById( tabId );
	var section = target.parentNode;
	if( !section ) return;

	for( var n = section.firstChild; n ; n = n.nextSibling )
	{
		if( !n.id ) continue;

		n.style.display = "none";
		if( n.id == target.id )
		{
			target.style.display = "";				
		}

		// in case we need to change a menu tab, lets check for it!
		var m = document.getElementById( "menu-" + n.id );	
		if( m && m.className == "activetab" )
		{
			m.className = "";
			document.getElementById( "menu-" + target.id ).className = "activetab";
		}
	}
}
