<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/theme.php");
include_once("./include/language.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");

include_once("./functions/utils.php");
include_once("./functions/user.php");
include_once("./functions/review.php");
include_once("./functions/borrowed_item.php");
include_once("./functions/item_type.php");
include_once("./functions/item_type_group.php");
include_once("./functions/item.php");
include_once("./functions/item_attribute.php");
include_once("./functions/widgets.php");
include_once("./functions/http.php");
include_once("./functions/parseutils.php");
include_once("./functions/listutils.php");
include_once("./functions/status_type.php");
include_once("./functions/HTML_Listing.class.inc");

function get_list_item_types($s_item_type_group, $s_item_type_rs=NULL)
{
	global $CONFIG_VARS;
	
	if(strlen($s_item_type_group)>0)
	{
		$types = fetch_item_types_for_group_r($s_item_type_group);
	}
	else if(is_not_empty_array($s_item_type_rs))//set of s_item_types.
	{
		$types = $s_item_type_rs;
	}		
	else
	{
		$itemtype_results = fetch_item_type_rs();
		while($itemtype_r = mysql_fetch_array($itemtype_results))
			$types[] = $itemtype_r['s_item_type'];
	}
	return $types;
}

function get_list_item_type_groups()
{
	$results = fetch_item_type_group_rs();
	if($results && mysql_num_rows($results)>0)
    {
		$item_type_group_rs = NULL;
		
		while($item_type_group_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			$item_type_group_rs[] = $item_type_group_r['s_item_type_group'];
		}
		mysql_free_result($results);
		
        return $item_type_group_rs;
	}
	else
	{
		return FALSE;
	}
}

/**
* Designed to merge display_attribute_type_rs arrays of the form:
* 	array(s_attribute_type => 'BOXSET', order_no => '1')
* with search_attribute_type_rs arrays of the form:
* 	array(s_attribute_type => 'BOXSET', lookup => 'RAMBO', value => 'FUCK', match => 'word', include_in_list => 'y')
*/
function &merge_display_column_config_arrays($display_column_config, $search_column_config)
{
	if(is_array($display_column_config) && is_array($search_column_config))
	{
		// for each display column config, see if the search array has any more info, and merge it in. 
		for($i=0; $i<count($display_column_config); $i++)
		{
			if($display_column_config[$i]['column_type'] == 's_attribute_type')
			{
				if(strlen($display_column_config[$i]['s_attribute_type'])>0)
				{
					$idx_of_element = -1;
					for($j=0; $j<count($search_column_config); $j++)
					{
						if(!is_numeric($display_column_config[$i]['order_no']) && 
								$display_column_config[$i]['s_attribute_type'] == $search_column_config[$j]['s_attribute_type'] &&
								(strlen($search_column_config[$j]['lookup_attribute_val'])>0 ||
								strlen($search_column_config[$j]['attribute_val'])>0 ||
								strlen($search_column_config[$j]['attr_update_on'])>0 ||
								strlen($search_column_config[$j]['attr_update_on_days'])>0) ) 
						{
							$idx_of_element = $j;
							break;
						}
					}
			
					// found display element in search.
					if($idx_of_element >= 0)
					{
						$display_column_config[$i] = array_merge($display_column_config[$i], $search_column_config[$idx_of_element]);
						
						// override orderby for search attributes.
						if($display_column_config[$i]['orderby']!==TRUE)
						{
							$display_column_config[$i]['orderby'] = TRUE;
						}
					}
				}
			}
		}

		//
		// Need to add additional s_attribute_type columns after the title.
		//		
		$tmp_display_column_config = array();
		$index_of_title = -1;
		for($i=0; $i<count($display_column_config); $i++)
		{
			$tmp_display_column_config[] = $display_column_config[$i];
			
			if($display_column_config[$i]['column_id'] == 'title')
			{
				$index_of_title = $i;
				break;
			}
		}
		
		// for each search column, see if it exists in display, if not, add it after the 'title' entry.
		for($i=0; $i<count($search_column_config); $i++)
		{
			if($search_column_config[$i]['column_type'] == 's_attribute_type')
			{
				if(strlen($search_column_config[$i]['s_attribute_type'])>0 && (
					strlen($search_column_config[$i]['lookup_attribute_val'])>0 ||
					strlen($search_column_config[$i]['attribute_val'])>0 ||
					strlen($search_column_config[$i]['attr_update_on'])>0 ||
					strlen($search_column_config[$i]['attr_update_on_days'])>0) )
				{
					$idx_of_element = -1;
					for($j=0; $j<count($display_column_config); $j++)
					{
						// found
						if(!is_numeric($display_column_config[$j]['order_no']) && 
								$search_column_config[$i]['s_attribute_type'] == $display_column_config[$j]['s_attribute_type'])
						{
							$idx_of_element = $j;
							break;
						}
					}
			
					// if not found
					if($idx_of_element == -1)
					{
						// Now we want to add it after 'title' element.
						$tmp_display_column_config[] = $search_column_config[$i];
					}
				}
			}
			else if($search_column_config[$i]['column_type'] == 's_field_type' && 
							$search_column_config[$i]['s_attribute_type'] == 'S_RATING')
			{
				// first of all check if element exists, before adding it in!
				$idx_of_element = -1;
				for($k=0; $k<count($display_column_config); $k++)
				{
					// found
					if($display_column_config[$k]['column_type'] == 's_field_type' && 
							$display_column_config[$k]['s_attribute_type'] == 'S_RATING')
					{
						$idx_of_element = $k;
						break;
					}
				}
						
				// if not found
				if($idx_of_element == -1)
				{
					// Now we want to add it after 'title' element.
					$tmp_display_column_config[] = $search_column_config[$i];
				}
			}
		}
		
		// now add the rest of the columns.
		for($i=$index_of_title+1; $i<count($display_column_config); $i++)
		{
			$tmp_display_column_config[] = $display_column_config[$i];
		
			if($display_column_config[$i]['column_id'] == 's_status_type')
			{
				// see if status_comment is defined
				for($j=0; $j<count($search_column_config); $j++)
				{
					if($search_column_config[$j]['column_id'] == 'status_comment')
					{
						// first of all check if element exists, before adding it in!
						$idx_of_element = -1;
						for($k=0; $k<count($display_column_config); $k++)
						{
							// found
							if($display_column_config[$k]['column_id'] == 'status_comment')
							{
								$idx_of_element = $k;
								break;
							}
						}
						
						// if not found
						if($idx_of_element == -1)
						{
							// Now we want to add it after 'title' element.
							$tmp_display_column_config[] = $search_column_config[$j];
						}	
					}
				}
			}
		}//for($i=$index_of_title+1; $i<count($display_column_config); $i++)
		
		return $tmp_display_column_config;
	}
	else //if(is_array($display_column_config))
	{
		return $display_column_config;
	}
}

/**
* printable=>FALSE
*/
function &filter_for_printable_list($column_display_config_rs)
{
	$new_column_display_config_rs = array();
	for($i=0; $i<count($column_display_config_rs); $i++)
	{
		if($column_display_config_rs[$i]['printable'] !== FALSE)
		{
			$new_column_display_config_rs[] =& $column_display_config_rs[$i];
		}
	}
	return $new_column_display_config_rs;
}

function get_search_query_matrix($HTTP_VARS)
{
	global $LANG_VARS;
	global $CONFIG_VARS;

	function get_match_type($match)
	{
		global $LANG_VARS;
		if($match == 'word')
			return $LANG_VARS['word_match'];
		else if($match == 'partial')
			return $LANG_VARS['partial_match'];
		else if($match == 'exact')
			return $LANG_VARS['exact_match'];
		else
			return NULL;
	}
	
	$searches = array();
	
	if(strlen($HTTP_VARS['title'])>0)
	{
		// Default title match is exact match.
		$HTTP_VARS['title_match'] = ifempty($HTTP_VARS['title_match'],'exact');
		
		if($HTTP_VARS['title_match'] == 'word' || $HTTP_VARS['title_match'] == 'partial' || $HTTP_VARS['title_match'] == 'exact')
			$searches[] = array(prompt=>$LANG_VARS['title'].' (<i>'.get_match_type($HTTP_VARS['title_match']).'</i>)',field=>$HTTP_VARS['title']);
		else
			$searches[] = array(prompt=>$LANG_VARS['title'],field=>$HTTP_VARS['title']);
	}
	
	if(strlen($HTTP_VARS['category'])>0)
	{
		// If s_item_type defined, we can get at the s_attribute_type of the category value.
		if(strlen($HTTP_VARS['s_item_type'])>0)
		{
			$attribute_type_r = fetch_sfieldtype_item_attribute_type_r($HTTP_VARS['s_item_type'], 'CATEGORY', TRUE);
			$searches[] = array(prompt=>$LANG_VARS['category'],field=>get_display_field($attribute_type_r['s_attribute_type'], $attribute_type_r['prompt'], str_replace('list-link', '', $attribute_type_r['display_type']), $HTTP_VARS['category'], FALSE));
		}
		else
			$searches[] = array(prompt=>$LANG_VARS['category'],field=>$HTTP_VARS['category']);
	}
	
	if(strlen($HTTP_VARS['owner_id'])>0)
	{
		$username = fetch_user_name($HTTP_VARS['owner_id']);
		if(strlen($username)>0)
			$searches[] = array(prompt=>$LANG_VARS['owner'],field=>$username.' ('.$HTTP_VARS['owner_id'].')');
	}
	
	if(strlen($HTTP_VARS['s_item_type_group'])>0)
	{
		$searches[] = array(
						prompt=>$LANG_VARS['s_item_type_group'],
						field=>$HTTP_VARS['s_item_type_group']);
	}
	
	if(strlen($HTTP_VARS['s_item_type'])>0)
	{
		$item_type_r = fetch_item_type_r($HTTP_VARS['s_item_type']);
		$searches[] = array(
						prompt=>$LANG_VARS['s_item_type'],
						field=>_theme_image($item_type_r['image'], $HTTP_VARS['s_item_type'], $item_type_r['description'],	'absmiddle', 's_item_type'));
	}
	
	if(is_numeric($HTTP_VARS['rating']))
	{
		$attribute_type_r = fetch_attribute_type_r('S_RATING');
		$searches[] = array(
					prompt=>$attribute_type_r['prompt'],
					field=>get_display_field(
						$attribute_type_r['s_attribute_type'], 
						$attribute_type_r['prompt'], 
						'review(%display%)',
						$HTTP_VARS['rating'],
						FALSE));
	}
	
	$attribute_type_r = NULL;
	if(strlen($HTTP_VARS['attribute_type'])>0)
	{
		$attribute_type_r = fetch_attribute_type_r($HTTP_VARS['attribute_type']);
		if(is_not_empty_array($attribute_type_r))
		{
			// Default title match is exact match.
			$HTTP_VARS['attr_match'] = ifempty($HTTP_VARS['attr_match'],'exact');
		
			// Special category search, but ignore if category variable actually specified.
			if(strlen($HTTP_VARS['category'])==0 && 
					strlen($HTTP_VARS['attribute_val'])>0 && 
					$HTTP_VARS['attr_match'] == 'category')
			{
				// We do not want the Listing Link to be added to this display field
				$searches[] = array(
					prompt=>$attribute_type_r['prompt'],
					field=>get_display_field($attribute_type_r['s_attribute_type'], $attribute_type_r['prompt'], str_replace('list-link', '', $attribute_type_r['display_type']), stripslashes($HTTP_VARS['attribute_val']), FALSE));

			}
			else
			{
				if(strlen($HTTP_VARS['attribute_val'])>0)
				{
					// We do not want the Listing Link to be added to this display field
					$search = ifempty( // using ifempty in case a display type does not return anything - for example it might have a 'popupsize' display type!!!
						get_display_field($attribute_type_r['s_attribute_type'], $attribute_type_r['prompt'], str_replace('list-link', '', $attribute_type_r['display_type']), stripslashes($HTTP_VARS['attribute_val']), FALSE),
						stripslashes($HTTP_VARS['attribute_val']));
				}
				else if(strlen($HTTP_VARS['lookup_attribute_val'])>0)
				{
					// We do not want the Listing Link to be added to this display field
					$search = get_display_field($attribute_type_r['s_attribute_type'], $attribute_type_r['prompt'], str_replace('list-link', '', $attribute_type_r['display_type']), stripslashes($HTTP_VARS['lookup_attribute_val']), FALSE);
				}
				
				if(!is_lookup_attribute_type($HTTP_VARS['attribute_type']))
					$searches[] = array(prompt=>$attribute_type_r['prompt'].' (<i>'.get_match_type($HTTP_VARS['attr_match']).'</i>)',field=>$search);
				else
					$searches[] = array(prompt=>$attribute_type_r['prompt'],field=>$search);
			}
		}//if(is_not_empty_array($attribute_type_r))
	}
	else
	{
		if(strlen($HTTP_VARS['attribute_val'])>0) // specified a search term without attribute type, this is a global search.
		{
			$searches[] = array(
						prompt=>$LANG_VARS['attribute_val'].' (<i>'.get_match_type(ifempty($HTTP_VARS['attr_match'],'exact')).'</i>)',
						field=>stripslashes($HTTP_VARS['attribute_val']));
		}
	}
	
	// add another search field if update_on value also specified.	
	if(strlen($HTTP_VARS['attr_update_on'])>0)
	{
		if(is_not_empty_array($attribute_type_r))
			$prompt = replace_lang_vars(array('s_attribute_type'=>$attribute_type_r['s_attribute_type'],'prompt'=>$attribute_type_r['prompt']), $LANG_VARS['attribute_prompt_updated']);
		else
			$prompt = $LANG_VARS['attributes_updated'];
		
		if(strlen($HTTP_VARS['datetimemask'])>0)
			$searches[] = array(prompt=>$prompt,field=>$HTTP_VARS['attr_update_on'].' ('.$HTTP_VARS['datetimemask'].')');
		else
			$searches[] = array(prompt=>$prompt,field=>$HTTP_VARS['attr_update_on']);
	}
	else if(is_numeric($HTTP_VARS['attr_update_on_days']))
	{
		if(is_not_empty_array($attribute_type_r))
			$prompt = replace_lang_vars(array('s_attribute_type'=>$attribute_type_r['s_attribute_type'],'prompt'=>$attribute_type_r['prompt']), $LANG_VARS['attribute_prompt_updated']);
		else
			$prompt = $LANG_VARS['attributes_updated'];
			
		if($HTTP_VARS['attr_update_on_days'] == '1')
			$field = $LANG_VARS['one_day_ago'];
		else if($HTTP_VARS['attr_update_on_days'] == '7')
			$field = $LANG_VARS['one_week_ago'];
		else if($HTTP_VARS['attr_update_on_days'] == '28')
			$field = $LANG_VARS['one_month_ago'];
		else if($HTTP_VARS['attr_update_on_days'] == '365')
			$field = $LANG_VARS['one_year_ago'];
			
		$searches[] = array(prompt=>$prompt, field=>$field);
	}
	
	if(strlen($HTTP_VARS['update_on'])>0)
	{
		if(strlen($HTTP_VARS['datetimemask'])>0)
			$searches[] = array(prompt=>$LANG_VARS['updated'],field=>$HTTP_VARS['update_on'].' ('.$HTTP_VARS['datetimemask'].')');
		else
			$searches[] = array(prompt=>$LANG_VARS['updated'],field=>$HTTP_VARS['update_on']);
	}
	else if(is_numeric($HTTP_VARS['update_on_days']))
	{
		if($HTTP_VARS['update_on_days'] == '1')
			$field = $LANG_VARS['one_day_ago'];
		else if($HTTP_VARS['update_on_days'] == '7')
			$field = $LANG_VARS['one_week_ago'];
		else if($HTTP_VARS['update_on_days'] == '28')
			$field = $LANG_VARS['one_month_ago'];
		else if($HTTP_VARS['update_on_days'] == '365')
			$field = $LANG_VARS['one_year_ago'];
			
		$searches[] = array(prompt=>$LANG_VARS['updated'], field=>$field);
	}
	
	if(is_not_empty_array($HTTP_VARS['s_status_type'])>0)
	{
		$search = "";
		for($i=0; $i<count($HTTP_VARS['s_status_type']); $i++)
		{
			// Add a new line every third element.
			if($i>0 && ($i % 3)==0)
				$search .= "<br>";
			else if(strlen($search)>0)
				$search .= ", ";
				
			$status_type_r = fetch_status_type_r($HTTP_VARS['s_status_type'][$i], FALSE);
			if(is_not_empty_array($status_type_r))
			{
				$search .= format_display_value('%img%', 
										$status_type_r['img'], 
										'Y',
										$status_type_r['description'],
										"borrowed_item");
			}
		}
		
		if(strlen($search)>0)
		{
			$searches[] = array(prompt=>$LANG_VARS['s_status_type'],field=>$search);
		}
	}
	
	if(strlen($HTTP_VARS['status_comment'])>0)
	{
		// Default status_comment match is exact match.
		$HTTP_VARS['status_comment_match'] = ifempty($HTTP_VARS['status_comment_match'],'exact');
		
		if($HTTP_VARS['status_comment_match'] == 'word' || $HTTP_VARS['status_comment_match'] == 'partial' || $HTTP_VARS['status_comment_match'] == 'exact')
			$searches[] = array(prompt=>$LANG_VARS['status_comment'].' (<i>'.get_match_type($HTTP_VARS['status_comment_match']).'</i>)',field=>$HTTP_VARS['status_comment']);
		else
			$searches[] = array(prompt=>$LANG_VARS['status_comment'],field=>$HTTP_VARS['status_comment']);
	}
	
	if($HTTP_VARS['linked_items'] == 'include')
	{
		$searches[] = array(prompt=>$LANG_VARS['linked_item(s)'],field=>$LANG_VARS['include']);
	}
	
	return $searches;
}//function get_search_query_matrix($HTTP_VARS)

if($CONFIG_VARS['site.enable']!==FALSE)
{
	session_start(); 
	if (is_opendb_valid_session())
	{
		// validate specified owner_id, if not an owner, unset, so we pretend it was not even specified.
		if(strlen($HTTP_VARS['owner_id'])>0 && is_user_allowed_to_own($HTTP_VARS['owner_id']))
		{
			$show_owner_column=FALSE;
		}
		else
		{
			$show_owner_column=TRUE;
			
			// Specified owner, is not actually a valid owner user, so ignore it.
			unset($HTTP_VARS['owner_id']);
		}
		
		if($HTTP_VARS['mode'] == 'printable')
		{
			// No checkbox for Printable version.
			$show_checkbox_column=FALSE;
			$show_action_column=FALSE;
				
			$category_display_type = 'category(%display%)';
		}
		else
		{
			// Work out whether Item action checkboxes should be displayed.
			$show_checkbox_column=FALSE;
			if($CONFIG_VARS['borrow.enable']!==FALSE && 
					$CONFIG_VARS['listings.show_multi_reserve']!==FALSE && 
						(($CONFIG_VARS['borrow.reserve_basket']!==FALSE && 
							($CONFIG_VARS['listings.show_add_to_reserve_basket_action']===TRUE ||
							($CONFIG_VARS['listings.show_add_to_reserve_basket_action']==='IF_NOT_EMPTY' && 
								is_not_empty_array($HTTP_SESSION_VARS['reserve_basket_listing'])) )) ||
						$CONFIG_VARS['listings.show_reserve_action']!==FALSE) )
			{
				// Only users who can borrow should see checkboxes and their own listings.
				if(is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']))
				{
					if($HTTP_VARS['owner_id'] !== $HTTP_SESSION_VARS['user_id'])
					{
						$show_checkbox_column=TRUE;
					}
				}
			}
		
			$category_display_type = 'category('.ifempty($CONFIG_VARS['listings.category_display_type_args'],'%display%').')';
				
			// Do we need to include the actions column?
			if(is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']) &&
			(
				(
					(
						(
							strlen($HTTP_VARS['owner_id'])==0 && 
							strlen($HTTP_VARS['not_owner_id'])==0
						) || $HTTP_VARS['owner_id'] == $HTTP_SESSION_VARS['user_id'] 
						  || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type'])
					) && 
					(
						$CONFIG_VARS['listings.show_input_links'] || 
						($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['listings.show_quick_checkout'])
					)
				) || ($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['listings.show_borrow_links'])))
			{	
				$show_action_column=TRUE;
			}
		}//if($HTTP_VARS['mode'] == 'printable')
			
		// set to null, so we know if it has been updated within the if structure below!
		$page_title = NULL;
		
		if($HTTP_VARS['search_list'] == 'y' || $HTTP_VARS['attribute_list'] == 'y')
		{
			if(strlen($HTTP_VARS['override_page_title'])>0)
				$page_title = $HTTP_VARS['override_page_title'];
			else
				$page_title = $LANG_VARS['search_results'];
		}
		else if(is_valid_s_status_type($HTTP_VARS['s_status_type']))
		{
			// Current user.
			if($HTTP_VARS['owner_id'] == $HTTP_SESSION_VARS['user_id'])
				$page_title = replace_lang_var('s_status_type_desc', fetch_status_type_col($HTTP_VARS['s_status_type'], 'description'), $LANG_VARS['my_s_status_type_item_listing']);
			else if(strlen($HTTP_VARS['owner_id'])>0)
				$page_title = replace_lang_vars(array('s_status_type_desc'=>fetch_status_type_col($HTTP_VARS['s_status_type'], 'description'), 'fullname'=>fetch_user_name($HTTP_VARS['owner_id']), 'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['s_status_type_item_listing_for_name']);
			else if(strlen($HTTP_VARS['not_owner_id'])>0)
				$page_title = replace_lang_var('s_status_type_desc', fetch_status_type_col($HTTP_VARS['s_status_type'], 'description'), $LANG_VARS['other_s_status_type_item_listing']);
			else
				$page_title = replace_lang_var('s_status_type_desc', fetch_status_type_col($HTTP_VARS['s_status_type'], 'description'), $LANG_VARS['all_s_status_type_item_listing']);
		}
		else
		{
			// Current user.
			if($HTTP_VARS['owner_id'] == $HTTP_SESSION_VARS['user_id'])
				$page_title = $LANG_VARS['my_item_listing'];
			else if(strlen($HTTP_VARS['owner_id'])>0)
				$page_title = replace_lang_vars(array('fullname'=>fetch_user_name($HTTP_VARS['owner_id']), 'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['item_listing_for_name']);
			else if(strlen($HTTP_VARS['not_owner_id'])>0)
				$page_title = $LANG_VARS['other_item_listing'];
			else
				$page_title = $LANG_VARS['all_item_listing'];
		}
		
		// We need to force the inclusion of a listing link into the HTTP_VARS
		$HTTP_VARS['listing_link'] = 'y';
	
		if($HTTP_VARS['mode'] == 'printable')
		{
			if(ifempty($HTTP_VARS['content_type'],'HTML') == 'HTML')
			{
				echo(_theme_header($page_title));
			}
			
			switch($HTTP_VARS['content_type'])
			{
				//case 'PDF':
				//	$listingObject =& new PDF_Listing($PHP_SELF, $HTTP_VARS);
				//	break;
				default:
					$listingObject =& new HTML_Listing($PHP_SELF, $HTTP_VARS, $HTTP_VARS['mode']);
			}
		}
		else
		{
			echo(_theme_header($page_title, $HTTP_VARS['inc_menu']));
			echo('<h2>'.$page_title.'</h2>');
			
			echo(get_popup_javascript());
			
			$listingObject =& new HTML_Listing($PHP_SELF, $HTTP_VARS, $HTTP_VARS['mode']);
		}
		
		// move this logic above search list results, so we can take advantage of
		// it for displaying search results.
		$v_item_types = get_list_item_types($HTTP_VARS['s_item_type_group'], $HTTP_VARS['s_item_type_rs']);
		if(is_not_empty_array($v_item_types))
		{
			// if s_item_type is not in currently selected group, then unset it.
			if(!in_array($HTTP_VARS['s_item_type'], $v_item_types))
			{
				unset($HTTP_VARS['s_item_type']);
			}
		}
		
		// display search results even in printable listing mode.
		if($HTTP_VARS['search_list'] == 'y' || $HTTP_VARS['attribute_list'] == 'y')
 		{
			// default search term if attribute_type specified, but no
			// value provided.
			if(strlen($HTTP_VARS['attribute_type'])>0 && 
					strlen($HTTP_VARS['attribute_val']) == 0 && 
					strlen($HTTP_VARS['lookup_attribute_val'])==0)
			{
				$HTTP_VARS['attribute_val'] = '%';
			}
			
			if($HTTP_VARS['show_search_query_matrix']!='N')
			{
 				$matrix_rs = get_search_query_matrix($HTTP_VARS);
				if(is_not_empty_array($matrix_rs))
 				{
 					$search_block = '';
 					while(list(,$matrix_r) = each($matrix_rs))
 					{
 						$search_block .= format_field($matrix_r['prompt'], NULL, $matrix_r['field']);
 					}
 				
 					echo('<table border=1 cellpadding=0 cellspacing=1><tr><td><table cellspacing=1 border=0>'
 						.'<tr><td class="navbar" colspan=2 align=middle>'.$LANG_VARS['search_query'].'</td></tr>'
 						.$search_block
 						.'</table></td></tr></table><br>');
 				}
			}
		}
		
		if($HTTP_VARS['mode'] != 'printable')
		{
			// #######################################################################
			// RESERVATIONS FUNCTIONALITY
			// #######################################################################
			$listingObject->setCheckBoxColumnAndInitList(
											'item_id_instance_no', 
											$show_checkbox_column, 
											$CONFIG_VARS['borrow.reserve_basket']!==FALSE?$HTTP_SESSION_VARS['reserve_basket_listing']:NULL);
			
			if($HTTP_VARS['show_lovs']!='N')
			{
				if($CONFIG_VARS['listings.show_owner_lov']!==FALSE)
				{
					$listingObject->addSelectControl(
											$LANG_VARS['owner_id'],
											'owner_id',
											fetch_user_rs(get_owner_user_types_r()),
											'%fullname% (%user_id%)',
											$HTTP_VARS['owner_id'],
											'user_id');
				}
				
				if($CONFIG_VARS['listings.show_s_status_type_lov']!==FALSE)
				{
					if(!is_array($HTTP_VARS['s_status_type']) || ($HTTP_VARS['search_list'] != 'y' && $HTTP_VARS['attribute_list'] != 'y'))
					{
						$results = fetch_status_type_rs(TRUE);
						if($results && mysql_num_rows($results)>1)
						{		
							$listingObject->addSelectControl(
												$LANG_VARS['s_status_type'],
												's_status_type',
												$results,
												'%s_status_type% - %description%',
												$HTTP_VARS['s_status_type'],
												's_status_type');
						}
					}
				}
					
				if($CONFIG_VARS['listings.show_item_type_group_lov']!==FALSE || $CONFIG_VARS['listings.show_item_type_lov']!==FALSE)
				{										
					//$item_types = get_list_item_types($HTTP_VARS['s_item_type_group'], $HTTP_VARS['s_item_type_rs']);
					// the list of $v_item_types is now obtained above.
					if(is_not_empty_array($v_item_types))
					{	
						if($CONFIG_VARS['listings.show_item_type_group_lov']!==FALSE)
						{
							$v_item_type_groups = get_list_item_type_groups();
							if(is_not_empty_array($v_item_type_groups))
							{
								$listingObject->addSelectControl(
												$LANG_VARS['s_item_type_group'],
												's_item_type_group',
												$v_item_type_groups,
												'%value%',
												$HTTP_VARS['s_item_type_group'],
												'valkey');
							}
						}
						
						// if s_item_type is not in currently selected group, then unset it.
						if(!in_array($HTTP_VARS['s_item_type'], $v_item_types))
						{
							unset($HTTP_VARS['s_item_type']);
						}
						
						if($CONFIG_VARS['listings.show_item_type_lov']!==FALSE)
						{
							$listingObject->addSelectControl(
												$LANG_VARS['s_item_type'],
												's_item_type',
												$v_item_types,
												'%value%',
												$HTTP_VARS['s_item_type'],
												'valkey');
						}
					}
				}
			}
			
			$listingObject->addAlphaList($HTTP_VARS['letter']);
			
			if($CONFIG_VARS['listings.allow_override_show_item_image']!==FALSE)
			{
				$listingObject->addToggleControl(
								$LANG_VARS['show_item_image'], 
								'show_item_image', 
								ifempty($HTTP_VARS['show_item_image'], $CONFIG_VARS['listings.show_item_image']==TRUE?'Y':'N'));
			}
			// --------------------------------
		}
		
		if(is_array($CONFIG_VARS['listings.display_columns']))
		{
			$v_column_display_config_key = 
				get_item_type_config_key(
					$HTTP_VARS['s_item_type_group'], 
					$HTTP_VARS['s_item_type'], 
					$CONFIG_VARS['listings.display_columns']);
			
			$v_column_display_config_rs =& $CONFIG_VARS['listings.display_columns'][$v_column_display_config_key];
			
			// Now we want to remove the elements that are not valid for printable listing.
			if($HTTP_VARS['mode'] == 'printable')
			{
				$v_column_display_config_rs =& filter_for_printable_list($v_column_display_config_rs);
			}
		}
	
		if($HTTP_VARS['attr_match'] != 'category')
		{
			// Now we have to merge in search terms, and add them after the 'title' column_id
			$v_column_display_config_rs =& 
					merge_display_column_config_arrays(
						$v_column_display_config_rs, 
						array(array(
							column_type=>'s_attribute_type',
							s_attribute_type=>$HTTP_VARS['attribute_type'],
							attribute_val=>$HTTP_VARS['attribute_val'],
							lookup_attribute_val=>$HTTP_VARS['lookup_attribute_val'],
							attr_match=>$HTTP_VARS['attr_match'],
							attr_update_on=>$HTTP_VARS['attr_update_on'],
							attr_update_on_days=>$HTTP_VARS['attr_update_on_days'],
							include_in_list=>ifempty($HTTP_VARS['search_list'],$HTTP_VARS['attribute_list']))));
		}
		
		// need to add status_comment to listing if search for status comment enabled.							
		if(strlen($HTTP_VARS['status_comment'])>0)
		{
			$v_column_display_config_rs =& 
				merge_display_column_config_arrays(
						$v_column_display_config_rs, 
						array(array(
							column_id=>'status_comment')));
		}
		
		if(strlen($HTTP_VARS['rating'])>0)
		{
			$v_column_display_config_rs =& 
				merge_display_column_config_arrays(
						$v_column_display_config_rs, 
						array(array(
							column_type=>'s_field_type',
							s_attribute_type=>'S_RATING')));
		}
		
		for($i=0; $i<count($v_column_display_config_rs); $i++)
		{
			if($v_column_display_config_rs[$i]['column_type'] == 's_attribute_type')
			{
				$v_attribute_type_r = fetch_attribute_type_r($v_column_display_config_rs[$i]['s_attribute_type']);
				if(is_array($v_attribute_type_r))
				{
					// get the s_item_type specific prompt if s_item_type is specified.
					if(strlen($HTTP_VARS['s_item_type'])>0)
					{
						$v_attribute_type_r['prompt'] = 
								ifempty(fetch_s_item_type_attr_prompt($HTTP_VARS['s_item_type'], 
																	$v_column_display_config_rs[$i]['s_attribute_type']),
										$v_attribute_type_r['prompt']);
					}
			
					// record whether the s_attribute_type is a lookup attribute_type for use while generating the page.
					if(is_lookup_attribute_type($v_column_display_config_rs[$i]['s_attribute_type']))
					{
						$v_column_display_config_rs[$i]['is_lookup_attribute_type'] = TRUE;
						
						// Is expecting lookup_attribute_val, so lets give it to them!
						if(strlen($v_column_display_config_rs[$i]['lookup_attribute_val'])==0 && strlen($v_column_display_config_rs[$i]['attribute_val'])>0)
						{
							$v_column_display_config_rs[$i]['lookup_attribute_val'] = $v_column_display_config_rs[$i]['attribute_val'];
							$v_column_display_config_rs[$i]['attribute_val'] = NULL;
						}
					}
					else
					{
						$v_column_display_config_rs[$i]['is_lookup_attribute_type'] = FALSE;
					}
					
					if(strlen($v_column_display_config_rs[$i]['display_type'])>0 || 
							(strlen($v_attribute_type_r['display_type'])>0 && 
								in_array(get_function_type($v_attribute_type_r['display_type']), array('hidden', 'popupsize')) !== TRUE) || // popupsize is a piece of nastiness that equates to a hidden.
							(strlen($v_attribute_type_r['display_type']) == 0 && 
								strcasecmp(get_function_type($v_attribute_type_r['input_type']), 'hidden')!==0))
					{
						if(strlen($v_column_display_config_rs[$i]['display_type'])==0)
						{
							$v_column_display_config_rs[$i]['display_type'] = $v_attribute_type_r['display_type'];
						}
					
						if($HTTP_VARS['mode'] == 'printable')
						{
							$v_column_display_config_rs[$i]['display_type'] = str_replace('list-link', '', $v_column_display_config_rs[$i]['display_type']);
						}
					
						// save the prompt, so it can be passed to addDisplayColumn
						$v_column_display_config_rs[$i]['prompt'] = 
											ifempty(
												$v_column_display_config_rs[$i]['column_title'], 
												$v_attribute_type_r['prompt']);
					
						if($v_column_display_config_rs[$i]['orderby'] !== FALSE)
						{
							$listingObject->addHeaderColumn(
									$v_column_display_config_rs[$i]['prompt'], 
									get_field_name($v_column_display_config_rs[$i]['s_attribute_type'], $v_column_display_config_rs[$i]['order_no']));

							//YM If the field is numeric, we need to specify it, for the sort to be casted.
							// JPELL - only if not already configured in column display config from include/config.php
							if (!isset($v_column_display_config_rs[$i]['numeric_orderby']) && 
											substr($v_attribute_type_r['input_type'],0,6)=='number')
								$v_column_display_config_rs[$i]['numeric_orderby'] = TRUE;
							else
								$v_column_display_config_rs[$i]['numeric_orderby'] =  FALSE;
						}
						else
						{
							$listingObject->addHeaderColumn(
									$v_column_display_config_rs[$i]['prompt']);
						}
					}
				}
			}
			else if($v_column_display_config_rs[$i]['column_type'] == 's_field_type')
			{
				$v_attribute_type_r = fetch_attribute_type_r($v_column_display_config_rs[$i]['s_attribute_type']);
				if(is_array($v_attribute_type_r))
				{
					// No support for other s_field_type's
					if($v_attribute_type_r['s_field_type'] == 'RATING')
					{
						$v_column_display_config_rs[$i]['display_type'] =  'review()';
						$v_column_display_config_rs[$i]['s_field_type'] = $v_attribute_type_r['s_field_type'];
						
						$listingObject->addHeaderColumn(
									$v_attribute_type_r['prompt']);
						
						$show_is_item_reviewed = FALSE;
					}
					else if($v_attribute_type_r['s_field_type'] == 'ITEM_ID')
					{
						$v_column_display_config_rs[$i]['display_type'] = 'display(%value%)';
						$v_column_display_config_rs[$i]['s_field_type'] = $v_attribute_type_r['s_field_type'];
						
						$listingObject->addHeaderColumn(
									$v_attribute_type_r['prompt'],
									'item_id');
					}
				}
			}
			else if($v_column_display_config_rs[$i]['column_id'] == 's_item_type')
			{
				$listingObject->addHeaderColumn($LANG_VARS['type'], 's_item_type', '5%');
			}
			else if($v_column_display_config_rs[$i]['column_id'] == 'title')
			{
				$listingObject->addHeaderColumn($LANG_VARS['title'], 'title', '50%');
			}
			else if($v_column_display_config_rs[$i]['column_id'] == 'action_links')
			{
				if($show_action_column)
				{
					$listingObject->addHeaderColumn($LANG_VARS['action'], NULL, '10%');
				}
			}
			else if($v_column_display_config_rs[$i]['column_id'] == 'username')
			{
				if($show_owner_column)
				{
					$listingObject->addHeaderColumn($LANG_VARS['owner'], 'owner_id', '5%');
				}
			}
			else if($CONFIG_VARS['borrow.enable']!==FALSE && 
						$v_column_display_config_rs[$i]['column_id'] == 'borrow_status')
			{
				$listingObject->addHeaderColumn($LANG_VARS['borrow_status'], NULL, '5%');
			}
			else if($v_column_display_config_rs[$i]['column_id'] == 's_status_type')
			{
				$listingObject->addHeaderColumn($LANG_VARS['status'], 's_status_type', '5%');
			}
			else if($v_column_display_config_rs[$i]['column_id'] == 'status_comment')
			{
				$listingObject->addHeaderColumn($LANG_VARS['status_comment'], NULL, '10%');
			}
			else if($v_column_display_config_rs[$i]['column_id'] == 'category')
			{
				$listingObject->addHeaderColumn($LANG_VARS['category'], 'category', '10%');
			}
		}//while(list(,$v_column_display_config_r) = each($v_column_display_config_rs))
		
		// If no items Per Page - we are listing everything.
		if(is_numeric($listingObject->getItemsPerPage()))
		{		
			$listingObject->setTotalItems(
					fetch_item_listing_cnt($HTTP_VARS, $v_column_display_config_rs));
		}
		
		$listingObject->startListing($page_title);
		
		// If a S_RATING is included as column, this will be set to FALSE.
		$show_is_item_reviewed = TRUE;
		
		// -------------------------------------- Process the Query here -----------------------------------------------------------------
		if( ($result = fetch_item_listing_rs(
					$HTTP_VARS,
					$v_column_display_config_rs, // calculated above
					$listingObject->getCurrentOrderBy(), 
					$listingObject->getCurrentSortOrder(), 
					$listingObject->getStartIndex(),
					$listingObject->getItemsPerPage())) ) 	
		{
			// ----------------------------------------------------------------------------
			// Save current url string, so we can return to last listings page if required.
			//
			// We need to put it here, so that we can get rid of any of the $HTTP_VARS
			// that are not required.
			// ----------------------------------------------------------------------------
			if($HTTP_VARS['mode'] != 'printable')
			{
				if($CONFIG_VARS['listings.save_listing_url'])
				{
					// The Listing class has already removed any $HTTP_VARS which should not
					// be passed onto the next request.
					$HTTP_SESSION_VARS['listing_url_vars'] = $listingObject->getHttpVars();
	
					// These variables should not be passed back from a 'Back to Listing' link!		
					$HTTP_SESSION_VARS['listing_url_vars']['internal_link'] = NULL;
					$HTTP_SESSION_VARS['listing_url_vars']['listing_link'] = NULL;
				
					// These are listing specific - we do not want to save them.
					$HTTP_SESSION_VARS['listing_url_vars']['item_id_instance_no'] = NULL;
					$HTTP_SESSION_VARS['listing_url_vars']['checked_item_id_instance_no'] = NULL;
					$HTTP_SESSION_VARS['listing_url_vars']['checked_item_id_instance_no_list'] = NULL;
		
					if(is_register_globals_enabled())
					{
						session_register('listing_url_vars');
						$listing_url_vars = $HTTP_SESSION_VARS['listing_url_vars'];
					}
				}
			}
			
			while($item_r = mysql_fetch_array($result, MYSQL_ASSOC))
			{  	
				$listingObject->startRow();
				
				// Get the Status Type config for the current item_instance.s_status_type, but grab it once.
				if(!is_array($status_type_rs[$item_r['s_status_type']]))
				$status_type_rs[$item_r['s_status_type']] = fetch_status_type_r($item_r['s_status_type']);
				
				if($HTTP_VARS['mode'] != 'printable')
				{
					if($listingObject->isCheckBoxColumn())
					{
						if(!is_numeric($item_r['parent_id']) && 
									$status_type_rs[$item_r['s_status_type']]['borrow_ind'] == 'Y' && 
									$item_r['owner_id'] !== $HTTP_SESSION_VARS['user_id'] && 
									is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) && 
									!is_item_reserved_or_borrowed_by_user($item_r['item_id'], $item_r['instance_no'], $HTTP_SESSION_VARS['user_id']) &&
									($CONFIG_VARS['borrow.allow_reserve_if_borrowed']!==FALSE || !is_item_borrowed($item_r['item_id'], $item_r['instance_no'])) &&
									($CONFIG_VARS['borrow.allow_multi_reserve']!==FALSE || !is_item_reserved($item_r['item_id'], $item_r['instance_no'])) )
						{
							$listingObject->addColumn($item_r['item_id']."_".$item_r['instance_no']);
						}
						else
						{
							$listingObject->addColumn();
						}
					}
				}
				
				for($i=0; $i<count($v_column_display_config_rs); $i++)
				{
					if($v_column_display_config_rs[$i]['column_type'] == 's_attribute_type')
					{
						if(strlen($v_column_display_config_rs[$i]['display_type'])>0)
						{
							if($v_column_display_config_rs[$i]['is_lookup_attribute_type']===TRUE)
							{
								$lookup_attribute_val = NULL;
								if($v_column_display_config_rs[$i]['orderby']!==FALSE)
								{
									$fieldname = get_field_name($v_column_display_config_rs[$i]['s_attribute_type'], $v_column_display_config_rs[$i]['order_no']);
									if(isset($item_r[$fieldname]))
									{
										$lookup_attribute_val[] = $item_r[$fieldname];
									}
								}
								else
								{
								
									$lookup_attribute_val = fetch_lookup_attribute_val_r($item_r['item_id'], $v_column_display_config_rs[$i]['s_attribute_type'], $v_column_display_config_rs[$i]['order_no']);
								}
								
								if($lookup_attribute_val!==FALSE && $lookup_attribute_val!==NULL)
								{
									$listingObject->addDisplayColumn(
										$v_column_display_config_rs[$i]['s_attribute_type'], 
										$v_column_display_config_rs[$i]['prompt'],
										$v_column_display_config_rs[$i]['display_type'], 
										$lookup_attribute_val);
								}
								else
								{
									$listingObject->addColumn();
								}
							}
							else
							{
								$attribute_val = NULL;
								if($v_column_display_config_rs[$i]['orderby']!==FALSE)
								{
									$fieldname = get_field_name($v_column_display_config_rs[$i]['s_attribute_type'], $v_column_display_config_rs[$i]['order_no']);
									if(isset($item_r[$fieldname]))
									{
										$attribute_val = $item_r[get_field_name($v_column_display_config_rs[$i]['s_attribute_type'], $v_column_display_config_rs[$i]['order_no'])];
									}
								}
								else
								{
									$attribute_val = fetch_attribute_val($item_r['item_id'], $v_column_display_config_rs[$i]['s_attribute_type'], $v_column_display_config_rs[$i]['order_no']);
								}
								
								if($attribute_val!==FALSE && $attribute_val!==NULL)
								{
									$listingObject->addDisplayColumn(
										$v_column_display_config_rs[$i]['s_attribute_type'], 
										$v_column_display_config_rs[$i]['prompt'],
										$v_column_display_config_rs[$i]['display_type'], 
										$attribute_val);
								}
								else
								{
									$listingObject->addColumn();
								}
							}
						}
					}
					else if($v_column_display_config_rs[$i]['column_type'] == 's_field_type')
					{
						if(strlen($v_column_display_config_rs[$i]['display_type'])>0)
						{
							if($v_column_display_config_rs[$i]['s_field_type'] == 'RATING')
							{
								$rating = fetch_review_rating($item_r['item_id']);
								if($rating !==FALSE)
								{
									$listingObject->addDisplayColumn(
										$v_column_display_config_rs[$i]['s_attribute_type'], 
										$v_column_display_config_rs[$i]['prompt'], 
										$v_column_display_config_rs[$i]['display_type'], 
										fetch_review_rating($item_r['item_id']));
								}
								else
								{
									$listingObject->addColumn();
								}
							}
							else if($v_column_display_config_rs[$i]['s_field_type'] == 'ITEM_ID')
							{
								$listingObject->addDisplayColumn(
											$v_column_display_config_rs[$i]['s_attribute_type'], 
											$v_column_display_config_rs[$i]['prompt'],
											$v_column_display_config_rs[$i]['display_type'], 
											$item_r['item_id']);
							}
						}
					}
					else if($v_column_display_config_rs[$i]['column_id'] == 's_item_type')
					{
						$listingObject->addItemTypeImageColumn(
								$item_r['s_item_type'], 
								is_numeric($item_r['parent_id']));
									
						if($HTTP_VARS['mode'] != 'printable' && is_numeric($item_r['parent_id']) && $item_r['owner_id'] !== $HTTP_SESSION_VARS['user_id'])
						{
							$listingObject->addHelpEntry($LANG_VARS['linked_items_cannot_be_reserved'], NULL, 'linked_items_cannot_be_reserved');
						}
					}
					else if($v_column_display_config_rs[$i]['column_id'] == 'title')
					{
						$listingObject->addTitleColumn(
											$item_r,
											$show_is_item_reviewed);
					}
					else if($v_column_display_config_rs[$i]['column_id'] == 'action_links')
					{
						// Add links for owner items.
						if($show_action_column)
						{
							$action_links_rs = NULL;
						
							// Administrator and Owner actions here.
							if($item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'] || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
							{
								// The option of having only Quick Checkout links should be provided.
								if($CONFIG_VARS['listings.show_input_links'] || $CONFIG_VARS['listings.show_quick_checkout'] || $CONFIG_VARS['listings.show_change_owner_link']!==FALSE)
								{
									if(!is_numeric($item_r['parent_id']))
									{
										if($CONFIG_VARS['listings.show_change_owner_link']!==FALSE)
										{
											if($status_type_rs[$item_r['s_status_type']]['change_owner_ind'] == 'Y' && !is_item_borrowed($item_r['item_id'], $item_r['instance_no']))
											{
												$action_links_rs[] = array(url=>'item_input.php?op=change_owner&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'change_owner.gif',text=>$LANG_VARS['change_owner']);		
											}
										}
										
										if($CONFIG_VARS['listings.show_input_links'])
										{
											$action_links_rs[] = array(url=>'item_input.php?op=updateinstance&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y', img=>'update.gif', text=>$LANG_VARS['update']);
											$action_links_rs[] = array(url=>'item_input.php?op=edit&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'edit.gif',text=>$LANG_VARS['edit']);
									
											// So we only have to check the 'is_site_plugin' once!
											if(strlen($item_types_rs[$item_r['s_item_type']]['legal_site_type'])==0)
											{
												$item_types_rs[$item_r['s_item_type']]['legal_site_type'] = is_item_legal_site_type($item_r['s_item_type']);
											}
																
											// Only site types which are considered legal can be allowed for refresh operation.
											if($CONFIG_VARS['listings.show_refresh_links'] && $item_types_rs[$item_r['s_item_type']]['legal_site_type'])
											{
												$action_links_rs[] = array(url=>'item_add.php?item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'refresh.gif',text=>$LANG_VARS['refresh']);
											}
										
											if($status_type_rs[$item_r['s_status_type']]['delete_ind'] == 'Y' && !is_item_reserved_or_borrowed($item_r['item_id'], $item_r['instance_no']))
											{
												$action_links_rs[] = array(url=>'item_input.php?op=delete&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'delete.gif',text=>$LANG_VARS['delete']);
											}
										}
									
										// Quick checkout NOT available to Admin user, unless they are also explicitly the owner.
										if($CONFIG_VARS['borrow.enable']!==FALSE && 
													$item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'] && 
													$CONFIG_VARS['borrow.quick_checkout'] && 
													$CONFIG_VARS['listings.show_quick_checkout'] && 
													($status_type_rs[$item_r['s_status_type']]['borrow_ind'] == 'Y' || $status_type_rs[$item_r['s_status_type']]['borrow_ind'] == 'N'))
										{
											// Cannot quick checkout an item already borrowed.
											if(!is_item_borrowed($item_r['item_id'], $item_r['instance_no']))
											{
												$action_links_rs[] = array(url=>'item_borrow.php?op=quick_check_out&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'quick_check_out.gif',text=>$LANG_VARS['quick_check_out']);
											}
										}								
									}
									else //if(!is_numeric($item_r['parent_id']))
									{
										$action_links_rs[] = array(url=>'item_input.php?op=edit&item_id='.$item_r['item_id'].'&parent_id='.$item_r['parent_id'].'&parent_instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'edit.gif',text=>$LANG_VARS['edit']);
										if($CONFIG_VARS['listings.show_refresh_links'] && is_item_legal_site_type($item_r['s_item_type']))
										{
											$action_links_rs[] = array(url=>'item_add.php?item_id='.$item_r['item_id'].'&parent_id='.$item_r['parent_id'].'&parent_instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'refresh.gif',text=>$LANG_VARS['refresh']);
										}
										$action_links_rs[] = array(url=>'item_input.php?op=delete&item_id='.$item_r['item_id'].'&parent_id='.$item_r['parent_id'].'&parent_instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'delete.gif',text=>$LANG_VARS['delete']);
									}
								}
							}
					
							if($item_r['owner_id'] != $HTTP_SESSION_VARS['user_id']) //non-owner items here.
							{   
								// Reservation/Cancel Information.
								if(!is_numeric($item_r['parent_id']) && $CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['listings.show_borrow_links']!==FALSE)
								{
									if(is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) && $status_type_rs[$item_r['s_status_type']]['borrow_ind'] == 'Y')
									{
										if(is_item_reserved_or_borrowed($item_r['item_id'], $item_r['instance_no']))
										{
											if(is_item_reserved_by_user($item_r['item_id'], $item_r['instance_no'], $HTTP_SESSION_VARS['user_id']))
											{
												$action_links_rs[] = array(url=>'item_borrow.php?op=cancel_reserve&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'cancel.gif',text=>$LANG_VARS['cancel']);
											}
											else if(!is_item_borrowed_by_user($item_r['item_id'], $item_r['instance_no'], $HTTP_SESSION_VARS['user_id']))
											{
												if(($CONFIG_VARS['borrow.allow_reserve_if_borrowed']!==FALSE || !is_item_borrowed($item_r['item_id'], $item_r['instance_no'])) &&
														($CONFIG_VARS['borrow.allow_multi_reserve']!==FALSE || !is_item_reserved($item_r['item_id'], $item_r['instance_no'])) )
												{
													if($CONFIG_VARS['borrow.reserve_basket']!==FALSE)
													{
														$action_links_rs[] = array(url=>'borrow.php?op=update_my_reserve_basket&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'add_to_reserve_list.gif',text=>$LANG_VARS['add_to_reserve_list']);
													}
													else
													{
														$action_links_rs[] = array(url=>'item_borrow.php?op=reserve&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'reserve.gif',text=>$LANG_VARS['reserve']);
													}
												}
											}
										}
										else
										{
											if($CONFIG_VARS['borrow.reserve_basket']!==FALSE)
											{
												$action_links_rs[] = array(url=>'borrow.php?op=update_my_reserve_basket&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'add_to_reserve_list.gif',text=>$LANG_VARS['add_to_reserve_list']);
											}
											else
											{
												$action_links_rs[] = array(url=>'item_borrow.php?op=reserve&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'borrow.gif',text=>$LANG_VARS['borrow']);
											}
										}
									}
								}//if(!is_numeric($item_r['parent_id']) && $CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['listings.show_borrow_links']!==FALSE)
							}//if($item_r['owner_id'] != $HTTP_SESSION_VARS['user_id'])
	
							$listingObject->addActionColumn(
										$action_links_rs);
						}//if($show_action_column)
					}
					else if($v_column_display_config_rs[$i]['column_id'] == 'username')
					{
						// Only show owner column value, if not single owner listing!
						if($show_owner_column)
						{
							$listingObject->addUserNameColumn(
										$item_r['owner_id']);
						}//if($show_owner_column)
					}
					else if($v_column_display_config_rs[$i]['column_id'] == 's_status_type')
					{
						$listingObject->addThemeImageColumn(
										$status_type_rs[$item_r['s_status_type']]['img'],
										$status_type_rs[$item_r['s_status_type']]['description'],
										NULL, //title
										'borrowed_item');//type
					}
					else if($v_column_display_config_rs[$i]['column_id'] == 'borrow_status')
					{
						if($CONFIG_VARS['borrow.enable']!==FALSE)
						{
							if(!is_numeric($item_r['parent_id']) && is_item_borrowed($item_r['item_id'],$item_r['instance_no']))
							{
								$listingObject->addThemeImageColumn(
											'borrowed.gif', 
											$LANG_VARS['borrowed'], 
											NULL, //title
											'borrowed_item');
			  				}
							else if(!is_numeric($item_r['parent_id']) && 
									($status_type_rs[$item_r['s_status_type']]['borrow_ind'] == 'Y' || $status_type_rs[$item_r['s_status_type']]['borrow_ind'] == 'N') && 
									is_item_reserved($item_r['item_id'], $item_r['instance_no']))
							{
								$listingObject->addThemeImageColumn(
											'reserved.gif', 
											$LANG_VARS['reserved'], 
											NULL, //title
											'borrowed_item');
							}
							else
							{
								$listingObject->addColumn($LANG_VARS['not_applicable']);
							}
						}
					}
					else if($v_column_display_config_rs[$i]['column_id'] == 'status_comment')
					{
						// If a comment is allowed and defined, add it in.
						if($status_type_rs[$item_r['s_status_type']]['status_comment_ind'] == 'Y' || ($status_type_rs[$item_r['s_status_type']]['status_comment_ind'] == 'H' && ($HTTP_SESSION_VARS['user_id'] === $item_r['owner_id'] || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))))
							$listingObject->addColumn(nl2br($item_r['status_comment'])); // support newlines in this field
						else
							$listingObject->addColumn($LANG_VARS['not_applicable']);
					}
					else if($v_column_display_config_rs[$i]['column_id'] == 'category')
					{
						// category
						if(strlen($item_types_rs[$item_r['s_item_type']]['category'])==0)
						{
							$item_types_rs[$item_r['s_item_type']]['category'] = fetch_sfieldtype_item_attribute_type($item_r['s_item_type'], 'CATEGORY');
						}
					
						// Finally the category column
						$listingObject->addDisplayColumn(
									$item_types_rs[$item_r['s_item_type']]['category'], 
									$LANG_VARS['category'], 
									$category_display_type, 
									trim_explode(' ', $item_r['category']));
					}
				}//while(list(,$v_column_display_config_r) = each($v_column_display_config_rs))
					
				$listingObject->endRow();
			}//end of while
			mysql_free_result($result);
			// ---------------------------------------------------------------------------------------------------------------
		}//end of if($result)
	
		if($HTTP_VARS['mode'] != 'printable')
		{
			if($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['listings.show_multi_reserve']!==FALSE)
			{
				if($CONFIG_VARS['listings.show_reserve_action']!==FALSE)
				{
					// The getCheckedListCount is the number of checkboxes checked from other pages.
					if($listingObject->getCheckBoxCount() > 0 || $listingObject->getCheckedListCount() > 0)
					{
						$listingObject->addListOpAction(
									$LANG_VARS['reserve_item(s)'], 
									'item_borrow.php', 
									'reserve',
									$listingObject->getCheckedListCount() == 0);//Do isChecked javascript, if no items chosen from other pages
					}
				}
				
				if($CONFIG_VARS['borrow.reserve_basket']!==FALSE && 
						($CONFIG_VARS['listings.show_add_to_reserve_basket_action']===TRUE ||
						($CONFIG_VARS['listings.show_add_to_reserve_basket_action']==='IF_NOT_EMPTY' && 
							is_not_empty_array($HTTP_SESSION_VARS['reserve_basket_listing'])) ))
				{
					// The getCheckedListCount is the number of checkboxes checked from other pages.
					if($listingObject->getCheckBoxCount() > 0 || $listingObject->getCheckedListCount() > 0)
					{
						$listingObject->addListOpAction(
									$LANG_VARS['add_to_reserve_list'], 
									'borrow.php', 
									'update_my_reserve_basket', 
									$listingObject->getCheckedListCount() == 0);//Do isChecked javascript, if no items chosen from other pages
					}
				}
			}
		}
	
		$listingObject->endListing();
		unset($listingObject);
				
		if($HTTP_VARS['mode'] != 'printable' || ifempty($HTTP_VARS['content_type'],'HTML') == 'HTML')
		{
			echo(_theme_footer());
		}
	}
	else
	{
		// invalid login, so login instead.
		include("./login.php");
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
