'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: b_lvl1_Control_General.inc,v $
'*
'*  $Revision: 1.3 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:06:40 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : Data Source Administrator
'*
'************************************************************************
'*
' #1 tLoad_Save_Print
' #1 tAutomaticControlFocus1
' #1 tAutomaticControlFocus2
' #1 tPosAndSize_Protect_Position
' #1 tPosAndSize_Protect_Size
' #1 tPosAndSize_Keyboard
' #1 tPosAndSize_Dialog
' #1 tPosAndSize_KeepRatio
' #1 tTabStop
' #1 tActivationOrder
' #1 tAddFields
'*
'\***********************************************************************
sub b_lvl1_Control_General
	
	call tLoad_Save_Print
	call tAutomaticControlFocus1
    call tAutomaticControlFocus2
	call tPosAndSize_Protect_Position
    call tPosAndSize_Protect_Size
    call tPosAndSize_Keyboard
    call tPosAndSize_Dialog    
    call tPosAndSize_KeepRatio
    'TODO Control the Setting on tabpage Rotation & Slant (should be inactive).
    
    call tTabStop
    call tActivationOrder
    call tAddFields

end sub

'--------------------------------------------------------------------------------------

testcase tLoad_Save_Print
    
    dim iXMLElementCount as integer
    dim i as integer
	'/// Load the document TT_All_Controls.sdw and TPCoG-controls&printing		
    hDateiOeffnen ( gTesttoolPath + ConvertPath("base\level1\input\TT_All_Controls.sdw"))
    'TODO: Are all controlls shown right (color, fonts etc.)?
    '/// save the doc under a diffrent name.
    hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_All_Controls.odt"),gWriterFilter)
    '/// Reload & compare it with the origin doc.
    hCloseDocument
    hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_All_Controls.odt"))
    hCloseDocument
    'TODO: Print the doc & compare it with the origin.
    '(Attention: Background can't be printed colored (Task: <A HREF="http://webserver1.stardiv.de/Bugtracker/Source/Body_ReportDetail.asp?ID=57223">57223</A>)).

endcase    
'--------------------------------------------------------------------------------------
testcase tAutomaticControlFocus1
	
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)

    call hToolbarSelect("FormControls",true)   
	
  	Kontext "FormControls"   	
   	    Edit.Click
        sleep(2)      
	'/// insert a Text Boxes
    printlog "insert three Text Boxes"                                                                    
    call hDrawingWithSelection ( 40, 40, 55, 55 ) 
        
    sleep(2)
    
	Kontext "FormControls"
	    ControlProperties.Click            
	sleep(2)	
	
    fSetControlProperty("Edit","DefaultValue","tt_control")
	sleep(1)
    '/// activate the Automatic control focus.
    printlog "activate the Automatic control focus."
	
    call hToolbarSelect("FormDesignTools",true)   
	    
    Kontext "FormDesignTools"
        AutoControlFocus.Click
        
	sleep(2)	
    '/// save the document
    printlog "save the document"
	hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_Control_Test1.odt"),gWriterFilter)
    sleep(1)
	hCloseDocument
    sleep(1)
    '/// reload the document
    printlog "reload the document"
	hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_Control_Test1.odt"))
    ' /// check if the control has the focus after reload.
    printlog " check if the second control has the focus after reload."
    Kontext "DocumentWriter"
    DocumentWriter.TypeKeys "<HOME>" , true
    sleep(1)       
	DocumentWriter.TypeKeys "<SHIFT END>" , true
    sleep(1)
    DocumentWriter.TypeKeys "<MOD1 C>" , true
    sleep(1)
    if GetClipboard <> "tt_control" then
        warnlog "The control has not the focus. The document has the focus." 
    endif
    
    hCloseDocument
    
endcase
'--------------------------------------------------------------------------------------
testcase tAutomaticControlFocus2
	
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)

    call hToolbarSelect("FormControls",true)   
	
  	Kontext "FormControls"   	
   	Edit.Click
   	sleep(1)
	'/// insert three Text Boxes
    printlog "insert three Text Boxes"
    call hDrawingWithSelection ( 20, 20, 30, 30 )
	sleep(2)
	Kontext "FormControls"
	ControlProperties.Click
	sleep(2)
    fSetControlProperty("Edit","DefaultValue","tt_control1")
	
	call hDrawingWithSelection  ( 35, 40, 55, 50 )
	sleep(2)
    ' open and close the form property browser to get the focus
	Kontext "FormControls"
	ControlProperties.Click
    sleep(2)
    ControlProperties.Click
	sleep(2)	
    
    fSetControlProperty("Edit","TabOrder","1")
    fSetControlProperty("Edit","DefaultValue","tt_control2")

    sleep(1)
    
    call hDrawingWithSelection  ( 10, 60, 20, 70 )
	sleep(2)
    ' open and close the form property browser to get the focus
    Kontext "FormControls"
	ControlProperties.Click
    sleep(2)
    ControlProperties.Click	
	sleep(2)	
    fSetControlProperty("Edit","DefaultValue","tt_control3")
	    
    '/// activate the Automatic control focus.
    printlog "activate the Automatic control focus."

    call hToolbarSelect("FormDesignTools",true)

    Kontext "FormDesignTools"
        AutoControlFocus.Click
        
	sleep(2)	
    '/// save the document
    printlog "save the document"
	hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_Control_Test2.odt"),gWriterFilter)
	hCloseDocument
    sleep(1)
    '/// reload the document
    printlog "reload the document"
	hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_Control_Test2.odt"))
    ' /// check if the second control has the focus after reload.
    printlog " check if the second control has the focus after reload."
    Kontext "DocumentWriter"
    DocumentWriter.TypeKeys "<HOME>" , true
    sleep(1)       
	DocumentWriter.TypeKeys "<SHIFT END>" , true
    sleep(1)
    DocumentWriter.TypeKeys "<MOD1 C>" , true
    sleep(1)
    if GetClipboard <> "tt_control2" then
        warnlog "The wrong control has the focus." 
    endif
    
    hCloseDocument
    
endcase
'--------------------------------------------------------------------------------------
testcase tPosAndSize_Keyboard
    
    dim sPosX as String
    dim sPosY as String
    dim sWidth as String
    dim sHeight as String
    
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    
	sleep(1)
    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"   	
   	    Edit.Click
   	
	'/// insert a Text Box
    printlog "insert a Text Box"    
    Kontext "DocumentWriter"
    DocumentWriter.MouseDown ( 45, 45 )
    DocumentWriter.MouseMove ( 55, 55 )
    DocumentWriter.MouseUp   ( 55, 55 )
	sleep(2)
	'/// open the position and size dialog.
    printlog "open the position and size dialog."
    
    call fOpenPositionAndSizeDialog    
    
    '/// remember the settings.
    printlog "remember the settings."
    Kontext "TabPositionAndSizeWriter"
    sPosX = HorizontalBy.getText()
    sPosY = Verticalby.getText()
    sWidth = Width.getText()
    sHeight = Height.getText()    
    TabPositionAndSizeWriter.OK
    sleep(2)
    
    Kontext "DocumentWriter"    
    gMouseClick(50,50)    
    sleep(2)
    
    '/// move the control via keyboard
    printlog "move the control via keyboard"     
    
    DocumentWriter.TypeKeys "<DOWN>" , true
    DocumentWriter.TypeKeys "<RIGHT>" , true
    DocumentWriter.TypeKeys "<MOD1 TAB>" , true
    DocumentWriter.TypeKeys "<DOWN>" , true
    DocumentWriter.TypeKeys "<RIGHT>" , true
        
    sleep(2)
    '/// open the position and size dialog
    printlog "open the position and size dialog"
    
    call fOpenPositionAndSizeDialog
    
    Kontext "TabPositionAndSizeWriter"
    '/// check the settings.
    printlog "check the settings."
    if sPosX = HorizontalBy.getText() then
        warnlog "The X position has not change."
    endif
    if sPosY = VerticalBy.getText() then
        warnlog "The Y position has not change."
    endif
    if sWidth = Width.getText() then
        warnlog "The width position has not change."
    endif
    if sHeight = Height.getText() then
        warnlog "The height position has not change."
    endif
    
    TabPositionAndSizeWriter.OK
    sleep(1)
    
    hCloseDocument
    
endcase
'--------------------------------------------------------------------------------------
testcase tPosAndSize_Dialog
    
    dim sPosX as String
    dim sPosY as String
    dim sWidth as String
    dim sHeight as String
    dim sText as String
    
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	    DocumentWriter.TypeKeys "tt_doc" , true
        sleep(1)
    
    call hToolbarSelect("FormControls",true)

  	Kontext "FormControls"   	
   	    Edit.Click
        sleep(1)
    '/// insert a Text Box
    printlog "insert a Text Box"
    call hDrawingWithSelection ( 40, 40, 60, 60 )
	sleep(2)
	'/// open the position and size dialog
    printlog "open the position and size dialog"
    
    call fOpenPositionAndSizeDialog         
        
    '/// set values for X , Y , width and height
    printlog "set values for X , Y , width and height"
    Kontext "TabPositionAndSizeWriter"
        ' uncheck KeepRatio because maybe it have set from a test before.
        KeepRatio.UnCheck
        HorizontalBy.setText("3")
        VerticalBy.setText("3")
        Width.setText("3")
        Height.setText("3")    
        sleep(1)
        TabPositionAndSizeWriter.OK
    sleep(2)
    '/// open the position and size dialog
    printlog "open the position and size dialog"
    
    call fOpenPositionAndSizeDialog
    
    Kontext "TabPositionAndSizeWriter"
    '/// check the settings.
    printlog "check the settings."
    sText = HorizontalBy.getText()
    if Instr(sText,"3") = 0 then
        warnlog "The X position has not changed."
    endif
    sText = VerticalBy.getText()
    if Instr(sText,"3") = 0 then
        warnlog "The Y position has not changed."
    endif
    sText = Width.getText()
    if Instr(sText,"3") = 0 then
        warnlog "The width has not changed."
    endif
    sText = Height.getText()    
    if Instr(sText,"3") = 0 then
        warnlog "The height has not changed."
    endif
    
    TabPositionAndSizeWriter.OK
    sleep(1)
    
    hCloseDocument
    
endcase
'--------------------------------------------------------------------------------------
testcase tPosAndSize_Protect_Position
    
    dim sPosX as String
    dim sPosY as String    
    
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)

    call hToolbarSelect("FormControls",true)
	
  	Kontext "FormControls"   	
   	    Edit.Click
   	sleep(1)
	'/// insert a Text Box
    printlog "insert a Text Box"
    call hDrawingWithSelection ( 40, 40, 60, 60 )
	sleep(2)
	'/// open the position and size dialog
    printlog "open the position and size dialog"

    call fOpenPositionAndSizeDialog
    
    Kontext "TabPositionAndSizeWriter"
    sPosX = HorizontalBy.getText()
    sPosY = VerticalBy.getText()
    '/// check protect position
    printlog "check protect position"
    ProtectPosition.Check
    TabPositionAndSizeWriter.OK
    sleep(2)
    
    Kontext "DocumentWriter"    
    gMouseClick(50,50)        
    sleep(2)
    'Kontext "DocumentWriter"    
    '/// test if is possible to move the control via keyboard
    printlog "test if is possible to move the control via keyboard"
    DocumentWriter.TypeKeys "<DOWN>" , true
    DocumentWriter.TypeKeys "<RIGHT>" , true
          
    sleep(2)
    '/// open the position and size dialog
    printlog "open the position and size dialog"
    
    call fOpenPositionAndSizeDialog
    
    Kontext "TabPositionAndSizeWriter"
    '/// check the settings, if the position is changed.
    printlog "check the settings, if the position is changed."
    if sPosX <> HorizontalBy.getText() then
        warnlog "The X position has change although the protect position is checked."
    endif
    if sPosY <> VerticalBy.getText() then
        warnlog "The Y position has change although the protect position is checked."
    endif   
    TabPositionAndSizeWriter.OK
    sleep(1)
    
    hCloseDocument
    
endcase
'--------------------------------------------------------------------------------------
testcase tPosAndSize_KeepRatio
    
    dim sWidth as String
    dim sHeight as String
    
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)

    call hToolbarSelect("FormControls",true) 	

  	Kontext "FormControls"   	
   	    Edit.Click
   	sleep(1)
	'/// insert a Text Box
    printlog "insert a Text Box"
    call hDrawingWithSelection ( 40, 40, 60, 60 )
	sleep(2)
	'/// open the position and size dialog
    printlog "open the position and size dialog"
    
    call fOpenPositionAndSizeDialog

    sleep(1)
    '/// set a width and height.
    printlog "set a width and height."
    Kontext "TabPositionAndSizeWriter"
        KeepRatio.UnCheck
        Width.setText("4")
        sleep(1)
        Height.setText("2")
        sleep(1)
        '/// check keep ratio
        printlog "check keep ratio"
        KeepRatio.Check
        sleep(1)
        Width.setText("6")
        sleep(1)
        '/// check if keep ratio is working
        printlog "check if keep ratio is working"
        if Instr(Height.getText(),"3") = -1  then
            warnlog "The height doesn't keep the ratio"
        endif
        TabPositionAndSizeWriter.OK
    sleep(2)
    '/// open the position and size dialog
    printlog "open the position and size dialog"
    call fOpenPositionAndSizeDialog
    
    Kontext "TabPositionAndSizeWriter"
        '/// check the settings.
        printlog "check the settings."
        if Instr(Width.getText(),"6") = -1 then
            warnlog "The width isn't correct. " + Width.getText()+" instead of 6."
        endif
        if Instr(Height.getText(),"3") = -1 then
           warnlog "The height isn't correct. " + height.getText()+" instead of 3."
        endif
        
        TabPositionAndSizeWriter.OK
    sleep(1)
    
    hCloseDocument
    
endcase
'--------------------------------------------------------------------------------------
testcase tPosAndSize_Protect_Size
    
    dim sWidth as String
    dim sHeight as String
    
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)

    call hToolbarSelect("FormControls",true) 
	
  	Kontext "FormControls"   	
   	    Edit.Click
   	sleep(1)
	'/// insert a Text Box
    printlog "insert a Text Box"
    call hDrawingWithSelection ( 40, 40, 60, 60 )
	sleep(2)
	'/// open the position and size dialog
    printlog "open the position and size dialog"
    
    call fOpenPositionAndSizeDialog
    
    Kontext "TabPositionAndSizeWriter"
        sWidth = Width.getText()
        sHeight = Height.getText()
        '/// check protect size
        printlog "check protect size"
        ProtectSize.Check
        TabPositionAndSizeWriter.OK
    sleep(2)
    
    Kontext "DocumentWriter"    
    gMouseClick(50,50)    
    sleep(2)
    'Kontext "DocumentWriter"    
    '/// test is is possible to change the size of the control via keyboard
    printlog "test is is possible to change the size of the control via keyboard"    
    DocumentWriter.TypeKeys "<MOD1 TAB>" , true
    DocumentWriter.TypeKeys "<DOWN>" , true
    DocumentWriter.TypeKeys "<RIGHT>" , true
    sleep(2)
    '/// open the position and size dialog
    printlog "open the position and size dialog"
    
    call fOpenPositionAndSizeDialog
    
    Kontext "TabPositionAndSizeWriter"
    '/// check the settings
    printlog "check the settings"
    if sWidth <> Width.getText() then
        warnlog "The width has change although the protect size is checked."
    endif
    if sHeight <> Height.getText() then
        warnlog "The height has change although the protect size is checked."
    endif   
    TabPositionAndSizeWriter.OK
    sleep(1)
    
    hCloseDocument
    
endcase

testcase tTabStop
    
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)

    call hToolbarSelect("FormControls",true) 
	
  	Kontext "FormControls"   	
   	    Edit.Click
   	sleep(1)
	'/// insert three Text Boxes
    printlog "insert three Text Boxes"
    call hDrawingWithSelection ( 20, 20, 30, 30 )
	sleep(2)
	
    call fOpenControlPropertyBrowser
    
    call fSetControlProperty("TextBox","DefaultValue","tt_control1")	
	
	call hDrawingWithSelection  ( 20, 40, 30, 50 )
	sleep(2)
    ' open and close the form property browser to get the focus
	
    call fOpenControlPropertyBrowser
    
    call fOpenControlPropertyBrowser
    

    call fSetControlProperty("TextBox","Order","2")
    
    call fSetControlProperty("TextBox","DefaultValue","tt_control2")
       
    call hDrawingWithSelection  ( 20, 60, 30, 70 )
	sleep(2)
    ' open and close the form property browser to get the focus
    
    call fOpenControlPropertyBrowser
    
    call fOpenControlPropertyBrowser
            
    call fSetControlProperty("TextBox","Order","1")
    
    call fSetControlProperty("TextBox","DefaultValue","tt_control3")
    

    call hToolbarSelect("FormDesignTools",true) 
    Kontext "FormDesignTools"
        '/// activate the AutomaticControlFocus
        printlog "activate the AutomaticControlFocus"
        AutoControlFocus.Click
        sleep(1)		
        '/// turn of the design view
        printlog "turn of the design view"
    Kontext "FormControls"
        SwitchControlDesignMode.Click    
        printlog "after designview click"
        sleep(4)
    '/// check if the right control has the focus
    printlog "check if the right control has the focus"
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<HOME>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<SHIFT END>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)        
        if GetClipboard = "tt_doc" then
            warnlog "The control has not the focus. The document has the focus." 
        elseif GetClipboard <> "tt_control3" then
            warnlog "The wrong control has the focus."
        endif  
        '/// check that tyou travel to the right controls via TAB
        printlog "check that tyou travel to the right controls via TAB"
        DocumentWriter.TypeKeys "<TAB>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<HOME>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<SHIFT END>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)        
        if GetClipboard <> "tt_control2" then
            warnlog "The wrong control has the focus." 
        endif        
    
    hCloseDocument
    
endcase
'--------------------------------------------------------------------------------------
testcase tActivationOrder

    Dim sSelText as string

    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	    DocumentWriter.TypeKeys "tt_doc" , true
        sleep(1)
    
    call hToolbarSelect("FormControls",true)    
	
    Kontext "FormControls"   	
   	    Edit.Click
        sleep(1)
    '/// insert three Text Boxes
    printlog "insert three Text Boxes"
    call hDrawingWithSelection ( 20, 20, 30, 30 )
	sleep(2)
    
    call fOpenControlPropertyBrowser
    
    call fSetControlProperty("TextBox","NameText","tt_control1")
    
    call fSetControlProperty("TextBox","DefaultValue","tt_control1")

    sleep(1)    
	
	call hDrawingWithSelection  ( 40, 40, 50, 50 )
	sleep(2)
    
    call fOpenControlPropertyBrowser
    
    call fSetControlProperty("TextBox","NameText","tt_control2")
    
    call fSetControlProperty("TextBox","DefaultValue","tt_control2")
    
    sleep(1)
    
    call hDrawingWithSelection  ( 60, 60, 70, 70 )
	sleep(2)
    
    call fOpenControlPropertyBrowser
    
    call fSetControlProperty("TextBox","NameText","tt_control3")
    
    call fSetControlProperty("TextBox","DefaultValue","tt_control3")
    
    call fOpenTabOrder
    
    ' INdexKLiener
    printlog "INdexKLiener"     
    Kontext "ActivationOrder"        
        sleep(1)
        ControlList.TypeKeys "<END>" , true ' to select the first entry        
        sleep(1)        
        ControlList.TypeKeys "<HOME>" , true        
        sleep(1)
        sSelText = ControlList.getSelText()
        if sSelText <> "tt_control1" then
            warnlog "Wrong control on first position in activation order dialog.(" + sSelText + ")"
        endif        
        sleep(1)
        ControlList.TypeKeys "<DOWN>" , true
        sleep(1)
        sSelText = ControlList.getSelText()
        if sSelText <> "tt_control2" then
            warnlog "Wrong control on second position in activation order dialog.(" + sSelText + ")"
        endif
        sleep(1)        
        ControlList.TypeKeys "<DOWN>" , true
        sleep(1)
        sSelText = ControlList.getSelText()
        if sSelText <> "tt_control3" then
            warnlog "Wrong control on third position in activation order dialog.(" + sSelText + ")"
        endif
        sleep(1)
        MoveUp.Click
        sleep(1)
        ControlList.TypeKeys "<HOME>" , true
        sleep(1)
        ControlList.TypeKeys "<DOWN>" , true
        sSelText = ControlList.getSelText()
        if sSelText <> "tt_control3" then
            warnlog "The move up button in activation order dialog doesn't work.(" + sSelText + ")"
        endif
        
        
        ActivationOrder.OK        
    sleep(1)        
    printlog "open TabOrder dialog"
    call fOpenTabOrder
        
    Kontext "ActivationOrder"        
        sleep(1)
        ControlList.TypeKeys "<END>" , true ' to select the first entry        
        sleep(1)        
        ControlList.TypeKeys "<HOME>" , true        
        sleep(1)
        sSelText = ControlList.getSelText()
        if sSelText <> "tt_control1" then
            warnlog "Wrong control on first position in activation order dialog.(" + sSelText + ")"
        endif        
        sleep(1)
        MoveDown.Click
        sleep(1)        
        ControlList.TypeKeys "<HOME>" , true
        sleep(1)
        ControlList.TypeKeys "<DOWN>" , true
        sSelText = ControlList.getSelText()
        if sSelText <> "tt_control1" then
            warnlog "The move down button in activation order dialog doesn't work.(" + sSelText + ")"
        endif        
        
        ActivationOrder.OK
    
    sleep(1)

    call hToolbarSelect("FormDesignTools",true)

    Kontext "FormDesignTools"
        
            '/// activate the AutomaticControlFocus
            printlog "activate the AutomaticControlFocus"
            AutoControlFocus.Click
            sleep(1)		
            '/// turn of the design view
            printlog "turn of the design view"
        Kontext "FormControls"
            SwitchControlDesignMode.Click    
            printlog "after designview click"
            sleep(4)
       
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<HOME>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<SHIFT END>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)        
        if GetClipboard = "tt_doc" then
            warnlog "The control has not the focus. The document has the focus." 
        elseif GetClipboard <> "tt_control3" then
            warnlog "The wrong control has the focus. (" + GetClipboard +  ")"
        endif      
        DocumentWriter.TypeKeys "<TAB>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)        
        if GetClipboard = "tt_doc" then
            warnlog "The control has not the focus. The document has the focus." 
        elseif GetClipboard <> "tt_control1" then
            warnlog "The wrong control has the focus. (" + GetClipboard +  ")"
        endif
        
        DocumentWriter.TypeKeys "<TAB>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)        
        if GetClipboard = "tt_doc" then
            warnlog "The control has not the focus. The document has the focus." 
        elseif GetClipboard <> "tt_control2" then
            warnlog "The wrong control has the focus. (" + GetClipboard +  ")"
        endif

        
        printlog "turn of the design view"
        Kontext "FormControls"
            SwitchControlDesignMode.Click    
            printlog "after designview click"
            sleep(4)
        
    printlog "open TabOrder dialog"
    call fOpenTabOrder
        
    Kontext "ActivationOrder"
        AutoOrder.Click
        sleep(1)
        ActivationOrder.OK
    sleep(1)
    
    Kontext "FormControls"	
        '/// turn off the design view
        printlog "turn of the design view"    
        SwitchControlDesignMode.Click
    sleep(2)
        
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<HOME>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<SHIFT END>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)        
        if GetClipboard = "tt_doc" then
            warnlog "The control has not the focus. The document has the focus." 
        elseif GetClipboard <> "tt_control1" then
            warnlog "The wrong control has the focus.(" + GetClipboard +  ")"
        endif      
        DocumentWriter.TypeKeys "<TAB>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)        
        if GetClipboard = "tt_doc" then
            warnlog "The control has not the focus. The document has the focus." 
        elseif GetClipboard <> "tt_control2" then
            warnlog "The wrong control has the focus.(" + GetClipboard +  ")"
        endif
        
        DocumentWriter.TypeKeys "<TAB>" , true
        sleep(1)
        DocumentWriter.TypeKeys "<MOD1 C>" , true
        sleep(1)        
        if GetClipboard = "tt_doc" then
            warnlog "The control has not the focus. The document has the focus." 
        elseif GetClipboard <> "tt_control3" then
            warnlog "The wrong control has the focus.(" + GetClipboard +  ")"
        endif
    
    sleep(1)
    
    call hCloseDocument
    
endcase
'-------------------------------------------------------------------------
testcase tAddFields
    
    Dim sControlName1 as String
    Dim sControlName2 as String
    '/// Open a new document,
    printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	    DocumentWriter.TypeKeys "tt_doc" , true
        sleep(1)
    
    call hToolbarSelect("FormControls",true)
    	
    Kontext "FormControls"   	
   	    Edit.Click
        sleep(1)
    '/// insert three Text Boxes
    printlog "insert three Text Boxes"
    call hDrawingWithSelection ( 20, 20, 30, 30 )
	sleep(2)
	Kontext "FormControls"
	    FormProperties.Click
        sleep(1)
   
    Kontext "FormPropertiesDialog"
   	    FormPropertiesTabControl.SetPage TabDataForm
  	
    Kontext "TabDataForm"                
		sleep(1)		
        DataSource.Select "Bibliography"
        sleep(1)
        Content.Select "biblio"
        sleep(1)
        
    Kontext "FormControls"   
	    FormProperties.Click
        sleep(1)

    call hToolbarSelect("FormDesignTools",true)
       
    Kontext "FormDesignTools"    
        AddField.Click
        sleep(1)
    
    Kontext "FeldAuswahl"
        Liste.Select 1
        sControlName1 = Liste.getSelText
        Liste.TypeKeys "<RETURN>"
        sleep(3)
        
    Kontext "FormDesignTools"
        ShowFmExplorer.Click
        sleep(1)

    Kontext "FormularNavigator" 
       	Liste.TypeKeys "<HOME>" , true 
        Liste.TypeKeys "<DOWN>" , 4, true   	    
        sControlName2 = Liste.getSelText
        if sControlName1 <> sControlName2 then
            warnlog "The control name is not the same as the fieldname."
        endif
        
    sleep (2)    
    
    call hCloseDocument
    
endcase

function fOpenPositionAndSizeDialog

    call hToolbarSelect("FormDesignTools",true)  	
            
    Kontext "FormDesignTools"        
        PositionAndSizeDialog.Click
    
    fOpenPositionAndSizeDialog=true
    
end function
'-------------------------------------------------------------------------
function fOpenTabOrder

    printlog "open FormControls Toolbar"

    call hToolbarSelect("FormDesignTools",true)  	

    Kontext "FormDesignTools"    
        TabDialog.Click    
    
    fOpenTabOrder=true
    
end function

'-------------------------------------------------------------------------

function fOpenControlPropertyBrowser
    sleep(2)

    call hToolbarSelect("FormControls",true)  	

    Kontext "FormControls"
        ControlProperties.Click  
    Kontext "ControlPropertiesDialog"
    
    if ControlPropertiesDialog.exists(3) then
        'nothing
    else
       Kontext "FormControls"        
            ControlProperties.Click    
    endif
        
    sleep(2)
    fOpenControlPropertyBrowser=true
    
end function
