'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: b_lvl1_Control_Several1.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: msc $ $Date: 2005/10/13 12:26:54 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : Control Serveral Part 1 - check each control and each property
'*
'************************************************************************
'*
' #1 tCheckBox 
' #1 tTextBox 
' #1 tFormattedField 
' #1 tPushButton 
' #1 tOptionButton 
' #1 tListBox 
' #1 tComboBox 
' #1 tLabelField 
'*
'\***********************************************************************

sub b_lvl1_Control_Several1
	
    call fSwitchAutopilotOff(true) ' has to run first to switch off the autopilot
    
    call tCheckBox         ' tested properties: Tristate, Enabled, Label field
    call tTextBox          ' tested properties: Background color, Additional Info, Scrollbars, Password
    call tFormattedField   ' tested properties: Value max, Value min, Formatting
    call tPushButton       ' tested properties: Graphic, Alignment, Default button, Toggle, Take Focus
    call tOptionButton     ' tested properties: Print, Reference value, Default status
    call tListBox          ' tested properties: Line count, Multiselection, List Entries, Default selection
    call tComboBox         ' tested properties: Auto fill, Max text length, Hide selection, Border color
    call tLabelField       ' tested properties: Alignment, Help text
    
    call fSwitchAutopilotOff(false)
    
end sub

'--------------------------------------------------------------------------------------
' todo: testcase: tTextBox and tLabelFild contain 'multiline' settings, but HelpID disappeared - has to be reworked
'--------------------------------------------------------------------------------------

testcase tCheckBox
	
    '/// Open a new document,
        printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	    DocumentWriter.TypeKeys "tt_doc" , true
        sleep(1)
	Kontext "Toolbar"
        call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"
    '/// insert a label field for creating a formular (also needed for checking property: label)
   	    Label.Click
        sleep(1)      
        printlog "insert a label"        
        call hDrawingWithSelection ( 20, 20, 30, 30 )
        sleep(2)
    '/// insert a checkbox
   Kontext "FormControls"
        CheckBox.Click
        sleep(1)      
        printlog "insert a checkbox"        
        call hDrawingWithSelection ( 40, 40, 50, 50 )
        sleep(2)
    Kontext "FormControls"
	    ControlProperties.Click
        sleep (1)
    Kontext "ControlPropertiesDialog"   
        ControlPropertiesTabControl.setPage TabGeneralControl       'make shure that tabpage general in property is choosen
        sleep(2)
    '/// set properties: Label - therefore needed: a present label field
        printlog "set properties"  
    Kontext "TabGeneralControl"	
        LabelFieldButton.Click
        sleep(1)
    Kontext "LabelFieldSelection"	
        LabelFieldSelection.TypeKeys "<DOWN>",TRUE
        LabelFieldSelection.TypeKeys "<DOWN>",TRUE
        sleep(1)
        LabelFieldSelection.OK
        sleep(1)
    '/// set properties: Tristate, Enabled
	    call fSetControlProperty("CheckBox","TriState","2")   
        call fSetControlProperty("CheckBox","Enabled","1")        'listbox property: no
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// save the document
        printlog "save the document"
        hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_CheckBox.odt"),gWriterFilter)
	hCloseDocument
        sleep(1)
    '/// reload the document
        printlog "reload the document"
	hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_CheckBox.odt"))    
    Kontext "Toolbar"
        call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"
        SwitchControlDesignMode.Click
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<SHIFT F4>"
        sleep(1)
     Kontext "FormControls"
     try
	    ControlProperties.Click
     catch 
        warnlog "error while open the control properties browser"
        call hCloseDocument
        goto endsub
     endcatch
    '/// check if the values are saved
        printlog "check if the values are saved"
        sleep(2)
    Kontext "TabGeneralControl"    
	    TabGeneralControl.TypeKeys "<TAB>" , true ' this tab is importent, I don't not why but it is.
    if fGetControlProperty("CheckBox","TriState") <> "2" then
        warnlog "the value 'tristate' is not saved correctly"
    endif    
    if fGetControlProperty("CheckBox","Enabled") <> "1" then
        warnlog "the value 'enabled' is not saved correctly"
    endif
    printlog "property character set text: " & LabelField.getText
    if LabelField.getText = "" then
        warnlog "the value 'label' is not saved correctly"
    endif
        printlog " - testcase end"
        sleep(1)
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// close document - end of testcase
    hCloseDocument
endcase
'--------------------------------------------------------------------------------------

testcase tTextBox     
    
    '/// Open a new document,
        printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	    DocumentWriter.TypeKeys "tt_doc" , true
        sleep(1)        
	Kontext "Toolbar"
	    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"   	
   	    Edit.Click
        sleep(1)      
	'/// insert a text box
        printlog "insert a text box"                    
        call hDrawingWithSelection ( 20, 20, 30, 30 )    
        sleep(2)
	Kontext "FormControls"
	    ControlProperties.Click
        sleep (1)
    Kontext "ControlPropertiesDialog"   
        ControlPropertiesTabControl.setPage TabGeneralControl       'make shure that tabpage general in property is choosen
        sleep(2)
    '/// set properties: Background color, Additional Info, Scrollbars, Password
        printlog "set properties"  
        call fSetControlProperty("TextBox","Background","92") 
        call fSetControlProperty("TextBox","AdditionalInfo","my only friend the end.")
        call fSetControlProperty("TextBox","TextType","2")      'needed for activate scrollbar
        call fSetControlProperty("TextBox","Scrollbars","4")       
        call fSetControlProperty("TextBox","TextType","1")      'needed for activate password
        call fSetControlProperty("TextBox","Password","p")
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// save the document
        printlog "save the document"
        hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_TextBox.odt"),gWriterFilter)
	hCloseDocument
        sleep(1)
    '/// reload the document
        printlog "reload the document"
	hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_TextBox.odt"))    
    Kontext "Toolbar"
	    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"  
        SwitchControlDesignMode.Click
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<SHIFT F4>"
        sleep(1)
    Kontext "FormControls"    
     try
        ControlProperties.Click
     catch 
        warnlog "error while open the control properties browser"
        call hCloseDocument
        goto endsub
     endcatch
    '/// check if the values are saved
        printlog "check if the values are saved"
        sleep(2)
    Kontext "TabGeneralControl"    
	    TabGeneralControl.TypeKeys "<TAB>" , true ' this tab is importent, I don't not why but it is.
    if fGetControlProperty("TextBox","Background") <> "92" then
        warnlog "the value: background is not saved"
    endif  
    if fGetControlProperty("TextBox","AdditionalInfo") <> "my only friend the end." then
        warnlog "the value: background is not saved"
    endif
        call fSetControlProperty("TextBox","TextType","2")      'needed for activate scrollbar
        sleep(1)
    if fGetControlProperty("TextBox","Scrollbars") <> "4" then
        warnlog "the value: Scrollbars are not saved"
    endif       
    call fSetControlProperty("TextBox","TextType","1")      'needed for activate password
        sleep(1)
    if fGetControlProperty("TextBox","Password") <> "p" then
        warnlog "the value: Password is not saved"
    endif   
        printlog " - testcase end"    
        sleep(1)    
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// close document - end of testcase
    hCloseDocument 
endcase
'--------------------------------------------------------------------------------------

testcase tFormattedField     
    
    '/// Open a new document,
        printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	    DocumentWriter.TypeKeys "tt_doc" , true
        sleep(1)
	Kontext "Toolbar"
	    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"   	
   	    FormattedField.Click
        sleep(1)      
	'/// insert a formatted field
        printlog "insert a formatted field"                
        call hDrawingWithSelection ( 20, 20, 30, 30 )
        sleep(2)
	Kontext "FormControls"
	    ControlProperties.Click
        sleep (1)
    Kontext "ControlPropertiesDialog"   
        ControlPropertiesTabControl.setPage TabGeneralControl       'make shure that tabpage general in property is choosen
        sleep(2)
    '/// set ValueMin to 2 and ValueMax to 9 and any Formatting
        printlog "set ValueMin to 2 and ValueMax to 9 and any Formatting"    
    Kontext "TabGeneralControl"     'set any formatting
        FormatkeyButton.Click
    Kontext "TabZahlen"
        TabZahlen.TypeKeys "<DOWN>", true
        TabZahlen.TypeKeys "<RETURN>", true   
        sleep(1)    	
        fsetControlProperty("FormattedField","ValueMax","9")
        sleep(1)            
        fsetControlProperty("FormattedField","ValueMin","2")
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// save the document
        printlog "save the document"
        hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_FormattedField.odt"),gWriterFilter)
	hCloseDocument
        sleep(1)
    '/// reload the document
        printlog "reload the document"
	hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_FormattedField.odt"))    
    Kontext "Toolbar"
	    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"  
        SwitchControlDesignMode.Click
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<SHIFT F4>"
        sleep(1)
    Kontext "FormControls"    
     try
        ControlProperties.Click
     catch 
        warnlog "error while open the control properties browser"
        call hCloseDocument
        goto endsub
     endcatch
    '/// check if the values are saved
        printlog "check if the values are saved"
        sleep(2)
    Kontext "TabGeneralControl"    
	    TabGeneralControl.TypeKeys "<TAB>" , true ' this tab is importent, I don't not why but it is.
    if fgetControlProperty("FormattedField","ValueMax") = "" then
        warnlog "the value ValueMax is not saved"
    endif
    if fgetControlProperty("FormattedField","ValueMin") = "" then
        warnlog "the value ValueMin is not saved"
    endif      
    if fgetControlProperty("FormattedField","Formatkey") = "" then
        warnlog "the value ValueMin is not saved"
    endif     
        sleep(1)  
        printlog " - testcase end"
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// close document - end of testcase
    hCloseDocument  
endcase
'--------------------------------------------------------------------------------------

testcase tPushButton
	
    '/// Open a new document,
        printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	    DocumentWriter.TypeKeys "tt_doc" , true
        sleep(1)
	Kontext "Toolbar"
	    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"   	
   	    PushButton.Click
        sleep(1)      
	'/// insert a Push Button
        printlog "insert a Push Button"    
        call hDrawingWithSelection ( 20, 20, 30, 30 )
        sleep(2)
	Kontext "FormControls"
	    ControlProperties.Click
        sleep (1)
    Kontext "ControlPropertiesDialog"   
        ControlPropertiesTabControl.setPage TabGeneralControl       'make shure that tabpage general in property is choosen
        sleep(2)
    '/// set a graphic for this button
        printlog "set a graphic for this button"	
	Kontext "TabGeneralControl"	
    if gNetzInst = false then
        call fSetControlProperty("PushButton","Graphics", gOfficePath + ConvertPath("share/gallery/bullets/blkpearl.gif"))
    else
        call fSetControlProperty("PushButton","Graphics", gNetzOfficePath + ConvertPath("share/gallery/bullets/blkpearl.gif"))
    endif
	    sleep(1)
    '/// set further properties: default button, toggle, graphics alignment
        printlog "set further properties"  
        call fSetControlProperty("PushButton","DefaultButton","2")           'listbox property: yes
        call fSetControlProperty("PushButton","ToggleProp","2")                  'listbox property: yes
        call fSetControlProperty("PushButton","GraphicsAlignment","5")
        call fSetControlProperty("PushButton","TakeFocus","1")       
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// save the document
        printlog "save the document"    
        hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_PushButton.odt"),gWriterFilter)
    hCloseDocument
        sleep(1)
    '/// reload the document
        printlog "reload the document"
	hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_PushButton.odt"))
    '/// check if the graphic still displayed
        printlog "check if the graphic still displayed"
    Kontext "Toolbar"
	    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"  
        SwitchControlDesignMode.Click
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<SHIFT F4>"
        sleep(1)
    Kontext "FormControls"    
     try
        ControlProperties.Click
     catch 
        warnlog "error while open the control properties browser"
        call hCloseDocument
        goto endsub
     endcatch
        sleep(1)    
    '/// check if everything is saved right
        printlog "check if everything is saved right"
        dim bScrOK as boolean       'control variable if all properties are correct
        bScrOK = true
        dim sGraphics as String     'variable for graphics path
    'check if the graphic is saved
        sGraphics = fGetControlProperty("PushButton","Graphics")
    if Right(sGraphics,12) <> "blkpearl.gif" then
        warnlog "The graphics file name is not saved"
        bScrOK = false
    endif
    if fGetControlProperty("PushButton","GraphicsAlignment") <> "5" then
        warnlog "the pushbutton is not saved with property: Graphics Alignment"
        bScrOK = false
    endif
    'check if the default button is saved
    if fGetControlProperty("PushButton","DefaultButton") <> "2" then
        warnlog "the pushbutton is not saved with property: Default Button"
        bScrOK = false
    endif
    if fGetControlProperty("PushButton","ToggleProp") <> "2" then
        warnlog "the pushbutton is not saved with property: Toggle"
        bScrOK = false
    endif
    if fGetControlProperty("PushButton","TakeFocus") <> "1" then
        warnlog "the pushbutton is not saved with property:  Take Focus on click"
        bScrOK = false
    endif
        sleep(1)	
    if bScrOK = true then printlog "Pushbutton was saved correctly"
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// close document - end of testcase
    hCloseDocument
endcase
'--------------------------------------------------------------------------------------

testcase tOptionButton
	
    '/// Open a new document,
        printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	    DocumentWriter.TypeKeys "tt_doc" , true
        sleep(1)
	Kontext "Toolbar"
	    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"   	
   	    Radiobutton.Click
        sleep(1)    
	'/// insert an optionbutton
        printlog "insert an optionbutton"        
    call hDrawingWithSelection ( 20, 20, 30, 30 )
	    sleep(2)
	Kontext "FormControls"
	    ControlProperties.Click
        sleep (1)
    Kontext "ControlPropertiesDialog"   
        ControlPropertiesTabControl.setPage TabGeneralControl       'make shure that tabpage general in property is choosen
        sleep(2)
    '/// set properties: Print, Reference value, Default status
        printlog "set properties"  
        call fSetControlProperty("Radiobutton","Printable","1")         'listbox property: no
        call fSetControlProperty("Radiobutton","ReferenceValue","777")
        call fSetControlProperty("Radiobutton","DefaultState","2")      'listbox property: selected
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// save the document
        printlog "save the document"
        hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_Optionbutton.odt"),gWriterFilter)
	hCloseDocument
        sleep(1)
    '/// reload and prepare the document
        printlog "reload the document"
	hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_Optionbutton.odt"))
    Kontext "Toolbar"
	    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"  
        SwitchControlDesignMode.Click
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<SHIFT F4>"
        sleep(1)
    Kontext "FormControls"    
     try
        ControlProperties.Click
     catch 
        warnlog "error while open the control properties browser"
        call hCloseDocument
        goto endsub
     endcatch
        sleep(1)
    '/// check if property values are inserted
        printlog "check if property values are inserted"
    Kontext "TabGeneralControl"	
        dim bScrOK as boolean       'control variable if all properties are correct
        bScrOK = true           
    if fGetControlProperty("Radiobutton","Printable") <> "1" then
        warnlog "the Optionbutton is not saved with property: Print"
        bScrOK = false
    endif
    if fGetControlProperty("Radiobutton","ReferenceValue") <> "777" then
        warnlog "the Optionbutton is not saved with property: ReferenceValue"
        bScrOK = false
    endif
    if fGetControlProperty("Radiobutton","DefaultState") <> "2" then
        warnlog "the Optionbutton is not saved with property: ReferenceValue"
        bScrOK = false
    endif
    if bScrOK = true then printlog "Optionbutton was saved correctly"
        sleep(1)   
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// close document - end of testcase
    hCloseDocument
endcase
'--------------------------------------------------------------------------------------

testcase tListBox
	
    '/// Open a new document,
        printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	    sleep(1)
	Kontext "Toolbar"
	    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"   	
   	    ListBox.Click
        sleep(1)    
	'/// insert a listbox
        printlog "insert a listbox"        
        call hDrawingWithSelection ( 20, 20, 30, 30 )
        sleep(2)
	Kontext "FormControls"
	    ControlProperties.Click
        sleep (1)
    Kontext "ControlPropertiesDialog"   
        ControlPropertiesTabControl.setPage TabGeneralControl       'make shure that tabpage general in property is choosen
        sleep(2)
    '/// set properties: default selection, line count, list entries, multiselection
     printlog "set properties"  
    Kontext "TabGeneralControl"	
    'set property: list entries
        call fSetControlProperty("ListBox","ListEntries","My only friend the end.")
    'set property: line count
        call fSetControlProperty("ListBox","DropDown","2")    'needed for activate line count
        sleep (1)
        call fSetControlProperty("ListBox","LineCount","10")
        sleep (1)
    'set property: multiselection
        call fSetControlProperty("ListBox","Multiselection","2")    'yes
        sleep (1)
    'set property: default selection    
        call fSetControlProperty("ListBox","DefaultSelection2","88")
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// save the document
        printlog "save the document"
        hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_ListBox.odt"),gWriterFilter)
	hCloseDocument
        sleep(1)
    '/// reload and prepare the document
        printlog "reload the document"
	hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_ListBox.odt"))
    Kontext "Toolbar"
	    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"  
        SwitchControlDesignMode.Click
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<SHIFT F4>"
        sleep(1)
    Kontext "FormControls"    
     try
        ControlProperties.Click
     catch 
        warnlog "error while open the control properties browser"
        call hCloseDocument
        goto endsub
     endcatch
        sleep(1)
    '/// check if property values are inserted
        printlog "check if property values are inserted"
    Kontext "TabGeneralControl"	
        dim bScrOK as boolean       'control variable if all properties are correct
        bScrOK = true  
    '(special field - cannot be read out)
    'if fGetControlProperty("ListBox","ListEntries") = "" then
        'warnlog "the listbox is not saved with property: ListEntries"
        'bScrOK = false
    'endif
    '(special field - cannot be read out)
    'if fGetControlProperty("ListBox","DefaultSelection2") = "" then
        'warnlog "the listbox is not saved with property: DefaultSelection2"
        'bScrOK = false
    'endif 
    if fGetControlProperty("ListBox","LineCount") <> "10" then
        warnlog "the listbox is not saved with property: LineCount"
        bScrOK = false
    endif
    if fGetControlProperty("ListBox","Multiselection") <> "2" then
        warnlog "the listbox is not saved with property: Multiselection"
        bScrOK = false
    endif
    if bScrOK = true then printlog "listbox was saved correctly"
        printlog " - testcase end"
        sleep(1) 
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// close document - end of testcase
    hCloseDocument
endcase
'--------------------------------------------------------------------------------------

testcase tComboBox
	
    '/// Open a new document,
        printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	    DocumentWriter.TypeKeys "tt_doc" , true
        sleep(1)
	Kontext "Toolbar"
	    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"   	
   	    ComboBox.Click
        sleep(1)    
	'/// insert a combobox
        printlog "insert a combobox"        
        call hDrawingWithSelection ( 20, 20, 30, 30 )
        sleep(2)
	Kontext "FormControls"
	    ControlProperties.Click
        sleep (1)
    Kontext "ControlPropertiesDialog"   
        ControlPropertiesTabControl.setPage TabGeneralControl       'make shure that tabpage general in property is choosen
        sleep(2)
    '/// set properties: Auto fill, Max text length, Hide Selection, Border color
        printlog "set properties"  
    Kontext "TabGeneralControl"	
        call fSetControlProperty("ComboBox","MaxTextLen","6")
        call fSetControlProperty("ComboBox","AutoComplete","1")    'no
        call fSetControlProperty("ComboBox","HideSelection","1")   'no
        call fSetControlProperty("ComboBox","Border","3")          'needed to activate Border Color
        call fSetControlProperty("ComboBox","BorderColor","13")
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// save the document
        printlog "save the document"
        hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_ComboBox.odt"),gWriterFilter)
	hCloseDocument
        sleep(1)
    '/// reload and prepare the document
        printlog "reload the document"
	hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_ComboBox.odt"))
    Kontext "Toolbar"
	    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"  
        SwitchControlDesignMode.Click
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<SHIFT F4>"
        sleep(1)
    Kontext "FormControls"    
     try
        ControlProperties.Click
     catch 
        warnlog "error while open the control properties browser"
        call hCloseDocument
        goto endsub
     endcatch
        sleep(1)
    '/// check if property values are inserted
        printlog "check if property values are inserted"
    Kontext "TabGeneralControl"	
        dim bScrOK as boolean       'control variable if all properties are correct
        bScrOK = true  
    if fGetControlProperty("ComboBox","MaxTextLen") <> "6" then
        warnlog "the combobox is not saved with property: MaxTextLen"
        bScrOK = false
    endif
    if fGetControlProperty("ComboBox","AutoComplete") <> "1" then
        warnlog "the combobox is not saved with property: AutoComplete"
        bScrOK = false
    endif
    if fGetControlProperty("ComboBox","HideSelection") <> "1" then
        warnlog "the combobox is not saved with property: Hide Selection"
        bScrOK = false
    endif
    if fGetControlProperty("ComboBox","BorderColor") <> "13" then
        warnlog "the combobox is not saved with property: Border Color"
        bScrOK = false
    endif
    if bScrOK = true then printlog "Combobox was saved correctly"
        sleep(1)  
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// close document - end of testcase
    hCloseDocument
endcase
'--------------------------------------------------------------------------------------

testcase tLabelField	
    
    '/// Open a new document,
        printlog "Open a new document,"
	call hNewDocument
    Kontext "DocumentWriter"       
	    DocumentWriter.TypeKeys "tt_doc" , true
        sleep(1)
	Kontext "Toolbar"
	    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"   	
   	    Edit.Click
        sleep(1)      
	'/// insert a lable field
        printlog "insert a lable field"            
        call hDrawingWithSelection ( 20, 20, 30, 30 )
        sleep(2)
        Kontext "FormControls"
        ControlProperties.Click
        sleep (1)
    Kontext "ControlPropertiesDialog"   
        ControlPropertiesTabControl.setPage TabGeneralControl       'make shure that tabpage general in property is choosen
        sleep(2)
    '/// set properties: alignment, multiline, help text
        printlog "set properties"  
        call fSetControlProperty("LabelField","Align","4")        'set to right
        call fSetControlProperty("LabelField","HelpText","Filled in Text")    
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// save the document
        printlog "save the document"
        hSpeichernUnterMitFilterKill ( gOfficePath + ConvertPath("user\work\TT_LabelField.odt"),gWriterFilter)
	hCloseDocument
        sleep(1)
    '/// reload the document
        printlog "reload the document"
	hDateiOeffnen ( gOfficePath + ConvertPath("user\work\TT_LabelField.odt"))    
    Kontext "Toolbar"
	    call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"  
        SwitchControlDesignMode.Click
    Kontext "DocumentWriter"
        DocumentWriter.TypeKeys "<SHIFT F4>"
        sleep(1)
    Kontext "FormControls"    
     try
        ControlProperties.Click
     catch 
        warnlog "error while open the control properties browser"
        call hCloseDocument
        goto endsub
     endcatch
    '/// check if the values are saved
        printlog "check if the values are saved"
        sleep(2)
    Kontext "TabGeneralControl"    
	    TabGeneralControl.TypeKeys "<TAB>" , true ' this tab is importent, I don't not why but it is.
    if fGetControlProperty("LabelField","Align") <> 4 then
        warnlog "the value: align is not saved"
    endif  
     if fGetControlProperty("LabelField","HelpText") <> "Filled in Text" then
        warnlog "the value: HelpText is not saved"
    endif  
        printlog " - testcase end"
        sleep(1)   
    '/// close control property browser    
    Kontext "ControlPropertiesDialog"
        ControlPropertiesDialog.close
    '/// close document - end of testcase
    hCloseDocument
endcase
'--------------------------------------------------------------------------------------

