'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: b_lvl1_hsqldb.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: msc $ $Date: 2005/12/02 09:59:46 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : hsqldb test
'*
'************************************************************************
'*
' #1 tGeneral
' #1 tOpenDatabaseWithViews
'*
'\***********************************************************************
sub b_lvl1_hsqldb

    call tGeneral
    call tOpenDatabaseWithViews

end sub

testcase tGeneral
    
    ' *********************************************************************
    '   databases specific settings for hsqldb
    ' *********************************************************************
        
    Dim i_fieldcount as integer 'amount of field types - columns
	i_fieldcount = 7 'amount of field types (no primary key supported in dBase) normally: 7
		
	Dim ifieldrow_amount as integer 'amount of inserted rows
	ifieldrow_amount = 3
	
    Dim sFileName as string
	sFileName = gOfficePath + ConvertPath("user/work/tt_hsqldb.odb")
    
	Dim sTableName as string
	sTableName = "tt_test_create-table"
	
	Dim sPWD as string
	sPWD = "ignore"
	
	Dim sCatalog as string
	sCatalog = " "     			' not used in this ds
	
	Dim sSchema as string
	sSchema = " "     			' not used in this ds
	
	
    Dim aFieldTypeContent(i_fieldcount,2) as string 'database specific data matrix
        
    aFieldTypeContent(1,1)="tt_boolean"	        'name of fieldtype
    aFieldTypeContent(1,2)="boolean"         	'number of fieldtype (listbox entry)
    
    aFieldTypeContent(2,1)="tt_longvarchar"			
    aFieldTypeContent(2,2)="longvarchar"			
    
    aFieldTypeContent(3,1)="tt_char"		
    aFieldTypeContent(3,2)="char"		
        
    aFieldTypeContent(4,1)="tt_decimal"
    aFieldTypeContent(4,2)="decimal"
        
    aFieldTypeContent(5,1)="tt_varchar"
    aFieldTypeContent(5,2)="varchar"
         
    aFieldTypeContent(6,1)="tt_date"    
    aFieldTypeContent(6,2)="date"
    
    Dim aFieldContent(1,6) as string 'database specific data matrix
        
    aFieldContent(1,1)="<space>"
    aFieldContent(1,2)="this is a memo field"    
    aFieldContent(1,3)="char"			
    aFieldContent(1,4)="1"		
    aFieldContent(1,5)="this is a text field"
    aFieldContent(1,6)="13.05.2004  "
    
   		dim dbok as boolean   		
        dbok = fCreateHSQLDatasource(sFileName)
        'dbok = true
        if dbok = true then
        
            call fOpendatabase(sFileName)
            call fCreateTable( aFieldTypeContent(), sTableName)
            call fInsertIntoTable( aFieldContent(), sTableName)
            call fCloseDatabase    
            
            'test the index design
            use "base\level1\datasources\inc\b_lvl1_IndexDesign.inc"    
            call tIndex(sFileName, sTableName)            

            'outcomment because the needed table is not available
            'TODO: I need a new table for this test
            'use "base\level1\inc\b_lvl1_Query.inc"            
            'app.FileCopy gTesttoolPath + ConvertPath("base/level1/input/TT_db.odb") , gOfficePath + ConvertPath("user/work/TT_db.odb")            
            'call b_lvl1_Query(gOfficePath + "user/work/TT_db.odb" ,"hsqldb")            
            
            'outcomment because of some bugs in forms
            'use "base\level1\inc\b_lvl1_Forms.inc"
            'call b_lvl1_Forms ("TT_dBase")
            
                      
		else 
            warnlog "Data Source could not be created - beyond testcases stopped"
		endif
	
endcase
'-------------------------------------------------------------------------
testcase tOpenDatabaseWithViews
    
    app.FileCopy ConvertPath(gTesttoolPath + "base/level1/input/hsql_datasource/TT_hsqldb_2.0.0.odb"),ConvertPath(gOfficePath + "user/work/TT_hsqldb_2.0.0.odb")
 
    call fOpenDatabase(ConvertPath(gOfficePath + "user/work/TT_hsqldb_2.0.0.odb"))
    
    if fOpenTable("View 1") then
        printlog "View 1 successful open"
        call fCloseTableView()
    else
        warnlog "View 1 not successful open"
        
    endif

    call fCloseDatabase()

endcase
'------------------------------------------------------------------------- 

