'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: b_lvl1_Table_Wizard.inc,v $
'*
'*  $Revision: 1.14 $
'*
'*  last change: $Author: msc $ $Date: 2006/02/02 12:43:46 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : Table Wizard
'*
'************************************************************************
'*
' #1 tNewTable
' #1 tCheckSampleTables
' #1 tChangeFieldName
' #1 tStartFormWizardFromTableWizard
' #1 tCreateAllTables
'*
'\***********************************************************************
sub b_lvl1_Table_Wizard

    call tNewTable
    call tCheckSampleTables
    call tChangeFieldName
    call tStartFormWizardFromTableWizard
    call tCreateAllTables

end sub
'-------------------------------------------------------------------------
testcase tNewTable  
  
    'hold a table name
    Dim sTableName as String 

    '/// open Bibliography database
    printlog "open Bibliography database"
    if not fOpenDataBase(gOfficePath + ConvertPath("user\database\biblio.odb")) then
        warnlog "Database " + gOfficePath + ConvertPath("user/database/biblio.odb") + " could not be open."
        goto endsub
    end if

    '/// start the table wizard
    printlog "start the table wizard"
    if not fStartTableWizard() then
        warnlog "The table wizard doesn't start. TEST STOPPED"
        goto endsub
    endif

    Kontext "TableWizard"
        '/// add all fields from the displayed table
        printlog "add all fields from the displayed table"
        AddAll.click
        '/// click NEXT
        printlog "click NEXT"
        NextBtn.click
             
        '/// click NEXT
        printlog "click NEXT"
        NextBtn.click

        'remember the table, because we want to delete it later
        sTableName = TableName.getText                    
        '/// click Finish
        printlog "click Finish"       
        FinishBtn.Click
    
    sleep(1)

    '/// close the open table
    printlog "close the open table"
    call fCloseTableView()
    
    '/// delete the created table
    printlog "delete the created table"
    call fDeleteTable sTableName

    '/// close the database
    printlog "close the database"
    call fClosedatabase()
    
endcase   
'-------------------------------------------------------------------------
testcase tCheckSampleTables

    dim iTablesCount as Integer
    dim iFieldsCount as Integer
    dim i as Integer
    dim ii as Integer        

    '/// open Bibliography database
    printlog "open Bibliography database"
    if not fOpenDataBase(gOfficePath + ConvertPath("user\database\biblio.odb")) then
        warnlog "Database " + gOfficePath + ConvertPath("user/database/biblio.odb") + " could not be open."
        goto endsub
    end if

    '/// start the table wizard
    printlog "start the table wizard"
    if not fStartTableWizard() then
        warnlog "The table wizard doesn't start. TEST STOPPED"
        goto endsub
    endif
    
    Kontext "TableWizard"        
        '/// check if there are 22 table in the business category
        printlog "check if there are 22 table in the business category"
        iTablesCount = Tables.GetItemCount()
        if ( iTablesCount <> 22 ) then
            warnlog "the number of tables in the business category should be 22 but it is : " + iTablesCount
        endif

        '/// check the count of all fields in all table in the business category
        printlog "check the count of all fields in all table in the business category"
        for i = 1 to iTablesCount 
            Tables.select i
            'printlog Tables.getseltext
            iFieldsCount = iFieldsCount + Fields.getItemCount
	            for ii = 1 to Fields.getItemCount
					Fields.select ii
	            	'printlog "          " + Fields.getSelText
	            next
        next

        if ( iFieldsCount <> 318 AND iFieldsCount <> 290 ) then
            warnlog "the number of all fields should be 318 or 290 but it is : " + iFieldsCount
        endif
    
    Kontext "TableWizard"
        '/// check the personal radio button
        Personal.Check            
        '/// check if there are 15 table in the personal category
        printlog "check if there are 15 table in the personal category"
        iTablesCount = Tables.GetItemCount()
        if ( iTablesCount <> 15 ) then
            warnlog "the number of tables in the personal category should be 15 but it is : " + iTablesCount
        endif

        '/// check the count of all fields in all table in the personal category
        printlog "check the count of all fields in all table in the personal category"
        for i = 1 to iTablesCount 
            Tables.select i
            'printlog Tables.getseltext
            iFieldsCount = iFieldsCount + Fields.getItemCount
	            for ii = 1 to Fields.getItemCount
					Fields.select ii
	            	'printlog "          " + Fields.getSelText
	            next
        next

        if ( iFieldsCount <> 480 AND iFieldsCount <> 508 ) then            
            warnlog "the number of all fields should be 480 or 508 but it is : " + iFieldsCount
        endif
        if (iFieldsCount = 480) then
            qaerrorlog "There have to be 508 fields. Please contact msc."
        endif
            
        '/// click CANCEL
        printlog "click CANCEL"       
        CancelBtn.Click
    
        '///close the database
        printlog "close the database"
        call fClosedatabase()
    
endcase   
'-------------------------------------------------------------------------
testcase tChangeFieldName
    
    '/// open Bibliography database
    printlog "open Bibliography database"
    if not fOpenDataBase(gOfficePath + ConvertPath("user\database\biblio.odb")) then
        warnlog "Database " + gOfficePath + ConvertPath("user/database/biblio.odb") + " could not be open."
        goto endsub
    end if

    '/// delete the table t_wizard if it's allready exists
    printlog "delete the table t_wizard if it's allready exists"
    call fDeleteTable ("t_wizard")

    '/// start the table wizard
    printlog "start the table wizard"
    if not fStartTableWizard() then
        warnlog "The table wizard doesn't start. TEST STOPPED"
        goto endsub
    endif
    
    Kontext "TableWizard"
        '/// select the first field
        printlog "select the first field"
        Fields.Select 1
        '/// click the add button
        printlog "click the add button"
        Add.click        
        '/// click NEXT
        printlog "click NEXT"
        NextBtn.click

        '/// select the first field
        printlog "select the first field"		
        FieldNames.select 1
        '/// change the field name for the first field to field_test
        FieldName.setText("field_test")              
        '/// click the add fields button (the + sign)
        printlog "click the add fields button (the + sign)"                 
        FieldsAdd.Click()
        '/// select the second field
        printlog "select the second field"
        FieldNames.select 2
        '/// change the field name for the second field to field_2
        printlog "change the field name for the second field to field_2"
        FieldName.setText("field_2")
        '/// click on field move up button to move the second filed to the first position
        printlog "click on field move up button to move the second filed to the first position"        
        FieldsUp.click()        
        '/// click NEXT
        printlog "click NEXT"
        NextBtn.click

        '/// change table name to t_wizard
        printlog "change table name to t_wizard"
        TableName.settext "t_wizard"            
        '/// click Finish
        printlog "click Finish"
        FinishBtn.Click
    
    sleep(1)

    '/// close the table view
    printlog "close the table view"
    call fCloseTableView()

    '/// open the table t_wizard in the design view
    printlog "open the table t_wizard in the design view"
    call fOpenTableInDesign("t_wizard")

    Kontext "TableDesignTable"
        '/// check if the first field is field_2
        printlog "check if the first field is field_2"
        Dim s as String
        s = Fieldname.getText
        if s <> "field_2" then
            printlog "the field name of the first field is not 'field_2' it is '" + s + "'."
            warnlog "the renaming or moving of a field in the wizard doesn't work"
        else
            printlog "==>> the first field name is field_2 => OK"            
        endif
        '/// check the second field
        TableDesignTable.typeKeys("<DOWN>")
        s = Fieldname.getText
        if s <> "field_test" then
            printlog "the field name of the second field is not 'field_test' it is '" + s + "'."
            warnlog "the renaming or moving of a field in the wizard doesn't work"
        else
            printlog "==>> the second field name is field_test => OK"            
        endif
        
    '/// close the table design
    printlog "close the table design"
    call fCloseTableDesign

    '/// delete the table t_wizard we dont't need it anymore
    printlog "delete the table t_wizard we dont't need it anymore"
    call fDeleteTable ("t_wizard")

    '/// close the database
    printlog "close the database"
    call fClosedatabase()
    
endcase   
'-------------------------------------------------------------------------
testcase tStartFormWizardFromTableWizard

    'hold a table name
    Dim sTableName as String 

    '/// open Bibliography database
    printlog "open Bibliography database"
    if not fOpenDataBase(gOfficePath + ConvertPath("user\database\biblio.odb")) then
        warnlog "Database " + gOfficePath + ConvertPath("user/database/biblio.odb") + " could not be open."
        goto endsub
    end if

    '/// start the table wizard
    printlog "start the table wizard"
    if not fStartTableWizard() then
        warnlog "The table wizard doesn't start. TEST STOPPED"
        goto endsub
    endif

    Kontext "TableWizard"
        '/// add all fields from the displayed table
        printlog "add all fields from the displayed table"
        AddAll.click
        '/// click NEXT
        printlog "click NEXT"
        NextBtn.click
             
        '/// click NEXT
        printlog "click NEXT"
        NextBtn.click

        'remember the table, because we want to delete it later
        sTableName = TableName.getText  
                  
        CreateForm.Check

        '/// click Finish
        printlog "click Finish"       
        FinishBtn.Click
    
    sleep(10)
    
    '/// check if the form wizard appear
    printlog "check if the form wizard appear"
    Kontext "FormWizard"
        if FormWizard.exists(1) then
            printlog "The formwizard appear ==>> OK"
            CancelBtn.Click
        else
            warnlog "The Form Wizard doesn't appear."
        endif
    
    '/// delete the created table
    printlog "delete the created table"
    call fDeleteTable sTableName

    '/// close the database
    printlog "close the database"
    call fClosedatabase()
    
endcase
'-------------------------------------------------------------------------
testcase tCreateAllTables    
    '/// create all tables form the business and personal category
    printlog "create all tables form the business and personal category"

    Dim i as integer 

    'copy the hsqldb database file to a local path    
    app.FileCopy gTesttoolPath + ConvertPath("base\level1\input\TT_hsqldb.odb"),gOfficePath + ConvertPath("user\work\TT_hsqldb.odb")

    '/// open a hsql database
    printlog "open a hsql database"
    call fOpendatabase(ConvertPath(gOfficePath + "user\work\TT_hsqldb.odb"))
    sleep(5)  

    for i = 1 to 22

        '/// start the table wizard
        printlog "start the table wizard"
        if not fStartTableWizard() then
            warnlog "The table wizard doesn't start. TEST STOPPED"
            goto endsub
        endif    

        Kontext "TableWizard"
        Tables.select i
        printlog "Create table " + Tables.getSelText
        '/// add all fields
        printlog "   add all fields"
        AddAll.click
        '/// click Finish
        printlog "   click Finish"       
        FinishBtn.Click
        
        Kontext "MessageBox"
        if ( MessageBox.exists(3) ) then
            warnlog "error while creating table"
            MessageBox.OK
            Kontext "TableWizard"
                CancelBtn.Click
        else
            '/// close the open table
            printlog "   close the open table"
            call fCloseTableView()
        endif
    next
    
    '/// now create all tables from the personal tables
    printlog "now create all tables from the personal tables"

    for i = 1 to 15
        '/// start the table wizard
        printlog "start the table wizard"
        if not fStartTableWizard() then
            warnlog "The table wizard doesn't start. TEST STOPPED"
            goto endsub
        endif    
        Kontext "TableWizard"        
        Personal.Check 
        Tables.select i
        printlog "Create table " + Tables.getSelText
        '/// add all fields
        printlog "   add all fields"
        AddAll.click                            
        '/// click Finish
        printlog "   click Finish"       
        FinishBtn.Click

        Kontext "MessageBox"
        if ( MessageBox.exists(3) ) then
            warnlog "error while creating table"
            MessageBox.OK
            Kontext "TableWizard"
                CancelBtn.Click
        else
            '/// close the open table
            printlog "   close the open table"
            call fCloseTableView()
        endif
    next    
    sleep(1)

    '/// close the database
    printlog "close the database"
    call fClosedatabase()

endcase  
